/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SynAnimSprite {
    private Image img;
    private String strImgFileName;
    private String strBinFileName;
    private short[][] iModulesData;
    private short[][][] iFramesData;
    private int[][] iFramesCollisionData;
    private short[][][] iAnimsData;
    private short[] iCurAnimFrame;
    private int iVer;
    private static byte TRANS_NONE = 0;
    private static byte TRANS_MIRROR = 1;
    private static byte TRANS_MIRROR_ROT180 = (byte)2;
    private static byte TRANS_ROT90 = (byte)3;
    private static byte TRANS_ROT180 = (byte)4;
    private static byte TRANS_MIRROR_ROT270 = (byte)5;
    private static byte TRANS_MIRROR_ROT90 = (byte)6;
    private static byte TRANS_ROT270 = (byte)7;
    private static byte[] iTransFlag = new byte[]{0, 5, 3, 6, 2, 7, 1, 4};

    public SynAnimSprite(String string, String string2) {
        this.img = null;
        this.strImgFileName = string;
        this.strBinFileName = string2;
    }

    public SynAnimSprite(Image image, String string) {
        this.img = image;
        this.strBinFileName = string;
    }

    public boolean loadSprite() {
        boolean bl = this.loadImage();
        boolean bl2 = this.loadSpriteData();
        return bl && bl2;
    }

    public boolean unLoadSprite() {
        this.img = null;
        this.iModulesData = null;
        this.iFramesData = null;
        this.iAnimsData = null;
        this.iCurAnimFrame = null;
        System.gc();
        return true;
    }

    private int getNextInt(InputStream inputStream) {
        try {
            byte[] byArray = new byte[2];
            inputStream.read(byArray, 0, 2);
            int n = this.getInt(byArray);
            return n;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private int getInt(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        n |= (byArray[1] & 0xFF) << 8;
        n <<= 16;
        return n >>= 16;
    }

    public boolean loadImage() {
        if (this.img != null) {
            return true;
        }
        try {
            this.img = Image.createImage((String)this.strImgFileName);
            return true;
        }
        catch (Exception exception) {
            try {
                this.img = Image.createImage((String)("/" + this.strImgFileName));
                return true;
            }
            catch (Exception exception2) {
                System.out.println("Exception while loading Sprite Image:" + exception2.toString());
                return false;
            }
        }
    }

    public boolean loadSpriteData() {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            InputStream inputStream = Class.forName("SynAnimSprite").getResourceAsStream(this.strBinFileName);
            this.iVer = this.getNextInt(inputStream);
            if (this.iVer != 1) {
                return false;
            }
            int n5 = this.getNextInt(inputStream);
            int n6 = this.getNextInt(inputStream);
            this.iModulesData = new short[n6][4];
            for (n4 = 0; n4 < n6; ++n4) {
                this.iModulesData[n4][0] = (short)this.getNextInt(inputStream);
                this.iModulesData[n4][1] = (short)this.getNextInt(inputStream);
                this.iModulesData[n4][2] = (short)this.getNextInt(inputStream);
                this.iModulesData[n4][3] = (short)this.getNextInt(inputStream);
            }
            n4 = this.getNextInt(inputStream);
            this.iFramesData = new short[n4][][];
            this.iFramesCollisionData = new int[n4][4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = this.getNextInt(inputStream);
                this.iFramesData[n3] = new short[n2][4];
                for (n = 0; n < n2; ++n) {
                    this.iFramesData[n3][n][0] = (short)this.getNextInt(inputStream);
                    this.iFramesData[n3][n][1] = (short)this.getNextInt(inputStream);
                    this.iFramesData[n3][n][2] = (short)this.getNextInt(inputStream);
                    this.iFramesData[n3][n][3] = (short)this.getNextInt(inputStream);
                }
                this.iFramesCollisionData[n3][0] = this.getNextInt(inputStream);
                this.iFramesCollisionData[n3][1] = this.getNextInt(inputStream);
                this.iFramesCollisionData[n3][2] = this.getNextInt(inputStream);
                this.iFramesCollisionData[n3][3] = this.getNextInt(inputStream);
            }
            n3 = this.getNextInt(inputStream);
            this.iAnimsData = new short[n3][][];
            this.iCurAnimFrame = new short[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.iCurAnimFrame[n2] = 0;
                n = this.getNextInt(inputStream);
                this.iAnimsData[n2] = new short[n][3];
                for (int i = 0; i < n; ++i) {
                    this.iAnimsData[n2][i][0] = (short)this.getNextInt(inputStream);
                    this.iAnimsData[n2][i][1] = (short)this.getNextInt(inputStream);
                    this.iAnimsData[n2][i][2] = (short)this.getNextInt(inputStream);
                }
            }
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception while loading Sprite Data:" + exception.toString());
            exception.printStackTrace();
        }
        return true;
    }

    public int getModuleX(int n) {
        return this.iModulesData[n][0];
    }

    public int getModuleY(int n) {
        return this.iModulesData[n][1];
    }

    public int getModuleW(int n) {
        return this.iModulesData[n][2];
    }

    public int getModuleH(int n) {
        return this.iModulesData[n][3];
    }

    public void paintModule(Graphics graphics, short[] sArray) {
        short s = sArray[0];
        short s2 = sArray[1];
        short s3 = sArray[2];
        short s4 = sArray[3];
        try {
            graphics.drawRegion(this.img, (int)this.iModulesData[s][0], (int)this.iModulesData[s][1], (int)this.iModulesData[s][2], (int)this.iModulesData[s][3], (int)iTransFlag[s4], s2 + (this.iModulesData[s][2] >> 1), s3 + (this.iModulesData[s][3] >> 1), 3);
        }
        catch (Exception exception) {
            System.out.println("" + this.strImgFileName + " error:" + exception + "in module no:" + s);
        }
    }

    public int getModuleIDof(int n, int n2) {
        return this.iFramesData[n][n2][0];
    }

    public int getModuleOXof(int n, int n2) {
        return this.iFramesData[n][n2][1];
    }

    public int getModuleOYof(int n, int n2) {
        return this.iFramesData[n][n2][2];
    }

    public int getFrameOXof(int n) {
        short s = 1000;
        for (int i = 0; i < this.iFramesData[n].length; ++i) {
            if (s <= this.iFramesData[n][i][1]) continue;
            s = this.iFramesData[n][i][1];
        }
        return s;
    }

    public int getFrameOYof(int n) {
        short s = 1000;
        for (int i = 0; i < this.iFramesData[n].length; ++i) {
            if (s <= this.iFramesData[n][i][2]) continue;
            s = this.iFramesData[n][i][2];
        }
        return s;
    }

    public int getFrameWidthof(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.iFramesData[n].length; ++n2) {
            int n4 = this.getModuleW(this.iFramesData[n][n2][0]);
            if (n3 >= n4 + this.iFramesData[n][n2][1]) continue;
            n3 = n4 + this.iFramesData[n][n2][1];
        }
        n2 = this.getFrameOXof(n);
        return n3 - n2;
    }

    public int getFrameHeightof(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.iFramesData[n].length; ++n2) {
            int n4 = this.getModuleH(this.iFramesData[n][n2][0]);
            if (n3 >= n4 + this.iFramesData[n][n2][2]) continue;
            n3 = n4 + this.iFramesData[n][n2][2];
        }
        n2 = this.getFrameOYof(n);
        return n3 - n2;
    }

    public int getModuleFlagof(int n, int n2) {
        return this.iFramesData[n][n2][3];
    }

    public void paintFrame(Graphics graphics, int n, int n2, int n3) {
        graphics.translate(n2, n3);
        for (int i = 0; i < this.iFramesData[n].length; ++i) {
            this.paintModule(graphics, this.iFramesData[n][i]);
        }
        graphics.translate(-n2, -n3);
    }

    public int getCurrentFrameOf(int n) {
        return this.iCurAnimFrame[n];
    }

    public int[] getCollisionRect(int n) {
        int[] nArray = new int[4];
        System.arraycopy(this.iFramesCollisionData[n], 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int[] getCollisionRectOfAnim(int n) {
        short s = this.iAnimsData[n][this.iCurAnimFrame[n]][0];
        int[] nArray = this.getCollisionRect(s);
        int n2 = this.getFrameOXof(n, this.iCurAnimFrame[n]);
        int n3 = this.getFrameOYof(n, this.iCurAnimFrame[n]);
        nArray[0] = nArray[0] + n2;
        nArray[1] = nArray[1] + n3;
        return nArray;
    }

    public int getFrameIDof(int n, int n2) {
        return this.iAnimsData[n][n2][0];
    }

    public int getFrameOXof(int n, int n2) {
        return this.iAnimsData[n][n2][1];
    }

    public int getFrameOYof(int n, int n2) {
        return this.iAnimsData[n][n2][2];
    }

    public int getTotalFrameOfAnim(int n) {
        return this.iAnimsData[n].length;
    }

    public void updateAnim(int n) {
        if (this.iAnimsData[n].length != 0) {
            this.iCurAnimFrame[n] = (byte)((this.iCurAnimFrame[n] + 1) % this.iAnimsData[n].length);
        }
    }

    public void updateAllAnim() {
        for (int i = 0; i < this.iCurAnimFrame.length; ++i) {
            this.updateAnim(i);
        }
    }

    public boolean updateAllAnimOnce() {
        boolean bl = false;
        for (int i = 0; i < this.iCurAnimFrame.length; ++i) {
            bl = bl || this.updateAnimOnce(i);
        }
        return bl;
    }

    public int getTotalAnims() {
        return this.iAnimsData.length;
    }

    public int getTotalFrames() {
        return this.iFramesData.length;
    }

    public void paintAnim(Graphics graphics, int n, int n2, int n3) {
        graphics.translate(n2, n3);
        if (this.iAnimsData[n].length != 0) {
            this.paintFrame(graphics, this.iAnimsData[n][this.iCurAnimFrame[n]][0], this.iAnimsData[n][this.iCurAnimFrame[n]][1], this.iAnimsData[n][this.iCurAnimFrame[n]][2]);
        }
        graphics.translate(-n2, -n3);
    }

    public int paintAnim(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n3, n4);
        this.paintFrame(graphics, this.iAnimsData[n][n2][0], this.iAnimsData[n][this.iCurAnimFrame[n]][1], this.iAnimsData[n][this.iCurAnimFrame[n]][2]);
        n2 = (n2 + 1) % this.iAnimsData[n].length;
        graphics.translate(-n3, -n4);
        return n2;
    }

    public boolean updateAnimOnce(int n) {
        if (this.iAnimsData[n].length == 0) {
            return true;
        }
        boolean bl = false;
        if (this.iCurAnimFrame[n] < this.iAnimsData[n].length - 1) {
            int n2 = n;
            this.iCurAnimFrame[n2] = (short)(this.iCurAnimFrame[n2] + 1);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void paintAnimOnce(Graphics graphics, int n, int n2, int n3) {
        graphics.translate(n2, n3);
        this.paintFrame(graphics, this.iAnimsData[n][this.iCurAnimFrame[n]][0], this.iAnimsData[n][this.iCurAnimFrame[n]][1], this.iAnimsData[n][this.iCurAnimFrame[n]][2]);
        graphics.translate(-n2, -n3);
    }

    public int paintAnimOnce(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = -1;
        graphics.translate(n3, n4);
        this.paintFrame(graphics, this.iAnimsData[n][n2][0], this.iAnimsData[n][n2][1], this.iAnimsData[n][n2][2]);
        if (n2 < this.iAnimsData[n].length - 1) {
            n5 = ++n2;
        } else {
            n2 = -1;
        }
        graphics.translate(-n3, -n4);
        return n5;
    }

    public void resetAnim(int n) {
        this.iCurAnimFrame[n] = 0;
    }
}

