/*
 * Decompiled with CFR 0.152.
 */
package Jim.Engine;

import Jim.Engine.JDefine;
import Jim.Engine.JImageRes;
import Jim.Engine.JSound;
import Jim.Engine.JTool;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class JCore
extends Canvas
implements Runnable {
    public static int CountTime;
    public static int DelayTime;
    public static boolean Draw;
    public static short EnglishFontWidth;
    public static Font Font;
    public static short FontHeight;
    public static short FontWidth;
    private byte Fps;
    public static int FpsTime;
    public static final byte GAME_ACT = 5;
    public static final byte GAME_CONTROL = 6;
    public static final byte GAME_LOAD = 2;
    public static final byte GAME_LOGO = 1;
    public static final byte GAME_MENU = 4;
    public static final byte GAME_NULL = -1;
    public static final byte GAME_SP_LOGO = 0;
    public static final byte GAME_TITLE = 3;
    public static int GameScreenHeight;
    public static int GameScreenWidth;
    public static byte GameState;
    private Thread GameThread;
    public static final byte INSERT_MARK = 1;
    public JImageRes ImageRes = null;
    public static boolean Init;
    public static byte KeyIndex;
    public static boolean[] KeyState;
    private int Keypad;
    private int Keyrel;
    public final byte LOAD_BAR_HEIGHT;
    public final byte LOAD_BAR_WIDTH;
    public final byte LOAD_NUM = (byte)10;
    public final short LOGO_HEIGHT;
    public final short LOGO_WIDTH;
    protected short LoadingBarProgress;
    public static byte OldGameState;
    public static short PosX;
    public static short PosY;
    public static int ScreenHeight;
    public static int ScreenWidth;
    public static JSound Sound;
    public static byte Stop;
    public static boolean Update;
    protected Image load_doll_img = null;
    protected Image logo_img = null;
    public static boolean release;

    static {
        KeyState = new boolean[14];
        Sound = null;
    }

    public JCore(boolean fullScreen, boolean offScreen, int screenWidth, int screenHeight, int gameScreenWidth, int gameScreenHeight) {
        this.LOAD_BAR_WIDTH = (byte)80;
        this.LOAD_BAR_HEIGHT = (byte)3;
        this.LOGO_WIDTH = (short)128;
        this.LOGO_HEIGHT = (short)128;
        if (fullScreen) {
            this.setFullScreenMode(true);
        }
        this.setScreen(screenWidth, screenHeight, gameScreenWidth, gameScreenHeight);
        this.setFps((byte)25);
        Font = Font.getDefaultFont();
        FontHeight = (short)Font.getHeight();
        if (offScreen) {
            // empty if block
        }
        this.ImageRes = null;
        this.logo_img = JTool.createImage("logo.png");
        this.load_doll_img = JTool.createImage("load.png");
        JCore.setGameState((byte)1);
        this.doInit();
    }

    public static void clearKeyState() {
        KeyIndex = (byte)-1;
        int i = 0;
        while (i < KeyState.length) {
            JCore.KeyState[i] = false;
            ++i;
        }
    }

    public static boolean delayCount(long time) {
        if ((long)(CountTime += FpsTime) >= time) {
            CountTime = 0;
            return true;
        }
        return false;
    }

    public void doInit() {
        this.LoadingBarProgress = 0;
        KeyIndex = (byte)-1;
        Draw = true;
        Update = true;
        this.doThread();
    }

    public void doThread() {
        this.GameThread = new Thread(this);
        this.GameThread.start();
    }

    public void drawLoadingDoll(Graphics g, int x, int y, int index) {
        JTool.drawClipImage(g, this.load_doll_img, x, y, index, 20, 20);
    }

    public static int getGameState() {
        return GameState;
    }

    public abstract void init();

    public abstract void keyAction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(int key) {
        try {
            int getkey = 0;
            this.Keypad = key;
            int keyNum = JDefine.LEFT_SYSTEM_KEY.length;
            int i = 0;
            while (i < keyNum) {
                if (this.Keypad == JDefine.LEFT_SYSTEM_KEY[i]) {
                    KeyIndex = (byte)12;
                    break;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < keyNum) {
                if (this.Keypad == JDefine.RIGHT_SYSTEM_KEY[i2]) {
                    KeyIndex = (byte)13;
                    break;
                }
                ++i2;
            }
            if (this.Keypad >= 48 && this.Keypad <= 57) {
                KeyIndex = (byte)(this.Keypad - 48);
            } else if (this.Keypad == 42) {
                KeyIndex = (byte)10;
            } else if (this.Keypad == 35) {
                KeyIndex = (byte)11;
            }
            getkey = this.getGameAction(key);
            if (getkey == 1) {
                KeyIndex = (byte)2;
            } else if (getkey == 6) {
                KeyIndex = (byte)8;
            } else if (getkey == 2) {
                KeyIndex = (byte)4;
            } else if (getkey == 5) {
                KeyIndex = (byte)6;
            } else if (getkey == 8) {
                KeyIndex = (byte)5;
            }
        }
        catch (Exception ex) {
        }
        finally {
            if (KeyIndex != -1) {
                JCore.KeyState[JCore.KeyIndex] = true;
                release = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyReleased(int key) {
        try {
            int getkey = 0;
            this.Keyrel = key;
            int keyNum = JDefine.LEFT_SYSTEM_KEY.length;
            if (this.Keyrel == 56) {
                KeyIndex = (byte)8;
            }
            if ((getkey = this.getGameAction(key)) == 6) {
                KeyIndex = (byte)8;
            }
        }
        catch (Exception ex) {
        }
        finally {
            if (KeyIndex != -1) {
                JCore.KeyState[JCore.KeyIndex] = true;
                release = true;
            }
        }
    }

    public abstract void loadRes();

    public static void pause() {
        Stop = 1;
    }

    public static void playSound(int index, int count) {
        if (Sound != null) {
            Sound.play(index, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read_Uni(String resource, int insertMark) {
        InputStream is;
        String strReturn = "";
        boolean start = true;
        int len = 0;
        try {
            is = this.getClass().getResourceAsStream(resource);
            len = is.available();
            if (len == 0) {
                String e = null;
                return e;
            }
            byte[] word_uni = new byte[len];
            is.read(word_uni);
            is.close();
            StringBuffer stringbuffer = new StringBuffer("");
            int j = 0;
            while (j < len) {
                int l;
                int k;
                if ((k = word_uni[j++]) < 0) {
                    k += 256;
                }
                if ((l = word_uni[j++]) < 0) {
                    l += 256;
                }
                char c = (char)(k + (l << 8));
                if (insertMark == 1 || c != '\n') {
                    if (c == '\r') continue;
                    if (start && insertMark == 1) {
                        stringbuffer.append('{');
                    } else if (c == '\n' && insertMark == 1) {
                        stringbuffer.append('}');
                        stringbuffer.append('{');
                    } else {
                        stringbuffer.append(c);
                    }
                }
                start = false;
            }
            strReturn = stringbuffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            is = null;
            Object word_uni = null;
        }
        return strReturn;
    }

    public static void resume() {
        Stop = 0;
    }

    public void run() {
        while (true) {
            if (Stop != 0) {
                continue;
            }
            long st = 0L;
            long et = 0L;
            st = System.currentTimeMillis();
            this.repaint(0, 0, ScreenWidth, ScreenHeight);
            et = System.currentTimeMillis();
            long time = et - st;
            if (time >= (long)FpsTime) continue;
            try {
                Thread.sleep((long)FpsTime - time);
                continue;
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
    }

    public void setFontWidth(short width) {
        FontWidth = width;
    }

    public void setFps(byte f) {
        if (this.Fps <= 0) {
            this.Fps = 1;
        }
        this.Fps = f;
        FpsTime = 1000 / this.Fps;
    }

    public static void setGameState(byte state) {
        OldGameState = GameState;
        GameState = state;
        JCore.setUpdate(true);
        JCore.clearKeyState();
    }

    public void setPosXY(short x, short y) {
        PosX = x;
        PosY = y;
    }

    public void setScreen(int screenWidth, int screenHeight, int gameScreenWidth, int gameScreenHeight) {
        if (screenWidth == -1 || screenHeight == -1) {
            ScreenWidth = this.getWidth();
            GameScreenHeight = ScreenHeight = this.getHeight();
            GameScreenWidth = ScreenWidth;
        } else {
            ScreenWidth = screenWidth;
            ScreenHeight = screenHeight;
            GameScreenWidth = gameScreenWidth;
            GameScreenHeight = gameScreenHeight;
        }
        this.setPosXY((short)((ScreenWidth - GameScreenWidth) / 2), (short)((ScreenHeight - GameScreenHeight) / 2));
        JTool.set(PosX, PosY, ScreenWidth + 100, ScreenHeight + 100);
    }

    public static void setUpdate(boolean update) {
        Update = update;
    }

    public static void stopSound() {
        if (Sound != null) {
            Sound.stop();
        }
    }

    public void update(Graphics g) {
        this.keyAction();
        switch (GameState) {
            case 1: {
                g.setColor(0);
                g.fillRect(0, 0, ScreenWidth, ScreenHeight);
                g.setColor(255, 255, 255);
                JTool.fillRect(g, 0, 0, GameScreenWidth, GameScreenHeight);
                if (this.logo_img != null) {
                    JTool.drawImage(g, this.logo_img, -1000, -1000);
                }
                System.gc();
                JCore.setGameState((byte)2);
                break;
            }
            case 2: {
                g.setColor(255, 255, 255);
                JTool.fillRect(g, 0, 0, GameScreenWidth, GameScreenHeight);
                JTool.drawImage(g, this.logo_img, -1000, -1000);
                g.setColor(255, 0, 0);
                JTool.fillRect(g, 0, GameScreenHeight - 3, this.LoadingBarProgress * (GameScreenWidth / 10), 3);
                this.loadRes();
                if (this.LoadingBarProgress <= 11) break;
                this.logo_img = null;
                this.load_doll_img = null;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                System.gc();
                Init = true;
                JCore.setGameState((byte)3);
            }
        }
    }
}

