/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.GameLogic;
import cc.jmap.games.GameObject;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class Cloud
extends GameObject {
    public static final int CLOUD_SMALL = 0;
    public static final int CLOUD_MID = 1;
    public static final int CLOUD_LARGE = 2;
    private static int state = 0;
    public static double diff = 0.1;
    public static double windspeed = 1.0;
    private static long nextChangeTime = 0L;
    public static long nextTargetSpeed = 0L;
    private static int posY = 60;

    private void setState() {
        if (nextTargetSpeed > 22L || nextTargetSpeed < -22L) {
            state = 2;
            posY = 60;
        } else if (nextTargetSpeed > 7L || nextTargetSpeed < -7L) {
            state = 1;
            posY = 60;
        } else {
            state = 0;
            posY = 60;
        }
    }

    public static double getSpeedForce() {
        double ratio = 5.5;
        if (windspeed >= 0.0) {
            if (GameLogic.stickAngleOnScreen > 50.0) {
                ratio *= 1.0 + (GameLogic.stickAngleOnScreen - 50.0) / 200.0;
            }
            return Math.sqrt(windspeed) / ratio;
        }
        if (GameLogic.stickAngleOnScreen < -50.0) {
            ratio *= 1.0 + (GameLogic.stickAngleOnScreen + 50.0) / -200.0;
        }
        return -1.0 * Math.sqrt(-1.0 * windspeed) / ratio;
    }

    void checkSpeed() {
        int speedStart = 0;
        int targetSpeed = 0;
        int r = GameLogic.ran.nextInt(1000);
        int prevTargetSpeed = (int)nextTargetSpeed;
        if (GameLogic.now > nextChangeTime) {
            int level = GameLogic.getGameLevel();
            if (level < 2) {
                nextChangeTime = GameLogic.now + 4000L;
                targetSpeed = 10;
                diff = 1.0;
            } else if (level < 4) {
                nextChangeTime = GameLogic.now + (long)((5 + r % 3) * 1000);
                targetSpeed = 12;
                speedStart = 9;
                diff = 4.0;
            } else if (level < 6) {
                nextChangeTime = GameLogic.now + (long)((5 + r % 2) * 1000);
                targetSpeed = 20;
                speedStart = 10;
                diff = 5.0;
                nextChangeTime = GameLogic.now + (long)((4 + r % 2) * 1000);
                targetSpeed = 20;
                speedStart = 20;
                diff = 7.0;
            } else if (level < 14) {
                nextChangeTime = GameLogic.now + (long)((2 + r % 5) * 1000);
                targetSpeed = 25;
                speedStart = 30;
                diff = 9.0;
            } else if (level < 16) {
                nextChangeTime = GameLogic.now + (long)((2 + r % 4) * 1000);
                targetSpeed = 30;
                speedStart = 40;
                diff = 10.0;
            } else {
                nextChangeTime = GameLogic.now + (long)((2 + r % 3) * 1000);
                targetSpeed = 30;
                speedStart = 40;
                diff = 12.0;
            }
            nextTargetSpeed = r % targetSpeed - targetSpeed / 2;
            nextTargetSpeed = nextTargetSpeed < 0L ? (nextTargetSpeed -= (long)speedStart) : (nextTargetSpeed += (long)speedStart);
            if ((long)prevTargetSpeed * nextTargetSpeed > 0L && r % 2 == 0) {
                nextTargetSpeed *= -1L;
            }
            this.setState();
        }
        windspeed = windspeed > (double)nextTargetSpeed ? (windspeed -= diff) : (windspeed += diff);
    }

    void reset() {
        nextTargetSpeed = 0L;
        nextChangeTime = 0L;
        diff = 0.1;
        windspeed = 0.0;
        state = 0;
        posY = 60;
    }

    void step() {
        this.checkSpeed();
        this.posX = (int)((double)this.posX + windspeed);
        if (this.posX > 360) {
            this.posX -= 360;
        } else if (this.posX < -360) {
            this.posX += 360;
        }
    }

    void render(Graphics g, GameCanvas canvas) {
        Image img = (Image)GameObject.cloudImgVec.elementAt(state);
        g.drawImage(img, this.posX - 360, posY, 20);
        g.drawImage(img, this.posX, posY, 20);
        g.drawImage(img, this.posX + 360, posY, 20);
    }
}

