/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.BalanceMidlet;
import cc.jmap.games.GameObject;
import cc.jmap.games.I18NResource;
import cc.jmap.games.SoundPlayer;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PageCanvas
extends Canvas {
    public static final int PAGE_BRAND = 0;
    public static final int PAGE_MAIN = 1;
    public static final int PAGE_MAIN_HELP = 2;
    public static final int PAGE_OVER = 4;
    private int state = 0;
    private Image brandPage = null;
    private Image mainPage = null;
    private static Image[] langIcons = new Image[3];
    private static Image[] mainIcons = new Image[5];
    private static Image[] helpIcons = new Image[2];
    private BalanceMidlet midlet = null;

    public void initOthers() {
        try {
            I18NResource.init();
            this.mainPage = Image.createImage((String)"/main/main.png");
            PageCanvas.helpIcons[0] = Image.createImage((String)"/main/help_box.png");
            PageCanvas.helpIcons[1] = Image.createImage((String)"/main/help_check.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getState() {
        return this.state;
    }

    public static void setI18N() {
        PageCanvas.mainIcons[0] = I18NResource.i18Imgs[0];
        PageCanvas.mainIcons[1] = I18NResource.i18Imgs[1];
        PageCanvas.mainIcons[2] = I18NResource.i18Imgs[2];
        PageCanvas.mainIcons[3] = I18NResource.i18Imgs[3];
        PageCanvas.mainIcons[4] = I18NResource.i18Imgs[4];
    }

    public PageCanvas(BalanceMidlet parent) {
        this.setFullScreenMode(true);
        try {
            this.brandPage = Image.createImage((String)"/brand/brand.png");
            PageCanvas.langIcons[0] = Image.createImage((String)"/brand/btn_en.png");
            PageCanvas.langIcons[1] = Image.createImage((String)"/brand/btn_tc.png");
            PageCanvas.langIcons[2] = Image.createImage((String)"/brand/btn_sc.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.midlet = parent;
    }

    public void showMain() {
        this.state = 1;
        this.repaint();
    }

    public void showHelp() {
        this.state = 2;
        this.repaint();
    }

    public void showOver() {
        this.state = 4;
        this.repaint();
    }

    private void drawMain(Graphics g) {
        g.drawImage(this.mainPage, 0, 0, 20);
        g.drawImage((Image)GameObject.cloudImgVec.elementAt(0), 20, 130, 20);
        g.drawImage(mainIcons[0], (360 - mainIcons[0].getWidth()) / 2, 30, 20);
        g.drawImage(mainIcons[1], 30, 180, 20);
        g.drawImage(mainIcons[2], 145, 290, 20);
        g.drawImage(mainIcons[3], 0, 640 - mainIcons[3].getHeight(), 20);
        g.drawImage(mainIcons[4], 360 - mainIcons[4].getWidth(), 640 - mainIcons[3].getHeight(), 20);
    }

    public void paint(Graphics g) {
        if (this.state == 0) {
            g.drawImage(this.brandPage, 0, 0, 20);
            g.drawImage(langIcons[0], 0, 640 - langIcons[0].getHeight(), 20);
            g.drawImage(langIcons[1], (360 - langIcons[1].getWidth()) / 2, 640 - langIcons[1].getHeight(), 20);
            g.drawImage(langIcons[2], 360 - langIcons[2].getWidth(), 640 - langIcons[2].getHeight(), 20);
        } else if (this.state == 1) {
            this.drawMain(g);
        } else if (this.state == 2) {
            this.drawMain(g);
            Font font = Font.getFont((int)0, (int)0, (int)8);
            g.setFont(font);
            g.drawImage(helpIcons[0], (360 - helpIcons[0].getWidth()) / 2, (640 - helpIcons[0].getHeight()) / 2, 20);
            g.setColor(0xD7D7D7);
            int x = 29;
            int y = 33;
            int yGap = 26;
            int i = 0;
            while (i < 21) {
                g.drawString(I18NResource.helpLines[i], x, y + yGap * i, 0);
                ++i;
            }
            g.drawImage(helpIcons[1], (360 - helpIcons[1].getWidth()) / 2, 575, 20);
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.state == 0) {
            boolean flag = false;
            if (x < 120 && y > 520) {
                I18NResource.setLanguage(2);
                flag = true;
            } else if (x > 120 && x < 240 && y > 520) {
                I18NResource.setLanguage(0);
                flag = true;
            } else if (x > 240 && y > 520) {
                I18NResource.setLanguage(1);
                flag = true;
            }
            if (flag) {
                SoundPlayer.playStart();
                this.showMain();
                this.midlet.gotoMain();
            }
        } else if (this.state == 1) {
            if (x > 20 && y > 170 && x < 240 && y < 250) {
                this.midlet.gotoPlay();
            } else if (x > 140 && y > 280 && x < 360 && y < 360) {
                BalanceMidlet.viewHighScore();
            } else if (x < 180 && y > 570) {
                this.showHelp();
            } else if (x > 180 && y > 570) {
                this.midlet.exit();
            }
        } else if (this.state == 2) {
            this.showMain();
        }
    }
}

