/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.Actor;
import cc.jmap.games.Flying;
import cc.jmap.games.GameEngine;
import cc.jmap.games.GameObject;
import cc.jmap.games.I18NResource;
import cc.jmap.games.SoundPlayer;
import cc.jmap.games.TastyDreamMidlet;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class GameLogic {
    public static final boolean DEBUG = false;
    public static final int SCREEN_HEIGHT = 680;
    public static final int SCREEN_WIDTH = 340;
    public static int score = 0;
    public static int life = 300;
    public static long lifeLastCutTime = 0L;
    public static long now = 0L;
    public static long startTime = 0L;
    public static long pauseTime = 0L;
    public static GameLogic instance = null;
    public static final int STATE_GAME_GO_BFORE_PLAY = 0;
    public static final int STATE_GAME_PLAY = 1;
    public static final int STATE_GAME_PLAY_PAUSED = 2;
    public static final int STATE_GAME_ENDING = 3;
    public static final int STATE_GAME_END = 4;
    public static int state = 1;
    public static int gameOverScore = 0;
    public static int gameOverH = 0;
    static Vector flyings = new Vector();
    Actor actor = new Actor();
    static Random ran = new Random();
    SoundPlayer player = null;
    private static boolean goAlreadyShown = false;
    private int oldState;
    private long goTimeStamp = 0L;
    private int goCount = 0;
    private int[] goIndexes;

    public GameLogic() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[3] = 1;
        this.goIndexes = nArray;
        instance = this;
    }

    public static void setGameOverScore() {
        gameOverScore = score;
    }

    public static void restartGame() {
        if (state == 4) {
            instance.GoToPlay();
            System.out.println("GmaeLogic restartGame()");
        }
    }

    public static void backToMenu() {
        if (state == 4 || state == 2) {
            TastyDreamMidlet.instance.gotoMain();
            System.out.println("GmaeLogic backToMenu()");
        }
    }

    public static void uploadScore() {
        TastyDreamMidlet.submitScore(gameOverScore);
    }

    public void pauseGame() {
        if (state == 1) {
            this.oldState = state;
            state = 2;
            SoundPlayer.pause();
            TastyDreamMidlet.engine.pauseEngine();
            GameEngine.repaint();
            System.out.println("GmaeLogic pauseGame()");
        }
    }

    public void resumeGame() {
        if (state == 2) {
            state = this.oldState;
            SoundPlayer.resume();
            TastyDreamMidlet.engine.resumeEngine();
            GameEngine.repaint();
            System.out.println("GmaeLogic resumeGame()");
        }
    }

    public void startGame() {
        if (goAlreadyShown) {
            this.GoToPlay();
            return;
        }
        state = 0;
        goAlreadyShown = true;
        GameEngine.repaint();
    }

    public void GoToPlay() {
        gameOverScore = 0;
        score = 0;
        gameOverH = 0;
        life = 1000;
        startTime = System.currentTimeMillis();
        pauseTime = 0L;
        this.actor.reset();
        Flying.classReset();
        state = 1;
        SoundPlayer.playFile(1);
        TastyDreamMidlet.instance.openSensor();
    }

    public void endGame() {
        state = 4;
        TastyDreamMidlet.instance.closeSensor();
    }

    public int getState() {
        return state;
    }

    public void initFlyings() {
        int i = 0;
        while (i < 26) {
            Flying f = new Flying();
            flyings.addElement(f);
            ++i;
        }
    }

    public static void addLife(double offset) {
        if ((life = (int)((double)life + offset)) > 1000) {
            life = 1000;
        } else if (life <= 0) {
            life = 0;
            state = 3;
            GameLogic.setGameOverScore();
            SoundPlayer.playFile(2);
        } else if (life < 200) {
            SoundPlayer.playFile(9);
        }
    }

    public static void addScore(int offset) {
        if ((score += offset) < 0) {
            score = 0;
        }
    }

    public void drawBackground(Graphics g, GameCanvas canvas) {
        g.drawImage(GameObject.bgImgs[0], 0, 0, 20);
    }

    public void drawActor(Graphics g, GameCanvas canvas) {
        this.actor.render(g, canvas);
    }

    public void drawFlying(Graphics g, GameCanvas canvas) {
        int i = 0;
        while (i < flyings.size()) {
            Flying f = (Flying)flyings.elementAt(i);
            f.render(g, canvas);
            ++i;
        }
    }

    public void drawScore(Graphics g, GameCanvas canvas) {
        this.drawScore(g, canvas, 350, 10);
    }

    public void drawScore(Graphics g, GameCanvas canvas, int x, int y) {
        int sco = score;
        int W = 32;
        if (sco >= 100000) {
            g.drawImage(GameObject.scoreImgs[sco / 100000 % 10], x - W * 6, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10000 % 10], x - W * 5, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 1000 % 10], x - W * 4, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - W * 3, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - W * 2, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - W, y, 20);
        } else if (sco >= 10000) {
            g.drawImage(GameObject.scoreImgs[sco / 10000 % 10], x - W * 5, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 1000 % 10], x - W * 4, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - W * 3, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - W * 2, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - W, y, 20);
        } else if (sco >= 1000) {
            g.drawImage(GameObject.scoreImgs[sco / 1000 % 10], x - W * 4, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - W * 3, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - W * 2, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - W, y, 20);
        } else if (sco >= 100) {
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - W * 3, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - W * 2, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - W, y, 20);
        } else if (sco >= 10) {
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - W * 2, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - W, y, 20);
        } else {
            g.drawImage(GameObject.scoreImgs[sco], x - W, y, 20);
        }
    }

    public static void drawFoodScore(Graphics g, GameCanvas canvas, int x, int y, int score) {
        int sco = score;
        boolean positive = true;
        if (sco < 0) {
            sco *= -1;
            positive = false;
        }
        int W = 15;
        if (sco >= 10000) {
            if (!positive) {
                g.drawImage(GameObject.fScoreImgs[10], x - W * 6, y, 20);
            }
            g.drawImage(GameObject.fScoreImgs[sco / 10000 % 10], x - W * 5, y, 20);
            g.drawImage(GameObject.fScoreImgs[sco / 1000 % 10], x - W * 4, y, 20);
            g.drawImage(GameObject.fScoreImgs[sco / 100 % 10], x - W * 3, y, 20);
            g.drawImage(GameObject.fScoreImgs[sco / 10 % 10], x - W * 2, y, 20);
            g.drawImage(GameObject.fScoreImgs[sco % 10], x - W, y, 20);
        } else if (sco >= 1000) {
            if (!positive) {
                g.drawImage(GameObject.fScoreImgs[10], x - W * 5, y, 20);
            }
            g.drawImage(GameObject.fScoreImgs[sco / 1000 % 10], x - W * 4, y, 20);
            g.drawImage(GameObject.fScoreImgs[sco / 100 % 10], x - W * 3, y, 20);
            g.drawImage(GameObject.fScoreImgs[sco / 10 % 10], x - W * 2, y, 20);
            g.drawImage(GameObject.fScoreImgs[sco % 10], x - W, y, 20);
        } else if (sco >= 100) {
            if (!positive) {
                g.drawImage(GameObject.fScoreImgs[10], x - W * 4, y, 20);
            }
            g.drawImage(GameObject.fScoreImgs[sco / 100 % 10], x - W * 3, y, 20);
            g.drawImage(GameObject.fScoreImgs[sco / 10 % 10], x - W * 2, y, 20);
            g.drawImage(GameObject.fScoreImgs[sco % 10], x - W, y, 20);
        }
    }

    public void drawLife(Graphics g, GameCanvas canvas) {
        Image img = GameObject.lifeImgs[0];
        g.drawImage(img, (360 - img.getWidth()) / 2, 580, 20);
        int bw = (1000 - life) * 300 / 1000;
        img = GameObject.lifeImgs[1];
        g.setClip((360 + img.getWidth()) / 2 - bw, 580, bw, 50);
        g.drawImage(img, (360 - img.getWidth()) / 2, 580, 20);
        g.setClip(0, 0, 360, 640);
        img = GameObject.lifeImgs[2];
        g.drawImage(img, (360 - img.getWidth()) / 2, 580, 20);
    }

    public void computeLife() {
        int sec = (int)(now - startTime) / 1000;
        int unit_time = 17;
        if (sec < 10) {
            unit_time *= 17;
            Flying.lifeForOnePoison = -45;
        } else if (sec < 20) {
            unit_time *= 15;
            Flying.lifeForOnePoison = -45;
        } else if (sec < 30) {
            unit_time *= 13;
            Flying.lifeForOnePoison = -42;
        } else if (sec < 40) {
            unit_time *= 11;
            Flying.lifeForOnePoison = -40;
        } else if (sec < 50) {
            unit_time *= 9;
            Flying.lifeForOnePoison = -40;
        } else if (sec < 60) {
            unit_time *= 7;
            Flying.lifeForOnePoison = -38;
        } else if (sec < 70) {
            unit_time *= 6;
            Flying.lifeForOnePoison = -38;
        } else if (sec < 80) {
            unit_time *= 5;
            Flying.lifeForOnePoison = -35;
        } else if (sec < 90) {
            unit_time *= 5;
            Flying.lifeForOnePoison = -35;
        } else if (sec < 100) {
            unit_time *= 4;
            Flying.lifeForOnePoison = -35;
        } else if (sec < 110) {
            unit_time *= 4;
            Flying.lifeForOnePoison = -32;
        } else if (sec < 120) {
            unit_time *= 3;
            Flying.lifeForOnePoison = -32;
        } else if (sec < 130) {
            unit_time *= 3;
            Flying.lifeForOnePoison = -32;
        } else if (sec < 140) {
            unit_time *= 2;
            Flying.lifeForOnePoison = -30;
        } else {
            unit_time *= 1;
            Flying.lifeForOnePoison = -28;
        }
        if (now - lifeLastCutTime > (long)unit_time) {
            lifeLastCutTime = now;
            if (life >= 2) {
                GameLogic.addLife(-2.0);
            } else {
                GameLogic.addLife(-1 * life);
            }
        }
    }

    public void drawSoundBtn(Graphics g, GameCanvas canvas) {
        g.drawImage(GameObject.iconImgs[4], 10, 10, 20);
        Image mimg = null;
        mimg = SoundPlayer.musicFlag ? GameObject.iconImgs[1] : GameObject.iconImgs[0];
        g.drawImage(mimg, 260, 60, 20);
        Image simg = null;
        simg = SoundPlayer.soundFlag ? GameObject.iconImgs[3] : GameObject.iconImgs[2];
        g.drawImage(simg, 310, 60, 20);
    }

    public void drawGameOverBtn(Graphics g, GameCanvas canvas) {
        Image aimg = GameObject.gameOverImgs[1];
        g.drawImage(aimg, 0, 640 - aimg.getHeight(), 20);
        aimg = GameObject.gameOverImgs[2];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, 640 - aimg.getHeight(), 20);
        aimg = GameObject.gameOverImgs[3];
        g.drawImage(aimg, 360 - aimg.getWidth(), 640 - aimg.getHeight(), 20);
    }

    public void drawGameOver(Graphics g, GameCanvas canvas) {
        if (gameOverH < 120) {
            gameOverH += 6;
        } else {
            state = 4;
            this.drawGameOverBtn(g, canvas);
        }
        Image aimg = GameObject.gameOverImgs[0];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, gameOverH, 20);
        aimg = GameObject.gameOverImgs[5];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, gameOverH + 80, 20);
        aimg = GameObject.gameOverImgs[4];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, gameOverH + 230, 20);
        int x = 180;
        int XW = 16;
        int sco = gameOverScore;
        if (sco < 10) {
            x = 196;
        } else if (sco < 100) {
            x = 212;
        } else if (sco < 1000) {
            x = 228;
        } else if (sco < 10000) {
            x = 244;
        } else if (sco < 100000) {
            x = 260;
        } else if (sco < 1000000) {
            x = 276;
        } else if (sco < 10000000) {
            x = 292;
        }
        this.drawScore(g, canvas, x, gameOverH + 230 + 55);
    }

    public void drawPause(Graphics g, GameCanvas canvas) {
        Image aimg = I18NResource.i18Imgs[8];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, (640 - aimg.getHeight()) / 2, 20);
        Font font = Font.getFont((int)0, (int)0, (int)8);
    }

    public void drawGo(Graphics g, GameCanvas canvas) {
        if (now > this.goTimeStamp && this.goCount < 10) {
            this.goTimeStamp = now + 600L;
            ++this.goCount;
        }
        int index = this.goIndexes[this.goCount % this.goIndexes.length];
        Image aimg = GameObject.goImgs[index];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, (640 - aimg.getHeight()) / 2, 20);
        aimg = I18NResource.i18Imgs[9];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, 147, 20);
    }

    public void drawDebug(Graphics g, GameCanvas canvas) {
        g.drawString("pScore:" + String.valueOf(Flying.lifeForOnePoison), 10, 10, 0);
        g.drawString("fScore:" + String.valueOf(Flying.lifeForOneFood), 10, 25, 0);
        g.drawString("life:" + String.valueOf(life), 10, 40, 0);
        g.drawString("fno:" + String.valueOf(Flying.fno), 10, 55, 0);
        g.drawString("hitc:" + String.valueOf(Flying.hitCount), 10, 70, 0);
        g.drawString("diff time:" + String.valueOf((int)((now - startTime) / 1000L)), 10, 85, 0);
        g.drawString("pause.t:" + String.valueOf(pauseTime), 10, 100, 0);
        g.drawString("flaying.s:" + String.valueOf(Flying.flyingSpeed), 10, 115, 0);
    }

    public void step() {
        now = System.currentTimeMillis();
        if (state == 1) {
            int count = 0;
            this.actor.step();
            int i = 0;
            while (i < flyings.size()) {
                Flying f = (Flying)flyings.elementAt(i);
                if (f.isEnabled()) {
                    f.step();
                    f.collisionCheck(this.actor);
                    ++count;
                }
                ++i;
            }
            Flying.prepareMore();
            this.computeLife();
        } else if (state == 3) {
            int i = 0;
            while (i < flyings.size()) {
                Flying f = (Flying)flyings.elementAt(i);
                if (f.isEnabled()) {
                    f.step();
                }
                ++i;
            }
        }
    }

    public void paint(Graphics g, GameCanvas canvas) {
        now = System.currentTimeMillis();
        if (state == 4) {
            return;
        }
        if (state == 0) {
            this.drawBackground(g, canvas);
            this.drawGo(g, canvas);
            return;
        }
        if (state != 2 && state != 4) {
            this.step();
        }
        this.drawBackground(g, canvas);
        this.drawFlying(g, canvas);
        if (state != 3 && state != 4) {
            this.drawActor(g, canvas);
            this.drawScore(g, canvas);
            this.drawLife(g, canvas);
            this.drawSoundBtn(g, canvas);
        }
        if (state == 3 || state == 4) {
            this.drawGameOver(g, canvas);
        }
        if (state == 2) {
            this.drawPause(g, canvas);
        }
    }
}

