/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games.net;

import cc.jmap.games.ParatrooperMidlet;
import cc.jmap.games.net.BTClient;
import cc.jmap.games.net.BTServer;
import cc.jmap.games.net.GameCommand;
import cc.jmap.games.net.MatchInterface;
import cc.jmap.games.net.UDPTransportServer;

public class MatchService
implements MatchInterface {
    private final int CMD_QUEUE_LEN;
    private boolean masterFlag = false;
    private final boolean udpFlag;
    private UDPTransportServer udpServer;
    private BTServer btServer;
    private BTClient btClient;
    private static final int CMD_LEN = 10;
    private int sendProducerIdx = 0;
    private int sendConsumerIdx = 0;
    private GameCommand[] sendCmds = new GameCommand[50];
    private int recvProducerIdx = 0;
    private int recvConsumerIdx = 0;
    private GameCommand[] recvCmds = new GameCommand[50];

    public MatchService() {
        this.CMD_QUEUE_LEN = 50;
        this.udpFlag = false;
        int i = 0;
        while (i < 10) {
            this.sendCmds[i] = GameCommand.newInstance();
            ++i;
        }
        i = 0;
        while (i < 10) {
            this.recvCmds[i] = GameCommand.newInstance();
            ++i;
        }
    }

    public void reset() {
        this.sendProducerIdx = 0;
        this.sendConsumerIdx = 0;
        this.recvProducerIdx = 0;
        this.recvConsumerIdx = 0;
    }

    public void openAsServer() {
        this.masterFlag = true;
        System.out.println("openAsServer()");
        this.btServer = new BTServer(ParatrooperMidlet.instance, this);
    }

    public void searchServers(String serverUrl) {
        this.masterFlag = false;
        this.btClient = new BTClient(ParatrooperMidlet.instance, this);
        this.btClient.requestSearch(serverUrl);
    }

    public void stopAndReset() {
        if (this.btServer != null) {
            this.btServer.destroy();
        }
        if (this.btClient != null) {
            this.btClient.destroy();
        }
    }

    public void cancelService() {
    }

    public void gameStart() {
    }

    public GameCommand dequeueSendCommand() {
        GameCommand cmd = null;
        if (this.sendProducerIdx > this.sendConsumerIdx) {
            cmd = this.sendCmds[this.sendConsumerIdx % 10];
            ++this.sendConsumerIdx;
        }
        return cmd;
    }

    public void sendGameCommand(GameCommand cmdIn) {
        GameCommand cmd = this.sendCmds[this.sendProducerIdx % 10];
        cmd.setValue(cmdIn);
        ++this.sendProducerIdx;
    }

    public GameCommand enqueueRecvCommand(byte[] bytes, int len, int offset) {
        GameCommand cmd = this.recvCmds[this.recvProducerIdx % 10];
        cmd.setFromBytes(bytes, len, offset);
        ++this.recvProducerIdx;
        return cmd;
    }

    public GameCommand recvGameCommand() {
        GameCommand cmd = null;
        if (this.recvProducerIdx > this.recvConsumerIdx) {
            cmd = this.recvCmds[this.recvConsumerIdx % 10];
            ++this.recvConsumerIdx;
        }
        return cmd;
    }
}

