/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.GameEngine;
import cc.jmap.games.GameLogic;
import cc.jmap.games.GameObject;
import cc.jmap.games.I18NResource;
import cc.jmap.games.PageCanvas;
import cc.jmap.games.SoundPlayer;
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.TactileFeedback;
import java.io.IOException;
import java.security.MessageDigest;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.MeasurementRange;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class JumpUpMidlet
extends MIDlet
implements Runnable,
DataListener {
    public static GameEngine engine;
    private int count = 0;
    private int[] channels = new int[3];
    private String[] channelNames = new String[3];
    private SensorConnection sensor;
    private String sensorUrl;
    public static JumpUpMidlet instance;
    private PageCanvas pageCanvas = null;
    private boolean resource_loaded = false;
    private boolean engineStarFlag = false;
    private boolean lightRunningFlag = true;
    public static final boolean DEBUG = false;
    private static boolean firstInit;
    private static final int BUFFER_SIZE = 1;
    public static long gameDisplaytime;
    public static TactileFeedback feedback;

    static {
        instance = null;
        firstInit = false;
        gameDisplaytime = 0L;
        feedback = new TactileFeedback();
    }

    public void startApp() throws MIDletStateChangeException {
        if (!firstInit) {
            firstInit = true;
            instance = this;
            this.pageCanvas = new PageCanvas(this);
            this.loadResource();
            new Thread(this).start();
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pageCanvas);
        } else {
            this.resumeApp();
        }
    }

    public void resumeApp() {
        if (this.pageCanvas.getState() == 0 || GameLogic.instance.getState() == 0 || GameLogic.instance.getState() == 3 || GameLogic.instance.getState() == 4) {
            return;
        }
        GameEngine.repaint();
        System.out.println("TastyDreamMidlet resumeApp()");
    }

    protected void pauseApp() {
        if (this.pageCanvas.getState() == 0 || GameLogic.instance.getState() == 0 || GameLogic.instance.getState() == 4) {
            return;
        }
        engine.pauseEngine();
    }

    private void loadResource() {
        if (!this.resource_loaded) {
            this.resource_loaded = true;
            this.pageCanvas.initOthers();
            engine = new GameEngine(12);
            GameObject.loadResource();
            new SoundPlayer().start();
            SoundPlayer.soundInit();
            this.checkSensor();
        }
    }

    public void gotoBrand() {
        this.loadResource();
    }

    public void gotoMain() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pageCanvas);
        this.pageCanvas.showMain();
    }

    public void gotoPlay() {
        gameDisplaytime = System.currentTimeMillis();
        engine.startEngine();
        JumpUpMidlet.engine.logic.startGame();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Display.getDisplay((MIDlet)this).setCurrent(engine.getDrawingArea());
    }

    private void checkSensor() {
        String sensorVersion = System.getProperty("microedition.sensor.version");
        if (sensorVersion == null) {
            System.out.println("Sensor not supported!");
            try {
                this.destroyApp(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Sensor version: " + sensorVersion);
        this.findSensorInfo();
    }

    public void openSensor() {
        if (this.sensorUrl == null) {
            this.findSensorInfo();
        }
        try {
            this.sensor = (SensorConnection)Connector.open((String)this.sensorUrl);
            this.sensor.setDataListener((DataListener)this, 1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void closeSensor() {
        if (this.sensor != null) {
            try {
                this.sensor.removeDataListener();
                this.sensor.close();
                this.sensor = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        System.out.print("destroyApp #1");
        this.lightRunningFlag = false;
        this.closeSensor();
        engine.stopEngine();
        SoundPlayer.soundFinalize();
        System.out.print("destroyApp #N");
    }

    public void exit() {
        try {
            this.destroyApp(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyDestroyed();
    }

    public void run() {
        try {
            while (this.lightRunningFlag) {
                if (GameLogic.instance.getState() == 1) {
                    DeviceControl.setLights((int)0, (int)80);
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.print("JumpUpMidlet run #N");
    }

    public void dataReceived(SensorConnection sensor, Data[] data, boolean isDataLost) {
        ++this.count;
        int i = 0;
        while (i < data.length) {
            if (data[i].getChannelInfo().getName().compareTo(this.channelNames[0]) == 0) {
                this.channels[0] = data[i].getIntValues()[0];
            } else if (data[i].getChannelInfo().getName().compareTo(this.channelNames[1]) == 0) {
                this.channels[1] = data[i].getIntValues()[0];
            } else if (data[i].getChannelInfo().getName().compareTo(this.channelNames[2]) == 0) {
                this.channels[2] = data[i].getIntValues()[0];
            }
            ++i;
        }
        engine.setX(this.channels[0]);
    }

    private void findSensorInfo() {
        try {
            SensorInfo[] si = SensorManager.findSensors((String)"acceleration", (String)"user");
            int i = 0;
            while (i < si.length) {
                SensorInfo s = si[i];
                System.out.println("getDescription: " + s.getDescription());
                System.out.println("isAvailable: " + s.isAvailable());
                System.out.println("isAvailabilityPushSupported: " + s.isAvailabilityPushSupported());
                System.out.println("isConditionPushSupported: " + s.isConditionPushSupported());
                System.out.println("getConnectionType: " + s.getConnectionType());
                System.out.println("getContextType: " + s.getContextType());
                System.out.println("getMaxBufferSize: " + s.getMaxBufferSize());
                System.out.println("getModel: " + s.getModel());
                System.out.println("getQuantity: " + s.getQuantity());
                this.sensorUrl = s.getUrl();
                System.out.println("getUrl: " + this.sensorUrl);
                System.out.println("Properties:");
                String[] propNames = s.getPropertyNames();
                int r = 0;
                while (r < propNames.length) {
                    System.out.println("  " + propNames[r] + ": " + s.getProperty(propNames[r]));
                    ++r;
                }
                ChannelInfo[] cInfos = s.getChannelInfos();
                if (cInfos.length != 3) {
                    System.out.println("Should support 3 channels but reports " + cInfos.length);
                } else {
                    System.out.println("Channels:");
                    int r2 = 0;
                    while (r2 < cInfos.length) {
                        ChannelInfo c = cInfos[r2];
                        this.channelNames[r2] = c.getName();
                        System.out.println("  getName: " + this.channelNames[r2]);
                        int type = c.getDataType();
                        switch (type) {
                            case 2: {
                                System.out.println("  Data type: TYPE_INT");
                                break;
                            }
                            case 1: {
                                System.out.println("  Data type: TYPE_DOUBLE");
                                System.out.println("Should be TYPE_INT");
                                break;
                            }
                            case 4: {
                                System.out.println("  Data type: TYPE_OBJECT");
                                System.out.println("Should be TYPE_INT");
                            }
                        }
                        System.out.println("  getScale: " + c.getScale());
                        System.out.println("  getUnit: " + c.getUnit().toString());
                        System.out.println("  getAccuracy: " + c.getAccuracy());
                        MeasurementRange[] ranges = c.getMeasurementRanges();
                        System.out.println("  Measurement range:");
                        int p = 0;
                        while (p < ranges.length) {
                            MeasurementRange m = ranges[p];
                            System.out.println("    getSmallestValue:" + m.getSmallestValue());
                            System.out.println("    getLargestValue: " + m.getLargestValue());
                            System.out.println("    getResolution: " + m.getResolution());
                            ++p;
                        }
                        ++r2;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void vibrate() {
        feedback.directFeedback(1);
    }

    public static String getMD5(String s) {
        String ret = "";
        int md5DigestLen = 32;
        byte[] newDigest = new byte[md5DigestLen];
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(s.getBytes("UTF-8"), 0, s.getBytes().length);
            md.digest(newDigest, 0, md5DigestLen);
            StringBuffer hexString = new StringBuffer();
            int i = 0;
            while (i < newDigest.length) {
                hexString.append(Integer.toHexString(newDigest[i] >>> 4 & 0xF));
                hexString.append(Integer.toHexString(0xF & newDigest[i]));
                ++i;
            }
            ret = hexString.toString().substring(0, 32);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static void submitScore(int score) {
        try {
            String imei = System.getProperty("com.nokia.mid.imei");
            String hash = JumpUpMidlet.getMD5(imei);
            String lang = String.valueOf(I18NResource.lang);
            String ts = String.valueOf(GameLogic.startTime);
            String scoreStr = String.valueOf(score);
            String shash = JumpUpMidlet.getMD5(String.valueOf(hash) + scoreStr + ts);
            String url = "http://rank.frienzplay.com/rank/submit/?s=" + scoreStr + "&g=1&h=" + hash + "&sh=" + shash + "&l=" + lang + "&t=" + ts + "&name=jump";
            instance.platformRequest(url);
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            // empty catch block
        }
    }

    public static void viewHighScore() {
        try {
            String imei = System.getProperty("com.nokia.mid.imei");
            String hash = JumpUpMidlet.getMD5(imei);
            String lang = String.valueOf(I18NResource.lang);
            String url = "http://rank.frienzplay.com/rank/top/100/?h=" + hash + "&g=1&l=" + lang + "&name=jump";
            instance.platformRequest(url);
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            // empty catch block
        }
    }
}

