/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.framework.graphics;

import com.foxmobile.ghostcamera.controller.AppController;
import com.foxmobile.ghostcamera.framework.Log;
import com.foxmobile.ghostcamera.framework.Size;
import com.foxmobile.ghostcamera.framework.Streams;
import com.foxmobile.ghostcamera.framework.device.DeviceTraits;
import com.foxmobile.ghostcamera.framework.graphics.AppFont;
import com.foxmobile.ghostcamera.framework.resources.ResourceProvider;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BitmapFont
implements AppFont {
    private static final String TAG;
    private int baseline = 0;
    private int lineHeight = 0;
    private Hashtable map = new Hashtable();
    private Image image;
    private int linePosition = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.foxmobile.ghostcamera.framework.graphics.BitmapFont");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAG = Log.tag(clazz);
    }

    public static AppFont fromBinaryFontFile(String name) {
        BitmapFont font = new BitmapFont();
        font.image = ResourceProvider.getInstance().loadBitmap(name);
        long startTime = System.currentTimeMillis();
        DeviceTraits traits = AppController.getInstance().getDeviceTraits();
        String fontResourceName = String.valueOf(name) + (traits.isLowResolution() ? "-l.fnt.bfnt" : "-h.fnt.bfnt");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.foxmobile.ghostcamera.res.ResourceMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("fonts/" + fontResourceName);
        try {
            try {
                DataInputStream dataStream = new DataInputStream(stream);
                font.baseline = dataStream.readInt();
                font.lineHeight = dataStream.readInt();
                while (dataStream.available() > 0) {
                    Glyph glyph = new Glyph();
                    glyph.code = dataStream.readInt();
                    glyph.x = dataStream.readInt();
                    glyph.y = dataStream.readInt();
                    glyph.width = dataStream.readInt();
                    glyph.height = dataStream.readInt();
                    glyph.xoffset = dataStream.readInt();
                    glyph.yoffset = dataStream.readInt();
                    glyph.xadvance = dataStream.readInt();
                    font.map.put(new Integer(glyph.code), glyph);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        finally {
            Streams.close(stream);
        }
        Log.log(TAG, "Loaded {0} from binary source in {1} ms", name, new Long(System.currentTimeMillis() - startTime));
        Log.log(TAG, "Total glyphs: {0}", new Integer(font.map.size()));
        return font;
    }

    private BitmapFont() {
    }

    public BitmapFont(String name) {
        long startTime = System.currentTimeMillis();
        this.image = ResourceProvider.getInstance().loadBitmap(name);
        DeviceTraits traits = AppController.getInstance().getDeviceTraits();
        String fontResourceName = String.valueOf(name) + (traits.isLowResolution() ? "-l.fnt" : "-h.fnt");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.foxmobile.ghostcamera.res.ResourceMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("fonts/" + fontResourceName);
        try {
            try {
                InputStreamReader reader = new InputStreamReader(stream);
                boolean done = false;
                while (!done) {
                    String line = BitmapFont.readLine(reader);
                    if (line == null) {
                        done = true;
                        continue;
                    }
                    if (line.startsWith("char ")) {
                        this.linePosition = 0;
                        Glyph glyph = new Glyph();
                        glyph.code = this.readInt(line);
                        glyph.x = this.readInt(line);
                        glyph.y = this.readInt(line);
                        glyph.width = this.readInt(line);
                        glyph.height = this.readInt(line);
                        glyph.xoffset = this.readInt(line);
                        glyph.yoffset = this.readInt(line);
                        glyph.xadvance = this.readInt(line);
                        this.map.put(new Integer(glyph.code), glyph);
                        continue;
                    }
                    if (!line.startsWith("common ")) continue;
                    int index = line.indexOf("base=");
                    int valueIndex = index + 5;
                    int endIndex = line.indexOf(32, valueIndex);
                    this.baseline = Integer.parseInt(line.substring(valueIndex, endIndex));
                    index = line.indexOf("lineHeight=");
                    valueIndex = index + 11;
                    endIndex = line.indexOf(32, valueIndex);
                    this.lineHeight = Integer.parseInt(line.substring(valueIndex, endIndex));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load font " + name + ": " + e.getMessage());
            }
        }
        finally {
            Streams.close(stream);
        }
        long delta = System.currentTimeMillis() - startTime;
        Log.log(TAG, "Loaded font {0} in {1} ms", name, new Long(delta));
    }

    private int readInt(String line) {
        int index = line.indexOf(61, this.linePosition);
        int lastIndex = line.indexOf(32, index + 1);
        this.linePosition = lastIndex + 1;
        String value = line.substring(index + 1, lastIndex);
        return Integer.parseInt(value);
    }

    private static String readLine(Reader reader) throws IOException {
        int c;
        StringBuffer buffer = new StringBuffer();
        while ((c = reader.read()) != -1) {
            if (c == 10) {
                return buffer.toString();
            }
            buffer.append((char)c);
        }
        return null;
    }

    public void blitString(Graphics graphics, String string, int x, int y) {
        int cursorX = x;
        int cursorY = y;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            Glyph glyph = (Glyph)this.map.get(new Integer(c));
            if (glyph != null) {
                int srcLeft = glyph.x;
                int srcTop = glyph.y;
                int srcWidth = glyph.width;
                int srcHeight = glyph.height;
                int destLeft = cursorX + glyph.xoffset;
                int destTop = cursorY + glyph.yoffset - this.baseline;
                graphics.drawRegion(this.image, srcLeft, srcTop, srcWidth, srcHeight, 0, destLeft, destTop, 0);
                cursorX += glyph.xadvance;
            }
            ++i;
        }
    }

    public Size measureString(String string, Graphics graphics) {
        int cursorX = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            Glyph glyph = (Glyph)this.map.get(new Integer(c));
            if (glyph != null) {
                cursorX += glyph.xadvance;
                int srcHeight = glyph.height + glyph.yoffset;
                if (srcHeight > maxHeight) {
                    maxHeight = srcHeight;
                }
            }
            ++i;
        }
        return new Size(cursorX, maxHeight);
    }

    public final int getBaseline() {
        return this.baseline;
    }

    public final int getLineHeight() {
        return this.lineHeight;
    }

    public final int getDescent() {
        return this.lineHeight - this.baseline;
    }

    public int getAscent() {
        return this.lineHeight - this.getDescent();
    }

    private static final class Glyph {
        int code;
        int x;
        int y;
        int width;
        int height;
        int xoffset;
        int yoffset;
        int xadvance;

        private Glyph() {
        }
    }
}

