/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.graphics;

import com.foxmobile.ghostcamera.framework.Log;
import com.foxmobile.ghostcamera.framework.Size;
import com.foxmobile.ghostcamera.framework.Timing;
import com.foxmobile.ghostcamera.graphics.CanvasKeyListener;
import com.foxmobile.ghostcamera.graphics.LoopProcedure;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public final class Canvas
extends GameCanvas
implements Runnable {
    private static final String TAG;
    private Thread loopThread;
    private volatile boolean finished = false;
    private volatile LoopProcedure loopProcedure;
    private final Timing timing = new Timing();
    private volatile Size size;
    private volatile boolean firstSizeChanged = false;
    private CanvasKeyListener listener;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.foxmobile.ghostcamera.graphics.Canvas");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAG = Log.tag(clazz);
    }

    public Canvas(CanvasKeyListener listener) {
        super(false);
        this.listener = listener;
    }

    public void launchLoop() {
        this.loopThread = new Thread((Runnable)this, "loop");
        this.loopThread.start();
    }

    public void run() {
        try {
            Graphics graphics = this.getGraphics();
            if (this.size == null) {
                this.size = new Size(this.getWidth(), this.getHeight());
            }
            while (!this.finished) {
                if (this.loopProcedure != null) {
                    this.timing.updateBeforeFrame();
                    this.loopProcedure.executeLoop(graphics, this.timing);
                    this.timing.updateAfterFrame();
                    continue;
                }
                graphics.setColor(0);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        catch (Throwable t) {
            Log.log(TAG, "Error in canvas: {0}", t);
        }
    }

    public void setLoopProcedure(LoopProcedure loopProcedure) {
        this.loopProcedure = loopProcedure;
    }

    public void finish() {
        this.finished = true;
    }

    protected void sizeChanged(int w, int h) {
        super.sizeChanged(w, h);
        if (!this.firstSizeChanged) {
            this.firstSizeChanged = true;
        }
        this.size = new Size(w, h);
        this.listener.sizeChanged(w, h);
    }

    public synchronized boolean isFirstSizeChanged() {
        return this.firstSizeChanged;
    }

    protected void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        this.listener.keyPressed(keyCode);
    }

    protected void keyReleased(int keyCode) {
        super.keyReleased(keyCode);
        this.listener.keyReleased(keyCode);
    }

    public Graphics getGraphics() {
        return super.getGraphics();
    }
}

