/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.controller.state.components;

import com.foxmobile.ghostcamera.controller.AppController;
import com.foxmobile.ghostcamera.framework.Timing;
import com.foxmobile.ghostcamera.framework.graphics.Sprite;
import com.foxmobile.ghostcamera.graphics.Canvas;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class TitleHeader {
    private Random random = new Random();
    private Sprite sprite;
    private Canvas canvas;
    private boolean isShaking = false;
    private float shakingVelocity = 0.0f;
    private float shakingDistance = 0.0f;
    private float shakingDistanceLeft = 0.0f;
    private boolean halfWayPassed = false;
    private long nextShakeInstant;

    public TitleHeader(Canvas canvas) {
        this.canvas = canvas;
        this.calculateNextShakeInstant();
        Image headerImage = (Image)AppController.getInstance().getPreparedResources().getResource("titleHeader");
        this.sprite = new Sprite(headerImage, true);
        this.resetPosition();
    }

    private void resetPosition() {
        this.sprite.setX((this.canvas.getWidth() - this.sprite.getWidth()) / 2);
        this.sprite.setY(this.canvas.getHeight() / 10);
    }

    private void calculateNextShakeInstant() {
        this.nextShakeInstant = this.random.nextInt(4) == 0 ? System.currentTimeMillis() : System.currentTimeMillis() + (long)((this.random.nextInt(4) + 1) * 1000);
    }

    public void blit(Graphics graphics) {
        this.sprite.blit(graphics);
    }

    public void updatePosition(Timing timing) {
        long currentInstant = System.currentTimeMillis();
        if (this.isShaking) {
            if (this.shakingDistanceLeft <= 0.0f) {
                this.isShaking = false;
                this.resetPosition();
                this.calculateNextShakeInstant();
            } else {
                if (!this.halfWayPassed && this.shakingDistanceLeft < this.shakingDistance / 2.0f) {
                    this.shakingVelocity = -this.shakingVelocity;
                    this.halfWayPassed = true;
                }
                float delta = timing.calculateDelta(this.shakingVelocity);
                this.sprite.moveY(delta);
                this.shakingDistanceLeft -= Math.abs(delta);
            }
        } else if (currentInstant >= this.nextShakeInstant) {
            this.isShaking = true;
            this.shakingDistanceLeft = this.shakingDistance = (float)(this.random.nextInt(5) + 2);
            this.shakingVelocity = this.shakingVelocity <= 0.0f ? -50.0f : 50.0f;
            this.halfWayPassed = false;
        }
    }

    public boolean isLightingTime() {
        return this.isShaking && Math.abs(this.shakingDistance - this.shakingDistanceLeft) <= 2.0f;
    }
}

