/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.framework.graphics;

import com.foxmobile.ghostcamera.controller.AppController;
import com.foxmobile.ghostcamera.framework.Log;
import com.foxmobile.ghostcamera.framework.device.DeviceTraits;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Bitmaps {
    private static final String TAG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.foxmobile.ghostcamera.framework.graphics.Bitmaps");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAG = Log.tag(clazz);
    }

    private Bitmaps() {
    }

    public static void alphaBlend(int alpha, int backgroundColor, int[] source, int[] target) {
        int i = 0;
        while (i < source.length) {
            int value = source[i];
            if ((value & 0xFF000000) != 0) {
                int rb = (value & 0xFF00FF) * alpha + (backgroundColor & 0xFF00FF) * (255 - alpha) & 0xFF00FF00;
                int g = (value & 0xFF00) * alpha + (backgroundColor & 0xFF00) * (255 - alpha) & 0xFF0000;
                target[i] = value & 0xFF000000 | (rb | g) >> 8;
            } else {
                target[i] = source[i];
            }
            ++i;
        }
    }

    public static final Image scaleImageHq(Image orgImage, int newWidth, int newHeight) {
        int orgWidth = orgImage.getWidth();
        int orgHeight = orgImage.getHeight();
        int orgLength = orgWidth * orgHeight;
        int orgMax = orgLength - 1;
        int[] rawInput = new int[orgLength];
        orgImage.getRGB(rawInput, 0, orgWidth, 0, 0, orgWidth, orgHeight);
        int newLength = newWidth * newHeight;
        int[] rawOutput = new int[newLength];
        int yd = (orgHeight / newHeight - 1) * orgWidth;
        int yr = orgHeight % newHeight;
        int xd = orgWidth / newWidth;
        int xr = orgWidth % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int y = newHeight;
        int ye = 0;
        while (y > 0) {
            int x = newWidth;
            int xe = 0;
            while (x > 0) {
                int pixelA = inOffset;
                int pixelB = pixelA + 1;
                int pixelC = pixelA + orgWidth;
                int pixelD = pixelC + 1;
                pixelA = rawInput[pixelA];
                pixelB = pixelB > orgMax ? pixelA : rawInput[pixelB];
                pixelC = pixelC > orgMax ? pixelA : rawInput[pixelC];
                pixelD = pixelD > orgMax ? pixelB : rawInput[pixelD];
                int xo = (xe << 8) / newWidth;
                int yo = (ye << 8) / newHeight;
                int weightD = xo * yo;
                int weightC = (yo << 8) - weightD;
                int weightB = (xo << 8) - weightD;
                int weightA = 65536 - weightB - weightC - weightD;
                int redA = pixelA >> 16;
                int redB = pixelB >> 16;
                int redC = pixelC >> 16;
                int redD = pixelD >> 16;
                int greenA = pixelA & 0xFF00;
                int greenB = pixelB & 0xFF00;
                int greenC = pixelC & 0xFF00;
                int greenD = pixelD & 0xFF00;
                int blueA = pixelA & 0xFF;
                int blueB = pixelB & 0xFF;
                int blueC = pixelC & 0xFF;
                int blueD = pixelD & 0xFF;
                int red = 0xFF0000 & redA * weightA + redB * weightB + redC * weightC + redD * weightD;
                int green = 0xFF000000 & greenA * weightA + greenB * weightB + greenC * weightC + greenD * weightD;
                int blue = 0xFF0000 & blueA * weightA + blueB * weightB + blueC * weightC + blueD * weightD;
                rawOutput[outOffset++] = red + ((green | blue) >> 16);
                inOffset += xd;
                if ((xe += xr) >= newWidth) {
                    xe -= newWidth;
                    ++inOffset;
                }
                --x;
            }
            inOffset += yd;
            if ((ye += yr) >= newHeight) {
                ye -= newHeight;
                inOffset += orgWidth;
            }
            --y;
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)false);
    }

    public static Image scaleImageFast(Image original, int newWidth, int newHeight) {
        long startTime = System.currentTimeMillis();
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int YD = original.getHeight() / newHeight * original.getWidth() - original.getWidth();
        int YR = original.getHeight() % newHeight;
        int XD = original.getWidth() / newWidth;
        int XR = original.getWidth() % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int y = newHeight;
        int YE = 0;
        while (y > 0) {
            int x = newWidth;
            int XE = 0;
            while (x > 0) {
                rawOutput[outOffset++] = rawInput[inOffset];
                inOffset += XD;
                if ((XE += XR) >= newWidth) {
                    XE -= newWidth;
                    ++inOffset;
                }
                --x;
            }
            inOffset += YD;
            if ((YE += YR) >= newHeight) {
                YE -= newHeight;
                inOffset += original.getWidth();
            }
            --y;
        }
        Image result = Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
        long endTime = System.currentTimeMillis();
        Log.log(TAG, "Time to resize the bitmap: {0} ms", new Long(endTime - startTime));
        return result;
    }

    public static Image scaleImage(Image sourceImage, int newWidth, int newHeight) {
        return Bitmaps.scaleImageFast(sourceImage, newWidth, newHeight);
    }

    public static Image invertImage(Image background) {
        int[] input = new int[background.getWidth() * background.getHeight()];
        background.getRGB(input, 0, background.getWidth(), 0, 0, background.getWidth(), background.getHeight());
        int[] output = new int[input.length];
        int i = 0;
        while (i < input.length) {
            output[i] = ~input[i];
            ++i;
        }
        return Image.createRGBImage((int[])output, (int)background.getWidth(), (int)background.getHeight(), (boolean)false);
    }

    public static Image alphaBlend(int alpha, int color, Image source) {
        int[] input = new int[source.getWidth() * source.getHeight()];
        source.getRGB(input, 0, source.getWidth(), 0, 0, source.getWidth(), source.getHeight());
        int[] output = new int[input.length];
        Bitmaps.alphaBlend(alpha, color, input, output);
        return Image.createRGBImage((int[])output, (int)source.getWidth(), (int)source.getHeight(), (boolean)false);
    }

    public static Image scaleImageWidth(Image source, int desiredWidth) {
        float imageAspect = (float)source.getWidth() / (float)source.getHeight();
        int resultingHeight = (int)((float)desiredWidth / imageAspect);
        return Bitmaps.scaleImage(source, desiredWidth, resultingHeight);
    }

    public static Image scaleImageHeight(Image source, int desiredHeight) {
        float imageAspect = (float)source.getWidth() / (float)source.getHeight();
        int resultingWidth = (int)((float)desiredHeight * imageAspect);
        return Bitmaps.scaleImage(source, resultingWidth, desiredHeight);
    }

    public static Image scaleImageForBackground(Image source) {
        DeviceTraits deviceTraits = AppController.getInstance().getDeviceTraits();
        Image scaledBackground = deviceTraits.isScreenWiderThanTaller() ? Bitmaps.scaleImageWidth(source, deviceTraits.getCanvasWidth()) : Bitmaps.scaleImage(source, deviceTraits.getCanvasWidth(), deviceTraits.getCanvasHeight());
        return scaledBackground;
    }

    public static Image rotateImageLeft(Image source) {
        Image result = Image.createImage((int)source.getHeight(), (int)source.getWidth());
        Graphics graphics = result.getGraphics();
        graphics.drawRegion(source, 0, 0, source.getWidth(), source.getHeight(), 5, 0, 0, 0);
        return result;
    }

    public static Image applyAlpha(Image target, Image source, int left, int top, int alphaShift) {
        int[] targetBytes = new int[target.getWidth() * target.getHeight()];
        int[] sourceBytes = new int[source.getWidth() * source.getHeight()];
        target.getRGB(targetBytes, 0, target.getWidth(), 0, 0, target.getWidth(), target.getHeight());
        source.getRGB(sourceBytes, 0, source.getWidth(), 0, 0, source.getWidth(), source.getHeight());
        int y = 0;
        while (y < source.getHeight()) {
            int yTarget = y + top;
            if (yTarget < target.getHeight() && yTarget >= 0) {
                int x = 0;
                while (x < source.getWidth()) {
                    int xTarget = x + left;
                    if (xTarget < target.getWidth() && xTarget >= 0) {
                        int sourceValue = sourceBytes[x + y * source.getWidth()];
                        int targetOffset = xTarget + yTarget * target.getWidth();
                        int targetValue = targetBytes[targetOffset];
                        targetBytes[targetOffset] = Bitmaps.blendPixel(targetValue, sourceValue, alphaShift);
                    }
                    ++x;
                }
            }
            ++y;
        }
        return Image.createRGBImage((int[])targetBytes, (int)target.getWidth(), (int)target.getHeight(), (boolean)false);
    }

    private static final int blendPixel(int bg, int src, int alphaShift) {
        int a = (src >> 24 & 0xFF) >> alphaShift;
        if (a == 0) {
            return bg;
        }
        int rb = (src & 0xFF00FF) * a + (bg & 0xFF00FF) * (255 - a) & 0xFF00FF00;
        int g = (src & 0xFF00) * a + (bg & 0xFF00) * (255 - a) & 0xFF0000;
        return (rb | g) >> 8;
    }
}

