/*
 * Decompiled with CFR 0.152.
 */
package com.astrolink;

import com.astrolink.Brick;
import com.astrolink.CanvasMenu;
import com.astrolink.CanvasSelectLevel;
import com.astrolink.Common;
import com.astrolink.MediaCenter;
import com.astrolink.MidletPuzzle;
import com.astrolink.ResourceManager;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class CanvasGame
extends Canvas
implements Runnable {
    public static final String END_PATH = "/res/music/start.amr";
    public static final String BG_PATH = "/res/music/start.amr";
    public static final int MAX_TIME = 999;
    public static final long SECOND_TIME = 100L;
    public static final long ANIMATION_TIME = 20L;
    public static int SPEED_FLY;
    public long sleepTime;
    public int state;
    public static final int GAMING = 0;
    public static final int PAUSE = 1;
    public static final int KEY_FLY_OUT = 2;
    public static final int BRICK_FLY_OUT = 3;
    public static final int KEY_FLY_IN = 4;
    public static final int BRICK_FLY_IN = 5;
    boolean[][] isStuffed;
    Brick[] bricks;
    Brick curBrick;
    String curLevelData;
    int curLevel;
    int yLevel;
    int curNumBricks;
    int maxLevelWidth;
    int halfMaxLevelWidth;
    int curTime;
    int yTime;
    boolean isRunning;
    Thread thread;
    public int indexPop;
    public int xPoint;
    public int yPoint;
    public static MediaCenter hitMedia;
    public static MediaCenter endMedia;
    public static MediaCenter gameMedia;
    public static int HALF_HALF_HEIGHT;
    int widthNum = ResourceManager.imgNums[0].getWidth();
    int heightNum = ResourceManager.imgNums[0].getHeight();
    int widthTime = ResourceManager.imgUse.getWidth() + ResourceManager.imgTime.getWidth() + ResourceManager.imgSecond.getWidth() + this.widthNum * 3;
    int xUse = Common.WIDTH - this.widthTime >>> 1;

    public void showNotify() {
    }

    public void hideNotify() {
        ResourceManager.loadPause();
        this.state = 1;
    }

    public CanvasGame(int indexLevel) {
        this.setFullScreenMode(true);
        Brick.resetStuffed();
        this.curLevel = indexLevel;
        this.initTextPosition();
        this.initLevelData();
        this.sleepTime = 20L;
        this.setBrickBound();
        this.state = 4;
        this.threadStart();
        if (CanvasMenu.hasMusic) {
            CanvasGame.playBG();
        }
    }

    final void resetGame() {
        Brick.resetStuffed();
        this.curTime = 0;
        this.initTextPosition();
        this.initLevelData();
        this.setBrickBound();
    }

    final void updateLevel() {
        Brick.resetStuffed();
        ++this.curLevel;
        this.curTime = 0;
        this.initTextPosition();
        this.initLevelData();
        this.setBrickBound();
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, Common.WIDTH, Common.HEIGHT);
        g.setColor(0);
        g.setFont(Common.largeFont);
        g.drawImage(ResourceManager.imgBackground, 0, 0, 20);
        switch (this.state) {
            case 5: {
                g.drawImage(ResourceManager.imgBound, Common.HALF_WIDTH, Common.HALF_HEIGHT, 3);
                this.drawLevel(g);
                this.drawTime(g);
                this.drawFlyBricks(g);
                break;
            }
            case 4: {
                g.drawImage(ResourceManager.imgBound, Common.HALF_WIDTH, Common.HALF_HEIGHT, 3);
                this.drawLevel(g);
                this.drawTime(g);
                g.drawImage(this.bricks[this.curNumBricks - 1].image, this.bricks[this.curNumBricks - 1].getBoundPosition(), this.bricks[this.curNumBricks - 1].y, 20);
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                g.drawImage(ResourceManager.imgBound, Common.HALF_WIDTH, Common.HALF_HEIGHT, 3);
                this.drawLevel(g);
                this.drawTime(g);
                this.drawBricks(g);
                break;
            }
            case 1: {
                this.drawPause(g);
            }
        }
    }

    final void drawPause(Graphics g) {
        for (int i = 0; i < ResourceManager.imgPop.length; ++i) {
            g.drawImage(ResourceManager.imgPop[i], Common.HALF_WIDTH, HALF_HALF_HEIGHT + i * HALF_HALF_HEIGHT, 3);
        }
        g.drawImage(ResourceManager.imgPopSelect, Common.HALF_WIDTH, HALF_HALF_HEIGHT + this.indexPop * HALF_HALF_HEIGHT, 3);
    }

    public static final boolean pointArea(int pointX, int pointY, int x, int y, int width, int height) {
        boolean isIn = false;
        if (pointX >= x && pointX <= x + width && pointY >= y && pointY <= y + height) {
            isIn = true;
        }
        return isIn;
    }

    protected void pointerDragged(int x, int y) {
        if (this.xPoint != 0 && this.yPoint != 0) {
            switch (this.curBrick.getType()) {
                case 0: {
                    if (this.xPoint > x) {
                        if (this.curBrick.getPositionX() <= 0 || this.xPoint - x < Brick.WIDTH_CELL) break;
                        this.xPoint = x;
                        this.keyReleased(Common.KEY_LEFT);
                        break;
                    }
                    if (this.curBrick.getPositionX() + this.curBrick.getSize() >= 6 || x - this.xPoint < Brick.WIDTH_CELL) break;
                    this.xPoint = x;
                    this.keyReleased(Common.KEY_RIGHT);
                    break;
                }
                case 1: {
                    if (this.yPoint > y) {
                        if (this.curBrick.getPositionY() <= 0 || this.yPoint - y < Brick.WIDTH_CELL) break;
                        this.yPoint = y;
                        this.keyReleased(Common.KEY_UP);
                        break;
                    }
                    if (this.curBrick.getPositionY() + this.curBrick.getSize() >= 6 || y - this.yPoint < Brick.WIDTH_CELL) break;
                    this.yPoint = y;
                    this.keyReleased(Common.KEY_DOWN);
                }
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        block0 : switch (this.state) {
            case 0: {
                for (int i = 0; i < this.bricks.length; ++i) {
                    if (!CanvasGame.pointArea(x, y, this.bricks[i].x, this.bricks[i].y, this.bricks[i].getWidth(), this.bricks[i].getHeight())) continue;
                    this.keyReleased(this.bricks[i].getCode());
                    this.xPoint = x;
                    this.yPoint = y;
                    break block0;
                }
                break;
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        switch (this.state) {
            case 0: {
                this.xPoint = 0;
                this.yPoint = 0;
                if (!CanvasGame.pointArea(x, y, 0, Common.HEIGHT - 30, Common.WIDTH, 30)) break;
                this.keyReleased(Common.KEY_SOFT_LEFT);
                break;
            }
            case 1: {
                this.indexPop = y / (Common.HEIGHT / ResourceManager.imgPop.length);
                this.repaint();
                this.keyReleased(Common.KEY_SOFT_LEFT);
            }
        }
    }

    protected void keyReleased(int key) {
        block43: {
            block47: {
                block48: {
                    block46: {
                        block45: {
                            block44: {
                                block42: {
                                    if (key != Common.KEY_UP) break block42;
                                    switch (this.state) {
                                        case 0: {
                                            this.curBrick.moveUp();
                                            break;
                                        }
                                        case 1: {
                                            --this.indexPop;
                                            if (this.indexPop >= 0) break;
                                            this.indexPop = ResourceManager.imgPop.length - 1;
                                        }
                                    }
                                    this.repaint();
                                    break block43;
                                }
                                if (key != Common.KEY_DOWN) break block44;
                                switch (this.state) {
                                    case 0: {
                                        this.curBrick.moveDown();
                                        break;
                                    }
                                    case 1: {
                                        ++this.indexPop;
                                        if (this.indexPop < ResourceManager.imgPop.length) break;
                                        this.indexPop = 0;
                                    }
                                }
                                this.repaint();
                                break block43;
                            }
                            if (key != Common.KEY_LEFT) break block45;
                            switch (this.state) {
                                case 0: {
                                    this.curBrick.moveLeft();
                                }
                            }
                            this.repaint();
                            break block43;
                        }
                        if (key != Common.KEY_RIGHT) break block46;
                        switch (this.state) {
                            case 0: {
                                this.curBrick.moveRight();
                                if (!Brick.isWin) break;
                                if (CanvasMenu.hasMusic) {
                                    // empty if block
                                }
                                CanvasMenu.passLevel(this.curLevel);
                                this.sleepTime = 20L;
                                this.setBrickBound();
                                this.state = 2;
                                Brick.isWin = false;
                            }
                        }
                        this.repaint();
                        break block43;
                    }
                    if (key != Common.KEY_SOFT_LEFT) break block47;
                    block14 : switch (this.state) {
                        case 0: {
                            ResourceManager.loadPause();
                            this.state = 1;
                            break;
                        }
                        case 1: {
                            switch (this.indexPop) {
                                case 0: {
                                    this.state = 0;
                                    break block14;
                                }
                                case 1: {
                                    this.resetGame();
                                    this.sleepTime = 20L;
                                    this.state = 4;
                                    if (CanvasMenu.hasMusic) {
                                        CanvasGame.playBG();
                                        break block14;
                                    }
                                    break block48;
                                }
                                case 2: {
                                    this.threadStop();
                                    MidletPuzzle.midlet.showCanvasMenu();
                                }
                            }
                        }
                    }
                }
                this.repaint();
                break block43;
            }
            if (key == Common.KEY_SOFT_RIGHT) {
                switch (this.state) {
                    case 0: {
                        ResourceManager.loadPause();
                        this.state = 1;
                        break;
                    }
                    case 1: {
                        this.state = 0;
                    }
                }
                this.repaint();
            } else if (key == 48 || key == 49 || key == 50 || key == 51 || key == 52 || key == 53 || key == 54 || key == 55 || key == 56 || key == 57 || key == 42 || key == 35 || key == Common.KEY_FIRE) {
                block27 : switch (this.state) {
                    case 0: {
                        for (int i = 0; i < this.bricks.length; ++i) {
                            if (this.bricks[i].getCode() != key) continue;
                            this.curBrick.setIsActivity(false);
                            this.bricks[i].setIsActivity(true);
                            this.curBrick = this.bricks[i];
                            this.repaint();
                            break block27;
                        }
                        break;
                    }
                    case 1: {
                        if (key == Common.KEY_FIRE) {
                            this.keyReleased(Common.KEY_SOFT_LEFT);
                            break;
                        }
                        switch (key) {
                            case 50: {
                                this.keyReleased(Common.KEY_UP);
                                break block27;
                            }
                            case 56: {
                                this.keyReleased(Common.KEY_DOWN);
                            }
                        }
                    }
                }
            }
        }
    }

    final void initTextPosition() {
        this.yLevel = (Brick.Y_START >>> 1) - (this.heightNum >>> 1);
        this.maxLevelWidth = this.widthNum * 3;
        this.halfMaxLevelWidth = this.maxLevelWidth >>> 1;
        this.yTime = (Common.HEIGHT - (Brick.Y_START + 6 * Brick.WIDTH_CELL) >>> 1) + (Brick.Y_START + 6 * Brick.WIDTH_CELL);
    }

    final void drawTime(Graphics g) {
        g.drawImage(ResourceManager.imgUse, this.xUse, this.yTime, 6);
        g.drawImage(ResourceManager.imgTime, this.xUse + ResourceManager.imgUse.getWidth(), this.yTime, 6);
        this.drawNumber(g, this.curTime, this.xUse + ResourceManager.imgUse.getWidth() + ResourceManager.imgTime.getWidth() + (3 * this.widthNum >>> 1), this.yTime - (this.heightNum >>> 1));
        g.drawImage(ResourceManager.imgSecond, this.xUse + ResourceManager.imgUse.getWidth() + ResourceManager.imgTime.getWidth() + 3 * this.widthNum, this.yTime, 6);
    }

    final void drawLevel(Graphics g) {
        g.drawImage(ResourceManager.imgPer, Common.HALF_WIDTH - this.halfMaxLevelWidth, this.yLevel + (Common.largeFont.getHeight() >>> 1), 10);
        this.drawNumber(g, this.curLevel + 1, Common.HALF_WIDTH, this.yLevel);
        g.drawImage(ResourceManager.imgLevel, Common.HALF_WIDTH + this.halfMaxLevelWidth, this.yLevel + (Common.largeFont.getHeight() >>> 1), 6);
        if (Common.PASS_LEVEL[this.curLevel]) {
            g.drawImage(ResourceManager.imgCompleted, Common.HALF_WIDTH + this.halfMaxLevelWidth + ResourceManager.imgLevel.getWidth(), this.yLevel + (Common.largeFont.getHeight() >>> 1), 6);
        }
    }

    final void drawNumber(Graphics g, int num, int xCenter, int y) {
        String strNum = null;
        int x = 0;
        if (num < 10) {
            x = xCenter - (this.widthNum >>> 1);
        } else if (num < 100) {
            x = xCenter - this.widthNum;
        } else if (num < 1000) {
            x = xCenter - this.widthNum - (this.widthNum >>> 1);
        }
        strNum = String.valueOf(num);
        for (int i = 0; i < strNum.length(); ++i) {
            int index = Integer.parseInt(strNum.substring(i, i + 1));
            g.drawImage(ResourceManager.imgNums[index], x + i * this.widthNum, y, 20);
        }
    }

    final void drawFlyBricks(Graphics g) {
        block4: for (int i = 0; i < this.curNumBricks; ++i) {
            switch (this.bricks[i].getType()) {
                case 0: {
                    g.drawImage(this.bricks[i].image, this.bricks[i].getBoundPosition(), this.bricks[i].y, 20);
                    continue block4;
                }
                case 1: {
                    g.drawImage(this.bricks[i].image, this.bricks[i].x, this.bricks[i].getBoundPosition(), 20);
                }
            }
        }
    }

    final void drawBricks(Graphics g) {
        for (int i = 0; i < this.curNumBricks; ++i) {
            g.drawImage(this.bricks[i].image, this.bricks[i].x, this.bricks[i].y, 20);
            if (this.state != 0 || this.bricks[i].getIsActivity()) continue;
            g.drawImage(this.bricks[i].imgCode, this.bricks[i].xCode, this.bricks[i].yCode, 20);
        }
    }

    public void run() {
        int cnt = 0;
        while (this.isRunning) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            switch (this.state) {
                case 0: {
                    if (++cnt <= 10) break;
                    cnt = 0;
                    if (this.curTime >= 999) break;
                    ++this.curTime;
                    this.repaint();
                    break;
                }
                case 2: {
                    if (this.curBrick.x < this.curBrick.getBoundPosition()) {
                        this.curBrick.x += SPEED_FLY;
                        this.repaint();
                        break;
                    }
                    this.state = 3;
                    cnt = 0;
                    break;
                }
                case 3: {
                    this.moveOut();
                    this.repaint();
                    break;
                }
                case 4: {
                    if (this.curBrick.getBoundPosition() <= this.curBrick.x) break;
                    this.curBrick.setBoundPosition(this.curBrick.getBoundPosition() - SPEED_FLY);
                    if (this.curBrick.getBoundPosition() <= this.curBrick.x) {
                        this.curBrick.setBoundPosition(this.curBrick.x);
                        this.state = 5;
                    }
                    this.repaint();
                    break;
                }
                case 5: {
                    this.moveIn();
                    this.repaint();
                }
            }
        }
    }

    public final void moveIn() {
        int i;
        boolean isFlying = true;
        block4: for (i = 0; i < this.curNumBricks - 1; ++i) {
            if (this.bricks[i].isReachBound()) continue;
            switch (this.bricks[i].getType()) {
                case 0: {
                    if (this.bricks[i].getPositionX() >= 3) {
                        if (this.bricks[i].getBoundPosition() <= this.bricks[i].x) continue block4;
                        this.bricks[i].setBoundPosition(this.bricks[i].getBoundPosition() - SPEED_FLY);
                        if (this.bricks[i].getBoundPosition() > this.bricks[i].x) continue block4;
                        this.bricks[i].setBoundPosition(this.bricks[i].x);
                        this.bricks[i].setReachBound(true);
                        continue block4;
                    }
                    if (this.bricks[i].getBoundPosition() >= this.bricks[i].x) continue block4;
                    this.bricks[i].setBoundPosition(this.bricks[i].getBoundPosition() + SPEED_FLY);
                    if (this.bricks[i].getBoundPosition() < this.bricks[i].x) continue block4;
                    this.bricks[i].setBoundPosition(this.bricks[i].x);
                    this.bricks[i].setReachBound(true);
                    continue block4;
                }
                case 1: {
                    if (this.bricks[i].getPositionY() >= 3) {
                        if (this.bricks[i].getBoundPosition() <= this.bricks[i].y) continue block4;
                        this.bricks[i].setBoundPosition(this.bricks[i].getBoundPosition() - SPEED_FLY);
                        if (this.bricks[i].getBoundPosition() > this.bricks[i].y) continue block4;
                        this.bricks[i].setBoundPosition(this.bricks[i].y);
                        this.bricks[i].setReachBound(true);
                        continue block4;
                    }
                    if (this.bricks[i].getBoundPosition() >= this.bricks[i].y) continue block4;
                    this.bricks[i].setBoundPosition(this.bricks[i].getBoundPosition() + SPEED_FLY);
                    if (this.bricks[i].getBoundPosition() < this.bricks[i].y) continue block4;
                    this.bricks[i].setBoundPosition(this.bricks[i].y);
                    this.bricks[i].setReachBound(true);
                }
            }
        }
        for (i = 0; i < this.curNumBricks - 1; ++i) {
            if (this.bricks[i].isReachBound()) continue;
            isFlying = false;
            break;
        }
        if (isFlying) {
            this.sleepTime = 100L;
            this.state = 0;
        }
    }

    public final void moveOut() {
        int i;
        boolean isFlying = true;
        block8: for (i = 0; i < this.curNumBricks - 1; ++i) {
            if (this.bricks[i].isReachBound()) continue;
            if (this.bricks[i].getBoundPosition() < 0) {
                switch (this.bricks[i].getType()) {
                    case 0: {
                        if (this.bricks[i].x <= this.bricks[i].getBoundPosition()) break;
                        this.bricks[i].x -= SPEED_FLY;
                        if (this.bricks[i].x > this.bricks[i].getBoundPosition()) break;
                        this.bricks[i].setReachBound(true);
                        break;
                    }
                    case 1: {
                        if (this.bricks[i].y <= this.bricks[i].getBoundPosition()) break;
                        this.bricks[i].y -= SPEED_FLY;
                        if (this.bricks[i].y > this.bricks[i].getBoundPosition()) break;
                        this.bricks[i].setReachBound(true);
                    }
                }
                continue;
            }
            switch (this.bricks[i].getType()) {
                case 0: {
                    if (this.bricks[i].x >= this.bricks[i].getBoundPosition()) continue block8;
                    this.bricks[i].x += SPEED_FLY;
                    if (this.bricks[i].x < this.bricks[i].getBoundPosition()) continue block8;
                    this.bricks[i].setReachBound(true);
                    continue block8;
                }
                case 1: {
                    if (this.bricks[i].y >= this.bricks[i].getBoundPosition()) continue block8;
                    this.bricks[i].y += SPEED_FLY;
                    if (this.bricks[i].y < this.bricks[i].getBoundPosition()) continue block8;
                    this.bricks[i].setReachBound(true);
                }
            }
        }
        for (i = 0; i < this.curNumBricks - 1; ++i) {
            if (this.bricks[i].isReachBound()) continue;
            isFlying = false;
            break;
        }
        if (isFlying) {
            if (this.curLevel >= 99) {
                this.threadStop();
                MidletPuzzle.midlet.showCanvasMenu();
            } else {
                this.updateLevel();
                this.state = 4;
                if (CanvasMenu.hasMusic) {
                    CanvasGame.playBG();
                }
            }
        }
    }

    public final void initLevelData() {
        this.curLevelData = CanvasSelectLevel.levelData[this.curLevel];
        String[] data = Common.spliteString(this.curLevelData, '|');
        this.curNumBricks = data.length;
        this.bricks = new Brick[this.curNumBricks];
        for (int i = 0; i < this.curNumBricks; ++i) {
            int[] info = CanvasSelectLevel.getLevelData(data[i], ',');
            this.bricks[i] = new Brick(info, i);
            if (i == this.curNumBricks - 1) {
                this.bricks[i].setIsKey(true);
                this.bricks[i].setIsActivity(true);
                this.curBrick = this.bricks[i];
            }
            this.bricks[i].setImage();
        }
    }

    final void setBrickBound() {
        for (int i = 0; i < this.bricks.length; ++i) {
            this.bricks[i].setBoundPosition();
            this.bricks[i].setReachBound(false);
        }
        this.bricks[this.bricks.length - 1].setBoundPosition(Common.WIDTH);
    }

    public static final void playHit() {
    }

    public static final void playBG() {
        if (gameMedia == null) {
            gameMedia = new MediaCenter("/res/music/start.amr", "audio/amr");
        }
        gameMedia.startPlay();
    }

    public static final void playEnd() {
        if (endMedia == null) {
            endMedia = new MediaCenter("/res/music/start.amr", "audio/amr");
        }
        endMedia.startPlay();
    }

    public final void releasePlayer() {
        if (hitMedia != null) {
            hitMedia.closePlayer();
            hitMedia = null;
        }
        if (endMedia != null) {
            endMedia.closePlayer();
            endMedia = null;
        }
    }

    final void threadStop() {
        this.isRunning = false;
        if (this.thread != null) {
            this.thread = null;
        }
    }

    final void threadStart() {
        this.isRunning = true;
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
        this.thread.start();
    }

    static {
        HALF_HALF_HEIGHT = Common.HALF_HEIGHT >>> 1;
    }
}

