/*
 * Decompiled with CFR 0.152.
 */
package com.astrolink;

import com.astrolink.CanvasGame;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;

public class Common {
    static Common instance;
    public final String URL_CONFIG;
    public static final Font largeFont;
    public static final Font defaultFont;
    public static final Font smallFont;
    public static int WIDTH;
    public static int HEIGHT;
    public static int HALF_WIDTH;
    public static int HALF_HEIGHT;
    public static int[] X_SETTING;
    public static int[] Y_SETTING;
    public static final int MENU_DISTANCE = 3;
    public static final int NUM_LEVELS = 100;
    public static final int NUM_MODES = 5;
    public static final int PER_MODES = 20;
    public static boolean[] PASS_LEVEL;
    public static boolean[] PASS_MODE;
    public static int KEY_UP;
    public static int KEY_DOWN;
    public static int KEY_LEFT;
    public static int KEY_RIGHT;
    public static int KEY_FIRE;
    public static int KEY_SOFT_LEFT;
    public static int KEY_SOFT_RIGHT;
    public static final int KEY_0 = 48;
    public static final int KEY_1 = 49;
    public static final int KEY_2 = 50;
    public static final int KEY_3 = 51;
    public static final int KEY_4 = 52;
    public static final int KEY_5 = 53;
    public static final int KEY_6 = 54;
    public static final int KEY_7 = 55;
    public static final int KEY_8 = 56;
    public static final int KEY_9 = 57;
    public static final int KEY_POUND = 35;
    public static final int KEY_STAR = 42;

    private Common() {
        this.URL_CONFIG = "/res/config/config.txt";
    }

    public static final Common getInstance() {
        if (instance == null) {
            instance = new Common();
        }
        return instance;
    }

    public final void setFeature(String[] feature) {
        if (feature == null) {
            return;
        }
        if (feature[0].equals("width")) {
            WIDTH = Integer.parseInt(feature[1]);
            HALF_WIDTH = WIDTH >>> 1;
        } else if (feature[0].equals("height")) {
            HEIGHT = Integer.parseInt(feature[1]);
            HALF_HEIGHT = HEIGHT >>> 1;
        } else if (feature[0].equals("KEY_UP")) {
            KEY_UP = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("KEY_DOWN")) {
            KEY_DOWN = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("KEY_LEFT")) {
            KEY_LEFT = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("KEY_RIGHT")) {
            KEY_RIGHT = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("KEY_FIRE")) {
            KEY_FIRE = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("KEY_SOFT_LEFT")) {
            KEY_SOFT_LEFT = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("KEY_SOFT_RIGHT")) {
            KEY_SOFT_RIGHT = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("X_SETTING0")) {
            Common.X_SETTING[0] = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("X_SETTING1")) {
            Common.X_SETTING[1] = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("X_SETTING2")) {
            Common.X_SETTING[2] = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("X_SETTING3")) {
            Common.X_SETTING[3] = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("Y_SETTING0")) {
            Common.Y_SETTING[0] = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("Y_SETTING1")) {
            Common.Y_SETTING[1] = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("Y_SETTING2")) {
            Common.Y_SETTING[2] = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("Y_SETTING3")) {
            Common.Y_SETTING[3] = Integer.parseInt(feature[1]);
        } else if (feature[0].equals("SPEED_FLY")) {
            CanvasGame.SPEED_FLY = Integer.parseInt(feature[1]);
        }
    }

    public final void setConfig() {
        String data = this.loadText("/res/config/config.txt");
        String[] items = Common.spliteString(data);
        for (int i = 0; i < items.length; ++i) {
            String[] feature = Common.spliteString(items[i], '=');
            try {
                this.setFeature(feature);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public final String loadText(String url) {
        String content = null;
        InputStream is = this.getClass().getResourceAsStream(url);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        int length = -1;
        try {
            is.skip(3L);
            while ((length = is.read(buffer)) > 0) {
                baos.write(buffer, 0, length);
            }
            byte[] data = baos.toByteArray();
            content = new String(data, "UTF-8");
            baos.close();
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return content.trim();
    }

    public static final String[] spliteString(String source, char ch) {
        if (source == null) {
            return null;
        }
        Object[] result = null;
        Vector<String> vector = new Vector<String>();
        int startIndex = 0;
        String element = null;
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) == ch) {
                element = source.substring(startIndex, i).trim();
                vector.addElement(element);
                startIndex = i + 1;
                continue;
            }
            if (i != source.length() - 1) continue;
            element = source.substring(startIndex).trim();
            vector.addElement(element);
            break;
        }
        result = new String[vector.size()];
        vector.copyInto(result);
        return result;
    }

    public static final String[] spliteString(String source) {
        if (source == null) {
            return null;
        }
        Object[] result = null;
        Vector<String> vector = new Vector<String>();
        int startIndex = 0;
        String element = null;
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) == '\n') {
                element = i != 0 && source.charAt(i - 1) == '\r' ? source.substring(startIndex, i - 1).trim() : source.substring(startIndex, i).trim();
                vector.addElement(element);
                startIndex = i + 1;
                continue;
            }
            if (i != source.length() - 1) continue;
            element = i != 0 && source.charAt(i - 1) == '\r' ? source.substring(startIndex, i - 1).trim() : source.substring(startIndex).trim();
            vector.addElement(element);
        }
        result = new String[vector.size()];
        vector.copyInto(result);
        return result;
    }

    static {
        largeFont = Font.getFont((int)0, (int)0, (int)16);
        defaultFont = Font.getDefaultFont();
        smallFont = Font.getFont((int)0, (int)0, (int)8);
        WIDTH = 240;
        HEIGHT = 320;
        HALF_WIDTH = WIDTH >>> 1;
        HALF_HEIGHT = HEIGHT >>> 1;
        X_SETTING = new int[4];
        Y_SETTING = new int[4];
        KEY_UP = -1;
        KEY_DOWN = -2;
        KEY_LEFT = -3;
        KEY_RIGHT = -4;
        KEY_FIRE = -5;
        KEY_SOFT_LEFT = -6;
        KEY_SOFT_RIGHT = -7;
    }
}

