/*
 * Decompiled with CFR 0.152.
 */
import breakpoint.canvas.BreakpointCanvas;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class MainMenu
extends BreakpointCanvas {
    private final int HIGHSCORES_NO;
    private final String BACK;
    private final String MAIN_CONTINUE;
    private final String MAIN_NEW_GAME;
    private final String MAIN_HIGH_SCORES;
    private final String MAIN_INSTRUCTIONS;
    private final String MAIN_OPTIONS;
    private final String MAIN_ABOUT;
    private final String MAIN_EXIT;
    private final String OPTIONS_SOUND;
    private final String OPTIONS_ON;
    private final String OPTIONS_OFF;
    private final String INSTRUCTIONS_TEXT;
    private final String ABOUT_TEXT;
    private final String OPTIONS_COLOR;
    private final int MENU_NONE;
    private final int MENU_OPTIONS;
    private final int MENU_HIGH_SCORES;
    private final int MENU_INSTRUCTIONS;
    private final int MENU_ABOUT;
    private final int MENU_OPTIONS_SOUND;
    private final int MENU_OPTIONS_VIBRA;
    private final int MENU_OPTIONS_COLOR;
    private final int MENU_OPTIONS_LEVEL;
    private final int RECT_COLOR;
    private final int RECT_FILL_COLOR;
    private final int ACTIVE_RECT_COLOR;
    private final int FONT_COLOR;
    private final int FONT_SELECTED_COLOR;
    private final int LINES_SPACING;
    private int active;
    private int activeSoundItem;
    private int activeVibraItem;
    private int activeLevelItem;
    private int activeColorItem;
    private String[] items;
    private String[] mainItems = new String[]{"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438", "\u041d\u043e\u0432\u0430\u044f \u0438\u0433\u0440\u0430", "\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u044b", "\u0421\u0430\u043c\u044b\u0439 \u0445\u043e\u0440\u043e\u0448\u0438\u0439", "\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438", "\u0410\u0432\u0442\u043e\u0440\u044b", "\u0417\u0430\u043a\u043e\u043d\u0447\u0438"};
    private String[] optionsItems = new String[]{"\u0417\u0432\u0443\u043a", "\u0446\u0432\u0435\u0442", "\u0412\u043e\u0437\u0432\u0440\u0430\u0442"};
    private String[] optionsSoundItems = new String[]{"\u0412\u043a\u043b\u044e\u0447\u0438", "\u0412\u044b\u043a\u043b\u044e\u0447\u0438", "\u0412\u043e\u0437\u0432\u0440\u0430\u0442"};
    private String[] optionsVibraItems;
    private String[] optionsColorItems = new String[]{"\u0412\u043a\u043b\u044e\u0447\u0438", "\u0412\u044b\u043a\u043b\u044e\u0447\u0438", "\u0412\u043e\u0437\u0432\u0440\u0430\u0442"};
    private String[] optionsLevelItems;
    private String[] highscoresItems;
    private String[] instructionsItems;
    private String[] aboutItems;
    private String[] hsNicks;
    private int[] hsPoints;
    private int hsNewIndex;
    private boolean isActiveThread;
    private boolean movingCloser;
    private final int SELECTORS_MAX_OFFSET;
    private final int SLEEP_TIME;
    private int selectorsOffset;
    private Jajka midlet;
    private int numDrawnItems;
    private int firstDrawnItem;
    private int fontHeight;
    private int divPoint;
    private int lastAction;
    private int activeMenu;
    private int mainIndex;
    private int selectedItem;
    private int firstDrawnOptionsItem;
    private int selectedOptionsItem;
    private Image background;
    private Image[] arrows;
    private boolean isContinue;
    private boolean isSelector;
    private boolean isActive;
    private boolean isNewHighscore;
    private boolean firstPaint = true;
    private boolean keyLock = false;

    public MainMenu(Jajka jajka) {
        this.HIGHSCORES_NO = 6;
        this.BACK = "\u0412\u043e\u0437\u0432\u0440\u0430\u0442";
        this.MAIN_CONTINUE = "\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438";
        this.MAIN_NEW_GAME = "\u041d\u043e\u0432\u0430\u044f \u0438\u0433\u0440\u0430";
        this.MAIN_HIGH_SCORES = "\u0421\u0430\u043c\u044b\u0439 \u0445\u043e\u0440\u043e\u0448\u0438\u0439";
        this.MAIN_INSTRUCTIONS = "\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438";
        this.MAIN_OPTIONS = "\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u044b";
        this.MAIN_ABOUT = "\u0410\u0432\u0442\u043e\u0440\u044b";
        this.MAIN_EXIT = "\u0417\u0430\u043a\u043e\u043d\u0447\u0438";
        this.OPTIONS_SOUND = "\u0417\u0432\u0443\u043a";
        this.OPTIONS_ON = "\u0412\u043a\u043b\u044e\u0447\u0438";
        this.OPTIONS_OFF = "\u0412\u044b\u043a\u043b\u044e\u0447\u0438";
        this.INSTRUCTIONS_TEXT = "\u041f\u043e\u0438\u0433\u0440\u0430\u0439 \u0435\u0449\u0435 \u0440\u0430\u0437 \u0432 \u044d\u0442\u0443 \u0438\u0433\u0440\u0443! \u0411\u043e\u043b\u044c\u0448\u043e\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u00ab\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!\u00bb \u041f\u043e\u043c\u043e\u0433\u0438 \u0432\u043e\u043b\u043a\u0443 \u043b\u043e\u0432\u0438\u0442\u044c \u044f\u0439\u0446\u0430. \u041a\u0430\u0436\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0441\u0442\u043e? \u041d\u043e \u043f\u043e\u043c\u043d\u0438, \u0447\u0442\u043e \u044f\u0438\u0446 \u0431\u0443\u0434\u0435\u0442 \u0432\u0441\u0435 \u0431\u043e\u043b\u044c\u0448\u0435 \u0438 \u0431\u043e\u043b\u044c\u0448\u0435, \u0430 \u0422\u044b \u043c\u043e\u0436\u0435\u0448\u044c \u0443\u0440\u043e\u043d\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0440\u0438 \u0438\u0437\n\u043d\u0438\u0445";
        this.ABOUT_TEXT = "\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u043e:\n\u0412r\u0435\u0430k\u0440\u043ei\u043ft\nwww.br\u0435\u0430k\u0440\u043ei\u043ft.\u0440l\n\n\u0412\u0441\u0435\n\u043f\u0440\u0430\u0432\u0430\n\u0437\u0430\u0449\u0438\u0449\u0435\u043d\u044b";
        this.OPTIONS_COLOR = "\u0446\u0432\u0435\u0442";
        this.MENU_NONE = 0;
        this.MENU_OPTIONS = 1;
        this.MENU_HIGH_SCORES = 2;
        this.MENU_INSTRUCTIONS = 3;
        this.MENU_ABOUT = 4;
        this.MENU_OPTIONS_SOUND = 20;
        this.MENU_OPTIONS_VIBRA = 21;
        this.MENU_OPTIONS_COLOR = 22;
        this.MENU_OPTIONS_LEVEL = 23;
        this.RECT_COLOR = 7434856;
        this.RECT_FILL_COLOR = 9474436;
        this.ACTIVE_RECT_COLOR = 3947830;
        this.FONT_COLOR = -16777216;
        this.FONT_SELECTED_COLOR = -65536;
        this.LINES_SPACING = 0;
        this.SELECTORS_MAX_OFFSET = 5;
        this.SLEEP_TIME = 100;
        try {
            this.arrows = new Image[]{Image.createImage((String)"/ruskie/arrow_left.png"), Image.createImage((String)"/ruskie/arrow_right.png"), Image.createImage((String)"/ruskie/arrows_none.png"), Image.createImage((String)"/ruskie/arrows_up_down.png"), Image.createImage((String)"/ruskie/arrows_up.png"), Image.createImage((String)"/ruskie/arrows_down.png")};
            this.background = Image.createImage((String)"/ruskie/title.png");
        }
        catch (IOException iOException) {
            System.out.println("nie udalo sie zaladowac obrazkow menu");
        }
        this.midlet = jajka;
        this.fontHeight = Jajka.f.getHeight();
        this.divPoint = BreakpointCanvas.MY - this.fontHeight - 2;
        this.numDrawnItems = (this.divPoint - 1 - this.arrows[2].getHeight()) / (this.fontHeight + 0);
        this.aboutItems = this.stringToArray("\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u043e:\n\u0412r\u0435\u0430k\u0440\u043ei\u043ft\nwww.br\u0435\u0430k\u0440\u043ei\u043ft.\u0440l\n\n\u0412\u0441\u0435\n\u043f\u0440\u0430\u0432\u0430\n\u0437\u0430\u0449\u0438\u0449\u0435\u043d\u044b");
        this.instructionsItems = this.stringToArray("\u041f\u043e\u0438\u0433\u0440\u0430\u0439 \u0435\u0449\u0435 \u0440\u0430\u0437 \u0432 \u044d\u0442\u0443 \u0438\u0433\u0440\u0443! \u0411\u043e\u043b\u044c\u0448\u043e\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u00ab\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!\u00bb \u041f\u043e\u043c\u043e\u0433\u0438 \u0432\u043e\u043b\u043a\u0443 \u043b\u043e\u0432\u0438\u0442\u044c \u044f\u0439\u0446\u0430. \u041a\u0430\u0436\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0441\u0442\u043e? \u041d\u043e \u043f\u043e\u043c\u043d\u0438, \u0447\u0442\u043e \u044f\u0438\u0446 \u0431\u0443\u0434\u0435\u0442 \u0432\u0441\u0435 \u0431\u043e\u043b\u044c\u0448\u0435 \u0438 \u0431\u043e\u043b\u044c\u0448\u0435, \u0430 \u0422\u044b \u043c\u043e\u0436\u0435\u0448\u044c \u0443\u0440\u043e\u043d\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0440\u0438 \u0438\u0437\n\u043d\u0438\u0445");
        this.hsNicks = new String[6];
        this.hsPoints = new int[6];
        this.highscoresItems = new String[6];
    }

    public boolean getSound() {
        return this.activeSoundItem == 0;
    }

    public boolean getVibra() {
        return this.activeVibraItem == 0;
    }

    public boolean getColor() {
        return this.activeColorItem == 0;
    }

    public void setSound(boolean bl) {
        this.activeSoundItem = bl ? 0 : 1;
    }

    public void setVibra(boolean bl) {
        this.activeVibraItem = bl ? 0 : 1;
    }

    public void setColor(boolean bl) {
        this.activeColorItem = bl ? 0 : 1;
        this.midlet.setColor(this.getColor());
    }

    public void setHighscores(String string, int n) {
        int n2;
        for (n2 = 0; n2 < 6 && this.hsPoints[n2] > n; ++n2) {
        }
        if (n2 != 6) {
            if (this.hsPoints[n2] != n) {
                for (int i = 4; i >= n2; --i) {
                    this.hsNicks[i + 1] = this.hsNicks[i];
                    this.hsPoints[i + 1] = this.hsPoints[i];
                }
            }
            this.hsNicks[n2] = string;
            this.hsPoints[n2] = n;
            this.isNewHighscore = true;
        }
        this.prepareHighscoresItems();
    }

    public boolean getContinue() {
        return this.isContinue;
    }

    public int getLastHighscore() {
        return this.hsPoints[5];
    }

    public void setContinue(boolean bl) {
        this.isContinue = bl;
        if (this.isNewHighscore) {
            this.items = this.highscoresItems;
            this.mainIndex = 3;
            this.items = this.highscoresItems;
            this.activeMenu = 2;
            this.isNewHighscore = false;
        } else {
            this.mainIndex = this.isContinue ? 0 : 1;
            this.activeMenu = 0;
        }
    }

    private void scrollUp() {
        if (this.firstDrawnItem > 0) {
            --this.firstDrawnItem;
        }
    }

    private void scrollDown() {
        if (this.firstDrawnItem + this.numDrawnItems < this.items.length) {
            ++this.firstDrawnItem;
        }
    }

    private void itemUp() {
        if (this.selectedItem > 0) {
            --this.selectedItem;
        } else {
            this.scrollUp();
        }
    }

    private void itemDown() {
        int n;
        int n2 = n = this.items.length - this.firstDrawnItem >= this.numDrawnItems ? this.numDrawnItems : this.items.length - this.firstDrawnItem;
        if (this.selectedItem < n - 1) {
            ++this.selectedItem;
        } else {
            this.scrollDown();
        }
    }

    private void prepareHighscoresItems() {
        for (int i = 0; i < 6; ++i) {
            this.highscoresItems[i] = this.hsNicks[i] + ": " + this.hsPoints[i];
        }
    }

    protected void keyPressed(int n) {
        if (this.keyLock) {
            return;
        }
        if (this.firstPaint) {
            this.firstPaint = false;
            this.repaint();
            this.serviceRepaints();
            return;
        }
        if (n != -7 && n != -6) {
            this.lastAction = this.getGameAction(n);
            switch (this.activeMenu) {
                case 0: {
                    this.actionsNone(this.lastAction);
                    break;
                }
                case 2: {
                    this.actionsHighScores(this.lastAction);
                    break;
                }
                case 3: {
                    this.actionsInstructions(this.lastAction);
                    break;
                }
                case 4: {
                    this.actionsAbout(this.lastAction);
                    break;
                }
                case 1: {
                    this.actionsOptions(this.lastAction);
                    break;
                }
                case 20: {
                    this.actionsOptionsSound(this.lastAction);
                    break;
                }
                case 22: {
                    this.actionsOptionsColor(this.lastAction);
                }
            }
            this.repaint();
            this.serviceRepaints();
        }
    }

    private void actionsNone(int n) {
        block0 : switch (n) {
            case 1: {
                break;
            }
            case 6: {
                break;
            }
            case 2: {
                --this.mainIndex;
                if ((this.isContinue || this.mainIndex >= 1) && this.mainIndex >= 0) break;
                this.mainIndex = this.mainItems.length - 1;
                break;
            }
            case 5: {
                ++this.mainIndex;
                if (this.mainIndex != this.mainItems.length) break;
                this.mainIndex = this.isContinue ? 0 : 1;
                break;
            }
            case 8: {
                switch (this.mainIndex) {
                    case 0: {
                        this.keyLock = true;
                        this.midlet.showGame(true);
                        break block0;
                    }
                    case 1: {
                        this.keyLock = true;
                        this.midlet.showGame(false);
                        break block0;
                    }
                    case 2: {
                        this.items = this.optionsItems;
                        this.isSelector = true;
                        this.activeMenu = 1;
                        break block0;
                    }
                    case 3: {
                        this.items = this.highscoresItems;
                        this.activeMenu = 2;
                        break block0;
                    }
                    case 4: {
                        this.items = this.instructionsItems;
                        this.activeMenu = 3;
                        break block0;
                    }
                    case 5: {
                        this.items = this.aboutItems;
                        this.activeMenu = 4;
                        break block0;
                    }
                    case 6: {
                        this.midlet.destroyApp(true);
                        this.midlet.notifyDestroyed();
                    }
                }
            }
        }
    }

    private void actionsInstructions(int n) {
        switch (this.lastAction) {
            case 1: {
                this.scrollUp();
                break;
            }
            case 6: {
                this.scrollDown();
                break;
            }
            case 2: {
                this.mainIndex -= 2;
            }
            case 5: {
                ++this.mainIndex;
            }
            case 8: {
                this.firstDrawnItem = 0;
                this.activeMenu = 0;
            }
        }
    }

    private void actionsAbout(int n) {
        switch (this.lastAction) {
            case 1: {
                this.scrollUp();
                break;
            }
            case 6: {
                this.scrollDown();
                break;
            }
            case 2: {
                this.mainIndex -= 2;
            }
            case 5: {
                ++this.mainIndex;
            }
            case 8: {
                this.firstDrawnItem = 0;
                this.activeMenu = 0;
            }
        }
    }

    private void actionsHighScores(int n) {
        switch (this.lastAction) {
            case 1: {
                this.scrollUp();
                break;
            }
            case 6: {
                this.scrollDown();
                break;
            }
            case 2: {
                this.mainIndex -= 2;
            }
            case 5: {
                ++this.mainIndex;
            }
            case 8: {
                this.firstDrawnItem = 0;
                this.activeMenu = 0;
            }
        }
    }

    private void actionsOptions(int n) {
        block0 : switch (this.lastAction) {
            case 1: {
                this.itemUp();
                break;
            }
            case 6: {
                this.itemDown();
                break;
            }
            case 2: {
                this.mainIndex -= 2;
            }
            case 5: {
                ++this.mainIndex;
                this.isActive = false;
                this.isSelector = false;
                this.activeMenu = 0;
                break;
            }
            case 8: {
                this.firstDrawnOptionsItem = this.firstDrawnItem;
                this.selectedOptionsItem = this.selectedItem;
                int n2 = this.firstDrawnItem + this.selectedItem;
                this.selectedItem = 0;
                this.firstDrawnItem = 0;
                this.isActive = true;
                switch (n2) {
                    case 0: {
                        this.items = this.optionsSoundItems;
                        this.active = this.activeSoundItem;
                        this.activeMenu = 20;
                        break block0;
                    }
                    case 1: {
                        this.items = this.optionsColorItems;
                        this.active = this.activeColorItem;
                        this.activeMenu = 22;
                        break block0;
                    }
                    case 2: {
                        this.isActive = false;
                        this.isSelector = false;
                        this.activeMenu = 0;
                    }
                }
            }
        }
    }

    private void actionsOptionsSound(int n) {
        block0 : switch (this.lastAction) {
            case 1: {
                this.itemUp();
                break;
            }
            case 6: {
                this.itemDown();
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 8: {
                switch (this.firstDrawnItem + this.selectedItem) {
                    case 0: {
                        this.active = 0;
                        break block0;
                    }
                    case 1: {
                        this.active = 1;
                        break block0;
                    }
                    case 2: {
                        this.activeSoundItem = this.active;
                        this.backToOptions();
                    }
                }
            }
        }
    }

    private void actionsOptionsColor(int n) {
        block0 : switch (this.lastAction) {
            case 1: {
                this.itemUp();
                break;
            }
            case 6: {
                this.itemDown();
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 8: {
                switch (this.firstDrawnItem + this.selectedItem) {
                    case 0: {
                        this.active = 0;
                        break block0;
                    }
                    case 1: {
                        this.active = 1;
                        break block0;
                    }
                    case 2: {
                        this.activeColorItem = this.active;
                        this.setColor(this.getColor());
                        this.backToOptions();
                    }
                }
            }
        }
    }

    private void backToOptions() {
        this.items = this.optionsItems;
        this.firstDrawnItem = this.firstDrawnOptionsItem;
        this.selectedItem = this.selectedOptionsItem;
        this.isActive = false;
        this.activeMenu = 1;
    }

    private final String[] stringToArray(String string) {
        int[] nArray = new int[200];
        int n = 0;
        int n2 = BreakpointCanvas.MX - 12;
        int n3 = 0;
        int n4 = 1;
        while (true) {
            int n5 = n4;
            if ((n4 = string.indexOf(32, n4 + 1)) == -1 || Jajka.f.substringWidth(string, n3, n4 - n3 + 1) > n2 && n5 == n3 + 1) {
                while (n5 < string.length() && Jajka.f.substringWidth(string, n3, n5 - n3 + 1) <= n2) {
                    ++n5;
                }
                if ((n4 = --n5 + 1) > string.length() - 1) {
                    n4 = -1;
                }
            }
            if (n4 != -1 && Jajka.f.substringWidth(string, n3, n4 - n3 + 1) <= n2) continue;
            n4 = string.indexOf(10, n3);
            if (n4 != -1 && n4 < n5) {
                n5 = n4;
            }
            nArray[++n - 1] = n3;
            nArray[++n - 1] = n5 + 1;
            n3 = n5 + 1;
            n4 = n5 + 2;
            if (n5 >= string.length() - 1) break;
        }
        String[] stringArray = new String[n / 2];
        int n6 = 0;
        int n7 = 0;
        while (n6 < n) {
            stringArray[n7] = string.substring(nArray[n6], nArray[n6 + 1]);
            n6 += 2;
            ++n7;
        }
        return stringArray;
    }

    protected void paint(Graphics graphics) {
        graphics.drawImage(this.background, 0, 0, 20);
        if (!this.firstPaint) {
            this.paintMainMenu(graphics);
            if (this.activeMenu != 0) {
                this.paintActiveMenu(graphics);
                this.paintStrings(graphics);
            }
        }
    }

    private void paintMainMenu(Graphics graphics) {
        int n = Jajka.f.stringWidth(this.mainItems[this.mainIndex]);
        int n2 = (BreakpointCanvas.MX - n) / 2;
        graphics.drawImage(this.arrows[1], 2, this.divPoint + 1, 20);
        graphics.drawImage(this.arrows[0], BreakpointCanvas.MX - 3, this.divPoint + 1, 24);
        Jajka.f.drawString(graphics, this.mainItems[this.mainIndex], n2, this.divPoint + 1);
    }

    private void paintActiveMenu(Graphics graphics) {
        boolean bl = this.items.length <= this.numDrawnItems;
        boolean bl2 = this.firstDrawnItem > 0;
        boolean bl3 = this.firstDrawnItem + this.numDrawnItems < this.items.length;
        graphics.setClip(0, 0, 176, 208);
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        directGraphics.setARGBColor(9474436);
        graphics.fillRect(1, 1, BreakpointCanvas.MX - 2, this.divPoint - 2);
        directGraphics.setARGBColor(7434856);
        graphics.drawRect(1, 1, BreakpointCanvas.MX - 3, this.divPoint - 3);
        int n = bl ? 2 : (bl3 && bl2 ? 3 : (bl2 ? 4 : 5));
        graphics.drawImage(this.arrows[n], BreakpointCanvas.MX / 2, this.divPoint - 4, 33);
    }

    private void paintStrings(Graphics graphics) {
        int n = this.items.length - this.firstDrawnItem >= this.numDrawnItems ? this.numDrawnItems : this.items.length - this.firstDrawnItem;
        for (int i = 0; i < n; ++i) {
            int n2 = 3 + i * (this.fontHeight + 0);
            if (this.activeMenu == 2) {
                n2 = 3 + i * (this.fontHeight + 0 + 10);
            }
            if (this.activeMenu == 1 || this.activeMenu == 20 || this.activeMenu == 22) {
                n2 = 60 + i * (this.fontHeight + 0 + 5);
            }
            if (this.isActive && this.active == i + this.firstDrawnItem) {
                graphics.setColor(3947830);
                graphics.fillRect(2, n2 + 1, BreakpointCanvas.MX - 4, this.fontHeight);
            }
            int n3 = Jajka.f.stringWidth(this.items[i + this.firstDrawnItem]);
            Jajka.f.drawString(graphics, this.items[i + this.firstDrawnItem], (BreakpointCanvas.MX - n3) / 2, n2);
            if (!this.isSelector || this.selectedItem != i) continue;
            this.paintSelector(graphics, n2 + 1);
        }
    }

    private void paintSelector(Graphics graphics, int n) {
        graphics.drawImage(this.arrows[0], 2 + this.selectorsOffset, n - 1, 20);
        graphics.drawImage(this.arrows[1], BreakpointCanvas.MX - 3 - this.selectorsOffset, n - 1, 24);
    }

    protected void hideNotify() {
        Jajka.setSound(this.getSound());
        Jajka.setVibra(false);
        this.midlet.setColor(this.getColor());
    }

    protected void showNotify() {
        this.keyLock = false;
        MainMenu mainMenu = this;
        this.setSound(mainMenu.midlet.getSound());
        MainMenu mainMenu2 = this;
        this.setVibra(mainMenu2.midlet.getVibra());
    }

    public void load(String string) {
        byte[] byArray = this.readFromRMS(string);
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            try {
                this.setSound(dataInputStream.readBoolean());
                this.setVibra(dataInputStream.readBoolean());
                this.setColor(dataInputStream.readBoolean());
                Jajka.setSound(this.getSound());
                Jajka.setVibra(this.getVibra());
                this.setContinue(dataInputStream.readBoolean());
                if (this.getContinue()) {
                    this.midlet.loadGame(dataInputStream);
                }
                for (int i = 0; i < 6; ++i) {
                    int n = dataInputStream.readInt();
                    this.hsNicks[i] = "";
                    for (int j = 0; j < n; ++j) {
                        this.hsNicks[i] = this.hsNicks[i] + dataInputStream.readChar();
                    }
                    this.hsPoints[i] = dataInputStream.readInt();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.out.println("brak rms");
            this.setSound(true);
            this.setVibra(true);
            this.setColor(true);
            Jajka.setSound(this.getSound());
            Jajka.setVibra(this.getVibra());
            this.setContinue(false);
            for (int i = 0; i < 6; ++i) {
                this.hsNicks[i] = "-----";
                this.hsPoints[i] = 0;
            }
        }
        this.prepareHighscoresItems();
    }

    public void save(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeBoolean(this.getSound());
            dataOutputStream.writeBoolean(this.getVibra());
            dataOutputStream.writeBoolean(this.getColor());
            dataOutputStream.writeBoolean(this.getContinue());
            if (this.getContinue()) {
                this.midlet.saveGame(dataOutputStream);
                System.out.println("po saveGame()");
            }
            for (int i = 0; i < 6; ++i) {
                dataOutputStream.writeInt(this.hsNicks[i].length());
                dataOutputStream.writeChars(this.hsNicks[i]);
                dataOutputStream.writeInt(this.hsPoints[i]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.writeToRMS(byteArrayOutputStream.toByteArray(), string);
    }

    private void writeToRMS(byte[] byArray, String string) {
        if (byArray == null || string == null) {
            throw new NullPointerException("byte = " + byArray + "name = " + string);
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() != 0) {
                recordStore.deleteRecord(recordStore.getNextRecordID() - 1);
            }
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            System.out.println("Rms not found.");
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            System.out.println("Rms not open.");
        }
        catch (RecordStoreFullException recordStoreFullException) {
            System.out.println("Rms full.");
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println("Rms exception (other than: not open, full and doesn't exist).");
        }
    }

    private byte[] readFromRMS(String string) {
        if (string == null) {
            throw new NullPointerException("name = " + string);
        }
        byte[] byArray = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() != 0) {
                byArray = recordStore.getRecord(recordStore.getNextRecordID() - 1);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            System.out.println("Rms not found.");
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            System.out.println("Rms not open.");
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return byArray;
    }
}

