/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d;

import java.io.DataInputStream;

public class LQMesh2 {
    private boolean hasMapping;
    private boolean hasVC;
    private boolean hasN;
    private short[] vertices;
    private int vertexNum;
    private short[] texels;
    private int texVertNum;
    private byte[] colors;
    private int colVertNum;
    private int triangleListNum;
    private int[][] triPosIndices;
    private int[][] triTexIndices;
    private int[][] triColIndices;
    private static boolean enableBuffer = false;

    public LQMesh2(DataInputStream dis) {
        try {
            this.v2FromStream(dis);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void v2FromStream(DataInputStream dis) throws Exception {
        int i;
        this.hasMapping = dis.readInt() > 0;
        this.hasVC = dis.readInt() > 0;
        this.hasN = dis.readInt() > 0;
        this.vertexNum = dis.readInt();
        this.vertices = new short[this.vertexNum * 3];
        for (i = 0; i < this.vertexNum * 3; ++i) {
            this.vertices[i] = dis.readShort();
        }
        if (this.hasMapping) {
            this.texVertNum = dis.readInt();
            this.texels = new short[this.texVertNum * 2];
            int TexImgWidth = 256;
            int TexImgHeight = 256;
            for (int i2 = 0; i2 < this.texVertNum; ++i2) {
                this.texels[i2 * 2] = (short)(dis.readFloat() * 256.0f);
                this.texels[i2 * 2 + 1] = (short)(dis.readFloat() * 256.0f);
            }
        }
        if (this.hasVC) {
            this.colVertNum = dis.readInt();
            this.colors = new byte[this.colVertNum * 4];
            for (i = 0; i < this.colVertNum; ++i) {
                int c = dis.readInt();
                this.colors[i * 4] = (byte)(c >> 16 & 0xFF);
                this.colors[i * 4 + 1] = (byte)(c >> 8 & 0xFF);
                this.colors[i * 4 + 2] = (byte)(c & 0xFF);
                this.colors[i * 4 + 3] = -1;
            }
        }
        if (this.hasN) {
            // empty if block
        }
        this.triangleListNum = dis.readInt();
        this.triPosIndices = new int[this.triangleListNum][];
        this.triTexIndices = new int[this.triangleListNum][];
        this.triColIndices = new int[this.triangleListNum][];
        for (int triListIndex = 0; triListIndex < this.triangleListNum; ++triListIndex) {
            int triNum = dis.readInt();
            if (triNum <= 0) continue;
            this.triPosIndices[triListIndex] = new int[triNum * 3];
            if (this.hasVC) {
                this.triColIndices[triListIndex] = new int[triNum * 3];
            }
            if (this.hasMapping) {
                this.triTexIndices[triListIndex] = new int[triNum * 3];
            }
            for (int faceIndex = 0; faceIndex < triNum; ++faceIndex) {
                int i3;
                for (i3 = 0; i3 < 3; ++i3) {
                    this.triPosIndices[triListIndex][faceIndex * 3 + i3] = dis.readInt();
                }
                if (this.hasVC) {
                    for (i3 = 0; i3 < 3; ++i3) {
                        this.triColIndices[triListIndex][faceIndex * 3 + i3] = dis.readInt();
                    }
                }
                if (!this.hasMapping) continue;
                for (i3 = 0; i3 < 3; ++i3) {
                    this.triTexIndices[triListIndex][faceIndex * 3 + i3] = dis.readInt();
                }
            }
        }
        boolean a = true;
    }

    public short[] getVertices(int materialID) {
        if (this.triPosIndices[materialID] == null) {
            return null;
        }
        int vertNum = this.triPosIndices[materialID].length;
        short[] ver = new short[vertNum * 3];
        for (int i = 0; i < vertNum; ++i) {
            int vertIndex = this.triPosIndices[materialID][i];
            ver[i * 3] = this.vertices[vertIndex * 3];
            ver[i * 3 + 1] = this.vertices[vertIndex * 3 + 1];
            ver[i * 3 + 2] = this.vertices[vertIndex * 3 + 2];
        }
        return ver;
    }

    public short[] getTexels(int materialID) {
        int texelNum = this.triTexIndices[materialID].length;
        short[] tex = new short[texelNum * 2];
        for (int i = 0; i < texelNum; ++i) {
            int vertIndex = this.triTexIndices[materialID][i];
            tex[i * 2] = this.texels[vertIndex * 2];
            tex[i * 2 + 1] = this.texels[vertIndex * 2 + 1];
        }
        return tex;
    }

    public byte[] getColors(int materialID) {
        int colNum = this.triColIndices[materialID].length;
        byte[] color = new byte[colNum * 4];
        if (this.colors != null) {
            for (int i = 0; i < colNum; ++i) {
                int vertIndex = this.triColIndices[materialID][i];
                color[i * 4] = this.colors[vertIndex * 4];
                color[i * 4 + 1] = this.colors[vertIndex * 4 + 1];
                color[i * 4 + 2] = this.colors[vertIndex * 4 + 2];
                color[i * 4 + 3] = this.colors[vertIndex * 4 + 3];
            }
        } else {
            for (int i = 0; i < colNum; ++i) {
                color[i * 4] = -1;
                color[i * 4 + 1] = -1;
                color[i * 4 + 2] = -1;
                color[i * 4 + 3] = -1;
            }
        }
        return color;
    }
}

