/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d.lq_particle_system;

import com.lemonquest.lq3d.LQAppearance;
import com.lemonquest.lq3d.lq_particle_system.LQBitmapParticleEffect;
import com.lemonquest.lq3d.lq_particle_system.LQParticle;
import com.lemonquest.lq3d.lq_particle_system.LQSpaceWrap;
import com.lemonquest.math.MathFP;
import java.util.Random;

public class LQFountainEffect
extends LQBitmapParticleEffect {
    Random rand = null;
    float[] params = new float[9];
    public static final short Param_MinSpeed = 0;
    public static final short Param_MaxSpeed = 1;
    public static final short Param_Degradation = 2;
    public static final short Param_OffAxisAngle = 3;
    public static final short Param_OffAxisSpread = 4;
    public static final short Param_GrowFor = 5;
    public static final short Param_FadeFor = 6;
    public static final short Param_StartLife = 7;
    public static final short Param_EndSpeed = 8;
    public static final int MaxParam = 9;
    LQSpaceWrap spaceWrap;
    int[][] fadeOutColor = new int[][]{{0xFF0000, 0xFFFF00, 0xFFFFFF}, {65280, 255, 0xFFFFFF}, {0xFF0000, 0xFFFF00, 0xFFFFFF}};
    float[] colorFadeTimes = new float[]{0.0f, 0.5f, 1.0f};

    public LQFountainEffect(int particleCapacity, byte mode, String textureFileName, int pixelBlendMode, float scale, int texSrcX, int texSrcY, int texelSize, int texFrame) {
        super(particleCapacity, mode, textureFileName, pixelBlendMode, scale, texSrcX, texSrcY, texelSize, texFrame);
        this.init();
    }

    public LQFountainEffect(int particleCapacity, byte mode, LQAppearance app, float scale, int texSrcX, int texSrcY, int texelSize, int texFrame) {
        super(particleCapacity, mode, app, scale, texSrcX, texSrcY, texelSize, texFrame);
        this.init();
    }

    private void init() {
        this.rand = new Random();
        this.params[0] = 0.1f;
        this.params[1] = 0.1f;
        this.params[2] = 0.01f;
        this.params[3] = 90.0f;
        this.params[4] = 15.0f;
        this.params[5] = 0.25f;
        this.params[6] = 0.25f;
        this.params[7] = 1.0f;
    }

    public void init(LQParticle p, float currentPSTime) {
        p.setActive(false);
        p.setLife(this.params[7]);
        p.setPos(p.getPS().getEmitPos()[0], p.getPS().getEmitPos()[1], p.getPS().getEmitPos()[2]);
        float[] vel = new float[3];
        float xyvel = this.rand.nextFloat() * (this.params[1] - this.params[0]) + this.params[0];
        p.setDegradation(this.params[2]);
        int axisAngle = (int)(this.params[3] + this.rand.nextFloat() * this.params[4] * 2.0f - this.params[4]);
        float sin = (float)MathFP.lookupSin(axisAngle) / 4096.0f;
        float cos = (float)MathFP.lookupCos(axisAngle) / 4096.0f;
        vel[0] = xyvel * cos;
        vel[1] = xyvel * sin;
        vel[2] = 0.0f;
        p.setVel(vel);
        float[] acc = new float[3];
        float xyacc = (this.params[8] - xyvel) * this.params[2];
        acc[0] = xyacc * cos;
        acc[1] = xyacc * sin;
        acc[2] = 0.0f;
        p.setAcc(acc);
        if (this.mode == 0) {
            int index = 1;
            float delta = 0.0f;
            if (currentPSTime < this.colorFadeTimes[1]) {
                index = 1;
                delta = (currentPSTime - this.colorFadeTimes[0]) * (1.0f / (this.colorFadeTimes[1] - this.colorFadeTimes[0]));
            } else {
                index = 2;
                delta = (currentPSTime - this.colorFadeTimes[1]) * (1.0f / (this.colorFadeTimes[2] - this.colorFadeTimes[1]));
            }
            int[] colors = new int[this.fadeOutColor[index].length];
            for (int i = 0; i < this.fadeOutColor[index].length; ++i) {
                colors[i] = LQFountainEffect.calcFadeColor(this.fadeOutColor[index - 1][i], this.fadeOutColor[index][i], delta);
            }
            p.setFadeOutColors(colors);
            p.setColor(colors[0]);
        } else if (this.mode == 1) {
            short[] tex = p.getTexels();
            tex[0] = this.texSrcX;
            tex[1] = (short)(this.texSrcY + this.texelSize);
            tex[2] = (short)(this.texSrcX + this.texelSize);
            tex[3] = (short)(this.texSrcY + this.texelSize);
            tex[4] = this.texSrcX;
            tex[5] = this.texSrcY;
            tex[6] = (short)(this.texSrcX + this.texelSize);
            tex[7] = this.texSrcY;
        }
        p.setSize(0.0f);
        p.setOldTexelFrame(0);
    }

    public void setTexels(short srcX, short srcY, short texelSize, int texFrame) {
        this.texSrcX = srcX;
        this.texSrcY = srcY;
        this.texelSize = texelSize;
        this.texelFrameNum = texFrame;
    }

    public void update(LQParticle p, float currentPSTime) {
        p.setLife(p.getLife() - p.getDegradation());
        if (p.getLife() < -0.001f) {
            this.init(p, currentPSTime);
            return;
        }
        if (1.0f - p.getLife() < this.params[5]) {
            p.setSize(this.scale * ((1.0f - p.getLife()) / this.params[5]));
        } else if (p.getLife() < this.params[6]) {
            p.setSize(this.scale * (p.getLife() / this.params[6]));
        } else {
            p.setSize(this.scale);
        }
        float[] ppos = p.getPos();
        float[] vel = p.getVel();
        ppos[0] = ppos[0] + vel[0];
        ppos[1] = ppos[1] + vel[1];
        ppos[2] = ppos[2] + vel[2];
        vel[0] = vel[0] + p.getAcc()[0];
        vel[1] = vel[1] + p.getAcc()[1];
        vel[2] = vel[2] + p.getAcc()[2];
        if (this.spaceWrap != null) {
            this.spaceWrap.UpdateVel(p);
        }
        if (this.mode == 0) {
            int fadeOutIndex = 1;
            float delta = 0.0f;
            if ((double)p.getLife() > 0.5) {
                fadeOutIndex = 1;
                delta = (1.0f - p.getLife()) * 2.0f;
            } else {
                fadeOutIndex = 2;
                delta = (0.5f - p.getLife()) * 2.0f;
            }
            int color = LQFountainEffect.calcFadeColor(p.getFadeOutColors()[fadeOutIndex - 1], p.getFadeOutColors()[fadeOutIndex], delta);
            int alpha = 255;
            color = color & 0xFFFFFF | alpha << 24;
            p.setColor(color);
        } else if (this.mode == 1) {
            short[] tex = p.getTexels();
            int frame = (int)((1.0f - p.getLife()) * (float)this.texelFrameNum);
            if (frame > 0) {
                boolean a = true;
            }
            if (frame > p.getOldTexelFrame() && frame < this.texelFrameNum) {
                for (int i = 0; i < tex.length; i += 2) {
                    int n = i;
                    tex[n] = (short)(tex[n] + this.texelSize);
                }
                p.setOldTexelFrame(frame);
            }
        }
    }

    public void setParam(short paramType, float value) {
        this.params[paramType] = value;
    }

    public float[] getParam() {
        return this.params;
    }

    public void setParams(float[] params) {
        for (int i = 0; i < params.length; ++i) {
            this.setParam((short)i, params[i]);
        }
    }

    public void setFadeColors(int[][] colors) {
        this.fadeOutColor = new int[colors.length][];
        for (int i = 0; i < this.fadeOutColor.length; ++i) {
            this.fadeOutColor[i] = new int[colors[i].length];
            for (int j = 0; j < this.fadeOutColor[i].length; ++j) {
                this.fadeOutColor[i][j] = colors[i][j];
            }
        }
    }

    public void setFadeTimes(float[] times) {
        this.colorFadeTimes = new float[times.length];
        for (int i = 0; i < this.colorFadeTimes.length; ++i) {
            this.colorFadeTimes[i] = times[i];
        }
    }

    public static int calcFadeColor(int initColor, int fadeOutColor, float delta) {
        int srcRed = initColor >> 16 & 0xFF;
        int srcGreen = initColor >> 8 & 0xFF;
        int srcBlue = initColor & 0xFF;
        int destRed = fadeOutColor >> 16 & 0xFF;
        int destGreen = fadeOutColor >> 8 & 0xFF;
        int destBlue = fadeOutColor & 0xFF;
        int red_delta = (int)((float)(destRed - srcRed) * delta);
        int green_delta = (int)((float)(destGreen - srcGreen) * delta);
        int blue_delta = (int)((float)(destBlue - srcBlue) * delta);
        int destColor = srcRed + red_delta << 16 | srcGreen + green_delta << 8 | srcBlue + blue_delta;
        return destColor;
    }

    public void setSpaceWrap(LQSpaceWrap spacewrap) {
        this.spaceWrap = spacewrap;
    }
}

