/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_m3g;

import com.lemonquest.lq3d.LQAction;
import com.lemonquest.lq3d.LQActionList;
import com.lemonquest.lq3d.LQConfig;
import com.lemonquest.lq3d_m3g.LQAction_m3g;
import com.lemonquest.text.LQLanguage;
import java.util.Hashtable;

public class LQActionList_m3g
extends LQActionList {
    public LQActionList_m3g(String fileName) {
        this.loadActionList(fileName);
    }

    public LQAction getAction(String actionName) {
        return (LQAction)this.m_actTable.get(actionName);
    }

    public void loadActionList(String fileName) {
        if (this.m_actTable != null) {
            this.m_actTable.clear();
            this.m_actTable = null;
        }
        this.m_actTable = new Hashtable();
        LQLanguage lang = new LQLanguage();
        String[] data = lang.load(fileName);
        int unitSize = 3;
        int actionNum = data.length / 3;
        int totalRenderTime = Integer.parseInt(data[0]);
        int totalFrame = Integer.parseInt(data[1]);
        int offset = 2;
        for (int i = 0; i < actionNum; ++i) {
            LQAction_m3g action = null;
            String actName = data[2 + i * 3];
            int startFrame = Integer.parseInt(data[2 + i * 3 + 1]);
            int endFrame = Integer.parseInt(data[2 + i * 3 + 2]);
            int frameNum = endFrame - startFrame;
            float frameStep = (float)totalRenderTime / (float)totalFrame;
            float maxRenderTime = (float)endFrame * frameStep;
            action = new LQAction_m3g(startFrame, (int)maxRenderTime, frameNum, (int)frameStep);
            this.m_actTable.put(actName, action);
            LQConfig.debug("act loaded -> " + actName + "     frame:" + startFrame + "-" + endFrame);
        }
    }
}

