/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_m3g;

import com.lemonquest.lq3d.LQAppearance;
import com.lemonquest.lq3d.LQTexture;
import com.lemonquest.lq3d_m3g.LQTexture_m3g;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;

public class LQAppearance_m3g
extends LQAppearance {
    protected Appearance app;
    protected int m_textureBlendingMode;
    protected int m_pixelBlendingMode;

    public LQAppearance_m3g(int shadingMode, String texture, int textureBlendMode, int pixelBlendMode, int cullingMode) {
        this.init(shadingMode, texture, textureBlendMode, pixelBlendMode, cullingMode);
    }

    public LQAppearance_m3g(int shadingMode, LQTexture texture, int textureBlendMode, int pixelBlendMode, int cullingMode) {
        this.init(shadingMode, texture, textureBlendMode, pixelBlendMode, cullingMode);
    }

    public LQAppearance_m3g(Appearance app) {
        this.app = app;
    }

    public Object data() {
        return this.app;
    }

    protected void init(int shadingMode, String fileName, int textureBlendMode, int pixelBlendMode, int cullingMode) {
        LQTexture_m3g tex = null;
        if (fileName != null) {
            tex = new LQTexture_m3g(fileName);
        }
        this.init(shadingMode, tex, textureBlendMode, pixelBlendMode, cullingMode);
    }

    protected void init(int shadingMode, LQTexture tex, int textureBlendMode, int pixelBlendMode, int cullingMode) {
        this.texture = tex;
        this.app = new Appearance();
        if (this.texture != null) {
            this.app.setTexture(0, (Texture2D)this.texture.data());
            this.setTextureBlending(textureBlendMode);
        }
        this.setPixelBlending(pixelBlendMode);
        PolygonMode pm = new PolygonMode();
        pm.setPerspectiveCorrectionEnable(true);
        if (cullingMode == 0) {
            pm.setCulling(160);
        } else if (cullingMode == 1) {
            pm.setCulling(161);
        } else if (cullingMode == 2) {
            pm.setCulling(162);
        }
        if (shadingMode == 1) {
            pm.setShading(165);
        } else {
            pm.setShading(164);
        }
        this.app.setPolygonMode(pm);
    }

    public void release() {
        this.app = null;
    }

    public int getTextureBlending() {
        return this.m_textureBlendingMode;
    }

    public void setTextureBlending(int blendMode) {
        this.m_textureBlendingMode = blendMode;
        this.texture.setBlending(blendMode);
    }

    public int getPixelBlending() {
        return this.m_pixelBlendingMode;
    }

    public void setPixelBlending(int blendMode) {
        this.m_pixelBlendingMode = blendMode;
        CompositingMode cm = this.app.getCompositingMode();
        if (cm == null) {
            cm = new CompositingMode();
            this.app.setCompositingMode(cm);
        }
        switch (blendMode) {
            case 0: {
                cm.setBlending(68);
                break;
            }
            case 1: 
            case 5: {
                cm.setBlending(64);
                break;
            }
            case 2: {
                cm.setBlending(65);
                break;
            }
            case 3: {
                cm.setBlending(66);
                break;
            }
            case 4: {
                cm.setBlending(67);
            }
        }
    }

    public void setCullingMode(int cullMode) {
        if (cullMode == 0) {
            this.app.getPolygonMode().setCulling(160);
        } else if (cullMode == 1) {
            this.app.getPolygonMode().setCulling(161);
        } else if (cullMode == 2) {
            this.app.getPolygonMode().setCulling(162);
        }
    }
}

