/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_m3g;

import com.lemonquest.lq3d.LQAction;
import com.lemonquest.lq3d.LQAppearance;
import com.lemonquest.lq3d.LQConfig;
import com.lemonquest.lq3d.LQMesh;
import com.lemonquest.text.LQLanguage;
import java.util.Hashtable;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.World;

public class LQMesh_m3g
extends LQMesh {
    protected static Hashtable m_meshFileTable = new Hashtable();
    protected Node m_node;

    public LQMesh_m3g(LQMesh copy) {
        Node node = ((LQMesh_m3g)copy).m_node;
        this.m_node = (Node)node.duplicate();
    }

    public LQMesh_m3g(String fileName, String meshName) {
        this.fromFile(fileName, meshName);
    }

    public LQMesh_m3g(Object data) {
        this.m_node = (Node)data;
    }

    public void fromFile(String fileName, String meshName) {
        int uid;
        MeshFile meshFile = (MeshFile)m_meshFileTable.get(fileName);
        if (meshFile == null) {
            meshFile = new MeshFile(fileName);
            m_meshFileTable.put(fileName, meshFile);
            LQConfig.debug("load m3g file-> " + fileName);
        }
        if ((uid = meshFile.getMeshID(meshName)) < 0) {
            return;
        }
        World world = meshFile.getWorld();
        if (world == null) {
            return;
        }
        try {
            this.m_node = (Node)world.find(uid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        world = null;
    }

    public Object data() {
        return this.m_node;
    }

    public void animate(LQAction action) {
        this.m_node.animate(action.getRenderTime());
    }

    public void setAppearance(LQAppearance appearance) {
        this.m_appearance = null;
        this.m_appearance = appearance;
        try {
            Mesh mesh = (Mesh)this.m_node;
            mesh.setAppearance(0, (Appearance)this.m_appearance.data());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class MeshFile {
        public String m_fileName;
        public Hashtable m_resNameTable;
        private Object3D[] objects;
        private World world;

        public MeshFile(String fileName) {
            this.m_fileName = fileName;
            this.m_resNameTable = new Hashtable();
            try {
                this.objects = Loader.load((String)fileName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            for (int j = this.objects.length - 1; j >= 0; --j) {
                if (!(this.objects[j] instanceof World)) continue;
                this.world = (World)this.objects[j];
                break;
            }
            String tableFileName = fileName.substring(0, fileName.lastIndexOf(46)) + ".xml";
            this.loadResTable(tableFileName);
        }

        public int getMeshID(String meshName) {
            int uid = -1;
            Integer UID = (Integer)this.m_resNameTable.get(meshName);
            if (UID != null) {
                uid = UID;
            }
            return uid;
        }

        public String getTexFileName() {
            return (String)this.m_resNameTable.get("texture");
        }

        public Object3D[] getObject3Ds() {
            return this.objects;
        }

        public World getWorld() {
            return this.world;
        }

        private void loadResTable(String fileName) {
            LQLanguage loader = new LQLanguage();
            String[] data = loader.load(fileName);
            int unitSize = 2;
            int nodeNum = data.length / 2;
            for (int i = 0; i < nodeNum; ++i) {
                if (data[i * 2].equals("texture")) {
                    this.m_resNameTable.put(data[i * 2], data[i * 2 + 1]);
                    continue;
                }
                int id = Integer.parseInt(data[i * 2 + 1]);
                this.m_resNameTable.put(data[i * 2], new Integer(id));
            }
        }
    }
}

