/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_mcv3;

import com.lemonquest.lq3d.LQBufferedTexture;
import com.lemonquest.lq3d.LQTexture;
import com.mascotcapsule.micro3d.v3.Texture;
import java.io.DataInputStream;

public class LQTexture_mcv3
extends LQTexture {
    protected Texture texture;
    byte[] curheaderData;

    public LQTexture_mcv3(String fileName) {
        this.init(fileName);
    }

    public LQTexture_mcv3(String name, LQBufferedTexture bufferedTex) {
        this.init(name, bufferedTex);
    }

    private void release() {
        if (this.texture != null) {
            this.texture.dispose();
            this.texture = null;
        }
    }

    protected void init(String fileName) {
        if (fileName == null) {
            return;
        }
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(fileName));
        LQBufferedTexture bufferedTex = new LQBufferedTexture(dis);
        try {
            dis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!bufferedTex.isIndexed()) {
            System.out.println("error: texture file is not indexed bmp.");
            return;
        }
        this.width = bufferedTex.getWidth();
        this.height = bufferedTex.getHeight();
        String headerFileName = fileName.substring(0, fileName.lastIndexOf(46));
        headerFileName = headerFileName + ".head";
        DataInputStream headerFileStream = new DataInputStream(this.getClass().getResourceAsStream(headerFileName));
        byte[] bmpData = null;
        try {
            int i;
            int headerLen = headerFileStream.readInt();
            byte[] headerData = new byte[headerLen];
            headerFileStream.read(headerData);
            bmpData = new byte[headerData.length + bufferedTex.getPalette().length * 4 + bufferedTex.getIndices().length];
            System.arraycopy(headerData, 0, bmpData, 0, headerLen);
            byte[] paletteByte = new byte[bufferedTex.getPalette().length * 4];
            for (i = 0; i < bufferedTex.getPalette().length; ++i) {
                int color = bufferedTex.getPalette()[i];
                paletteByte[i * 4 + 0] = (byte)(color >> 0 & 0xFF);
                paletteByte[i * 4 + 1] = (byte)(color >> 8 & 0xFF);
                paletteByte[i * 4 + 2] = (byte)(color >> 16 & 0xFF);
                paletteByte[i * 4 + 3] = (byte)(color >> 24 & 0xFF);
            }
            System.arraycopy(paletteByte, 0, bmpData, headerLen, paletteByte.length);
            for (i = 0; i < bufferedTex.getHeight(); ++i) {
                int srcOffset = bufferedTex.getWidth() * (bufferedTex.getHeight() - 1 - i);
                int destOffset = headerLen + paletteByte.length + i * bufferedTex.getWidth();
                System.arraycopy(bufferedTex.getIndices(), srcOffset, bmpData, destOffset, bufferedTex.getWidth());
            }
            headerFileStream.close();
            this.curheaderData = headerData;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        this.texture = new Texture(bmpData, true);
    }

    protected void init(String name, LQBufferedTexture bufferedTex) {
        if (!bufferedTex.isIndexed()) {
            System.out.println("error: texture file is not indexed bmp.");
            return;
        }
        this.width = bufferedTex.getWidth();
        this.height = bufferedTex.getHeight();
        String headerFileName = name.substring(0, name.indexOf(46));
        headerFileName = headerFileName + ".head";
        DataInputStream headerFileStream = new DataInputStream(this.getClass().getResourceAsStream(headerFileName));
        byte[] bmpData = null;
        try {
            int i;
            int headerLen = headerFileStream.readInt();
            byte[] headerData = new byte[headerLen];
            headerFileStream.read(headerData);
            bmpData = new byte[headerData.length + bufferedTex.getPalette().length * 4 + bufferedTex.getIndices().length];
            System.arraycopy(headerData, 0, bmpData, 0, headerLen);
            byte[] paletteByte = new byte[bufferedTex.getPalette().length * 4];
            for (i = 0; i < bufferedTex.getPalette().length; ++i) {
                int color = bufferedTex.getPalette()[i];
                paletteByte[i * 4 + 0] = (byte)(color >> 0 & 0xFF);
                paletteByte[i * 4 + 1] = (byte)(color >> 8 & 0xFF);
                paletteByte[i * 4 + 2] = (byte)(color >> 16 & 0xFF);
                paletteByte[i * 4 + 3] = (byte)(color >> 24 & 0xFF);
            }
            System.arraycopy(paletteByte, 0, bmpData, headerLen, paletteByte.length);
            for (i = 0; i < bufferedTex.getHeight(); ++i) {
                int srcOffset = bufferedTex.getWidth() * (bufferedTex.getHeight() - 1 - i);
                int destOffset = headerLen + paletteByte.length + i * bufferedTex.getWidth();
                System.arraycopy(bufferedTex.getIndices(), srcOffset, bmpData, destOffset, bufferedTex.getWidth());
            }
            headerFileStream.close();
            this.curheaderData = headerData;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        this.texture = new Texture(bmpData, true);
    }

    public Object data() {
        return this.texture;
    }

    public void set(LQBufferedTexture bufferedTex) {
        int i;
        this.release();
        byte[] headerData = this.curheaderData;
        byte[] bmpData = new byte[headerData.length + bufferedTex.getPalette().length * 4 + bufferedTex.getIndices().length];
        System.arraycopy(headerData, 0, bmpData, 0, headerData.length);
        byte[] paletteByte = new byte[bufferedTex.getPalette().length * 4];
        for (i = 0; i < bufferedTex.getPalette().length; ++i) {
            int color = bufferedTex.getPalette()[i];
            paletteByte[i * 4 + 0] = (byte)(color >> 0 & 0xFF);
            paletteByte[i * 4 + 1] = (byte)(color >> 8 & 0xFF);
            paletteByte[i * 4 + 2] = (byte)(color >> 16 & 0xFF);
            paletteByte[i * 4 + 3] = (byte)(color >> 24 & 0xFF);
        }
        System.arraycopy(paletteByte, 0, bmpData, headerData.length, paletteByte.length);
        for (i = 0; i < bufferedTex.getHeight(); ++i) {
            int srcOffset = bufferedTex.getWidth() * (bufferedTex.getHeight() - 1 - i);
            int destOffset = headerData.length + paletteByte.length + i * bufferedTex.getWidth();
            System.arraycopy(bufferedTex.getIndices(), srcOffset, bmpData, destOffset, bufferedTex.getWidth());
        }
        this.texture = new Texture(bmpData, true);
    }

    public void setBlending(int blendMode) {
    }
}

