/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d;

import com.lemonquest.lq3d.LQTransform;

public class LQVector {
    protected float m_x;
    protected float m_y;
    protected float m_z;
    private static float[] tmpMatrix = new float[16];

    public LQVector() {
    }

    public LQVector(float x, float y, float z) {
        this.set(x, y, z);
    }

    public LQVector(LQVector vector) {
        this.set(vector);
    }

    public float getX() {
        return this.m_x;
    }

    public float getY() {
        return this.m_y;
    }

    public float getZ() {
        return this.m_z;
    }

    public void setX(float x) {
        this.m_x = x;
    }

    public void setY(float y) {
        this.m_y = y;
    }

    public void setZ(float z) {
        this.m_z = z;
    }

    public void set(float x, float y, float z) {
        this.m_x = x;
        this.m_y = y;
        this.m_z = z;
    }

    public void set(LQVector vector) {
        this.m_x = vector.m_x;
        this.m_y = vector.m_y;
        this.m_z = vector.m_z;
    }

    public float innerProduct(LQVector vector) {
        return this.m_x * vector.m_x + this.m_y * vector.m_y + this.m_z * vector.m_z;
    }

    public static float innerProduct(LQVector v1, LQVector v2) {
        return v1.innerProduct(v2);
    }

    public void outerProduct(LQVector vector) {
        float x = this.m_y * vector.m_z - this.m_z * vector.m_y;
        float y = this.m_z * vector.m_x - this.m_x * vector.m_z;
        float z = this.m_x * vector.m_y - this.m_y * vector.m_x;
        this.m_x = x;
        this.m_y = y;
        this.m_z = z;
    }

    public static LQVector outerProduct(LQVector v1, LQVector v2) {
        v1.outerProduct(v2);
        return v1;
    }

    public void mul(LQTransform trans) {
        float x = this.m_x;
        float y = this.m_y;
        float z = this.m_z;
        trans.get(tmpMatrix);
        this.m_x = x * tmpMatrix[0] + y * tmpMatrix[1] + z * tmpMatrix[2];
        this.m_y = x * tmpMatrix[4] + y * tmpMatrix[5] + z * tmpMatrix[6];
        this.m_z = x * tmpMatrix[8] + y * tmpMatrix[9] + z * tmpMatrix[10];
    }

    public String toString() {
        return "[" + this.m_x + ", " + this.m_y + ", " + this.m_z + "]";
    }
}

