/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d.lq_particle_system;

import com.lemonquest.lq3d.lq_particle_system.LQParticleSystem;

public class LQParticle {
    private LQParticleSystem m_ps;
    private float life = 1.0f;
    private float degradation = 0.1f;
    private float[] vel = new float[]{0.0f, 0.0f, 0.0f};
    private float[] acc = new float[]{0.0f, 0.0f, 0.0f};
    private float[] pos = new float[]{0.0f, 0.0f, 0.0f};
    private int color = -1;
    private int[] fadeOutColors = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
    short[] texels = new short[]{0, 32, 32, 32, 0, 0, 32, 0};
    int oldTexelFrame;
    private float size = 1.0f;
    private boolean isActive = false;

    public LQParticle(LQParticleSystem ps) {
        this.m_ps = ps;
    }

    public LQParticle(float[] velocity, float[] position, int color) {
        this.setVel(velocity);
        this.setPos(position);
        this.setColor(color);
    }

    public LQParticleSystem getPS() {
        return this.m_ps;
    }

    void setLife(float life) {
        this.life = life;
    }

    float getLife() {
        return this.life;
    }

    void setVel(float[] tvel) {
        System.arraycopy(tvel, 0, this.vel, 0, this.vel.length);
    }

    float[] getVel() {
        return this.vel;
    }

    void setAcc(float[] acc) {
        System.arraycopy(acc, 0, this.acc, 0, this.acc.length);
    }

    float[] getAcc() {
        return this.acc;
    }

    void setPos(float[] tpos) {
        System.arraycopy(tpos, 0, this.pos, 0, this.pos.length);
    }

    void setPos(float x, float y, float z) {
        this.pos[0] = x;
        this.pos[1] = y;
        this.pos[2] = z;
    }

    float[] getPos() {
        return this.pos;
    }

    void setColor(int color) {
        this.color = color;
    }

    int getColor() {
        return this.color;
    }

    public void setDegradation(float degradation) {
        this.degradation = degradation;
    }

    public float getDegradation() {
        return this.degradation;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public int[] getFadeOutColors() {
        return this.fadeOutColors;
    }

    public void setFadeOutColors(int[] colors) {
        System.arraycopy(colors, 0, this.fadeOutColors, 0, this.fadeOutColors.length);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public void setTexels(short[] texels) {
        System.arraycopy(texels, 0, this.texels, 0, this.texels.length);
    }

    public short[] getTexels() {
        return this.texels;
    }

    public void setOldTexelFrame(int frame) {
        this.oldTexelFrame = frame;
    }

    public int getOldTexelFrame() {
        return this.oldTexelFrame;
    }
}

