/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_m3g;

import com.lemonquest.lq3d.LQBufferedTexture;
import com.lemonquest.lq3d.LQTexture;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Texture2D;

public class LQTexture_m3g
extends LQTexture {
    protected static Hashtable image2DTable = new Hashtable();
    Texture2D texture;
    Image2D image2D;

    public LQTexture_m3g(String fileName) {
        this.init(fileName);
    }

    public LQTexture_m3g(String name, LQBufferedTexture bufferedTex) {
        this.init(name, bufferedTex);
    }

    protected void init(String fileName) {
        if (fileName == null) {
            return;
        }
        this.image2D = (Image2D)image2DTable.get(fileName);
        if (this.image2D == null) {
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(fileName));
            LQBufferedTexture bufferedTex = new LQBufferedTexture(dis);
            this.width = bufferedTex.getWidth();
            this.height = bufferedTex.getHeight();
            try {
                this.image2D = bufferedTex.hasAlpha() ? new Image2D(100, this.width, this.height) : new Image2D(99, this.width, this.height);
                image2DTable.put(fileName, this.image2D);
                this.image2D.set(0, 0, this.width, this.height, bufferedTex.data());
                dis.close();
            }
            catch (Exception e) {
                try {
                    dis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                System.out.println("Failed to create texture. Error: " + e);
                e.printStackTrace();
            }
        }
        this.texture = new Texture2D(this.image2D);
    }

    protected void init(String name, LQBufferedTexture bufferedTex) {
        this.image2D = (Image2D)image2DTable.get(name);
        if (this.image2D == null) {
            this.width = bufferedTex.getWidth();
            this.height = bufferedTex.getHeight();
            try {
                this.image2D = bufferedTex.hasAlpha() ? new Image2D(100, this.width, this.height) : new Image2D(99, this.width, this.height);
                image2DTable.put(name, this.image2D);
                this.image2D.set(0, 0, this.width, this.height, bufferedTex.data());
            }
            catch (Exception e) {
                System.out.println("Failed to create texture. Error: " + e);
                e.printStackTrace();
            }
        }
        this.texture = new Texture2D(this.image2D);
    }

    public Object data() {
        return this.texture;
    }

    public void setBlending(int blendMode) {
        switch (blendMode) {
            case 0: {
                this.texture.setBlending(228);
                break;
            }
            case 1: {
                this.texture.setBlending(225);
                break;
            }
            case 2: {
                this.texture.setBlending(224);
                break;
            }
            case 3: {
                this.texture.setBlending(227);
            }
        }
        this.texture.setWrapping(240, 240);
        this.texture.setFiltering(208, 210);
    }

    public void set(LQBufferedTexture buf) {
        try {
            this.image2D.set(0, 0, this.width, this.height, buf.data());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

