/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.physics_v2;

import com.lemonquest.math.MathFP;
import com.lemonquest.math.Vec2D;
import com.lemonquest.physics_v2.AABB;
import com.lemonquest.physics_v2.DefaultEventHandler;
import com.lemonquest.physics_v2.DynamicObj;
import com.lemonquest.physics_v2.EventHandler;
import com.lemonquest.physics_v2.Shape;
import com.lemonquest.physics_v2.ShapeCircle;
import com.lemonquest.physics_v2.ShapeLine;

public class StaticObj {
    private Shape shape;
    private AABB aabb;
    private int spring = MathFP.toFP("0");
    private boolean isEventOnly = false;
    private byte eventType = (byte)-1;
    private EventHandler eventHandler = DefaultEventHandler.instance();
    public short groundID;
    private short id;
    private boolean isActivated = false;

    public StaticObj(int index, Shape shape, DefaultEventHandler defaultEventHandler) {
        this.id = (short)index;
        this.shape = shape;
        if (this.shape instanceof ShapeLine) {
            this.aabb = new AABB();
            this.setLineAABB(((ShapeLine)shape).getStart(), ((ShapeLine)shape).getEnd());
        } else if (this.shape instanceof ShapeCircle) {
            this.aabb = new AABB();
            int radius = ((ShapeCircle)shape).getRadius();
            Vec2D center = ((ShapeCircle)shape).getCenter();
            this.aabb.left = center.X - radius;
            this.aabb.top = center.Y - radius;
            this.aabb.right = center.X + radius;
            this.aabb.bottom = center.Y + radius;
        }
        this.eventHandler = defaultEventHandler;
    }

    public void activate() {
        this.isActivated = true;
    }

    public void sleep() {
        this.isActivated = false;
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public void setGroundID(int id) {
        this.groundID = (short)id;
    }

    public int getSpring() {
        return this.spring;
    }

    public void setSpring(int spring) {
        this.spring = spring;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setLineShape(Vec2D start, Vec2D end) {
        ((ShapeLine)this.shape).set(start, end);
        this.setLineAABB(start, end);
    }

    private void setLineAABB(Vec2D start, Vec2D end) {
        if (start.X < end.X) {
            this.aabb.left = start.X;
            this.aabb.right = end.X;
        } else {
            this.aabb.left = end.X;
            this.aabb.right = start.X;
        }
        if (start.Y < end.Y) {
            this.aabb.top = start.Y;
            this.aabb.bottom = end.Y;
        } else {
            this.aabb.top = end.Y;
            this.aabb.bottom = start.Y;
        }
    }

    public AABB getAABB() {
        return this.aabb;
    }

    public void setEventHandler(byte eventType, EventHandler handler) {
        this.eventType = eventType;
        this.eventHandler = handler;
    }

    public void setEvent(byte eventType) {
        this.eventType = eventType;
    }

    public void setEventOnly(boolean isEventOnly) {
        this.isEventOnly = isEventOnly;
    }

    public boolean isEventOnly() {
        return this.isEventOnly;
    }

    public void fireEvent(DynamicObj dynObj) {
        this.eventHandler.fireEvent(this.eventType, dynObj, this);
    }

    public void fireInstantEvent(DynamicObj dynObj) {
        this.eventHandler.fireInstantEvent(this.eventType, dynObj, this);
    }
}

