/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.text;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LQFont {
    protected int fontHeight;
    protected int charSpacing;
    protected int lineSpacing;
    protected int spaceSize;
    protected int numSymbols;
    protected int numLetters;
    protected short[][] symbols;
    protected char[] letterChars;
    protected byte[][] letterSymbols;
    protected Image image;
    protected boolean m_isEnableArea;
    protected int m_areaX;
    protected int m_areaY;
    protected int m_areaW;
    protected int m_areaH;

    protected LQFont() {
    }

    public LQFont(DataInputStream dis) {
        try {
            int j;
            byte version = dis.readByte();
            this.numSymbols = dis.readUnsignedByte();
            this.symbols = new short[this.numSymbols][6];
            for (j = 0; j < this.numSymbols; ++j) {
                this.symbols[j][0] = (short)dis.readUnsignedByte();
                this.symbols[j][1] = (short)dis.readUnsignedByte();
                this.symbols[j][2] = (short)dis.readUnsignedByte();
                this.symbols[j][3] = (short)dis.readUnsignedByte();
                this.symbols[j][4] = dis.readByte();
                this.symbols[j][5] = dis.readByte();
            }
            this.fontHeight = dis.readUnsignedByte();
            this.charSpacing = dis.readByte();
            this.lineSpacing = dis.readUnsignedByte();
            this.spaceSize = dis.readUnsignedByte();
            this.numLetters = dis.readUnsignedByte();
            this.letterChars = new char[this.numLetters];
            this.letterSymbols = new byte[this.numLetters][];
            for (j = 0; j < this.numLetters; ++j) {
                this.letterChars[j] = dis.readChar();
                int numSymbolsLetter = dis.readUnsignedByte();
                this.letterSymbols[j] = new byte[numSymbolsLetter];
                for (int k = 0; k < numSymbolsLetter; ++k) {
                    this.letterSymbols[j][k] = (byte)dis.readUnsignedByte();
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[dis.available()];
            int readed = dis.read(buffer);
            baos.write(buffer, 0, readed);
            buffer = baos.toByteArray();
            this.image = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
            baos.close();
            dis.close();
            baos = null;
            dis = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setArea(boolean isEnableArea, int x, int y, int w, int h) {
        this.m_isEnableArea = isEnableArea;
        this.m_areaX = x;
        this.m_areaY = y;
        this.m_areaW = w;
        this.m_areaH = h;
    }

    public int getLineNums(String data, int width) {
        return this.getLineData(data, width).length;
    }

    public short[][] getLineData(String data, int width) {
        char[] text = data.toCharArray();
        Vector<short[]> lines = new Vector<short[]>();
        int lineStart = 0;
        int lineEnd = 0;
        int lineWidth = 0;
        boolean noData = true;
        int nextWordStart = 0;
        int processWidth = 0;
        int lastCharType = 48;
        for (int index = 0; index < text.length; ++index) {
            char actualCharacter = text[index];
            switch (actualCharacter) {
                case ' ': {
                    if (lastCharType == 67) {
                        lineEnd = index - 1;
                        lineWidth = processWidth - this.getCharSpacing();
                    }
                    processWidth += this.getSpaceSize() + this.getCharSpacing();
                    lastCharType = 83;
                    break;
                }
                case '\n': {
                    lineEnd = index - 1;
                    lineWidth = processWidth - this.getCharSpacing();
                    lastCharType = 78;
                    break;
                }
                default: {
                    if (noData) {
                        lineStart = index;
                        noData = false;
                    }
                    if (lastCharType == 83) {
                        nextWordStart = index;
                    } else if (lastCharType == 78) {
                        nextWordStart = index;
                    }
                    processWidth += this.getCharacterWidth(actualCharacter) + this.getCharSpacing();
                    lastCharType = 67;
                }
            }
            if (index == text.length - 1) {
                lineEnd = index;
                lineWidth = processWidth - this.getCharSpacing();
                lastCharType = 78;
            }
            if (processWidth < width && lastCharType != 78) continue;
            short[] lineData = new short[3];
            if (!noData) {
                lineData[0] = (short)lineStart;
                lineData[1] = (short)lineEnd;
                lineData[2] = (short)lineWidth;
            }
            lines.addElement(lineData);
            if (nextWordStart <= lineEnd) {
                noData = true;
            } else {
                lineStart = nextWordStart;
                processWidth -= (nextWordStart - lineEnd) * this.getSpaceSize() - 2;
            }
            processWidth -= lineWidth + this.getCharSpacing();
        }
        short[][] result = new short[lines.size()][];
        Enumeration e = lines.elements();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (short[])e.nextElement();
        }
        return result;
    }

    protected int getCharacterWidth(char character) {
        short[] charSymbol = this.getSymbolByCharacter(character, 0);
        if (charSymbol == null) {
            if (character == ' ') {
                return this.getSpaceSize();
            }
            System.out.println("Character " + character + " not found");
            return 0;
        }
        return charSymbol[2];
    }

    private short[] getSymbolByCharacter(char character, int numSymbol) {
        int charIndex = this.binarySearchOnChars(character, 0, this.letterChars.length - 1);
        if (charIndex == -1) {
            return null;
        }
        return this.symbols[this.letterSymbols[charIndex][numSymbol]];
    }

    private int binarySearchOnChars(char character, int left, int right) {
        if (right < left) {
            return -1;
        }
        int mid = (left + right) / 2;
        if (this.letterChars[mid] == character) {
            return mid;
        }
        if (character < this.letterChars[mid]) {
            return this.binarySearchOnChars(character, left, mid - 1);
        }
        return this.binarySearchOnChars(character, mid + 1, right);
    }

    protected int drawChar(Graphics graphics, char character, int x, int y) {
        if (character == ' ') {
            return this.getSpaceSize();
        }
        int charIndex = this.binarySearchOnChars(character, 0, this.letterChars.length - 1);
        if (charIndex == -1) {
            return 0;
        }
        byte[] f = this.letterSymbols[charIndex];
        int result = this.drawSymbol(graphics, this.symbols[f[0]], x, y);
        for (int i = 1; i < f.length; ++i) {
            result = Math.max(result, this.drawSymbol(graphics, this.symbols[f[i]], x, y));
        }
        return result;
    }

    public int getLineWidth(char[] text) {
        int totalWidth = 0;
        if (text.length < 1) {
            return 0;
        }
        totalWidth += this.getCharacterWidth(text[0]);
        for (int i = 1; i < text.length; ++i) {
            char auxChar = text[i];
            totalWidth = totalWidth + this.getCharacterWidth(auxChar) + this.getCharSpacing();
        }
        return totalWidth;
    }

    private int drawSymbol(Graphics g, short[] symbol, int x, int y) {
        x -= symbol[4];
        int y1 = y -= symbol[5];
        short w = symbol[2];
        int h = symbol[3];
        if (this.m_isEnableArea) {
            if (x + symbol[2] < this.m_areaX) {
                return symbol[2];
            }
            if (x > this.m_areaX + this.m_areaW) {
                return symbol[2];
            }
            if (y + symbol[3] < this.m_areaY) {
                return symbol[2];
            }
            if (y > this.m_areaY + this.m_areaH) {
                return symbol[2];
            }
            if (y < this.m_areaY) {
                y1 = this.m_areaY;
                h -= this.m_areaY - y;
            } else if (this.m_areaY + this.m_areaH < y + h) {
                y1 = y;
                h -= y + h - (this.m_areaY + this.m_areaH);
            }
        }
        g.setClip(x, y1, (int)w, h);
        g.drawImage(this.image, x - symbol[0], y - symbol[1], 20);
        return symbol[2];
    }

    public int drawString(Graphics g, String text, int x, int y, int anchor, boolean isBig) {
        text = text.toUpperCase();
        return this.drawString(g, text, x, y, anchor);
    }

    public int drawString(Graphics g, String text, int x, int y, int anchor) {
        char[] data = text.toCharArray();
        y = (anchor & 0x20) != 0 ? (y -= this.getLineSpacing()) : ((anchor & 2) != 0 ? (y += this.getFontHeight() / 2) : (y += this.getFontHeight()));
        int textWidth = 0;
        if ((anchor & 8) != 0) {
            textWidth = this.getLineWidth(data);
            x -= textWidth;
        } else if ((anchor & 1) != 0) {
            textWidth = this.getLineWidth(data);
            x -= textWidth / 2;
        }
        if (textWidth == 0) {
            for (int i = 0; i < data.length; ++i) {
                textWidth = textWidth + this.drawChar(g, data[i], x + textWidth, y) + this.getCharSpacing();
            }
        } else {
            for (int i = 0; i < data.length; ++i) {
                x = x + this.drawChar(g, data[i], x, y) + this.getCharSpacing();
            }
        }
        data = null;
        return textWidth;
    }

    public short[][] drawString(Graphics g, String data, int x, int y, int width, int height, int anchor, boolean isBig) {
        data = data.toUpperCase();
        return this.drawString(g, data, x, y, width, height, anchor);
    }

    public short[][] drawString(Graphics g, String data, int x, int y, int width, int height, int anchor) {
        short[][] mLineData = this.getLineData(data, width);
        this.drawFastString(g, data, mLineData, x, y, width, height, anchor);
        return mLineData;
    }

    public short[][] drawFastString(Graphics g, String data, short[][] mLineData, int x, int y, int width, int height, int anchor) {
        int textHeight;
        int maxLines = height / (this.getFontHeight() + this.getLineSpacing());
        if (maxLines < 1) {
            maxLines = 1;
        }
        if (mLineData.length < maxLines) {
            maxLines = mLineData.length;
        }
        int n = textHeight = maxLines == 1 ? maxLines * this.getFontHeight() : maxLines * (this.getLineSpacing() + this.getFontHeight());
        y = (anchor & 0x20) != 0 ? (y -= textHeight) : ((anchor & 2) != 0 ? y + this.getFontHeight() + (height - textHeight >> 1) : (y += this.getFontHeight()));
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        boolean textWidth = false;
        for (int i = 0; i < maxLines; ++i) {
            textWidth = false;
            if (mLineData[i][2] != 0) {
                this.drawFastString(g, data.toCharArray(), x, y, anchor, mLineData[i]);
            }
            y = y + this.getLineSpacing() + this.getFontHeight();
        }
        return mLineData;
    }

    public int getMaxNumLines(short[][] mLineData, int height) {
        return height / (this.getFontHeight() + this.lineSpacing);
    }

    public short[][] drawFastString(Graphics g, String data, int x, int y, int width, int height, int anchor, int firstLine, int linesToDraw) {
        int textHeight;
        short[][] mLineData = this.getLineData(data, width);
        int maxLines = height / (this.getFontHeight() + this.getLineSpacing());
        if (linesToDraw < maxLines) {
            maxLines = linesToDraw;
        }
        int n = textHeight = maxLines == 1 ? maxLines * this.getFontHeight() : maxLines * (this.getLineSpacing() + this.getFontHeight());
        y = (anchor & 0x20) != 0 ? (y -= textHeight) : ((anchor & 2) != 0 ? (y += height - textHeight >> 1) : (y += this.getFontHeight()));
        this.drawFastString(g, data, mLineData, x, y, width, anchor, firstLine, linesToDraw);
        return mLineData;
    }

    protected void drawFastString(Graphics g, String data, short[][] mLineData, int x, int y, int width, int anchor, int firstLine, int linesToDraw) {
        int maxLines = firstLine + linesToDraw;
        if (maxLines > mLineData.length) {
            maxLines = mLineData.length;
        }
        if ((anchor & 0x10) == 0) {
            y += this.getFontHeight();
        }
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        boolean textWidth = false;
        for (int i = firstLine; i < maxLines; ++i) {
            textWidth = false;
            if (mLineData[i][2] != 0) {
                this.drawFastString(g, data.toCharArray(), x, y, anchor, mLineData[i]);
            }
            y = y + this.getLineSpacing() + this.getFontHeight();
        }
    }

    private void drawFastString(Graphics g, char[] text, int x, int y, int anchor, short[] lineData) {
        if ((anchor & 8) != 0) {
            x -= lineData[2];
        } else if ((anchor & 1) != 0) {
            x -= lineData[2] / 2;
        }
        for (int i = lineData[0]; i < lineData[1] + 1; ++i) {
            x = x + this.drawChar(g, text[i], x, y) + this.getCharSpacing();
        }
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    protected int getCharSpacing() {
        return this.charSpacing;
    }

    protected int getSpaceSize() {
        return this.spaceSize;
    }
}

