/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.ui;

import com.lemonquest.text.LQFont;
import javax.microedition.lcdui.Graphics;

public class LQDialog {
    protected LQFont m_font;
    protected short[][] m_lineData;
    protected String m_txt;
    protected int m_width;
    protected int m_height;
    protected int m_pageNum;
    protected int m_currentPage;
    protected int m_lineNumPerPage;
    protected int m_scrollPosY;
    protected int m_scrollSpeedY = 1;
    boolean m_isSmoothScroll = false;

    public LQDialog(String txt, int width, int height, LQFont font) {
        this.m_font = font;
        this.m_txt = txt;
        this.m_width = width;
        this.m_height = height;
        this.m_lineData = this.m_font.getLineData(this.m_txt, this.m_width);
        this.m_lineNumPerPage = this.m_height / (this.m_font.getFontHeight() + this.m_font.getLineSpacing());
        this.m_pageNum = this.m_lineData.length / this.m_lineNumPerPage;
        if (this.m_lineData.length % this.m_lineNumPerPage != 0) {
            ++this.m_pageNum;
        }
    }

    public void draw(Graphics g, int x, int y, int anchor) {
        if (this.m_isSmoothScroll) {
            g.setClip(x, y, this.m_width, this.m_height);
            this.m_font.drawString(g, this.m_txt, x, y - this.m_scrollPosY, this.m_width, 65535, anchor);
        } else {
            this.m_font.drawFastString(g, this.m_txt, x, y, this.m_width, this.m_height, anchor, this.m_currentPage * this.m_lineNumPerPage, this.m_lineNumPerPage);
        }
    }

    public void setScrollSpeedY(int speed) {
        this.m_scrollSpeedY = speed;
    }

    public boolean scrollDown() {
        if (this.m_isSmoothScroll) {
            this.m_scrollPosY += this.m_scrollSpeedY;
            return false;
        }
        if (this.m_currentPage < this.m_pageNum - 1) {
            ++this.m_currentPage;
            return false;
        }
        return true;
    }

    public boolean scrollUp() {
        if (this.m_isSmoothScroll) {
            this.m_scrollPosY -= this.m_scrollSpeedY;
            return false;
        }
        if (this.m_currentPage > 0) {
            --this.m_currentPage;
            return false;
        }
        return true;
    }
}

