/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.lemonquest.lq3d.LQPrimitive;
import com.lemonquest.lq3d.renderlist.LQRenderNode;
import com.lemonquest.math.MathFP;
import com.lemonquest.math.Vec2D;
import com.lemonquest.physics_v2.RaceWorld;
import com.lemonquest.util.LQGfx;
import game.Level;
import game.Res;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Effects {
    private static Effects instance = new Effects();
    private static Random rand = new Random();
    private SimpleModelAnimEff bikeSparkEff;
    private SimpleModelAnimEff bikeSandEff;
    private SimpleModelAnimEff bikeSmokeEff;

    private Effects() {
    }

    public static Effects instance() {
        return instance;
    }

    public void release() {
        this.bikeSparkEff = null;
        this.bikeSandEff = null;
    }

    public void addBikeSpark(Vec2D pos) {
        if (this.bikeSparkEff != null) {
            return;
        }
        this.bikeSparkEff = new SimpleModelAnimEff();
        this.bikeSparkEff.pos = new Vec2D(pos);
        this.bikeSparkEff.frameNum = 3;
        this.bikeSparkEff.frameLen = 1;
        this.bikeSparkEff.prim = Res.instance().bikeSparkPrim;
        this.bikeSparkEff.renderNodes = Res.instance().bikeSparkRenderNode;
    }

    public SimpleModelAnimEff getBikeSparkEff() {
        return this.bikeSparkEff;
    }

    public void addBikeSand(Vec2D pos) {
        if (this.bikeSandEff != null) {
            return;
        }
        this.bikeSandEff = new SimpleModelAnimEff();
        this.bikeSandEff.pos = new Vec2D(pos);
        this.bikeSandEff.frameNum = 2;
        this.bikeSandEff.frameLen = 1;
        this.bikeSandEff.prim = Res.instance().bikeSandPrim;
        this.bikeSandEff.renderNodes = Res.instance().bikeSandRenderNode;
    }

    public SimpleModelAnimEff getBikeSandEff() {
        return this.bikeSandEff;
    }

    public void addBikeSmoke(Vec2D pos, int frameLen) {
        if (this.bikeSmokeEff != null) {
            return;
        }
        this.bikeSmokeEff = new SimpleModelAnimEff();
        this.bikeSmokeEff.pos = new Vec2D(pos);
        this.bikeSmokeEff.frameNum = 1;
        this.bikeSmokeEff.frameLen = frameLen;
        this.bikeSmokeEff.prim = Res.instance().bikeSmokePrim;
        this.bikeSmokeEff.renderNodes = Res.instance().bikeSmokeRenderNode;
    }

    public SimpleModelAnimEff getBikeSmokeEff() {
        return this.bikeSmokeEff;
    }

    public void update(Level level) {
        if (this.bikeSparkEff != null && this.bikeSparkEff.update()) {
            this.bikeSparkEff = null;
        }
        if (this.bikeSandEff != null && this.bikeSandEff.update()) {
            if (level.getPlayerBike().isInSand() && level.getPlayerBike().getSpeedFP() > RaceWorld.CONST_2) {
                this.bikeSandEff.pos.set(level.getPlayerBike().getSandPos());
                this.bikeSandEff.frame = 1;
            } else {
                this.bikeSandEff = null;
            }
        }
        if (this.bikeSmokeEff != null && this.bikeSmokeEff.update()) {
            this.bikeSmokeEff = null;
        }
    }

    public static class FullScreenBlackOutEff {
        private static FullScreenBlackOutEff instance = new FullScreenBlackOutEff();
        private boolean isStarted;
        private int tick;
        private int frameNum;

        private FullScreenBlackOutEff() {
        }

        public static FullScreenBlackOutEff instance() {
            return instance;
        }

        public void begin(int frameNum) {
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
            this.tick = 0;
            this.frameNum = frameNum;
        }

        public void update() {
        }

        public void draw(Graphics g) {
            if (!this.isStarted) {
                return;
            }
            int OneThirdTime = this.frameNum / 3;
            int MoveSpeed = Res.ScreenW / OneThirdTime;
            boolean color = false;
            if (this.tick < OneThirdTime) {
                int x = this.tick * MoveSpeed;
                g.setColor(0);
                g.fillRect(Res.ScreenX, Res.ScreenY, x, Res.ScreenH);
                for (int i = 0; i < Res.instance().effectFullScreenGfx.length; ++i) {
                    Res.instance().effectFullScreenGfx[i].draw(g, Res.ScreenX + x + i * Res.instance().effectFullScreenGfx[i].getWidth(), Res.ScreenY, 0);
                }
            } else if (this.tick < OneThirdTime * 2) {
                g.setColor(0);
                g.fillRect(Res.ScreenX, Res.ScreenY, Res.ScreenW, Res.ScreenH);
            } else {
                g.setColor(0);
                int offx = (this.tick - OneThirdTime * 2) * MoveSpeed;
                g.fillRect(Res.ScreenX + offx, Res.ScreenY, Res.ScreenW - offx, Res.ScreenH);
                int effGfxNum = Res.instance().effectFullScreenGfx.length;
                for (int i = 0; i < effGfxNum; ++i) {
                    int index = effGfxNum - 1 - i;
                    Res.instance().effectFullScreenGfx[index].draw(g, Res.ScreenX + offx - index * Res.instance().effectFullScreenGfx[index].getWidth(), Res.ScreenY, 0);
                }
            }
            ++this.tick;
            if (this.tick >= this.frameNum) {
                this.isStarted = false;
            }
        }
    }

    public static class WaterDropEffect2D {
        private int X;
        private int Y;
        private int W;
        private int H;
        private final int maxDropNum;
        private byte[] dropType;
        private int[] dropPos;
        private int[] dropMove;
        private int[] dropLife;
        private int dropInitLife = 128;
        private int dropGenerateTick;
        private int dropGenerateTime;
        private int dropGenerateFrequency = 96;

        public WaterDropEffect2D(int x, int y, int w, int h) {
            this.maxDropNum = 6;
            this.X = x;
            this.Y = y;
            this.W = w;
            this.H = h;
            this.dropType = new byte[6];
            this.dropPos = new int[12];
            this.dropMove = new int[6];
            this.dropLife = new int[6];
            this.dropGenerateTick = this.dropGenerateTime = this.dropGenerateFrequency / 2 + rand.nextInt() % (this.dropGenerateFrequency / 2);
        }

        public void update() {
            int i;
            --this.dropGenerateTick;
            if (this.dropGenerateTick < 0) {
                for (i = 0; i < this.dropType.length; ++i) {
                    if (this.dropLife[i] > 0) continue;
                    this.dropGenerateTick = this.dropGenerateTime = this.dropGenerateFrequency / 2 + rand.nextInt() % (this.dropGenerateFrequency / 2);
                    this.dropLife[i] = this.dropInitLife;
                    this.dropType[i] = (byte)Math.abs(rand.nextInt() % 2);
                    this.dropPos[i * 2] = this.X + Math.abs(rand.nextInt()) % this.W;
                    this.dropPos[i * 2 + 1] = this.Y + Math.abs(rand.nextInt()) % this.H;
                    this.dropMove[i] = 0;
                    break;
                }
            }
            for (i = 0; i < this.dropType.length; ++i) {
                if (this.dropLife[i] <= 0) continue;
                int n = i;
                this.dropLife[n] = this.dropLife[n] - 1;
                int n2 = i;
                this.dropMove[n2] = this.dropMove[n2] + 1;
                if (this.dropMove[i] < 5) continue;
                this.dropMove[i] = 0;
                if (this.dropType[i] == 0) {
                    int n3 = i * 2 + 1;
                    this.dropPos[n3] = this.dropPos[n3] + 1;
                    continue;
                }
                int n4 = i * 2 + 1;
                this.dropPos[n4] = this.dropPos[n4] + 0;
            }
        }

        public void draw(Graphics g, LQGfx[] waterDropImgs) {
            LQGfx img = null;
            for (int i = 0; i < this.dropType.length; ++i) {
                img = waterDropImgs[this.dropType[i]];
                if (this.dropLife[i] <= 0) continue;
                try {
                    img.draw(g, this.dropPos[i * 2], this.dropPos[i * 2 + 1], 0, 0, img.getWidth(), img.getHeight(), 3, this.dropLife[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class RainEffect2D {
        private int rainLineNum = 10;
        private int rainLineLength = 30;
        private int disturb = 10;
        private int X;
        private int Y;
        private int W;
        private int H;
        private int[] lines;
        private int[] lineLife;
        private int lifeLen = 6;

        public RainEffect2D(int x, int y, int w, int h) {
            this.X = x;
            this.Y = y;
            this.W = w;
            this.H = h;
            this.lines = new int[this.rainLineNum * 4];
            this.lineLife = new int[this.rainLineNum];
        }

        public void update(int wind, int aheadSpeed) {
            int aheadCenter_X = this.X + this.W / 2 + wind / 8;
            for (int i = 0; i < this.rainLineNum; ++i) {
                if (this.lineLife[i] <= 0) {
                    int random = rand.nextInt() % this.lifeLen;
                    this.lineLife[i] = this.lifeLen + random;
                    int lineLen = this.rainLineLength + random * this.rainLineLength / this.lifeLen;
                    int x = Math.abs(rand.nextInt()) % (this.W + Math.abs(wind) / 2) + this.X - wind / 4;
                    int y = this.Y + rand.nextInt() % ((aheadSpeed + 1) * 4);
                    int theta = rand.nextInt() % this.disturb;
                    theta += wind / 8;
                    if ((theta += (x - aheadCenter_X) * aheadSpeed / 60) < -60) {
                        theta = -60;
                    }
                    if (theta > 60) {
                        theta = 60;
                    }
                    int x2 = x + (lineLen * MathFP.lookupSin(theta) >> 12);
                    int y2 = y + (lineLen * MathFP.lookupCos(theta) >> 12);
                    this.lines[i * 4 + 0] = x;
                    this.lines[i * 4 + 1] = y;
                    this.lines[i * 4 + 2] = x2;
                    this.lines[i * 4 + 3] = y2;
                    continue;
                }
                int n = i;
                this.lineLife[n] = this.lineLife[n] - 1;
                int oldx = this.lines[i * 4 + 0];
                int oldy = this.lines[i * 4 + 1];
                this.lines[i * 4 + 0] = this.lines[i * 4 + 2];
                this.lines[i * 4 + 1] = this.lines[i * 4 + 3];
                this.lines[i * 4 + 2] = this.lines[i * 4 + 2] + (this.lines[i * 4 + 2] - oldx);
                this.lines[i * 4 + 3] = this.lines[i * 4 + 3] + (this.lines[i * 4 + 3] - oldy);
            }
        }

        public void draw(Graphics g) {
            g.setColor(0x99AAAA);
            for (int i = 0; i < this.lines.length; i += 4) {
                g.drawLine(this.lines[i], this.lines[i + 1], this.lines[i + 2], this.lines[i + 3]);
            }
        }
    }

    public static class ThunderEffect2D {
        private int thunderTick;
        private int thunderFrequency;

        public ThunderEffect2D() {
            this.thunderTick = this.thunderFrequency = 360;
        }

        public void draw(Graphics g) {
            --this.thunderTick;
            if (this.thunderTick == 3 || this.thunderTick == 0) {
                if (this.thunderTick == 0) {
                    this.thunderTick = this.thunderFrequency + rand.nextInt() % (this.thunderFrequency >> 1);
                }
                g.setColor(0xFFFFFF);
                g.fillRect(Res.ScreenX, Res.ScreenY, Res.ScreenW, Res.ScreenH / 2);
            }
        }
    }

    public static class SimpleModelAnimEff {
        public Vec2D pos;
        private int frameTick;
        public int frameLen;
        public int frame;
        public int frameNum;
        public LQPrimitive prim;
        public LQRenderNode[] renderNodes;

        public boolean update() {
            if (this.frame >= this.frameNum) {
                return true;
            }
            this.prim.fastUpdateVert(this.renderNodes[this.frame].getVertex());
            this.prim.fastUpdateTexels(this.renderNodes[this.frame].getTexels());
            ++this.frameTick;
            if (this.frameTick >= this.frameLen) {
                this.frameTick = 0;
                ++this.frame;
            }
            return false;
        }
    }
}

