/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.lemonquest.lq3d.LQAppearance;
import com.lemonquest.lq3d.LQBufferedTexture;
import com.lemonquest.lq3d.LQFactory;
import com.lemonquest.lq3d.LQGraphics3D;
import com.lemonquest.lq3d.LQPrimitive;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.math.LQMath;
import com.lemonquest.math.MathFP;
import com.lemonquest.math.Vec2D;
import com.lemonquest.text.LQFont;
import com.lemonquest.util.LQGfx;
import com.lemonquest.util.LQKey;
import game.Bike;
import game.Camera;
import game.Design;
import game.Effects;
import game.LQSound;
import game.Level;
import game.LevelMap;
import game.MainCanvas;
import game.MainMIDlet;
import game.MessageTeam;
import game.RaceMapClipper;
import game.Res;
import game.RoadEventHandler;
import game.UI;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GameMain {
    private MainCanvas main = null;
    public MessageTeam msgt = new MessageTeam();
    public boolean isFirstClew_QuickRace = true;
    public boolean isFirstClew_Champion = true;
    public static int debug = 0;
    private final int[] Cheating_FinishLevel = new int[]{16384, 32768, 32, 32768};
    private final int[] Cheating_AddBikePoints = new int[]{16384, 32768, 128, 32768};
    private Res res = Res.instance();
    public Effects effects = Effects.instance();
    private Effects.RainEffect2D rainEff2D;
    private Effects.ThunderEffect2D thunderEff2D;
    private Effects.WaterDropEffect2D waterDropEff2D;
    public UI ui;
    public Level level;
    private Level.LevelCustom levelCustom;
    public static LevelMap levelMap;
    private int levelIndex = 0;
    public boolean isMiniGame = false;
    private boolean isWin;
    public int smallGameName;
    private int zigzagRound;
    public int earnedPoints;
    public float wheelieAngle;
    public float destWheelieAngle;
    public float wheelieX;
    public float wheelieZ;
    public float brakeBikeInitPos;
    public boolean brakeHasHit;
    public int accDrawMinFrame;
    public int accDrawMaxFrame;
    private Bike.BikeCustom playerBikeCustom;
    public boolean enableMeshDataBuffer = false;
    public static final int MapGridHalfW = 160;
    public static final int MapGridHalfH = 160;
    public static final int FPS = 10;
    private LQGraphics3D g3d = LQFactory.LQGraphics3D();
    public Camera camera;
    public static final int ShowGroundNum = 6;
    private static Display display;
    private static boolean isVibrateEnabled;
    public RoadEventHandler roadEventHandler = new RoadEventHandler(this);
    public static final byte Graphics_Fastest = 0;
    public static final byte Graphics_Normal = 1;
    public static final byte Graphics_Debug = 2;
    public static final byte GraphicsQualityNum = 3;
    public static byte GraphicsQuality;
    public static final int STATE_Logo_Init = 1;
    public static final int STATE_Logo = 2;
    public static final int STATE_Logo_Exit = 3;
    public static final int STATE_EnableSound_Init = 4;
    public static final int STATE_EnableSound = 5;
    public static final int STATE_Cover_Init = 11;
    public static final int STATE_Cover = 12;
    public static final int STATE_MainMenu_Init = 21;
    public static final int STATE_MainMenu = 22;
    public static final int STATE_LoadStaticRes_Init = 101;
    public static final int STATE_LoadStaticRes = 102;
    public static final int STATE_LoadStaticRes_Exit = 103;
    public static final int STATE_LoadLevel_Init = 104;
    public static final int STATE_LoadLevel = 105;
    public static final int STATE_LoadLevel_Exit = 106;
    public static final int STATE_LoadMenu_Init = 107;
    public static final int STATE_LoadMenu = 108;
    public static final int STATE_LoadMenu_Exit = 109;
    public static final int STATE_ChooseBike_Init = 111;
    public static final int STATE_ChooseBike = 112;
    public static final int STATE_ChooseBike_Exit = 113;
    public static final int STATE_ChooseQuickRace_Init = 114;
    public static final int STATE_ChooseQuickRace = 115;
    public static final int STATE_ChooseQuickRace_Exit = 116;
    public static final int STATE_ChooseQuickRace_Ghost = 117;
    public static final int STATE_HighScore_Init = 121;
    public static final int STATE_HighScore = 122;
    public boolean isGhostDataFromOnLine;
    public static final int STATE_RaceDay_Init = 131;
    public static final int STATE_RaceDay = 132;
    public static final int STATE_RaceDay_Exit = 133;
    public static final int STATE_MotoEnhance_Init = 141;
    public static final int STATE_MotoEnhance = 142;
    public static final int STATE_MotoEnhance_Exit = 143;
    public static final int STATE_Training_Init = 151;
    public static final int STATE_Training = 152;
    public static final int STATE_Training_Exit = 153;
    public static final int STATE_TireConfig_Init = 161;
    public static final int STATE_TireConfig = 162;
    public static final int STATE_TireConfig_Exit = 163;
    public static final int STATE_Pause_Init = 201;
    public static final int STATE_Pause = 202;
    public static final int STATE_Pause_Help = 203;
    public static final int STATE_Pause_Exit = 204;
    public static final int STATE_LevelResult_Init = 301;
    public static final int STATE_LevelResult = 302;
    public static final int STATE_LevelResult_Exit = 303;
    public static final int STATE_ChampionshipResult_Init = 311;
    public static final int STATE_ChampionshipResult = 312;
    public static final int STATE_ChampionshipResult_Exit = 313;
    public static final int STATE_Congratulations = 321;
    public static final int STATE_Confirm_Init = 401;
    public static final int STATE_Confirm = 402;
    public static final int STATE_Confirm_Exit = 403;
    public static final int STATE_Confirm_ExitAll = 404;
    public static final int STATE_Help_Init = 411;
    public static final int STATE_Help = 412;
    public static final int STATE_About_Init = 421;
    public static final int STATE_About = 422;
    public static final int STATE_Achievement = 451;
    public static final int STATE_AchievementDisplay = 452;
    public static final int[] POINT_Achievement;
    public static final int STATE_Level = 501;
    public static final int STATE_LevelFinishing_Init = 541;
    public static final int STATE_LevelFinishing = 542;
    public static final int STATE_LevelFinishing_Exit = 543;
    public static final int STATE_REPLAY_Init = 551;
    public static final int STATE_REPLAY = 552;
    public static final int STATE_SmallGame_Init = 561;
    public static final int STATE_SmallGame = 562;
    public static final int STATE_SmallGame_Exit = 563;
    public static final int STATE_SUSPEND = 601;
    public int gameState = 1;
    public int copy_gameState = -1;
    private Level.LevelCustom oldLevelCustom;
    public static String errMessage;
    public static String errMessage2;
    public static String errMessage3;
    public static int loading;
    public static int debugTime;
    LQTransform bikeTrans = LQFactory.LQTransform();
    LQTransform bikeShadowTrans = LQFactory.LQTransform();
    LQTransform bikeSparkTrans = LQFactory.LQTransform();
    LQTransform bikeSandTrans = LQFactory.LQTransform();
    LQTransform bikeSmokeTrans = LQFactory.LQTransform();
    LQTransform bikeBackLightTrans = LQFactory.LQTransform();
    LQTransform bikeSavedTrans = LQFactory.LQTransform();
    private float bg_offset_x = 0.0f;
    private float last_bg_offset_x = 0.0f;
    private float aaaaa = 0.0f;
    private int playerBikeThumbTick;
    private int brakeGameTick;
    private final int CONST_667 = MathFP.toFP("6.667");
    private int flickTick;
    private int levelResultBoxW;
    private int levelResultBoxH;
    public boolean isDraw = true;
    public int levelIndexRaceDay;
    LQPrimitive debugPrim;
    int[] debugPrimIndices;
    LQPrimitive debugArrow;
    short[] debugArrowVertices;
    public int stateOnLine = -1;
    public static final int STATE_UpLoad = 0;
    public static final int STATE_DownLoad = 1;
    public static final int STATE_DownLoadList = 2;

    public GameMain(MainCanvas main1) {
        this.main = main1;
        this.ui = new UI(this, this.g3d);
        this.rainEff2D = new Effects.RainEffect2D(Res.ScreenX, Res.ScreenY, Res.ScreenW, Res.ScreenH * 5 / 6);
        this.thunderEff2D = new Effects.ThunderEffect2D();
        this.waterDropEff2D = new Effects.WaterDropEffect2D(Res.ScreenX + Res.ScreenW / 8, Res.ScreenY + Res.ScreenH / 8, Res.ScreenW * 3 / 4, Res.ScreenH * 3 / 4);
    }

    public void initLevel(int levelID) {
        GameMain.setLoading(22);
        int groundGroup = Design.getGroundGroup(levelID);
        String normTexFile = Res.DIR_3D + "map_" + groundGroup;
        String effTexFile = Res.DIR_3D + "map_" + groundGroup + "_effect";
        GameMain.setLoading(23);
        this.level = null;
        System.gc();
        this.level = new Level(this, this.levelCustom.opponentNum, levelID);
        this.getCamera().setType((byte)-4);
        GameMain.setLoading(24);
        this.res.groundRenderList.setNodeList(levelMap.getGroundRenderNodes());
        if (!Res.isSBmemory()) {
            this.res.treeRenderList.setNodeList(levelMap.getTreeRenderNodes());
        }
        GameMain.setLoading(25);
        DataInputStream normTexStream = new DataInputStream(this.getClass().getResourceAsStream(normTexFile + ".tex"));
        System.out.println("normTexFile:" + normTexFile);
        if (normTexStream == null) {
            System.out.println("Error:::::normTexStream==null");
        }
        LQBufferedTexture normalTex = LQFactory.LQBufferedTexture(normTexStream);
        GameMain.setLoading(26);
        try {
            normTexStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        GameMain.setLoading(27);
        DataInputStream effTexStream = new DataInputStream(this.getClass().getResourceAsStream(effTexFile + ".tex"));
        LQBufferedTexture effectTex = LQFactory.LQBufferedTexture(effTexStream);
        try {
            effTexStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        GameMain.setLoading(28);
        if (this.levelCustom.weather == 1) {
            Res.changePalette(normalTex, normTexFile + "_rain.pal");
            Res.changePalette(effectTex, effTexFile + "_rain.pal");
        }
        GameMain.setLoading(29);
        GameMain.setLoading(31);
    }

    public Level getLevel() {
        return this.level;
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public void initLevelCustom(int gameMode, int typeOfRace, int curcuit, int lapNum, int opponentNum, int weatherType) {
        this.levelCustom = new Level.LevelCustom();
        this.levelCustom.gameMode = (byte)gameMode;
        this.levelCustom.typeOfRace = (byte)typeOfRace;
        this.levelCustom.curcuit = curcuit;
        this.levelCustom.lapNum = lapNum;
        this.levelCustom.opponentNum = opponentNum;
        this.levelCustom.weather = (byte)weatherType;
    }

    public void releaseLevelCustom() {
        this.levelCustom = null;
    }

    public Level.LevelCustom getLevelCustom() {
        return this.levelCustom;
    }

    public void initSmallGameLevelCustom(int gameMode, int typeOfRace, int curcuit, int lapNum, int opponentNum, int weatherType) {
        this.oldLevelCustom = this.levelCustom;
        this.initLevelCustom(gameMode, typeOfRace, curcuit, lapNum, opponentNum, weatherType);
    }

    public void releaseSmallGameLevelCustom() {
        this.levelCustom = null;
        this.levelCustom = this.oldLevelCustom;
    }

    public void initBikeCustom(byte tireType, byte tireHardness) {
        this.playerBikeCustom = new Bike.BikeCustom();
        this.playerBikeCustom.tireType = tireType;
        this.playerBikeCustom.tireHardness = tireHardness;
    }

    public Bike.BikeCustom getPlayerBikeCustom() {
        return this.playerBikeCustom;
    }

    public void setGameState(int state) {
        System.gc();
        this.gameState = state;
    }

    public void draw(Graphics g) {
        switch (this.gameState) {
            case 202: 
            case 203: 
            case 501: {
                this.drawLevel(g);
                break;
            }
            case 542: {
                Res.resetClip(g);
                this.drawBG2D(g);
                this.drawLevel3D(g);
                this.drawLevelResult(g);
                break;
            }
            case 302: {
                break;
            }
            case 601: {
                this.drawSuspend(g);
            }
        }
        if (this.gameState < 500) {
            this.ui.draw(g);
        }
        if (this.gameState != 601 && this.msgt.isHaveMessage()) {
            this.msgt.draw(g);
        }
    }

    public static void setLoading(int a) {
        loading = a;
    }

    public void drawDebug(Graphics g) {
        ++debugTime;
        g.setClip(0, 0, 600, 600);
        g.setColor(0xFF0000);
        g.drawString("state:" + this.gameState, 4, 50, 0);
        g.drawString("time:" + (debugTime %= 100000), 4, 70, 0);
    }

    private void drawSuspend(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        this.res.loadFontBig();
        this.res.fontWhiteBig.drawString(g, this.res.txt[17], 120, 160, 3, true);
        this.ui.drawButtons(g, 18, -1);
    }

    private void drawLevel(Graphics g) {
        Res.resetClip(g);
        this.drawBG2D(g);
        if (this.levelCustom.weather == 1) {
            this.thunderEff2D.draw(g);
        }
        this.drawLevel3D(g);
        if (this.levelCustom.weather == 1) {
            int speed = MathFP.toInt(this.level.getPlayerBike().getSpeedFP());
            this.rainEff2D.update(-this.level.getPlayerBike().getTurnAngle() * speed, speed);
            this.rainEff2D.draw(g);
        }
        this.drawUI(g);
        if (this.gameState != 202) {
            Res.resetClip(g);
            this.drawFullScreenEffect(g);
        }
        Res.resetClip(g);
        if (this.gameState != 202 && this.gameState != 203 && !this.msgt.isHaveMessage() && !this.camera.isOpeningShow()) {
            g.drawImage(this.res.notifyIconImg, 2, Res.ScreenH - 2, 36);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLevel3D(Graphics g) {
        try {
            this.g3d.bindTarget(g);
            this.g3d.clear();
            this.res.groundRenderList.draw(this.g3d, this.res.groundTrans);
            this.g3d.flush();
            for (int bikeIndex = 0; bikeIndex < this.level.getBikes().length; ++bikeIndex) {
                Bike bike = this.level.getBikes()[bikeIndex];
                int groundID = bike.getGroundID();
                int start = RaceMapClipper.GroundStartIndex;
                int end = RaceMapClipper.GroundEndIndex;
                if (end >= levelMap.getGrounds().length ? !(groundID >= start && groundID <= levelMap.getGrounds().length - 1 || groundID <= (end -= levelMap.getGrounds().length) && groundID >= 0) : groundID < start || groundID > end) continue;
                this.bikeTrans.identity();
                int angle = bike.getAngle();
                this.bikeTrans.rotateWorldZ(angle);
                if (bike == this.level.getPlayerBike()) {
                    this.bikeShadowTrans.set(this.bikeTrans);
                    this.bikeSparkTrans.set(this.bikeTrans);
                    this.bikeSmokeTrans.set(this.bikeTrans);
                    this.bikeSandTrans.set(this.bikeTrans);
                }
                if (this.levelCustom.typeOfRace == 6 && bike.getSpeedFP() > 0) {
                    this.wheelieAngle += (this.destWheelieAngle - this.wheelieAngle) * 0.5f;
                    this.bikeTrans.translate(0.0f, 0.0f, this.wheelieZ);
                    this.bikeTrans.rotateY(-this.wheelieAngle);
                    this.bikeTrans.translate(this.wheelieX, 0.0f, -this.wheelieZ);
                }
                int offset = 0;
                if (Math.abs(bike.getTurnAngle()) > 10 && Math.abs(bike.getTurnAngle()) < 25) {
                    offset = 1;
                } else if (Math.abs(bike.getTurnAngle()) >= 25) {
                    offset = 2;
                }
                if (bike.getTurnAngle() < 0) {
                    offset = -offset;
                }
                int meshIndex = 2 + offset;
                this.bikeTrans.rotateX(-bike.getDrawTurnAngle());
                float x = bike.getXf();
                float y = bike.getYf();
                float z = bike.getZf();
                this.bikeTrans.translateWorld(x, y, z);
                if (bike == this.level.getPlayerBike()) {
                    this.bikeBackLightTrans.set(this.bikeTrans);
                }
                this.bikeTrans.rotateZ(90.0f);
                if (bike.getMode() == 4) {
                    meshIndex = 7;
                    bike.humanCrashTrans.identity();
                    bike.humanCrashTrans.translateWorld(x - 20.0f, y - 20.0f, z);
                    bike.bikeCrashRotTrans.rotateWorldZ(MathFP.toInt(bike.getSpeedFP() >> 2));
                    this.bikeTrans.mul(bike.bikeCrashRotTrans);
                    this.bikeShadowTrans.mul(bike.bikeCrashRotTrans);
                }
                if (bike.getMode() != 4 && bike.getSpeedFP() == 0) {
                    meshIndex = 5;
                    this.bikeTrans.rotateX(5.0f);
                }
                if (bike.isGhost()) {
                    this.res.humanMeshes[meshIndex].setAppearance(this.res.humanAddApp);
                    this.res.bikeMesh.setAppearance(this.res.bikeAddApp);
                } else {
                    this.res.humanMeshes[meshIndex].setAppearance(this.res.humanReplaceApp);
                    this.res.bikeMesh.setAppearance(this.res.bikeReplaceApp);
                }
                if (bike == this.level.getPlayerBike() || this.getLevelCustom().typeOfRace == 3) {
                    this.bikeSavedTrans.set(this.bikeTrans);
                    this.g3d.render(this.res.bikeMesh, this.bikeTrans);
                    if (bike.getMode() == 4) {
                        this.g3d.render(this.res.humanMeshes[meshIndex], bike.humanCrashTrans);
                        continue;
                    }
                    this.g3d.render(this.res.humanMeshes[meshIndex], this.bikeTrans);
                    continue;
                }
                byte bikeType = bike.getRiderInfo().bikeType;
                this.res.bikeMeshSimple.setAppearance(this.res.bikeReplaceAppSimple[bikeType]);
                this.g3d.render(this.res.bikeMeshSimple, this.bikeTrans);
            }
            if (!Res.isSBmemory()) {
                this.res.treeRenderList.draw(this.g3d, this.res.groundTrans);
            }
            this.drawDebug(this.g3d);
            this.g3d.flush();
        }
        finally {
            this.g3d.releaseTarget();
        }
    }

    public void drawBG2D(Graphics g) {
        g.setColor(6252346);
        g.fillRect(0, 0, 240, 320);
        if (Res.isSBmemory() && !Res.isK700()) {
            return;
        }
        if (Res.isHI()) {
            // empty if block
        }
        this.last_bg_offset_x = this.bg_offset_x;
        Image bgImg = null;
        bgImg = this.levelCustom.weather == 1 ? this.res.gameBgImg_Rain : this.res.gameBgImg_Dry;
        this.bg_offset_x = this.camera.getAngle2();
        float off = this.bg_offset_x - this.last_bg_offset_x;
        if (Math.abs(off) > 180.0f) {
            if (this.last_bg_offset_x < 90.0f && this.bg_offset_x > 270.0f) {
                off = this.bg_offset_x - 360.0f - this.last_bg_offset_x;
            }
            if (this.bg_offset_x < 90.0f && this.last_bg_offset_x > 270.0f) {
                off = this.bg_offset_x + 360.0f - this.last_bg_offset_x;
            }
        }
        this.aaaaa += off * 5.0f;
        int bg_x = LQMath.round(this.aaaaa) % bgImg.getWidth();
        g.drawImage(bgImg, bg_x, 0, 0);
        if (Res.isK700()) {
            g.drawImage(bgImg, bg_x + 44, 0, 0);
            g.drawImage(bgImg, bg_x + 88, 0, 0);
            g.drawImage(bgImg, bg_x + 132, 0, 0);
        } else if (Res.isSBmemory()) {
            g.drawImage(bgImg, bg_x + 120, 0, 0);
        }
        if (bg_x < 0) {
            g.drawImage(bgImg, bg_x + bgImg.getWidth(), 0, 0);
        }
        if (bg_x > 0) {
            g.drawImage(bgImg, bg_x, 0, 24);
        }
    }

    public void drawUI(Graphics g) {
        Res.resetClip(g);
        if (this.levelCustom.typeOfRace == 6) {
            this.drawWheelieGameUI(g);
            return;
        }
        if (this.levelCustom.typeOfRace == 8) {
            this.drawBrakeGameUI(g);
            return;
        }
        if (this.levelCustom.typeOfRace == 7) {
            this.drawAccelerationGameUI(g);
            return;
        }
        Res.resetClip(g);
        this.drawInstrumentPanel(g);
        this.drawTimePanel(g);
        this.drawSmallMapPng(g);
        if (this.level.getState() == 0) {
            if (this.gameState != 202) {
                Effects.FullScreenBlackOutEff.instance().draw(g);
            }
        } else if (this.level.getState() == 1) {
            int countingNum = this.level.getShowTick() / 10;
            if (countingNum < 3) {
                boolean isShow;
                int time = this.level.getShowTick() % 10;
                boolean isSmallNum = time > 1 && time < 8;
                boolean bl = isShow = time < 8;
                if (isShow) {
                    LQGfx numGfx = this.res.countingBigGfx;
                    if (!isSmallNum) {
                        numGfx = this.res.countingSmallGfx;
                    }
                    if (Res.isSBmemory() || Res.isW128()) {
                        g.setClip(0, 0, 600, 600);
                        if (!this.msgt.isHaveMessage()) {
                            if (this.res.fontWhiteSmall == null) {
                                this.res.loadFontSamll();
                            }
                            this.res.fontWhiteSmall.drawString(g, "" + (3 - countingNum), Res.ScreenX + Res.ScreenW / 2, Res.ScreenY + Res.ScreenH / 2, 3);
                        }
                    } else {
                        numGfx.draw(g, Res.ScreenX + Res.ScreenW / 2, Res.ScreenY + Res.ScreenH / 2, countingNum * numGfx.getWidth() / 3, 0, numGfx.getWidth() / 3, numGfx.getHeight(), 3);
                    }
                }
            } else {
                int offset = (this.level.getShowTick() - 35) * 20;
                if (offset < 0) {
                    offset = 0;
                }
                if (Res.isSBmemory()) {
                    String GO = "GO";
                    if (!this.msgt.isHaveMessage()) {
                        this.res.fontWhiteSmall.drawString(g, GO, Res.ScreenX + Res.ScreenW / 2 + offset, Res.ScreenY + Res.ScreenH / 2, 3);
                        this.res.fontWhiteSmall.drawString(g, GO, Res.ScreenX + Res.ScreenW / 2 - offset, Res.ScreenY + Res.ScreenH / 2, 3);
                    }
                } else {
                    this.res.countingGoGfx.draw(g, Res.ScreenX + Res.ScreenW / 2 + offset, Res.ScreenY + Res.ScreenH / 2, 0, 0, this.res.countingGoGfx.getWidth(), this.res.countingGoGfx.getHeight() / 2, 3);
                    this.res.countingGoGfx.draw(g, Res.ScreenX + Res.ScreenW / 2 - offset, Res.ScreenY + Res.ScreenH / 2, 0, this.res.countingGoGfx.getHeight() / 2, this.res.countingGoGfx.getWidth(), this.res.countingGoGfx.getHeight() / 2, 3);
                }
            }
        }
    }

    private void drawAccelerationGameUI(Graphics g) {
        int frame;
        this.drawInstrumentPanel(g);
        int barX = Res.ScreenX + Res.ScreenW * 4 / 5;
        int barY = Res.ScreenY + Res.ScreenH / 6;
        int barW = Res.ScreenW / 10;
        int barH = Res.ScreenH * 2 / 5;
        int gear = this.level.getPlayerBike().getGear();
        if (gear == 0) {
            gear = 1;
        }
        if ((frame = this.level.getFrame()) == Design.AccChangeGearTime[0]) {
            this.accDrawMinFrame = Design.AccChangeGearTime[0];
            this.accDrawMaxFrame = Design.AccChangeGearTime[1];
        } else if (frame == Design.AccChangeGearTime[1] || frame == Design.AccChangeGearTime[2] || frame == Design.AccChangeGearTime[3] || frame == Design.AccChangeGearTime[4] || frame == Design.AccChangeGearTime[5]) {
            this.accDrawMinFrame = Design.AccChangeGearTime[gear] - Math.abs(this.res.rand.nextInt()) % 6;
            this.accDrawMaxFrame = Design.AccChangeGearTime[gear + 1] + Math.abs(this.res.rand.nextInt()) % 6;
        }
        int currPos2D = barH - LQMath.round((float)(frame - this.accDrawMinFrame) * (float)barH / (float)(this.accDrawMaxFrame - this.accDrawMinFrame));
        if (this.res.accGameAlphaBar == null) {
            this.res.accGameAlphaBar = Res.createFixedMsgBox(barW, barH, 0, 0);
            this.res.accGameAlphaBar.setAlpha(127);
        }
        this.res.accGameAlphaBar.draw(g, barX, barY, 20);
        Res.resetClip(g);
        g.setColor(0xFFFFFF);
        if (gear < 6) {
            int perfectHitTime = Design.AccChangeGearTime[gear] - Design.AccPerfectOffset[gear];
            if (frame >= perfectHitTime - 1 && frame <= perfectHitTime + 1) {
                g.setColor(65280);
            } else if (frame >= perfectHitTime - 1 - 2 && frame <= perfectHitTime + 1 + 2) {
                g.setColor(0xFFFF00);
            }
        }
        g.drawRect(barX - 1, barY - 1, barW + 1, barH + 1);
        if (gear < 6) {
            int perfectFrame = this.accDrawMaxFrame - Design.AccPerfectOffset[gear];
            int perfectPos2D = barH - LQMath.round((float)(perfectFrame - this.accDrawMinFrame) * (float)barH / (float)(this.accDrawMaxFrame - this.accDrawMinFrame));
            int perfectScale2D = LQMath.round(1.0f * (float)barH / (float)(this.accDrawMaxFrame - this.accDrawMinFrame));
            int acceptableScale2D = LQMath.round(2.0f * (float)barH / (float)(this.accDrawMaxFrame - this.accDrawMinFrame));
            int[] fadeColors = new int[]{0xFF0000, 0xFF6600, 11500854, 0x5D552D};
            int targetBarH = (perfectScale2D + acceptableScale2D) * 2;
            int targetBarStep = targetBarH / 7;
            g.setColor(fadeColors[0]);
            g.fillRect(barX, barY + perfectPos2D - targetBarStep / 2, barW, targetBarStep);
            g.setColor(fadeColors[1]);
            g.fillRect(barX, barY + perfectPos2D - targetBarStep / 2 - targetBarStep, barW, targetBarStep);
            g.fillRect(barX, barY + perfectPos2D + targetBarStep / 2, barW, targetBarStep);
            g.setColor(fadeColors[2]);
            g.fillRect(barX, barY + perfectPos2D - targetBarStep / 2 - targetBarStep * 2, barW, targetBarStep);
            g.fillRect(barX, barY + perfectPos2D + targetBarStep / 2 + targetBarStep * 1, barW, targetBarStep);
            g.setColor(fadeColors[3]);
            g.fillRect(barX, barY + perfectPos2D - targetBarStep / 2 - targetBarStep * 3, barW, targetBarStep);
            g.fillRect(barX, barY + perfectPos2D + targetBarStep / 2 + targetBarStep * 2, barW, targetBarStep);
            g.setColor(0x33FFFF);
            g.drawRect(barX, barY + perfectPos2D - perfectScale2D - acceptableScale2D, barW, acceptableScale2D);
            g.drawRect(barX, barY + perfectPos2D + perfectScale2D, barW, acceptableScale2D);
            g.setColor(0xFFAAFF);
            g.drawRect(barX, barY + perfectPos2D - perfectScale2D, barW, perfectScale2D * 2);
        }
        if (this.res.menuArrowGfx == null) {
            this.res.menuArrowGfx = new LQGfx(Res.DIR + "aaaa.png");
        }
        this.ui.drawArrow(g, 3, barX - 3, barY + currPos2D, 10);
        this.ui.drawArrow(g, 2, barX + barW + 3, barY + currPos2D, 6);
        Res.resetClip(g);
        g.setColor(0xFFFFFF);
        g.fillRect(barX - 2, barY + currPos2D, barW + 4, 1);
        g.setColor(0xFF0000);
        g.drawRect(barX - 3, barY + currPos2D - 1, barW + 5, 2);
    }

    private void drawBrakeGameUI(Graphics g) {
        this.drawMovieScreenEffect(g, Res.ScreenH / 6, this.level.getFrame(), 60);
        this.drawInstrumentPanel(g);
        LQGfx gfx = this.res.meterGfx;
        int meterX = Res.ScreenX + Res.ScreenW * 4 / 5;
        int meterY = 0;
        int bikeDrawY2D = Res.ScreenY + Res.ScreenH * 3 / 4;
        float scaleRatio = 0.3f;
        float playerPos3D = this.level.getPlayerBike().getXf() - this.brakeBikeInitPos;
        float scrollPos = playerPos3D * scaleRatio;
        int meterLength = LQMath.round(3600.0f * scaleRatio);
        float init2DPos = meterLength;
        for (int drawedLen = 0; drawedLen < meterLength * 3; drawedLen += gfx.getHeight()) {
            gfx.draw(g, meterX, LQMath.round((float)(-meterLength + meterY + bikeDrawY2D) - init2DPos + scrollPos + (float)drawedLen), 17);
        }
        int mileNumberX = meterX - gfx.getWidth() / 2;
        int pos3000 = LQMath.round((float)(meterY + bikeDrawY2D) - 120.0f * scaleRatio + scrollPos);
        int pos2500 = LQMath.round((float)(meterY + bikeDrawY2D) - 620.0f * scaleRatio + scrollPos);
        int pos2000 = LQMath.round((float)(meterY + bikeDrawY2D) - 1120.0f * scaleRatio + scrollPos);
        int pos1500 = LQMath.round((float)(meterY + bikeDrawY2D) - 1620.0f * scaleRatio + scrollPos);
        this.res.fontNumWhiteMid.drawString(g, "1500", mileNumberX, pos3000, 10);
        this.res.fontNumWhiteMid.drawString(g, "1250", mileNumberX, pos2500, 10);
        this.res.fontNumWhiteMid.drawString(g, "1000", mileNumberX, pos2000, 10);
        this.res.fontNumWhiteMid.drawString(g, "750", mileNumberX, pos1500, 10);
        Res.resetClip(g);
        int lableWidth = 28;
        float targetPoint2D = 3120.0f * scaleRatio;
        int perfectH2D = LQMath.round(100.0f * scaleRatio);
        int acceptableH2D = LQMath.round(150.0f * scaleRatio);
        g.setColor(65280);
        g.fillRect(meterX - lableWidth / 2, LQMath.round((float)(meterY + bikeDrawY2D) - targetPoint2D + scrollPos) - perfectH2D, lableWidth, perfectH2D * 2);
        g.setColor(0xFFFF00);
        g.fillRect(meterX - lableWidth / 2, LQMath.round((float)(meterY + bikeDrawY2D) - targetPoint2D + scrollPos) - perfectH2D - acceptableH2D, lableWidth, acceptableH2D);
        g.fillRect(meterX - lableWidth / 2, LQMath.round((float)(meterY + bikeDrawY2D) - targetPoint2D + scrollPos) + perfectH2D, lableWidth, acceptableH2D);
        if (playerPos3D >= 3020.0f && playerPos3D <= 3220.0f) {
            if (this.brakeGameTick++ % 2 == 0) {
                g.setColor(65280);
                g.fillRect(meterX - gfx.getWidth() / 2 - 2, 0, 2, Res.ScreenH);
                g.fillRect(meterX + gfx.getWidth() / 2, 0, 2, Res.ScreenH);
            }
        } else if (playerPos3D >= 2870.0f && playerPos3D <= 3370.0f && this.brakeGameTick++ % 2 == 0) {
            g.setColor(0xFFFF00);
            g.fillRect(meterX - gfx.getWidth() / 2 - 2, 0, 2, Res.ScreenH);
            g.fillRect(meterX + gfx.getWidth() / 2, 0, 2, Res.ScreenH);
        }
        if (this.brakeGameTick > 20000) {
            this.brakeGameTick = 0;
        }
        this.res.curcuitThumbBikesGfx.draw(g, meterX, bikeDrawY2D, 9, 0, 9, 9, 3);
        this.drawTimePanel(g);
    }

    private void drawWheelieGameUI(Graphics g) {
        this.drawTimePanel(g);
        this.drawMovieScreenEffect(g, Res.ScreenH / 6, this.level.getFrame(), 60);
    }

    private void drawMovieScreenEffect(Graphics g, int height, int time, int totalTime) {
        Res.resetClip(g);
        g.setColor(0);
        int fadeTime = totalTime / 3;
        float fadeStep = (float)height / (float)fadeTime;
        if (time <= fadeTime) {
            int rectH = LQMath.round((float)time * fadeStep);
            g.fillRect(Res.ScreenX, Res.ScreenY, Res.ScreenW, rectH);
            g.fillRect(Res.ScreenX, Res.ScreenY + Res.ScreenH - rectH, Res.ScreenW, rectH);
        } else if (time <= 2 * fadeTime) {
            int rectH = height;
            g.fillRect(Res.ScreenX, Res.ScreenY, Res.ScreenW, rectH);
            g.fillRect(Res.ScreenX, Res.ScreenY + Res.ScreenH - rectH, Res.ScreenW, rectH);
        } else if (time <= totalTime) {
            int rectH = LQMath.round((float)(totalTime - time) * fadeStep);
            g.fillRect(Res.ScreenX, Res.ScreenY, Res.ScreenW, rectH);
            g.fillRect(Res.ScreenX, Res.ScreenY + Res.ScreenH - rectH, Res.ScreenW, rectH);
        }
    }

    private void drawAiInfo(Graphics g, int cx, int cy) {
        LevelMap.Ground[] grounds = levelMap.getGrounds();
        for (int groupIndex = RaceMapClipper.GroundStartIndex; groupIndex <= RaceMapClipper.GroundEndIndex; ++groupIndex) {
            int id = groupIndex;
            if (groupIndex < 0) {
                id = groupIndex + grounds.length;
            }
            if (groupIndex > grounds.length - 1) {
                id = groupIndex - grounds.length;
            }
            int x = this.level.getPhyWorld().toDrawX(grounds[id].drivingPointFP.X);
            int y = this.level.getPhyWorld().toDrawY(grounds[id].drivingPointFP.Y);
            g.setColor(65535);
            g.fillRect(x - 1, y - 1, 3, 3);
            g.setColor(0xFFFF00);
            g.drawRect(x - 2, y - 2, 4, 4);
        }
    }

    private void drawInstrumentPanel(Graphics g) {
        int speed = this.level.getPlayerBike().getSpeedFP();
        int MaxSpeed = this.level.getPlayerBike().getMaxSpeedFPGear();
        int angle = -90;
        if (MaxSpeed > 0) {
            angle = MathFP.toInt(MathFP.div(MathFP.mul(speed, MathFP.toFP(270)), MaxSpeed)) - 90;
        }
        if (angle < -90) {
            angle = -90;
        }
        if (angle > 185) {
            angle = 180;
        }
        int sin = MathFP.lookupSin(angle);
        int cos = MathFP.lookupCos(angle);
        int radius = 20;
        int posx = 40;
        int posy = Res.ScreenH - 48;
        if (Res.isW176()) {
            radius = 13;
            posx = 29;
            posy = Res.ScreenH - 48 + 11;
        }
        int x = posx - MathFP.toInt(MathFP.mul(MathFP.toFP(radius), cos));
        int y = posy - MathFP.toInt(MathFP.mul(MathFP.toFP(radius), sin));
        Res.resetClip(g);
        g.drawImage(this.res.dashboardImg, 6, Res.ScreenH - 16, 36);
        if (!Res.isW128() && !Res.isSBmemory()) {
            g.setColor(0xFF4400);
            g.drawLine(posx, posy, x, y);
        }
        if (speed > 0) {
            speed = speed * 8 / 5;
        }
        speed = MathFP.mul(speed, this.CONST_667);
        int speedx = 64;
        int speedy = Res.ScreenH - 26;
        if (Res.isW128() || Res.isSBmemory()) {
            speedx = 30;
            speedy = 304;
        } else {
            if (Res.isW176()) {
                speedx = 44;
                speedy = Res.ScreenH - 26 + 9;
            }
            if (Res.isW240()) {
                speedy += 3;
            }
        }
        this.res.fontNumWhiteMid.drawString(g, "" + MathFP.toInt(speed), speedx, speedy, 33);
        int gearx = 16;
        int geary = Res.ScreenH - 22;
        if (Res.isW128() || Res.isSBmemory()) {
            gearx = 11;
            geary = 304;
        } else {
            if (Res.isW176()) {
                gearx = 12;
                geary = 305;
            }
            if (Res.isW240()) {
                geary += 3;
            }
        }
        this.res.fontNumWhiteMid.drawString(g, "" + this.level.getPlayerBike().getGear(), gearx, geary, 33);
    }

    private void drawTimePanel(Graphics g) {
        int lapNum;
        Res.resetClip(g);
        int Y = 18;
        if (!Res.isW128() && !Res.isSBmemory()) {
            Y = this.res.topCenterUiImg.getHeight() * 2 / 5;
            g.drawImage(this.res.topCenterUiImg, Res.ScreenW / 2, 0, 17);
            g.drawImage(this.res.topLeftUiImg, 0, Y, 6);
            g.drawImage(this.res.topRightUiImg, Res.ScreenW, Y, 10);
        }
        int time = 0;
        boolean needDraw = true;
        if (this.getLevelCustom().typeOfRace == 1) {
            time = this.getLevelCustom().lapNum * Design.AgainstClockTime[this.getLevelIndex()] - this.getLevel().getPlayerBike().getTotalUsedTime();
            if (time < 30 && this.flickTick++ % 2 == 0) {
                needDraw = false;
            }
        } else if (this.getLevelCustom().typeOfRace == 4) {
            time = 600 - this.getLevel().getPlayerBike().getTotalUsedTime();
            if (time < 30 && this.flickTick++ % 2 == 0) {
                needDraw = false;
            }
        } else if (this.getLevelCustom().typeOfRace == 5) {
            time = 1680 - this.getLevel().getPlayerBike().getTotalUsedTime();
            if (time < 30 && this.flickTick++ % 2 == 0) {
                needDraw = false;
            }
        } else if (this.getLevelCustom().typeOfRace == 8) {
            time = 380 - this.getLevel().getPlayerBike().getTotalUsedTime();
            if (time < 30 && this.flickTick++ % 2 == 0) {
                needDraw = false;
            }
        } else {
            time = this.getLevel().getPlayerBike().getTotalUsedTime();
        }
        lapNum = (lapNum = this.getLevel().getPlayerBike().getFinishedLaps()) == 0 ? 1 : ++lapNum;
        int totalLap = this.getLevelCustom().lapNum;
        g.setColor(0xFFFFFF);
        int x_lap = Res.ScreenW / 2 + 51 - 8;
        int y_lap = Y;
        if (Res.isW128() || Res.isSBmemory()) {
            y_lap = 4;
            this.res.fontNumWhiteMid.drawString(g, this.res.txt[32].toLowerCase(), x_lap -= 12, y_lap, 6);
            y_lap += this.res.fontNumWhiteMid.getFontHeight() + 4;
        } else if (Res.is352x416()) {
            x_lap = 286;
        } else if (Res.is320x240()) {
            x_lap = 246;
        } else if (Res.isW176()) {
            x_lap = Res.ScreenW / 2 + 51 - 8;
            y_lap = Y - 1;
        }
        this.res.fontNumWhiteMid.drawString(g, lapNum + "/" + totalLap, x_lap, y_lap, 6);
        if (needDraw) {
            if (time > Design.MAX_TIME) {
                time = Design.MAX_TIME;
            }
            String timeStr = GameMain.getTimeString(time);
            if (Res.isW128() || Res.isSBmemory()) {
                this.res.fontNumWhiteMid.drawString(g, this.res.txt[118].toLowerCase(), Res.ScreenW / 2, 4, 3);
            }
            this.res.fontNumWhiteMid.drawString(g, timeStr, Res.ScreenW / 2, Y, 3);
        }
        int[] ranks = this.getLevel().getBikeRanks();
        int playerRank = this.getLevel().getPlayerBike().getRank() + 1;
        int x_rank = Res.ScreenW / 2 - 47;
        int y_rank = Y;
        if (Res.isW128() || Res.isSBmemory()) {
            y_rank = 4;
            this.res.fontNumWhiteMid.drawString(g, this.res.txt[116], (x_rank += 12) - 4, y_rank, 3);
            y_rank += this.res.fontNumWhiteMid.getFontHeight() + 4;
        } else if (Res.is352x416()) {
            x_rank = 66;
        } else if (Res.is320x240()) {
            x_rank = 74;
        } else if (Res.isW176()) {
            x_rank = Res.ScreenW / 2 - 47 + 5;
            y_rank = Y - 1;
        }
        this.res.fontNumWhiteMid.drawString(g, playerRank + "/" + ranks.length, x_rank, y_rank, 10);
        if (this.level.getPlayerBike().isDirWrong()) {
            Res.resetClip(g);
            if (this.flickTick++ % 10 > 3) {
                g.drawImage(this.res.wrongWayImg, Res.ScreenX + Res.ScreenW / 2, Res.ScreenY + 106, 17);
            }
        }
        if (this.flickTick >= 20000) {
            this.flickTick = 0;
        }
    }

    private void drawSmallMapPng(Graphics g) {
        if (this.getLevelCustom().typeOfRace == 4) {
            return;
        }
        if (this.res.smap == null) {
            return;
        }
        int offsetY = 20;
        int offsetX = 4;
        int thubmX = Res.ScreenW - offsetX - this.res.smap.getWidth();
        int thubmY = Res.ScreenH - offsetY - this.res.smap.getHeight();
        if ((Res.is320x240() || Res.is352x416() || Res.isW240()) && !Res.isSBmemory()) {
            thubmY = 42;
        }
        Res.resetClip(g);
        g.drawImage(this.res.smap, thubmX, thubmY, 20);
        Bike[] bikes = this.getLevel().getBikes();
        Res.resetClip(g);
        int scale = this.res.getScaleSmallMap();
        for (int i = 0; i < bikes.length; ++i) {
            int bikeX = thubmX + this.res.drawX2Thumb((int)bikes[i].getXf(), scale, levelMap.getBoundingBox());
            int bikeY = thubmY + this.res.drawY2Thumb((int)bikes[i].getYf(), scale, levelMap.getBoundingBox());
            if (bikes[i] == this.getLevel().getPlayerBike()) {
                ++this.playerBikeThumbTick;
                if (this.playerBikeThumbTick % 8 < 4) {
                    if (scale == 6) {
                        this.res.curcuitThumbBikesGfx.draw(g, bikeX, bikeY, 9, 0, 9, 9, 3);
                        continue;
                    }
                    g.setColor(0xFF0000);
                    g.fillRect(bikeX, bikeY, 2, 2);
                    continue;
                }
                if (scale == 6) {
                    this.res.curcuitThumbBikesGfx.draw(g, bikeX, bikeY, 0, 0, 9, 9, 3);
                    continue;
                }
                g.setColor(65280);
                g.fillRect(bikeX, bikeY, 2, 2);
                continue;
            }
            if (scale == 6) {
                this.res.curcuitThumbBikesGfx.draw(g, bikeX, bikeY, 18, 0, 9, 9, 3);
                continue;
            }
            g.setColor(255);
            g.fillRect(bikeX, bikeY, 2, 2);
        }
    }

    private void drawSmallMapLQGfx(Graphics g) {
        if (this.getLevelCustom().typeOfRace == 4) {
            return;
        }
        int offsetY = 20;
        this.res.curcuitThumbGfx.draw(g, Res.ScreenW - 8, Res.ScreenH - offsetY, 40);
        int thubmX = Res.ScreenW - this.res.curcuitThumbGfx.getWidth() - 8;
        int thubmY = Res.ScreenH - offsetY - this.res.curcuitThumbGfx.getHeight();
        Bike[] bikes = this.getLevel().getBikes();
        Res.resetClip(g);
        int scale = this.res.getScaleSmallMap();
        for (int i = 0; i < bikes.length; ++i) {
            int bikeX = thubmX + this.res.drawX2Thumb((int)bikes[i].getXf(), scale, levelMap.getBoundingBox());
            int bikeY = thubmY + this.res.drawY2Thumb((int)bikes[i].getYf(), scale, levelMap.getBoundingBox());
            if (bikes[i] == this.getLevel().getPlayerBike()) {
                ++this.playerBikeThumbTick;
                if (this.playerBikeThumbTick % 8 < 4) {
                    this.res.curcuitThumbBikesGfx.draw(g, bikeX, bikeY, 9, 0, 9, 9, 3);
                    continue;
                }
                this.res.curcuitThumbBikesGfx.draw(g, bikeX, bikeY, 0, 0, 9, 9, 3);
                continue;
            }
            this.res.curcuitThumbBikesGfx.draw(g, bikeX, bikeY, 18, 0, 9, 9, 3);
        }
    }

    private void drawLevelResult(Graphics g) {
        int h_resultBack;
        GameMain gameMain = this;
        if (gameMain.res.isSB240_29X()) {
            this.ui.getClass();
            h_resultBack = this.levelResultBoxH + 20 - 32;
        } else {
            this.ui.getClass();
            h_resultBack = this.levelResultBoxH + 20;
        }
        int wSpace = this.levelResultBoxW;
        int y_resultBack = (Res.ScreenH - h_resultBack) / 2;
        if (Res.isW128() || Res.isW176() || Res.isSB240()) {
            wSpace = Res.ScreenW - 4;
            h_resultBack = 300;
            y_resultBack = 4;
        }
        UI.drawMessageBox(g, Res.menuWhiteBar, (Res.ScreenW - wSpace) / 2, y_resultBack, wSpace, h_resultBack, 0, 0, 0);
        int drawX = Res.ScreenW / 4;
        int drawY = (Res.ScreenH - this.levelResultBoxH) / 2 + Res.ScreenH / 16;
        if (!Res.isW128()) {
            this.res.fontWhiteBig.drawString(g, this.res.txt[115], Res.ScreenW / 2, drawY, 17, true);
        }
        this.ui.getClass();
        drawY += 20;
        if (this.getLevelCustom().typeOfRace == 2) {
            if (this.isWin) {
                this.res.fontWhiteMid.drawString(g, this.res.txt[118], Res.ScreenW / 2, drawY, 17);
                this.ui.getClass();
                this.res.fontWhiteSmall.drawString(g, GameMain.getTimeString(this.level.getBikes()[0].getTotalUsedTime()), Res.ScreenW / 2, drawY += 15, 17);
                this.ui.getClass();
                drawY += 20;
                LQFont lQFont = this.res.fontWhiteMid;
                String string = this.res.txt[120];
                this.ui.getClass();
                this.ui.getClass();
                lQFont.drawString(g, string, 10, drawY, Res.ScreenW - 10 * 2, Res.ScreenH, 17);
                this.ui.getClass();
                this.res.fontWhiteSmall.drawString(g, "5", Res.ScreenW / 2, drawY += 15, 17);
            } else {
                this.drawYouFailed(g, drawY);
            }
        } else if (this.getLevelCustom().typeOfRace == 3) {
            if (this.isWin) {
                this.res.fontWhiteMid.drawString(g, this.res.txt[118], Res.ScreenW / 2, drawY, 17);
                this.ui.getClass();
                this.res.fontWhiteSmall.drawString(g, GameMain.getTimeString(this.level.getPlayerBike().getTotalUsedTime()), Res.ScreenW / 2, drawY += 15, 17);
                this.ui.getClass();
                drawY += 20;
                if (this.flickTick++ % 10 > 2) {
                    this.res.fontWhiteBig.drawString(g, this.res.txt[123], Res.ScreenW / 2, drawY, 17, true);
                }
                if (this.flickTick >= 20000) {
                    this.flickTick = 0;
                }
                this.ui.drawButtons(g, 110, -1);
            } else {
                this.drawYouFailed(g, drawY);
                this.ui.drawButtons(g, 110, -1);
            }
        } else if (this.getLevelCustom().typeOfRace == 1) {
            if (this.isWin) {
                this.res.fontWhiteMid.drawString(g, this.res.txt[118], Res.ScreenW / 2, drawY, 17);
                this.ui.getClass();
                this.res.fontWhiteSmall.drawString(g, GameMain.getTimeString(this.level.getBikes()[0].getTotalUsedTime()), Res.ScreenW / 2, drawY += 15, 17);
                this.ui.getClass();
                drawY += 20;
                LQFont lQFont = this.res.fontWhiteMid;
                String string = this.res.txt[120];
                this.ui.getClass();
                this.ui.getClass();
                lQFont.drawString(g, string, 10, drawY, Res.ScreenW - 10 * 2, Res.ScreenH, 17);
                this.ui.getClass();
                this.res.fontWhiteSmall.drawString(g, "5", Res.ScreenW / 2, drawY += 15, 17);
            } else {
                this.drawYouFailed(g, drawY);
            }
        } else if (this.getLevelCustom().typeOfRace == 4) {
            if (this.isWin) {
                if (this.isMiniGame) {
                    this.drawYouWin(g, drawY);
                } else {
                    this.res.fontWhiteMid.drawString(g, this.res.txt[118], Res.ScreenW / 2, drawY, 17);
                    this.ui.getClass();
                    this.res.fontWhiteSmall.drawString(g, GameMain.getTimeString(this.level.getBikes()[0].getTotalUsedTime()), Res.ScreenW / 2, drawY += 15, 17);
                    this.ui.getClass();
                    drawY += 20;
                    LQFont lQFont = this.res.fontWhiteMid;
                    String string = this.res.txt[120];
                    this.ui.getClass();
                    this.ui.getClass();
                    lQFont.drawString(g, string, 10, drawY, Res.ScreenW - 10 * 2, Res.ScreenH, 17);
                    this.ui.getClass();
                    this.res.fontWhiteSmall.drawString(g, "2", Res.ScreenW / 2, drawY += 15, 17);
                }
            } else {
                this.drawYouFailed(g, drawY);
            }
        } else if (this.getLevelCustom().typeOfRace == 8) {
            if (this.isWin) {
                if (this.isMiniGame) {
                    this.drawYouWin(g, drawY);
                } else {
                    LQFont lQFont = this.res.fontWhiteMid;
                    String string = this.res.txt[120];
                    this.ui.getClass();
                    this.ui.getClass();
                    lQFont.drawString(g, string, 10, drawY, Res.ScreenW - 10 * 2, Res.ScreenH, 17);
                    this.ui.getClass();
                    this.res.fontWhiteSmall.drawString(g, "" + this.earnedPoints, Res.ScreenW / 2, drawY += 15, 17);
                }
            } else {
                this.drawYouFailed(g, drawY);
            }
        } else if (this.getLevelCustom().typeOfRace == 5 || this.getLevelCustom().typeOfRace == 6 || this.getLevelCustom().typeOfRace == 7) {
            if (this.isMiniGame) {
                if (this.earnedPoints == 0) {
                    this.drawYouFailed(g, drawY);
                } else {
                    this.drawYouWin(g, drawY);
                }
            } else {
                LQFont lQFont = this.res.fontWhiteMid;
                String string = this.res.txt[120];
                this.ui.getClass();
                this.ui.getClass();
                lQFont.drawString(g, string, 10, drawY, Res.ScreenW - 10 * 2, Res.ScreenH, 17);
                this.ui.getClass();
                this.res.fontWhiteSmall.drawString(g, "" + this.earnedPoints, Res.ScreenW / 2, drawY += 15, 17);
            }
        } else if (Res.isW128() || Res.isW176()) {
            if (this.isQuickRaceMode()) {
                this.drawRaceResultRanks(g, drawX, drawY);
            } else {
                this.res.fontWhiteMid.drawString(g, this.res.txt[120], Res.ScreenW / 2, drawY, 17);
                this.ui.getClass();
                this.res.fontWhiteSmall.drawString(g, "" + this.earnedPoints, Res.ScreenW / 2, drawY += 15, 17);
                this.ui.getClass();
                this.res.fontWhiteMid.drawString(g, this.res.txt[119], Res.ScreenW / 2, drawY += 15, 17);
                this.ui.getClass();
                this.res.fontWhiteSmall.drawString(g, "" + this.res.userProfile.getBikeProper(4), Res.ScreenW / 2, drawY += 15, 17);
            }
        } else {
            int offsetY = this.drawRaceResultRanks(g, drawX, drawY);
            if (!this.isQuickRaceMode()) {
                this.res.fontWhiteMid.drawString(g, this.res.txt[120], Res.ScreenW / 2, drawY += offsetY, 17);
                this.ui.getClass();
                this.res.fontWhiteSmall.drawString(g, "" + this.earnedPoints, Res.ScreenW / 2, drawY += 15, 17);
                this.ui.getClass();
                this.res.fontWhiteMid.drawString(g, this.res.txt[119], Res.ScreenW / 2, drawY += 15, 17);
                this.ui.getClass();
                this.res.fontWhiteSmall.drawString(g, "" + this.res.userProfile.getBikeProper(4), Res.ScreenW / 2, drawY += 15, 17);
            }
        }
        if (this.getLevelCustom().typeOfRace != 3) {
            this.ui.drawButtons(g, 110, -1);
        }
    }

    private void drawYouWin(Graphics g, int drawY) {
        LQFont lQFont = this.res.fontWhiteBig;
        String string = this.res.txt[223];
        this.ui.getClass();
        this.ui.getClass();
        lQFont.drawString(g, string, 10, drawY, Res.ScreenW - 10 * 2, Res.ScreenH, 17, true);
    }

    private void drawYouFailed(Graphics g, int drawY) {
        LQFont lQFont = this.res.fontWhiteBig;
        String string = this.res.txt[124];
        this.ui.getClass();
        this.ui.getClass();
        lQFont.drawString(g, string, 10, drawY, Res.ScreenW - 10 * 2, Res.ScreenH, 17, true);
    }

    public int drawRaceResultRanks(Graphics g, int drawX, int drawY) {
        this.res.loadFontSamll();
        this.res.loadFontMid();
        int timeStrLen = this.res.fontWhiteMid.getLineWidth("00:00:00".toCharArray());
        if (!Res.isW128() && !Res.isW176()) {
            this.res.fontWhiteMid.drawString(g, this.res.txt[118], 120, drawY, 17, true);
        }
        int[] ranks = this.level.getBikeRanks();
        Bike[] bikes = this.level.getBikes();
        String posStr = "";
        String namesStr = "";
        String timesStr = "";
        for (int i = 0; i < ranks.length; ++i) {
            if (!bikes[ranks[i]].hasFinishedRace()) continue;
            posStr = posStr + "" + (i + 1) + '\n';
            if (Res.isW128()) {
                if (bikes[ranks[i]].getRiderInfo().name.length() < 12) {
                    namesStr = namesStr + bikes[ranks[i]].getRiderInfo().name + '\n';
                } else {
                    int index1 = bikes[ranks[i]].getRiderInfo().name.indexOf(" ");
                    if (index1 == -1) {
                        index1 = bikes[ranks[i]].getRiderInfo().name.length();
                    }
                    namesStr = namesStr + bikes[ranks[i]].getRiderInfo().name.substring(0, index1) + "..." + '\n';
                }
            } else {
                namesStr = namesStr + bikes[ranks[i]].getRiderInfo().name + '\n';
            }
            timesStr = timesStr + GameMain.getTimeString(bikes[ranks[i]].getTotalUsedTime()) + '\n';
        }
        int drawX1 = 32;
        int drawX2 = drawX1 + 20;
        int drawX3 = 3 * drawX;
        if (Res.isW128()) {
            drawX1 = 1;
            drawX2 = 11;
            drawX3 = 86;
            drawY = 16;
            timeStrLen = 200;
        } else if (Res.isW176()) {
            drawX1 = 8;
            drawX2 = 20;
        } else {
            this.ui.getClass();
            drawY += 15;
        }
        this.res.fontWhiteSmall.drawString(g, posStr, drawX1, drawY, Res.ScreenW, Res.ScreenH, 20);
        this.res.fontWhiteSmall.drawString(g, namesStr, drawX2, drawY, Res.ScreenW, Res.ScreenH, 20);
        this.res.fontWhiteSmall.drawString(g, timesStr, drawX3, drawY, timeStrLen, Res.ScreenH, 20);
        this.ui.getClass();
        int n = 15 * ranks.length;
        this.ui.getClass();
        return n + 15 * 2;
    }

    private void drawFullScreenEffect(Graphics g) {
        int startTime;
        int crashTick;
        if (this.level.getPlayerBike().getMode() == 4 && (crashTick = this.level.getPlayerBike().getCrashTick()) >= (startTime = 18) && this.gameState != 202) {
            Effects.FullScreenBlackOutEff.instance().begin(30 - startTime + 12);
        }
        Effects.FullScreenBlackOutEff.instance().draw(g);
    }

    public boolean isChampionshipMode() {
        return this.getLevelCustom().gameMode == 1;
    }

    public boolean isQuickRaceMode() {
        return this.getLevelCustom().gameMode == 2;
    }

    public boolean isRaceTypeNormal() {
        return this.getLevelCustom().typeOfRace == 0;
    }

    public boolean isGhost() {
        return this.getLevelCustom().typeOfRace == 3;
    }

    public boolean isCanRestart() {
        if (this.isTrainingMode()) {
            return true;
        }
        if (this.isGhost()) {
            return true;
        }
        return this.isQuickRaceMode() || this.isChampionshipMode();
    }

    public void update(int delta) {
        this.isDraw = true;
        this.updateCheating();
        if (this.msgt.isHaveMessage()) {
            if (LQKey.IsKeyPressed(512) || LQKey.IsKeyPressed(0x100000)) {
                this.msgt.nextMessage();
                Res.menuWhiteBar.initFade(800, 50, 120);
            }
            this.msgt.updata();
            if (this.gameState != 601) {
                return;
            }
        }
        if (this.gameState <= 500) {
            this.ui.update(delta);
        }
        switch (this.gameState) {
            case 101: {
                this.camera = null;
                this.camera = new Camera(this);
                this.g3d.setCamera(this.camera.getData());
                this.initDebugData();
                this.res.initLoadingRes();
                this.res.startLoadStaticRes(this);
                this.setGameState(102);
                break;
            }
            case 102: {
                if (this.res.loadingTick != 100 || !this.res.isLoadOver) break;
                this.setGameState(11);
                break;
            }
            case 103: {
                this.res.releaseLoadingRes();
                break;
            }
            case 104: {
                if (UI.SOUND_OPEN && Res.audioManager != null) {
                    Res.audioManager.StopCurrentSound();
                }
                this.res.releaseMainMenuRes();
                this.levelIndex = this.levelCustom.curcuit;
                this.res.initLoadingRes();
                Res.instance().startLoadLevel(this);
                this.setGameState(105);
                break;
            }
            case 105: {
                if (this.res.loadingTick != 100 || !this.res.isLoadOver) break;
                this.setGameState(106);
                break;
            }
            case 106: {
                this.res.releaseLoadingRes();
                this.setGameState(501);
                this.isDraw = false;
                break;
            }
            case 601: {
                if (!LQKey.IsKeyPressed(65536)) break;
                LQKey.ClearKey();
                this.setGameState(this.copy_gameState);
                boolean isSound = true;
                switch (this.copy_gameState) {
                    case 22: {
                        if (!this.ui.isStateSetting()) break;
                        isSound = false;
                        break;
                    }
                    case 401: 
                    case 402: 
                    case 403: {
                        if (this.ui.confirmBoxLastGameState != 202) break;
                        isSound = false;
                    }
                }
                if (isSound && Res.audioManager != null) {
                    Res.audioManager.Resume();
                }
                LQKey.ClearKey();
                break;
            }
            case 107: {
                if (this.isMiniGame) {
                    this.res.loadMenuNextState = 21;
                }
                this.res.initLoadingRes();
                Res.instance().startLoadMenu(this);
                if (this.isMiniGame) {
                    this.isMiniGame = false;
                    this.res.initMainMenuResForMiniGame();
                    this.setGameState(21);
                    break;
                }
                this.setGameState(108);
                break;
            }
            case 108: {
                if (this.res.loadingTick != 100 || !this.res.isLoadOver) break;
                this.setGameState(109);
                break;
            }
            case 109: {
                this.res.releaseLoadingRes();
                break;
            }
            case 501: {
                if (LQKey.IsKeyPressed(65536) && !this.camera.isOpeningShow()) {
                    this.level.pause();
                }
                this.updateLevel(delta);
                break;
            }
            case 541: {
                this.res.initLevelResultsRes();
                this.levelResultBoxW = Res.ScreenW * 5 / 6;
                if (this.levelResultBoxW < 128) {
                    this.levelResultBoxW = 128;
                }
                if (this.levelCustom.typeOfRace == 7 || this.levelCustom.typeOfRace == 8 || this.levelCustom.typeOfRace == 6 || this.levelCustom.typeOfRace == 5) {
                    this.ui.getClass();
                    this.ui.getClass();
                    this.ui.getClass();
                    this.levelResultBoxH = 20 + 15 + 15;
                } else if (this.levelCustom.typeOfRace == 4 || this.levelCustom.typeOfRace == 1 || this.levelCustom.typeOfRace == 2 || this.levelCustom.typeOfRace == 3) {
                    this.ui.getClass();
                    this.ui.getClass();
                    this.ui.getClass();
                    this.levelResultBoxH = 20 + (15 + 15) * 2;
                } else {
                    this.ui.getClass();
                    this.ui.getClass();
                    this.ui.getClass();
                    int n = 20 + 15 * 3 + 15 * this.levelCustom.opponentNum;
                    this.ui.getClass();
                    this.ui.getClass();
                    this.levelResultBoxH = n + (15 + 15) * 2;
                }
                this.levelResultBoxH += Res.ScreenH / 8;
                if (this.levelResultBoxH > Res.ScreenH) {
                    this.levelResultBoxH = Res.ScreenH;
                }
                Res.menuWhiteBar.setAlpha(127);
                if (this.getLevelCustom().typeOfRace == 7 || this.getLevelCustom().typeOfRace == 6 || this.getLevelCustom().typeOfRace == 5) {
                    if (this.earnedPoints > 0) {
                        Res.audioManager.PlaySound(Res.SND_WIN, 1);
                    } else {
                        Res.audioManager.PlaySound(Res.SND_LOSE, 1);
                    }
                } else if (this.isWin) {
                    Res.audioManager.PlaySound(Res.SND_WIN, 1);
                } else {
                    Res.audioManager.PlaySound(Res.SND_LOSE, 1);
                }
                this.setGameState(542);
                break;
            }
            case 542: {
                this.updateLevel(delta);
                if (this.getLevelCustom().typeOfRace == 3 && this.isWin) {
                    if (!LQKey.IsKeyPressed(65536)) break;
                    if (this.levelCustom.typeOfRace != 2 && this.levelCustom.typeOfRace != 3) {
                        this.level.finishRace();
                    }
                    this.setGameState(543);
                    break;
                }
                if (!LQKey.IsKeyPressed(65536) && !LQKey.IsKeyPressed(0x100000)) break;
                if (this.isChampionshipMode() && !this.isTrainingMode()) {
                    this.champFinishRaceDay();
                    this.champNextRaceDay();
                }
                if (this.levelCustom.typeOfRace != 2 && this.levelCustom.typeOfRace != 3) {
                    this.level.finishRace();
                }
                this.setGameState(543);
                break;
            }
            case 543: {
                this.res.userProfile.saveBikeProperty();
                if (this.getLevelCustom().typeOfRace == 4 || this.getLevelCustom().typeOfRace == 5 || this.getLevelCustom().typeOfRace == 6 || this.getLevelCustom().typeOfRace == 7 || this.getLevelCustom().typeOfRace == 8) {
                    if (this.res.accGameAlphaBar != null) {
                        this.res.accGameAlphaBar = null;
                    }
                    if (this.getLevelCustom().typeOfRace == 4 && this.zigzagRound < 2) {
                        ++this.zigzagRound;
                        this.level.reset((byte)1, this.getLevelIndex());
                        this.setGameState(501);
                        break;
                    }
                    if (this.isMiniGame) {
                        this.ui.setBackMiniGame();
                    }
                    this.res.releaseLevel();
                    this.res.releaseLevelResultsRes();
                    this.releaseSmallGameLevelCustom();
                    this.res.loadMenuNextState = 131;
                    this.setGameState(107);
                    break;
                }
                if (this.getLevelCustom().typeOfRace == 1 || this.getLevelCustom().typeOfRace == 2 || this.getLevelCustom().typeOfRace == 3) {
                    this.res.releaseLevel();
                    this.res.releaseLevelResultsRes();
                    this.res.loadMenuNextState = 303;
                    this.setGameState(107);
                    break;
                }
                this.res.releaseLevel();
                this.res.releaseLevelResultsRes();
                if (this.res.menuBgGfx == null) {
                    this.res.menuBgGfx = new LQGfx(Res.DIR + "menu_bg.png");
                }
                this.setGameState(301);
                break;
            }
            case 561: 
            case 562: 
            case 563: {
                this.updateSmallGame(this.gameState, delta);
            }
        }
    }

    private void updateSmallGame(int state, int delta) {
        block0 : switch (state) {
            case 561: {
                this.levelCustom = null;
                if (this.levelCustom == null) {
                    this.initLevelCustom(1, 0, this.levelIndex, Design.ChampionshipCircuitLaps[0], 6, 0);
                }
                this.initBikeCustom((byte)0, (byte)1);
                switch (this.smallGameName) {
                    case 60: {
                        this.initSmallGameLevelCustom(1, 7, 3, 1, 0, this.levelCustom.weather);
                        this.setGameState(104);
                        break block0;
                    }
                    case 61: {
                        this.initSmallGameLevelCustom(1, 8, 3, 1, 0, this.levelCustom.weather);
                        this.setGameState(104);
                        break block0;
                    }
                    case 62: {
                        this.wheelieAngle = 0.0f;
                        this.destWheelieAngle = 0.0f;
                        this.wheelieX = 0.0f;
                        this.wheelieZ = 0.0f;
                        this.initSmallGameLevelCustom(1, 6, 3, 1, 0, this.levelCustom.weather);
                        this.setGameState(104);
                        break block0;
                    }
                    case 63: {
                        this.zigzagRound = 0;
                        this.initSmallGameLevelCustom(1, 4, 16, 1, 0, this.levelCustom.weather);
                        this.setGameState(104);
                        break block0;
                    }
                    case 64: {
                        this.initSmallGameLevelCustom(1, 5, 15, 6, 0, this.levelCustom.weather);
                        this.setGameState(104);
                    }
                }
            }
        }
    }

    public void normalRaceWin() {
        this.earnedPoints = 0;
        Bike playerBike = this.getLevel().getPlayerBike();
        int playerRank = playerBike.getRank();
        int[] crashPerLap = playerBike.getCrashParLap();
        for (int i = 0; i < crashPerLap.length; ++i) {
            if (crashPerLap[i] != 0) continue;
            ++this.earnedPoints;
        }
        this.earnedPoints += playerBike.getPassNum();
        if (playerRank < 3) {
            this.earnedPoints += 3 - playerRank;
        }
        this.earnedPoints += playerBike.getRankBonus();
        this.earnedPoints += playerBike.getSpeedBonus();
        this.earnedPoints += playerBike.getDraftBonus();
        if (this.getLevelCustom().gameMode != 2) {
            this.res.userProfile.addBikePoints(this.earnedPoints);
            this.res.userProfile.add_racesFinishChampionshipMode();
        }
        this.res.userProfile.add_OverTake(playerBike.getPassNum());
        if (playerRank < 3) {
            this.isWin = true;
            this.res.userProfile.add_racesWon();
        } else {
            this.isWin = false;
        }
        if (this.getLevelCustom().opponentNum == 0 && this.getLevelCustom().lapNum == 1 && this.res.userProfile.isNewRecord(this.getLevelIndex(), this.getLevel().getPlayerBike().getTotalUsedTime())) {
            this.res.userProfile.saveGhostData(this.getLevel().getPlayerBike(), this.getLevelIndex(), this.getLevel().getPlayerBike().getTotalUsedTime());
        }
    }

    public void zigzagWin() {
        this.res.userProfile.addBikePoints(2);
        this.isWin = true;
    }

    public void zigzagFail() {
        this.isWin = false;
    }

    public void miniCircuitWin() {
        this.earnedPoints = this.level.getPlayerBike().getFinishedLaps() - 1;
        if (this.earnedPoints < 0) {
            this.earnedPoints = 0;
        }
        this.res.userProfile.addBikePoints(this.earnedPoints);
    }

    public void wheelieWin() {
        this.earnedPoints = this.level.getPlayerBike().getFinishedGround() - 4;
        if (this.earnedPoints < 0) {
            this.earnedPoints = 0;
        }
        this.res.userProfile.addBikePoints(this.earnedPoints);
    }

    public void brakeGameWin() {
        this.isWin = true;
        float stopPoint = this.level.getPlayerBike().getXf() - this.brakeBikeInitPos;
        float distant = Math.abs(stopPoint - 3120.0f);
        this.earnedPoints = 0;
        if (distant <= 100.0f) {
            this.earnedPoints = 5;
        } else if (distant <= 150.0f) {
            this.earnedPoints = 3;
        }
    }

    public void brakeGameFail() {
        this.isWin = false;
    }

    public void accelerationGameWin() {
        this.res.userProfile.addBikePoints(this.earnedPoints);
    }

    public void againstClockWin() {
        this.isWin = true;
        this.res.userProfile.addBikePoints(5);
    }

    public void againstClockFail() {
        this.isWin = false;
    }

    public void eliminationWin() {
        this.isWin = true;
        this.res.userProfile.addBikePoints(5);
    }

    public void eliminationFail() {
        this.isWin = false;
    }

    public void ghostModeWin() {
        this.isWin = true;
        this.res.userProfile.saveGhostData(this.getLevel().getPlayerBike(), this.getLevelIndex(), this.getLevel().getPlayerBike().getTotalUsedTime());
    }

    public void ghostModeFail() {
        this.isWin = false;
    }

    private void updateLevel(int delta) {
        if (!this.level.getPhyWorld().isPause()) {
            this.level.update();
        }
        this.res.groundRenderList.update();
        if (!Res.isSBmemory()) {
            this.res.treeRenderList.update();
        }
        this.effects.update(this.level);
    }

    private void updateCheating() {
        if (LQKey.IsKeyCombo(this.Cheating_AddBikePoints)) {
            this.ui.tmpBikePoints = this.res.userProfile.getBikeProper(4);
            this.res.userProfile.addBikePoints(20);
        }
        if (this.gameState == 501) {
            if (LQKey.IsKeyCombo(this.Cheating_FinishLevel)) {
                this.setGameState(541);
            }
            if (LQKey.IsKeyHold(32768) && LQKey.IsKeyPressed(32)) {
                this.camera.changeType();
            }
            if (LQKey.IsKeyHold(32768) && LQKey.IsKeyPressed(8192) && (GraphicsQuality = (byte)(GraphicsQuality + 1)) >= 3) {
                GraphicsQuality = 0;
            }
            if (LQKey.IsKeyHold(32768) && LQKey.IsKeyPressed(16384)) {
                this.level.enterReplayMode();
                this.effects.release();
            }
        }
    }

    public void champNextRaceDay() {
        this.res.userProfile.champNextRaceDay();
        this.ui.champYet();
        this.levelIndex = this.res.userProfile.getChampLevel();
    }

    public void champFinishRaceDay() {
        int[] totalRanks = this.res.userProfile.getChampTotalRanks();
        int[] ranks = this.level.getBikeRanks();
        int i = 0;
        while (i < totalRanks.length) {
            int rank = 0;
            for (int j = 0; j < ranks.length; ++j) {
                if (ranks[j] != i) continue;
                rank = j;
                break;
            }
            int points = ranks.length - rank;
            int n = i++;
            totalRanks[n] = totalRanks[n] + points;
        }
        this.res.userProfile.setChampTotalRanks(totalRanks);
    }

    public boolean isTrainingMode() {
        return this.getLevelCustom().typeOfRace == 7 || this.getLevelCustom().typeOfRace == 8 || this.getLevelCustom().typeOfRace == 5 || this.getLevelCustom().typeOfRace == 6 || this.getLevelCustom().typeOfRace == 4;
    }

    public static String getTimeString(int frameNum) {
        int time = frameNum;
        int min = time / 60;
        int sec = time - min * 60;
        String minStr = "" + min;
        if (min < 10) {
            minStr = "0" + minStr;
        }
        String secStr = "" + sec;
        if (sec < 10) {
            secStr = "0" + secStr;
        }
        return minStr + "." + secStr;
    }

    public Camera getCamera() {
        return this.camera;
    }

    private void initDebugData() {
        int MaxLineNum = 150;
        String fileName = null;
        LQAppearance app = LQFactory.LQAppearance(1, fileName, 0, 0, 0);
        this.debugPrim = LQFactory.LQPrimitive(0, app, 1350);
        this.debugPrimIndices = new int[150];
        for (int i = 0; i < 150; ++i) {
            this.debugPrimIndices[i] = this.addDebugLine(0, 0, 0, 0);
        }
    }

    private void updateDebugData() {
        Vec2D lineStart = new Vec2D();
        Vec2D lineEnd = new Vec2D();
        int objCount = this.level.getPhyWorld().debugGetStaticObjCount();
        int count = 0;
        for (int i = 0; i < objCount; ++i) {
            Vec2D tmp;
            if (!this.level.getPhyWorld().getStaticObj(i).isActivated() || (tmp = this.level.getPhyWorld().debugGetLineStart(i)) == null) continue;
            lineStart.set(tmp);
            tmp = this.level.getPhyWorld().debugGetLineEnd(i);
            lineEnd.set(tmp);
            this.updateDebugLine(this.debugPrimIndices[count], lineStart.X, lineStart.Y, lineEnd.X, lineEnd.Y);
            ++count;
        }
    }

    private void updateDebugLine(int index, int x2d_1, int y2d_1, int x2d_2, int y2d_2) {
        int z = 2;
        int lineSize = 10;
        int x3d_1 = MathFP.toInt(x2d_1);
        int y3d_1 = MathFP.toInt(y2d_1);
        int x3d_2 = MathFP.toInt(x2d_2);
        int y3d_2 = MathFP.toInt(y2d_2);
        int[] v = new int[]{x3d_1 + 10, y3d_1, -8, x3d_2, y3d_2, 2, x3d_1 - 10, y3d_1, 12, x3d_1, y3d_1, 2, x3d_2, y3d_2 - 10, 12, x3d_2, y3d_2 + 10, -8, x3d_1, y3d_1, 2, x3d_2 - 10, y3d_2 + 10, 2, x3d_2 + 10, y3d_2 - 10, 2};
        short[] vertices = new short[v.length];
        for (int i = 0; i < v.length; ++i) {
            vertices[i] = (short)v[i];
        }
        byte[] c = new byte[]{-1, 0, -1, -1};
        byte[] colors = new byte[c.length * 9];
        for (int i = 0; i < colors.length; i += c.length) {
            for (int j = 0; j < c.length; ++j) {
                colors[i + j] = c[j];
            }
        }
        this.debugPrim.fastUpdateVert(index, vertices);
        this.debugPrim.fastUpdateColors(index, colors);
    }

    private int addDebugLine(int x2d_1, int y2d_1, int x2d_2, int y2d_2) {
        int z = 100;
        int lineSize = 10;
        int x3d_1 = x2d_1;
        int y3d_1 = y2d_1;
        int x3d_2 = x2d_2;
        int y3d_2 = y2d_2;
        int[] v = new int[]{x3d_1 + 10, y3d_1, 90, x3d_2, y3d_2, 100, x3d_1 - 10, y3d_1, 110, x3d_1, y3d_1, 100, x3d_2, y3d_2 - 10, 110, x3d_2, y3d_2 + 10, 90, x3d_1, y3d_1, 100, x3d_2 - 10, y3d_2 + 10, 100, x3d_2 + 10, y3d_2 - 10, 100};
        short[] vertices = new short[v.length];
        for (int i = 0; i < v.length; ++i) {
            vertices[i] = (short)v[i];
        }
        byte[] c = new byte[]{-1, 0, -1, -1};
        byte[] colors = new byte[c.length * 9];
        for (int i = 0; i < colors.length; i += c.length) {
            for (int j = 0; j < c.length; ++j) {
                colors[i + j] = c[j];
            }
        }
        return this.debugPrim.addSubPrim(vertices, null, colors, null);
    }

    private void drawDebug(LQGraphics3D g3d) {
        if (GraphicsQuality < 2) {
            return;
        }
        g3d.render(this.debugPrim, LQFactory.LQTransform());
    }

    public void soundSwitch() {
        boolean bl = LQSound.SOUND_ON = !LQSound.SOUND_ON;
        if (LQSound.SOUND_ON && this.gameState == 202) {
            Res.audioManager.PlaySound(Res.SND_SOUND_ON, 1);
        }
    }

    public boolean isSoundEnabled() {
        return LQSound.SOUND_ON;
    }

    public void vibrationSwitch() {
        boolean bl = isVibrateEnabled = !isVibrateEnabled;
        if (isVibrateEnabled) {
            GameMain.vibrate(100);
        }
    }

    public static boolean isVibrateEnabled() {
        return isVibrateEnabled;
    }

    public static void vibrate(int time) {
        if (!UI.VIBRATION_OPEN) {
            return;
        }
        if (GameMain.isVibrateEnabled()) {
            display.vibrate(time);
        }
    }

    public static void initVibrate() {
        display = Display.getDisplay((MIDlet)MainMIDlet.getInstance());
    }

    public void suspend() {
        boolean isPause = false;
        switch (this.gameState) {
            case 501: {
                if (this.level == null || this.level.isPause()) break;
                this.level.pause();
                isPause = true;
            }
        }
        if (!isPause && this.gameState != 601 && this.gameState != 202 && this.gameState != 201 && this.gameState != 203) {
            this.copy_gameState = this.gameState;
            this.setGameState(601);
        }
    }

    public boolean isGMG() {
        return this.gameState == 22 && this.ui.isGMG();
    }

    static {
        isVibrateEnabled = true;
        GraphicsQuality = 1;
        POINT_Achievement = new int[]{100, 150, 200, 300, 400, 500, 50, 150, 250, 350, 550, 50, 100, 200, 300, 400, 500, 500};
        errMessage = null;
        errMessage2 = null;
        errMessage3 = null;
        loading = 0;
        debugTime = 0;
    }
}

