/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.lemonquest.lq3d.LQFactory;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.lq3d.LQVector;
import com.lemonquest.lq3d.renderlist.LQMeshBuffer;
import com.lemonquest.lq3d.renderlist.LQRenderNode;
import com.lemonquest.math.LQMath;
import com.lemonquest.math.MathFP;
import com.lemonquest.math.Vec2D;
import com.lemonquest.util.LQConsole;
import game.Design;
import game.GameMain;
import game.Res;
import java.io.DataInputStream;
import java.io.IOException;

public class LevelMap {
    public static final byte RoadType_Road = 0;
    public static final byte RoadType_Sand = 1;
    public static final byte GroundDir_Left = 0;
    public static final byte GroundDir_Right = 1;
    public static final byte GroundDir_Up = 2;
    public static final byte GroundDir_Down = 3;
    public static final int GroundSize = 320;
    public static final int HalfGroundSize = 160;
    private Ground[] grounds;
    private LQMeshBuffer[] groundMeshes;
    private CollideShape[][] groundCollideShapes;
    private LQRenderNode[] groundRenderNodes;
    private Tree[][] trees;
    private LQMeshBuffer[] treeMeshes;
    private CollideShape[][] treeCollideShapes;
    private LQRenderNode[] treeRenderNodes;
    private CollideShape[][] freeCollideShapes;
    private short[][] startPoints;
    private int finishLineGroundID;
    private short[] boundingBox;

    public LevelMap(int levelIndex) {
        GameMain.setLoading(1001);
        CollideShape[][] allShape = null;
        DataInputStream allCollideFile = new DataInputStream(this.getClass().getResourceAsStream(Res.DIR_3D + "all.collide"));
        GameMain.setLoading(1002);
        try {
            int meshFileNum = allCollideFile.readShort();
            allShape = new CollideShape[meshFileNum][];
            for (int i = 0; i < meshFileNum; ++i) {
                int shapeNum = allCollideFile.readByte();
                allShape[i] = new CollideShape[shapeNum];
                for (int shapeIndex = 0; shapeIndex < shapeNum; ++shapeIndex) {
                    allShape[i][shapeIndex] = this.readShape(allCollideFile);
                }
            }
            GameMain.setLoading(1003);
            allCollideFile.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        GameMain.setLoading(1004);
        int groundGroup = Design.getGroundGroup(levelIndex);
        String mapFilePath = Res.DIR_3D + "level_" + levelIndex + ".46";
        GameMain.setLoading(1005);
        if (Design.hasCityCircuits && groundGroup == 1) {
            mapFilePath = Res.DIR_3D + "level_" + levelIndex + "_city.46";
        }
        DataInputStream mapFile = new DataInputStream(this.getClass().getResourceAsStream(mapFilePath));
        GameMain.setLoading(1006);
        try {
            int i;
            this.boundingBox = new short[4];
            for (int i2 = 0; i2 < this.boundingBox.length; ++i2) {
                this.boundingBox[i2] = mapFile.readShort();
            }
            GameMain.setLoading(1007);
            int groundMeshNum = mapFile.readShort();
            this.groundMeshes = new LQMeshBuffer[groundMeshNum];
            this.groundCollideShapes = new CollideShape[groundMeshNum][];
            GameMain.setLoading(1008);
            for (int i3 = 0; i3 < groundMeshNum; ++i3) {
                short fileID = mapFile.readShort();
                short id = mapFile.readShort();
                LQTransform rotationMatrix = LQFactory.LQTransform();
                float[] matrix = new float[16];
                rotationMatrix.get(matrix);
                for (int matrix_row = 0; matrix_row < 3; ++matrix_row) {
                    for (int matrix_col = 0; matrix_col < 3; ++matrix_col) {
                        float tmp;
                        matrix[matrix_col * 4 + matrix_row] = tmp = mapFile.readFloat();
                    }
                }
                rotationMatrix.set(matrix);
                String typeStr = "" + fileID;
                if (fileID < 10) {
                    typeStr = "0" + typeStr;
                }
                GameMain.setLoading(1009);
                String meshFilePath = "";
                meshFilePath = Res.DIR_3D + "ground" + groundGroup + "/ground_" + typeStr + ".lq3d";
                DataInputStream meshFile = new DataInputStream(this.getClass().getResourceAsStream(meshFilePath));
                this.groundMeshes[id] = new LQMeshBuffer(meshFile, rotationMatrix);
                meshFile.close();
                int shapeNum = allShape[fileID].length;
                this.groundCollideShapes[i3] = new CollideShape[shapeNum];
                for (int shapeIndex = 0; shapeIndex < shapeNum; ++shapeIndex) {
                    this.groundCollideShapes[i3][shapeIndex] = new CollideShape(allShape[fileID][shapeIndex], rotationMatrix);
                }
            }
            GameMain.setLoading(1010);
            int groundNum = mapFile.readShort();
            byte groundAppID = mapFile.readByte();
            this.groundRenderNodes = new LQRenderNode[groundNum];
            this.grounds = new Ground[groundNum];
            for (i = 0; i < groundNum; ++i) {
                this.grounds[i] = new Ground();
                this.grounds[i].meshID = mapFile.readShort();
                this.grounds[i].x = mapFile.readShort();
                this.grounds[i].y = mapFile.readShort();
                this.grounds[i].z = mapFile.readShort();
                this.grounds[i].drivingPointFP.X = MathFP.toFP(mapFile.readShort());
                this.grounds[i].drivingPointFP.Y = MathFP.toFP(mapFile.readShort());
                LQMeshBuffer buf = this.groundMeshes[this.grounds[i].meshID];
                this.groundRenderNodes[i] = new LQRenderNode(buf, groundAppID);
            }
            if (levelIndex != 16) {
                for (i = 0; i < groundNum; ++i) {
                    int prevID = i - 1;
                    if (prevID < 0) {
                        prevID = groundNum - 1;
                    }
                    this.grounds[i].drivingDir.set(this.grounds[i].drivingPointFP.X, this.grounds[i].drivingPointFP.Y);
                    this.grounds[i].drivingDir.sub(this.grounds[prevID].drivingPointFP);
                    this.grounds[i].drivingDir.normalize();
                }
            }
            int treeMeshNum = mapFile.readShort();
            this.treeMeshes = new LQMeshBuffer[treeMeshNum];
            GameMain.setLoading(1011);
            for (int i4 = 0; i4 < treeMeshNum; ++i4) {
                short strLen = mapFile.readShort();
                byte[] strData = new byte[strLen];
                mapFile.read(strData);
                short fileID = mapFile.readShort();
                short id = mapFile.readShort();
                LQTransform rotationMatrix = LQFactory.LQTransform();
                float[] matrix = new float[16];
                rotationMatrix.get(matrix);
                for (int matrix_row = 0; matrix_row < 3; ++matrix_row) {
                    for (int matrix_col = 0; matrix_col < 3; ++matrix_col) {
                        float tmp;
                        matrix[matrix_col * 4 + matrix_row] = tmp = mapFile.readFloat();
                    }
                }
                rotationMatrix.set(matrix);
                String typeStr = "" + fileID;
                if (fileID < 10) {
                    typeStr = "0" + typeStr;
                }
                String meshFilePath = new String(strData);
                DataInputStream meshFile = null;
                meshFilePath = Res.DIR_3D + meshFilePath + "_" + typeStr + ".lq3d";
                LQConsole.println("file >> " + meshFilePath);
                meshFile = new DataInputStream(this.getClass().getResourceAsStream(meshFilePath));
                this.treeMeshes[id] = new LQMeshBuffer(meshFile, rotationMatrix);
                if (Res.isSBmemory()) {
                    this.treeMeshes[id] = null;
                }
                meshFile.close();
            }
            if (Res.isSBmemory()) {
                this.treeMeshes = null;
            }
            GameMain.setLoading(1012);
            int treeGroupNum = mapFile.readShort();
            short treeNum = mapFile.readShort();
            this.trees = new Tree[treeGroupNum][];
            this.treeRenderNodes = new LQRenderNode[treeNum];
            int renderNodeCount = 0;
            for (int groupIndex = 0; groupIndex < treeGroupNum; ++groupIndex) {
                int count = mapFile.readShort();
                this.trees[groupIndex] = new Tree[count];
                for (int i5 = 0; i5 < count; ++i5) {
                    this.trees[groupIndex][i5] = new Tree();
                    this.trees[groupIndex][i5].meshID = mapFile.readShort();
                    byte appID = mapFile.readByte();
                    this.trees[groupIndex][i5].x = mapFile.readShort();
                    this.trees[groupIndex][i5].y = mapFile.readShort();
                    this.trees[groupIndex][i5].z = mapFile.readShort();
                    if (!Res.isSBmemory()) {
                        LQMeshBuffer buf = this.treeMeshes[this.trees[groupIndex][i5].meshID];
                        this.treeRenderNodes[renderNodeCount] = new LQRenderNode(buf, appID);
                        this.trees[groupIndex][i5].renderNode = this.treeRenderNodes[renderNodeCount];
                    }
                    ++renderNodeCount;
                }
            }
            GameMain.setLoading(1013);
            this.startPoints = new short[mapFile.readShort()][];
            for (int i6 = 0; i6 < this.startPoints.length; ++i6) {
                this.startPoints[i6] = new short[4];
                this.startPoints[i6][0] = mapFile.readShort();
                this.startPoints[i6][1] = mapFile.readShort();
                this.startPoints[i6][2] = mapFile.readByte();
                this.startPoints[i6][3] = mapFile.readByte();
            }
            this.finishLineGroundID = mapFile.readShort();
            GameMain.setLoading(1014);
            mapFile.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        GameMain.setLoading(1015);
    }

    private void readCollide(String levelName) {
        DataInputStream collideFile = new DataInputStream(this.getClass().getResourceAsStream(Res.DIR_3D + "all.collide"));
        try {
            int groundMeshNum = collideFile.readShort();
            this.groundCollideShapes = new CollideShape[groundMeshNum][];
            for (int meshIndex = 0; meshIndex < groundMeshNum; ++meshIndex) {
                int shapeNum = collideFile.readByte();
                this.groundCollideShapes[meshIndex] = new CollideShape[shapeNum];
                for (int shapeIndex = 0; shapeIndex < shapeNum; ++shapeIndex) {
                    this.groundCollideShapes[meshIndex][shapeIndex] = this.readShape(collideFile);
                }
            }
            collideFile.close();
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CollideShape readShape(DataInputStream dis) {
        CollideShape newShape = new CollideShape();
        try {
            newShape.shapeType = dis.readByte();
            newShape.roadType = dis.readByte();
            if (newShape.shapeType == 0) {
                int pointDataLen = dis.readShort();
                newShape.pointsFP = new int[pointDataLen];
                for (int i = 0; i < pointDataLen; ++i) {
                    int tmp = LQMath.round(dis.readFloat());
                    int snapDis = 20;
                    if (Math.abs(Math.abs(tmp) - 160) <= 20) {
                        tmp = tmp < 0 ? -160 : 160;
                    }
                    newShape.pointsFP[i] = MathFP.toFP(tmp);
                }
                return newShape;
            }
            if (newShape.shapeType != 1) return newShape;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return newShape;
    }

    private void calcLineNormal(CollideShape shape, Vec2D c) {
        Vec2D startPoint = new Vec2D(shape.pointsFP[0], shape.pointsFP[1]);
        Vec2D line = new Vec2D(shape.pointsFP[2], shape.pointsFP[3]);
        line.sub(startPoint);
        Vec2D center = new Vec2D(c);
        center.sub(startPoint);
        int leftRight = line.crossProduct(center);
        if (leftRight > 0) {
            int i = 0;
            for (int j = shape.pointsFP.length - 2; i < j; i += 2, j -= 2) {
                int tmp_x = shape.pointsFP[i];
                int tmp_y = shape.pointsFP[i + 1];
                shape.pointsFP[i] = shape.pointsFP[j];
                shape.pointsFP[i + 1] = shape.pointsFP[j + 1];
                shape.pointsFP[j] = tmp_x;
                shape.pointsFP[j + 1] = tmp_y;
            }
        } else if (leftRight < 0) {
            boolean a = false;
        } else {
            LQConsole.println("error: collision line cross (0,0)!!");
        }
    }

    public Ground[] getGrounds() {
        return this.grounds;
    }

    public LQRenderNode[] getGroundRenderNodes() {
        return this.groundRenderNodes;
    }

    public Tree[][] getTrees() {
        return this.trees;
    }

    public LQRenderNode[] getTreeRenderNodes() {
        return this.treeRenderNodes;
    }

    public CollideShape[] getGroundCollision(int meshID) {
        return this.groundCollideShapes[meshID];
    }

    public CollideShape[] getTreeCollision(int meshID) {
        if (this.treeCollideShapes == null) {
            return null;
        }
        return this.treeCollideShapes[meshID];
    }

    public CollideShape[] getFreeCollision(int groundID) {
        if (this.freeCollideShapes == null) {
            return null;
        }
        return this.freeCollideShapes[groundID];
    }

    public short[] getStartPoint(int posIndex) {
        return this.startPoints[posIndex];
    }

    public int getFinishLineGroundID() {
        return this.finishLineGroundID;
    }

    public int getNextGroundID(int groundID) {
        int nextID = groundID + 1;
        if (nextID >= this.grounds.length) {
            nextID -= this.grounds.length;
        }
        return nextID;
    }

    public byte getGroundDir(int groundID_from, int groundID_to) {
        if (this.grounds[groundID_to].x - this.grounds[groundID_from].x > 318) {
            return 1;
        }
        if (this.grounds[groundID_to].x - this.grounds[groundID_from].x < -318) {
            return 0;
        }
        if (this.grounds[groundID_to].y - this.grounds[groundID_from].y > 318) {
            return 2;
        }
        if (this.grounds[groundID_to].y - this.grounds[groundID_from].y < -318) {
            return 3;
        }
        return 1;
    }

    public short[] getBoundingBox() {
        return this.boundingBox;
    }

    public static class CollideShape {
        public static final byte ShapeLine = 0;
        public static final byte ShapeCircle = 1;
        public short meshID;
        public byte shapeType;
        public byte roadType = 0;
        public int[] pointsFP;

        public CollideShape() {
        }

        public CollideShape(CollideShape copy, LQTransform rotationMatrix) {
            this.meshID = copy.meshID;
            this.shapeType = copy.shapeType;
            this.roadType = copy.roadType;
            this.pointsFP = new int[copy.pointsFP.length];
            if (rotationMatrix == null) {
                System.arraycopy(copy.pointsFP, 0, this.pointsFP, 0, this.pointsFP.length);
            } else {
                for (int i = 0; i < this.pointsFP.length / 2; ++i) {
                    LQVector point = new LQVector();
                    point.setX(copy.pointsFP[i * 2]);
                    point.setY(copy.pointsFP[i * 2 + 1]);
                    point.mul(rotationMatrix);
                    this.pointsFP[i * 2 + 0] = LQMath.round(point.getX());
                    this.pointsFP[i * 2 + 1] = LQMath.round(point.getY());
                }
            }
        }
    }

    public static class Ground {
        public short meshID;
        public short x;
        public short y;
        public short z;
        public Vec2D drivingPointFP = new Vec2D();
        public Vec2D drivingDir = new Vec2D();
    }

    public static class Tree {
        public short meshID;
        public LQRenderNode renderNode;
        public short x;
        public short y;
        public short z;
    }
}

