/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.lemonquest.text.LQFont;
import com.lemonquest.util.LQGfx;
import game.FontRollProperty;
import game.Res;
import game.UI;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class MessageTeam {
    private Res res = Res.instance();
    LQFont font = null;
    private int MAX_msg = 10;
    private int heartbeat = 0;
    public Message[] msg = new Message[this.MAX_msg];

    public MessageTeam() {
        for (int i = 0; i < this.msg.length; ++i) {
            this.msg[i] = new Message();
        }
    }

    public void addNewMessage(LQFont font1, String str1, boolean isHot) {
        this.addNewMessage(font1, str1, isHot, 40, null);
    }

    public void addNewMessage(LQFont font1, String str1, boolean isHot, Image img1) {
        this.addNewMessage(font1, str1, isHot, 40, img1);
    }

    public void addNewMessage(LQFont font1, String str1, boolean isHot, int lifeTime) {
        this.addNewMessage(font1, str1, isHot, lifeTime, null);
    }

    public void addNewMessage(LQFont font1, String str1, boolean isHot, int lifeTime, Image img1) {
        if (Res.menuWhiteBar == null) {
            Res.menuWhiteBar = new LQGfx(Res.DIR + "menuSelectBar.png");
        }
        Res.menuWhiteBar.setAlpha(160);
        this.font = font1;
        if (this.font == null) {
            this.res.loadFontSamll();
            this.font = this.res.fontWhiteSmall;
        }
        if (isHot) {
            for (int i = this.msg.length - 1; i >= 0; --i) {
                this.msg[i] = null;
                if (i == 0) {
                    this.msg[i] = new Message();
                    this.msg[i].newMessage(str1, lifeTime, img1);
                    break;
                }
                this.msg[i] = this.msg[i - 1];
            }
        } else {
            for (int i = 0; i < this.msg.length; ++i) {
                if (this.msg[i].state != 1) continue;
                this.msg[i].newMessage(str1, lifeTime, img1);
                return;
            }
        }
    }

    public boolean isHaveMessage() {
        return this.msg[0].state != 1;
    }

    public int get_lifeTime() {
        return this.msg[0].get_lifeTime();
    }

    public void updata() {
        switch (this.msg[0].state) {
            case 2: {
                if (!this.msg[0].updata_life()) break;
                this.nextMessage();
            }
        }
    }

    public void draw(Graphics g) {
        ++this.heartbeat;
        if (this.heartbeat > 99999) {
            this.heartbeat = 0;
        }
        switch (this.msg[0].state) {
            case 1: {
                break;
            }
            case 0: {
                this.msg[0].init();
                break;
            }
            case 2: {
                this.msg[0].draw(g);
            }
        }
    }

    public void nextMessage() {
        for (int i = 0; i < this.msg.length; ++i) {
            this.msg[i] = null;
            if (i == this.msg.length - 1) {
                this.msg[i] = new Message();
                break;
            }
            this.msg[i] = this.msg[i + 1];
        }
        if (!this.isHaveMessage()) {
            this.font = null;
        }
    }

    class Message {
        Image img = null;
        String txt = null;
        private int state = 1;
        private static final int STATE_WAIT = 0;
        private static final int STATE_NULL = 1;
        private static final int STATE_HOT = 2;
        private static final int STATE_FLY_IN = 3;
        private static final int STATE_FLY_OUT = 4;
        private int lifeTime = 0;
        int w = 210;
        int h = 240;
        int x = (240 - this.w) / 2;
        int y = 52;
        private FontRollProperty roll_message = null;

        public void newMessage(String str, int lifeTime1, Image img1) {
            this.img = null;
            this.img = img1;
            this.txt = str;
            this.state = 0;
            this.lifeTime = lifeTime1;
            if (Res.isW128()) {
                this.y = 8;
            }
        }

        public void init() {
            this.state = 2;
        }

        public void set_y(int y1) {
            this.y = y1;
            if (Res.isW128()) {
                this.y = 8;
            }
        }

        public void draw(Graphics g) {
            short[][] data = MessageTeam.this.font.getLineData(this.txt, this.w);
            int h_box = (data.length + 1) * (MessageTeam.this.font.getFontHeight() + MessageTeam.this.font.getLineSpacing()) + 24;
            if (Res.isW128()) {
                h_box = 316;
            }
            MessageTeam.this.res;
            UI.drawMessageBox(g, Res.menuWhiteBar, this.x - 8, this.y - 8, this.w + 16, h_box, 0, 0, 0);
            if (this.img != null) {
                g.drawImage(this.img, this.x + this.y, this.y + 8, 40);
            }
            if (Res.isW128()) {
                if (this.roll_message == null) {
                    this.roll_message = new FontRollProperty();
                    this.roll_message.set(-160);
                }
                this.roll_message.roll();
                ((MessageTeam)MessageTeam.this).res.fontWhiteSmall.setArea(true, 0, 8, 600, 144);
                ((MessageTeam)MessageTeam.this).res.fontWhiteSmall.drawString(g, this.txt, 10, 8 + this.roll_message.get_y(), 220, 200, 3);
                ((MessageTeam)MessageTeam.this).res.fontWhiteSmall.setArea(false, 0, 0, 0, 0);
            } else {
                int x_message = 18;
                if (Res.is320x240() || Res.is352x416()) {
                    x_message = 66;
                } else if (Res.isW176()) {
                    x_message = 12;
                }
                MessageTeam.this.font.drawString(g, this.txt, x_message, this.y, this.w, this.h, 20);
            }
            int y_anyKey = this.y + data.length * (MessageTeam.this.font.getFontHeight() + MessageTeam.this.font.getLineSpacing()) + 8;
            if (Res.isW128()) {
                y_anyKey = 304 - MessageTeam.this.font.getFontHeight();
            }
            if (MessageTeam.this.heartbeat % 8 < 4) {
                MessageTeam.this.font.drawString(g, ((MessageTeam)MessageTeam.this).res.txt[1], 120, y_anyKey, 17);
            }
        }

        public boolean updata_life() {
            return this.lifeTime > 0 && --this.lifeTime <= 0;
        }

        public int get_lifeTime() {
            return this.lifeTime;
        }
    }
}

