/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;

public class LevelManager {
    public static short[] availableSetLevelQty;
    public static String[] availableSetName;
    public static int currentSet;
    public static String[] levelNames;
    public static short[] setCurrentLevel;
    public static short[] setLevelQty;
    public static long[] setLevelTime;
    public static String[] setName;
    public static final String[] standartLevelNames;

    static {
        standartLevelNames = new String[]{"The beggining!", "Some mirrors", "Dark forest", "Voodoo people", "Forest maze", "Green Square", "The ruins", "Rock to power", "Mirror puzzle", "Alarm system", "Ammunition", "Our office", "The Iceland", "Bomb trap", "Dragon&Dracula", "Icy lawn", "Ice alley", "Snowflake", "The Space Base", "Rocks&Rockets", "Laser field", "Long way", "Think twice", "Almost win", "Saving Eny!"};
    }

    public static void delete(String name) {
        int num = 0;
        int i = 0;
        while (i < setName.length) {
            if (setName[i].equals(name)) {
                num = i;
                break;
            }
            ++i;
        }
        if (num == 0) {
            return;
        }
        try {
            RecordStore.deleteRecordStore((String)name);
        }
        catch (RecordStoreException ex) {
            // empty catch block
        }
        if (currentSet == num) {
            LevelManager.setCurrent("Standart");
        } else if (currentSet > num) {
            --currentSet;
        }
        int qty = setName.length - 1;
        String[] tName = new String[qty];
        short[] tCurrentLevel = new short[qty];
        short[] tLevelQty = new short[qty];
        i = 0;
        while (i < qty) {
            int t = i;
            if (i >= num) {
                ++t;
            }
            tName[i] = setName[t];
            tCurrentLevel[i] = setCurrentLevel[t];
            tLevelQty[i] = setLevelQty[t];
            ++i;
        }
        setName = tName;
        setCurrentLevel = tCurrentLevel;
        setLevelQty = tLevelQty;
        String[] menu = new String[setName.length + 2];
        System.arraycopy(setName, 0, menu, 1, setName.length);
        menu[0] = Game.ChooseLevelSetText[0];
        menu[menu.length - 1] = Game.QUIT;
        Game.ChooseLevelSetText = menu;
        LevelManager.save();
    }

    public static void download(String name) {
        int ID = 0;
        Game.GameState = 16;
        Game.Draw();
        HttpConnection hc = null;
        DataInputStream dis = null;
        InputStream is = null;
        int num = -1;
        int i = 0;
        while (i < availableSetName.length) {
            if (availableSetName[i].equals(name)) {
                num = i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < setName.length) {
            if (setName[i].equals(name)) {
                num = -1;
                break;
            }
            ++i;
        }
        if (num == -1) {
            return;
        }
        String urlstring = Game.Robo2Http + "/levels/" + availableSetName[num];
        RecordStore myStore = null;
        try {
            int l;
            myStore = RecordStore.openRecordStore((String)availableSetName[num], (boolean)true);
            hc = (HttpConnection)Connector.open((String)urlstring);
            if (hc == null || hc.getResponseCode() != 200 || (is = hc.openInputStream()) == null) {
                Game.GameState = 17;
                Game.Redraw = true;
                return;
            }
            dis = new DataInputStream(is);
            int levelQty = availableSetLevelQty[num];
            byte[] b = null;
            i = 0;
            while (i < levelQty) {
                int l2;
                short length = dis.readShort();
                b = new byte[length];
                int loaded = l2 = dis.read(b);
                int leftToLoad = length - l2;
                while (leftToLoad > 0) {
                    byte[] t = new byte[leftToLoad];
                    l2 = dis.read(t);
                    leftToLoad -= l2;
                    System.arraycopy(t, 0, b, loaded, l2);
                    loaded += l2;
                }
                ID = myStore.addRecord(b, 0, (int)length);
                ++i;
            }
            byte[] tempLevelTime = new byte[levelQty << 3];
            ID = myStore.addRecord(tempLevelTime, 0, tempLevelTime.length);
            short length = dis.readShort();
            b = new byte[length];
            int loaded = l = dis.read(b);
            int leftToLoad = length - l;
            while (leftToLoad > 0) {
                byte[] t = new byte[leftToLoad];
                l = dis.read(t);
                leftToLoad -= l;
                System.arraycopy(t, 0, b, loaded, l);
                loaded += l;
            }
            ID = myStore.addRecord(b, 0, (int)length);
            myStore.closeRecordStore();
        }
        catch (RecordStoreFullException ex) {
            try {
                RecordStore.deleteRecordStore((String)availableSetName[num]);
            }
            catch (RecordStoreException ex1) {
                // empty catch block
            }
            Game.GameState = 18;
            Game.Redraw = true;
            return;
        }
        catch (Exception ex) {
            Game.GameState = 17;
            Game.Redraw = true;
            return;
        }
        int qty = setName.length;
        String[] tName = new String[qty + 1];
        short[] tCurrentLevel = new short[qty + 1];
        short[] tLevelQty = new short[qty + 1];
        System.arraycopy(setName, 0, tName, 0, qty);
        System.arraycopy(setCurrentLevel, 0, tCurrentLevel, 0, qty);
        System.arraycopy(setLevelQty, 0, tLevelQty, 0, qty);
        tName[qty] = name;
        tCurrentLevel[qty] = 0;
        tLevelQty[qty] = availableSetLevelQty[num];
        setName = tName;
        setCurrentLevel = tCurrentLevel;
        setLevelQty = tLevelQty;
        String[] menu = new String[setName.length + 2];
        System.arraycopy(setName, 0, menu, 1, setName.length);
        menu[0] = Game.ChooseLevelSetText[0];
        menu[menu.length - 1] = Game.QUIT;
        Game.ChooseLevelSetText = menu;
        LevelManager.save();
        Game.GameState = 14;
    }

    public static InputStream getLevel(int num) {
        if (num > setCurrentLevel[currentSet]) {
            LevelManager.setCurrentLevel[LevelManager.currentSet] = (short)num;
        }
        if (currentSet == 0) {
            return Game.pGame.getClass().getResourceAsStream("/data/" + num);
        }
        try {
            byte[] data = RecordStore.openRecordStore((String)setName[currentSet], (boolean)true).getRecord(num + 1);
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            return bais;
        }
        catch (RecordStoreException ex) {
            return null;
        }
    }

    public static void getLevelSets() {
        if (availableSetName != null) {
            return;
        }
        Game.GameState = 16;
        Game.Draw();
        HttpConnection hc = null;
        DataInputStream dis = null;
        InputStream is = null;
        String urlstring = Game.Robo2Http + "/levels/desc";
        try {
            hc = (HttpConnection)Connector.open((String)urlstring);
            if (hc == null || hc.getResponseCode() != 200 || (is = hc.openInputStream()) == null) {
                Game.GameState = 17;
                Game.Redraw = true;
                return;
            }
            dis = new DataInputStream(is);
            int qty = dis.readShort();
            availableSetName = new String[qty];
            availableSetLevelQty = new short[qty];
            Game.DownloadLevelSetText = new String[qty + 1];
            Game.DownloadLevelSetText[qty] = Game.QUIT;
            int i = 0;
            while (i < qty) {
                Game.DownloadLevelSetText[i] = LevelManager.availableSetName[i] = dis.readUTF();
                LevelManager.availableSetLevelQty[i] = dis.readShort();
                ++i;
            }
            if (hc != null) {
                hc.close();
            }
            if (dis != null) {
                dis.close();
            }
        }
        catch (Exception ex) {
            Game.GameState = 17;
            Game.Redraw = true;
            return;
        }
        Game.GameState = 14;
    }

    public static void init() {
        try {
            RecordStore myStore = RecordStore.openRecordStore((String)"levelset", (boolean)true);
            if (myStore.getNumRecords() != 0) {
                byte[] data = myStore.getRecord(1);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(bais);
                int qty = dis.readShort();
                currentSet = dis.readShort();
                setName = new String[qty];
                setCurrentLevel = new short[qty];
                setLevelQty = new short[qty];
                int i = 0;
                while (i < qty) {
                    LevelManager.setName[i] = dis.readUTF();
                    LevelManager.setCurrentLevel[i] = dis.readShort();
                    LevelManager.setLevelQty[i] = dis.readShort();
                    ++i;
                }
                dis.close();
            } else {
                setName = new String[1];
                setCurrentLevel = new short[1];
                setLevelQty = new short[1];
                LevelManager.setName[0] = "Standart";
                LevelManager.setCurrentLevel[0] = 0;
                LevelManager.setLevelQty[0] = 25;
                currentSet = 0;
                RecordStore store = RecordStore.openRecordStore((String)"Standart", (boolean)true);
                byte[] data = new byte[setLevelQty[0] << 3];
                store.addRecord(data, 0, data.length);
                store.closeRecordStore();
            }
            myStore.closeRecordStore();
        }
        catch (Exception rse) {
            // empty catch block
        }
        String[] menu = new String[setName.length + 2];
        System.arraycopy(setName, 0, menu, 1, setName.length);
        menu[0] = Game.ChooseLevelSetText[0];
        menu[menu.length - 1] = Game.QUIT;
        Game.ChooseLevelSetText = menu;
        LevelManager.setCurrent(setName[currentSet]);
    }

    public static String levelString(int i) {
        StringBuffer s = new StringBuffer();
        s.append(Integer.toString(i + 1));
        s.append(" - ");
        s.append(levelNames[i]);
        s.append(" ");
        if (setLevelTime[i] == 0L) {
            s.append("???");
        } else {
            int LevelMin = (int)(setLevelTime[i] / 60000L);
            int LevelSec = (int)(setLevelTime[i] % 60000L / 1000L);
            if (LevelMin < 10) {
                s.append('0');
            }
            s.append(Integer.toString(LevelMin));
            s.append(':');
            if (LevelSec < 10) {
                s.append('0');
            }
            s.append(Integer.toString(LevelSec));
        }
        return s.toString();
    }

    public static void save() {
        try {
            RecordStore myStore = RecordStore.openRecordStore((String)"levelset", (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream das = new DataOutputStream(baos);
            das.writeShort(setName.length);
            das.writeShort(currentSet);
            int i = 0;
            while (i < setName.length) {
                das.writeUTF(setName[i]);
                das.writeShort(setCurrentLevel[i]);
                das.writeShort(setLevelQty[i]);
                ++i;
            }
            byte[] data = baos.toByteArray();
            das.close();
            if (myStore.getNumRecords() == 0) {
                myStore.addRecord(data, 0, data.length);
            } else {
                myStore.setRecord(1, data, 0, data.length);
            }
            myStore.closeRecordStore();
        }
        catch (Exception rse) {
        }
    }

    public static void saveBestTime() {
        int qty = setLevelQty[currentSet];
        DataOutputStream dos = null;
        ByteArrayOutputStream baos = null;
        int recordNum = qty + 1;
        if (currentSet == 0) {
            recordNum = 1;
        }
        try {
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            int i = 0;
            while (i < qty) {
                dos.writeLong(setLevelTime[i]);
                ++i;
            }
            RecordStore.openRecordStore((String)setName[currentSet], (boolean)true).setRecord(recordNum, baos.toByteArray(), 0, qty << 3);
        }
        catch (Exception ex) {
        }
    }

    public static boolean setBestTime(long newTime, int num) {
        if (newTime >= setLevelTime[num] && setLevelTime[num] != 0L) {
            return false;
        }
        LevelManager.setLevelTime[num] = newTime;
        Game.ChooseLevelText[num] = LevelManager.levelString(num);
        return true;
    }

    public static void setCurrent(String name) {
        int len;
        byte[] data;
        int num = -1;
        int i = 0;
        while (i < setName.length) {
            if (setName[i].equals(name)) {
                num = i;
                break;
            }
            ++i;
        }
        if (num == -1) {
            return;
        }
        if (setLevelTime != null) {
            LevelManager.saveBestTime();
        }
        currentSet = num;
        short qty = setLevelQty[currentSet];
        setLevelTime = new long[qty];
        DataInputStream dis = null;
        ByteArrayInputStream bais = null;
        int recordNum = qty + 1;
        if (currentSet == 0) {
            recordNum = 1;
        }
        try {
            data = RecordStore.openRecordStore((String)setName[currentSet], (boolean)true).getRecord(recordNum);
            bais = new ByteArrayInputStream(data);
            dis = new DataInputStream(bais);
            i = 0;
            while (i < qty) {
                LevelManager.setLevelTime[i] = dis.readLong();
                ++i;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (currentSet == 0) {
            levelNames = standartLevelNames;
        } else {
            try {
                data = RecordStore.openRecordStore((String)setName[currentSet], (boolean)true).getRecord(recordNum + 1);
                bais = new ByteArrayInputStream(data);
                dis = new DataInputStream(bais);
                levelNames = new String[qty];
                i = 0;
                while (i < qty) {
                    LevelManager.levelNames[i] = dis.readUTF();
                    ++i;
                }
            }
            catch (Exception ex) {
            }
        }
        String[] temp = new String[qty];
        i = len = 0;
        while (i < qty) {
            temp[i] = LevelManager.levelString(i);
            ++i;
        }
        Game.ChooseLevelText = temp;
    }
}

