/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import java.util.Date;
import javax.microedition.rms.RecordStore;
import util.DataConverter;

public class GameInfo {
    public static final String SAVESTORE = "SaveGame";
    boolean myNoDataSaved;
    private String userName;
    private String myDate;
    private String location;
    private String scoreName;
    private int myLevel;
    private int driverNumber;
    private int jeepNumber;
    private int engineUp;
    private int seatUp;
    private int bodyUp;
    private int ticks;
    private int money;
    private int numberOfRecords;
    private int jeepHealth;
    private int gas;
    private int driverHealth;
    private int levelScore;
    private int[] numberOfScoresRecord = new int[]{0, 0, 0};

    boolean getIsEmpty() {
        return this.myNoDataSaved;
    }

    int getLevel() {
        return this.myLevel;
    }

    int getDriverNumber() {
        return this.driverNumber;
    }

    int getJeepNumber() {
        return this.jeepNumber;
    }

    int getEngineUpgrade() {
        return this.engineUp;
    }

    int getSeatUpgrade() {
        return this.seatUp;
    }

    int getBodyUpgrade() {
        return this.bodyUp;
    }

    int getMoney() {
        return this.money;
    }

    int getJeepHealth() {
        return this.jeepHealth;
    }

    int getGas() {
        return this.gas;
    }

    int getNumberOfScoresRecord(int number) {
        return this.numberOfScoresRecord[number];
    }

    int getLevelScore() {
        return this.levelScore;
    }

    int getTicks() {
        return this.ticks;
    }

    int getDriverHealth() {
        return this.driverHealth;
    }

    String getName() {
        return this.userName;
    }

    String getScoreName() {
        return this.scoreName;
    }

    String getLocation() {
        return this.location;
    }

    String getDate() {
        return this.myDate;
    }

    int getNumberOfRecord() {
        return this.numberOfRecords;
    }

    GameInfo(int level, int dImage, int jImage, int engine, int seat, int body, int Fare, String name, int jHealth, int myGas, int dHealth, String locn, int tick) throws Exception {
        this.myLevel = level;
        this.driverNumber = dImage;
        this.jeepNumber = jImage;
        this.ticks = tick;
        this.engineUp = engine;
        this.seatUp = seat;
        this.bodyUp = body;
        this.money = Fare;
        this.userName = name;
        this.jeepHealth = jHealth;
        this.gas = myGas;
        this.driverHealth = dHealth;
        this.location = locn;
        this.saveInfo();
    }

    GameInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadInfo(int recordNumber) {
        RecordStore saveStore = null;
        try {
            saveStore = RecordStore.openRecordStore((String)SAVESTORE, (boolean)true);
            this.numberOfRecords = saveStore.getNumRecords();
            if (saveStore != null && saveStore.getNumRecords() > 0) {
                byte[] data = saveStore.getRecord(recordNumber);
                this.myLevel = data[0];
                this.driverNumber = data[1];
                this.jeepNumber = data[2];
                this.engineUp = data[3];
                this.seatUp = data[4];
                this.bodyUp = data[5];
                byte[] fourBytesMoney = new byte[4];
                System.arraycopy(data, 6, fourBytesMoney, 0, 4);
                this.money = DataConverter.parseInt(fourBytesMoney);
                byte[] fourBytesJeep = new byte[4];
                System.arraycopy(data, 10, fourBytesJeep, 0, 4);
                this.jeepHealth = DataConverter.parseInt(fourBytesJeep);
                byte[] fourBytesGas = new byte[4];
                System.arraycopy(data, 14, fourBytesGas, 0, 4);
                this.gas = DataConverter.parseInt(fourBytesGas);
                byte[] fourBytesDriver = new byte[4];
                System.arraycopy(data, 18, fourBytesDriver, 0, 4);
                this.driverHealth = DataConverter.parseInt(fourBytesDriver);
                byte[] byteDateData = new byte[16];
                System.arraycopy(data, 22, byteDateData, 0, 16);
                this.myDate = new String(byteDateData);
                byte[] byteNameData = new byte[data.length - 22 - 16];
                System.arraycopy(data, 38, byteNameData, 0, data.length - 22 - 16);
                this.userName = new String(byteNameData);
            } else {
                this.myNoDataSaved = true;
            }
        }
        catch (Exception e) {
            this.myNoDataSaved = true;
        }
        finally {
            try {
                if (saveStore != null) {
                    this.numberOfRecords = saveStore.getNumRecords();
                    saveStore.closeRecordStore();
                }
            }
            catch (Exception exception) {}
        }
    }

    int saveInfo() throws Exception {
        RecordStore saveStore = null;
        try {
            byte[] byteNameData = this.userName.getBytes();
            byte[] data = new byte[38 + byteNameData.length];
            data[0] = new Integer(this.myLevel).byteValue();
            data[1] = new Integer(this.driverNumber).byteValue();
            data[2] = new Integer(this.jeepNumber).byteValue();
            data[3] = new Integer(this.engineUp).byteValue();
            data[4] = new Integer(this.seatUp).byteValue();
            data[5] = new Integer(this.bodyUp).byteValue();
            byte[] fareBytes = DataConverter.intToFourBytes(this.money);
            System.arraycopy(fareBytes, 0, data, 6, 4);
            byte[] jeepBytes = DataConverter.intToFourBytes(this.jeepHealth);
            System.arraycopy(jeepBytes, 0, data, 10, 4);
            byte[] gasBytes = DataConverter.intToFourBytes(this.gas);
            System.arraycopy(gasBytes, 0, data, 14, 4);
            byte[] driverBytes = DataConverter.intToFourBytes(this.driverHealth);
            System.arraycopy(driverBytes, 0, data, 18, 4);
            String date = new Date().toString();
            byte[] byteDateData = date.getBytes();
            System.arraycopy(byteDateData, 0, data, 22, 16);
            System.arraycopy(byteNameData, 0, data, 38, byteNameData.length);
            saveStore = RecordStore.openRecordStore((String)SAVESTORE, (boolean)true);
            int numRecords = saveStore.getNumRecords();
            if (numRecords >= 6) {
                for (int i = 1; i < numRecords; ++i) {
                    byte[] tempRecord = saveStore.getRecord(i + 1);
                    int recordSize = saveStore.getRecordSize(i + 1);
                    saveStore.setRecord(i, tempRecord, 0, recordSize);
                }
                saveStore.setRecord(numRecords, data, 0, data.length);
            } else {
                saveStore.addRecord(data, 0, data.length);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (saveStore != null) {
                    this.numberOfRecords = saveStore.getNumRecords();
                    saveStore.closeRecordStore();
                }
            }
            catch (Exception e) {}
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteInfo(int recordNumber) {
        RecordStore saveStore = null;
        try {
            saveStore = RecordStore.openRecordStore((String)SAVESTORE, (boolean)false);
            this.numberOfRecords = saveStore.getNumRecords();
            if (saveStore != null && saveStore.getNumRecords() > 0) {
                saveStore.deleteRecord(recordNumber);
            } else {
                this.myNoDataSaved = true;
            }
        }
        catch (Exception e) {
            this.myNoDataSaved = true;
        }
        finally {
            try {
                if (saveStore != null) {
                    this.numberOfRecords = saveStore.getNumRecords();
                    saveStore.closeRecordStore();
                }
            }
            catch (Exception exception) {}
        }
    }
}

