/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import MyGame.Buildings;
import MyGame.EnemyJeep;
import MyGame.Items;
import MyGame.Stations;
import MyGame.Vehicles;
import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Jeepney
extends Sprite {
    static final int WIDTH = 24;
    static final int HEIGHT = 32;
    static final int[] FORWARD = new int[]{16, 17, 18, 19, 20};
    static final int[] TURBO = new int[]{4, 5, 6, 7, 8};
    static final int[] TICKET = new int[]{4, 5, 6, 7, 8};
    static final int[] LEFT_FAST = new int[]{23, 23};
    static final int[] RIGHT_FAST = new int[]{24, 24};
    static final int[] LOADING = new int[]{0, 1, 2, 3};
    static final int[] CRASHING_UP = new int[]{25, 25};
    static final int[] CRASHING_DOWN = new int[]{28, 28};
    static final int[] CRASHING_LEFT = new int[]{27, 27};
    static final int[] CRASHING_RIGHT = new int[]{26, 26};
    static final int[] TURNING_LEFT = new int[]{21, 21};
    static final int[] TURNING_RIGHT = new int[]{22, 22};
    static final int[] TICKETING = new int[]{10, 11, 12, 13};
    private int myInitialX;
    private int myInitialY;
    private int dispGap;
    public int passengersUnloaded = 0;
    public int currentPassengers = 0;
    public int newPassengers = 0;
    public int fareEarned = 0;
    public int damagePoints = 8;
    public static int itemX = 0;
    public static int moneyBag = 0;
    private Random myRandom = new Random();
    boolean VehcCollided = false;
    boolean BldgCollided = false;
    boolean LdngCollided = false;
    boolean GasCollided = false;
    boolean RprCollided = false;
    boolean DrvCollided = false;
    boolean ItemCollided = false;
    boolean EnemyCollided = false;
    public boolean turboFlag = false;
    public boolean turboFrameFlag = false;
    public boolean musicFlag = false;
    public boolean scramblerFlag = false;
    public byte noColCounter = 0;
    public byte LRColCounter = 0;
    public byte VehcColCounter = 0;
    public byte EnemyColCounter = 0;
    public byte BldgColCounter = 0;
    public byte LdngColCounter = 0;
    public byte GasColCounter = 0;
    public byte RprColCounter = 0;
    public byte ItemColCounter = 0;
    public byte DrvColCounter = 0;
    public byte returnToken = (byte)5;
    public byte driverDamage = (byte)5;
    public byte driverBurger = 0;

    public Jeepney(int initialX, int initialY, int dWidth) throws Exception {
        super(Image.createImage((String)"/images/jeepneySarao.png"), 24, 32);
        this.myInitialY = initialY;
        if (dWidth >= 320) {
            this.dispGap = 60;
            this.myInitialX = initialX + 1;
            this.myInitialY = initialY + 12;
        } else {
            this.dispGap = 0;
            this.myInitialX = initialX;
        }
        this.defineReferencePixel(0, 0);
        this.setRefPixelPosition(this.myInitialX, this.myInitialY);
        this.setFrameSequence(FORWARD);
        this.VehcCollided = false;
        this.BldgCollided = false;
        this.LdngCollided = false;
        this.GasCollided = false;
        this.RprCollided = false;
        this.DrvCollided = false;
        this.ItemCollided = false;
        this.turboFlag = false;
        this.turboFrameFlag = false;
        this.musicFlag = false;
        this.scramblerFlag = false;
        this.EnemyCollided = false;
    }

    int checkVehicleCollision(Vehicles vehicle, boolean direction, int token, boolean fromTop, boolean goingUp, int speed, int damage) {
        int retVal = 0;
        this.driverDamage = 0;
        this.damagePoints = damage;
        this.VehcCollided = false;
        if (this.collidesWith(vehicle, true)) {
            if (this.VehcColCounter < 1 && this.BldgColCounter < 1 && this.LdngColCounter < 1 && this.GasColCounter < 1 && this.RprColCounter < 1) {
                retVal = this.damagePoints;
                this.VehcCollided = true;
                this.setFrameSequence(null);
                this.driverDamage = (byte)5;
                if (!fromTop) {
                    if (token == 3 && this.LdngColCounter < 1 && this.GasColCounter < 1 && this.RprColCounter < 1) {
                        this.setFrameSequence(CRASHING_LEFT);
                        this.move(6, 0);
                    } else if (token == 4 && this.LdngColCounter < 1 && this.GasColCounter < 1 && this.RprColCounter < 1) {
                        this.setFrameSequence(CRASHING_RIGHT);
                        this.move(-6, 0);
                    } else if (!goingUp || speed < 3 || token == 2) {
                        this.setFrameSequence(CRASHING_DOWN);
                        this.returnToken = (byte)5;
                    } else {
                        this.setFrameSequence(CRASHING_UP);
                        this.returnToken = (byte)5;
                    }
                } else if (token == 3 && this.LdngColCounter < 1 && this.GasColCounter < 1 && this.RprColCounter < 1) {
                    this.move(6, 0);
                    this.setFrameSequence(CRASHING_LEFT);
                } else if (token == 4 && this.LdngColCounter < 1 && this.GasColCounter < 1 && this.RprColCounter < 1) {
                    this.move(-6, 0);
                    this.setFrameSequence(CRASHING_RIGHT);
                } else if (!goingUp) {
                    this.setFrameSequence(CRASHING_DOWN);
                    this.returnToken = (byte)5;
                } else {
                    this.setFrameSequence(CRASHING_UP);
                    this.returnToken = (byte)5;
                }
                this.VehcColCounter = (byte)30;
            }
        } else if (speed > 0 && (token == 3 || token == 4)) {
            if (this.VehcColCounter < 1 && this.BldgColCounter < 1 && this.LdngColCounter < 1 && this.GasColCounter < 1 && this.RprColCounter < 1) {
                if (token == 3) {
                    this.setFrameSequence(null);
                    if (goingUp) {
                        if (speed < 5) {
                            this.setFrameSequence(TURNING_LEFT);
                            this.LRColCounter = (byte)30;
                        } else {
                            this.setFrameSequence(LEFT_FAST);
                            this.LRColCounter = (byte)30;
                        }
                    } else {
                        this.setFrameSequence(TURNING_RIGHT);
                        this.LRColCounter = (byte)30;
                    }
                } else if (token == 4) {
                    this.setFrameSequence(null);
                    if (goingUp) {
                        if (speed < 5) {
                            this.setFrameSequence(TURNING_RIGHT);
                            this.LRColCounter = (byte)30;
                        } else {
                            this.setFrameSequence(RIGHT_FAST);
                            this.LRColCounter = (byte)30;
                        }
                    } else {
                        this.setFrameSequence(TURNING_LEFT);
                        this.LRColCounter = (byte)30;
                    }
                } else {
                    this.setFrameSequence(FORWARD);
                }
            }
        } else {
            this.noColCounter = (byte)-128;
        }
        if (this.LRColCounter > 0) {
            this.LRColCounter = (byte)(this.LRColCounter - 1);
            if (this.LRColCounter == 1) {
                this.returnToken = (byte)5;
                this.noColCounter = 0;
                token = 1;
            }
        }
        if (this.VehcColCounter > 0) {
            this.VehcColCounter = (byte)(this.VehcColCounter - 1);
            if (this.VehcColCounter == 1) {
                this.returnToken = (byte)5;
            }
        }
        if (this.noColCounter > 0) {
            this.noColCounter = (byte)(this.noColCounter - 1);
            if (this.noColCounter == 1) {
                this.returnToken = (byte)5;
            }
        }
        if ((this.LRColCounter == 1 || this.VehcColCounter == 1 || this.noColCounter == 1) && this.BldgColCounter < 1 && this.LdngColCounter < 1 && token == 1 && this.GasColCounter < 1 && this.RprColCounter < 1) {
            this.setFrameSequence(null);
            if (this.turboFrameFlag) {
                this.setFrameSequence(TURBO);
            } else {
                this.setFrameSequence(FORWARD);
            }
        }
        return retVal;
    }

    int checkEnemyCollision(EnemyJeep enemycar, boolean direction, int token, boolean fromTop, boolean goingUp, int speed, int damage) {
        int retVal = 0;
        this.driverDamage = 0;
        this.damagePoints = damage;
        this.EnemyCollided = false;
        if (this.collidesWith(enemycar, true) && this.EnemyColCounter < 1 && this.BldgColCounter < 1 && this.LdngColCounter < 1 && this.GasColCounter < 1 && this.RprColCounter < 1) {
            retVal = this.damagePoints;
            this.EnemyCollided = true;
            this.setFrameSequence(null);
            this.driverDamage = (byte)5;
            if (!fromTop) {
                if (token == 3 && this.LdngColCounter < 1 && this.GasColCounter < 1 && this.RprColCounter < 1) {
                    this.setFrameSequence(CRASHING_LEFT);
                    this.move(6, 0);
                } else if (token == 4 && this.LdngColCounter < 1 && this.GasColCounter < 1 && this.RprColCounter < 1) {
                    this.setFrameSequence(CRASHING_RIGHT);
                    this.move(-6, 0);
                } else if (!goingUp || speed < 3 || token == 2) {
                    this.setFrameSequence(CRASHING_DOWN);
                    this.returnToken = (byte)5;
                } else {
                    this.setFrameSequence(CRASHING_UP);
                    this.returnToken = (byte)5;
                }
            }
            this.EnemyColCounter = (byte)20;
        }
        if (this.EnemyColCounter > 0) {
            this.EnemyColCounter = (byte)(this.EnemyColCounter - 1);
            if (this.EnemyColCounter == 1) {
                this.returnToken = (byte)5;
                if (this.BldgColCounter < 1 && this.LdngColCounter < 1 && token == 1 && this.GasColCounter < 1 && this.RprColCounter < 1 && this.ItemColCounter < 1) {
                    this.setFrameSequence(null);
                    if (this.turboFrameFlag) {
                        this.setFrameSequence(TURBO);
                    } else {
                        this.setFrameSequence(FORWARD);
                    }
                }
            }
        }
        return retVal;
    }

    int checkItemCollision(Items item, boolean rightdirection, int token, boolean goingUp, int speed, boolean good, int itemnumber, int badItemCounter, int damage) {
        int retVal = 0;
        this.driverDamage = 0;
        this.driverBurger = 0;
        this.damagePoints = damage;
        this.ItemCollided = false;
        this.turboFlag = false;
        this.musicFlag = false;
        this.scramblerFlag = false;
        if (this.collidesWith(item, true) && this.BldgColCounter < 1 && this.LdngColCounter < 1 && this.GasColCounter < 1 && this.RprColCounter < 1 && this.ItemColCounter < 1) {
            if (!(good || badItemCounter >= 1 && itemnumber != 0 && itemnumber != 3)) {
                retVal = this.damagePoints;
                this.ItemCollided = true;
                this.ItemColCounter = (byte)20;
                this.setFrameSequence(null);
                this.driverDamage = (byte)5;
                if (token == 3) {
                    this.setFrameSequence(CRASHING_LEFT);
                    this.move(6, 0);
                } else if (token == 4) {
                    this.setFrameSequence(CRASHING_RIGHT);
                    this.move(-6, 0);
                } else if (!goingUp) {
                    this.setFrameSequence(CRASHING_DOWN);
                } else {
                    this.setFrameSequence(CRASHING_UP);
                }
            } else if (good) {
                this.ItemCollided = true;
                this.ItemColCounter = (byte)20;
                if (itemnumber == 0) {
                    this.turboFlag = true;
                    this.turboFrameFlag = true;
                    item.setVisible(false);
                } else if (itemnumber == 1) {
                    retVal = this.damagePoints;
                    item.setVisible(false);
                } else if (itemnumber == 2) {
                    this.driverBurger = (byte)8;
                    item.setVisible(false);
                } else if (itemnumber == 3) {
                    this.musicFlag = true;
                    item.setVisible(false);
                } else if (itemnumber == 4) {
                    this.scramblerFlag = true;
                    item.setVisible(false);
                } else if (itemnumber == 5) {
                    moneyBag = (byte)(20 + this.getRandomInt(41));
                    item.setVisible(false);
                    this.ItemColCounter = (byte)120;
                    itemX = this.getRefPixelX();
                }
                item.setVisible(false);
            }
        }
        if (this.ItemColCounter > 0) {
            this.ItemColCounter = (byte)(this.ItemColCounter - 1);
            if (this.ItemColCounter == 1) {
                this.returnToken = (byte)5;
                if (this.VehcColCounter < 1 && this.EnemyColCounter < 1 && this.BldgColCounter < 1 && this.LdngColCounter < 1 && token == 1 && this.GasColCounter < 1 && this.RprColCounter < 1) {
                    this.setFrameSequence(null);
                    moneyBag = 0;
                    itemX = 0;
                    if (this.turboFrameFlag) {
                        this.setFrameSequence(TURBO);
                    } else {
                        this.setFrameSequence(FORWARD);
                    }
                }
            }
        }
        return retVal;
    }

    int checkBuildingCollision(Buildings building, int rightDistance, int leftDistance, boolean direction, int damage) {
        int retVal = 0;
        this.driverDamage = 0;
        this.damagePoints = damage;
        this.BldgCollided = false;
        int jeepY = this.getRefPixelY();
        int jeepX = this.getRefPixelX();
        if (!(!this.collidesWith(building, true) || jeepY > 1667 && jeepY < 1802 || jeepY > 1248 && jeepY < 1383 || jeepY > 269 && jeepY < 400 || this.GasColCounter >= 1 || this.RprColCounter >= 1)) {
            retVal = this.damagePoints;
            this.BldgCollided = true;
            this.setFrameSequence(null);
            this.driverDamage = (byte)5;
            if (jeepX > 180) {
                this.setFrameSequence(CRASHING_RIGHT);
                this.move(rightDistance, 0);
            } else {
                this.setFrameSequence(CRASHING_LEFT);
                this.move(leftDistance, 0);
            }
            this.BldgColCounter = (byte)20;
        }
        if (this.BldgColCounter > 0) {
            this.BldgColCounter = (byte)(this.BldgColCounter - 1);
            if (this.BldgColCounter == 1) {
                this.setFrameSequence(null);
                if (this.turboFrameFlag) {
                    this.setFrameSequence(TURBO);
                } else {
                    this.setFrameSequence(FORWARD);
                }
                this.returnToken = (byte)5;
            }
        }
        return retVal;
    }

    boolean checkStationCollision(Stations station, int rightDistance, int oldPassenger, int maxPassenger) {
        boolean retVal = false;
        this.currentPassengers = oldPassenger;
        this.fareEarned = 0;
        int delta = maxPassenger - oldPassenger;
        int jeepY = this.getRefPixelY();
        int jeepX = this.getRefPixelX();
        this.LdngCollided = false;
        this.GasCollided = false;
        this.RprCollided = false;
        this.DrvCollided = false;
        if (this.collidesWith(station, true)) {
            if (jeepY > 2119 && jeepY < 2189 || jeepY > 860 && jeepY < 930) {
                retVal = true;
                this.LdngCollided = true;
                this.setFrameSequence(null);
                this.setFrameSequence(LOADING);
                this.LdngColCounter = (byte)75;
                if (oldPassenger > 0) {
                    this.passengersUnloaded = oldPassenger > 1 ? (maxPassenger == 15 && oldPassenger >= 4 ? 4 + this.getRandomInt(oldPassenger - 4 + 1) : (maxPassenger == 15 && oldPassenger < 4 ? oldPassenger : 1 + this.getRandomInt(oldPassenger))) : 1;
                    this.currentPassengers = oldPassenger - this.passengersUnloaded;
                    delta = maxPassenger - this.currentPassengers;
                }
                this.newPassengers = delta > 1 ? (maxPassenger == 15 && delta >= 4 ? 4 + this.getRandomInt(delta - 4 + 1) : (maxPassenger == 15 && delta < 4 ? delta : 1 + this.getRandomInt(delta))) : (delta == 1 ? 1 : 0);
                this.currentPassengers += this.newPassengers;
                if (this.passengersUnloaded > 0) {
                    this.fareEarned = 20 * this.passengersUnloaded;
                }
            }
        } else if (jeepX > 190 + this.dispGap) {
            if (jeepY > 1700 && jeepY < 1770) {
                retVal = true;
                this.GasCollided = true;
                this.setFrameSequence(null);
                this.GasColCounter = (byte)100;
                this.setVisible(false);
            } else if (jeepY > 300 && jeepY < 370) {
                retVal = true;
                this.RprCollided = true;
                this.setFrameSequence(null);
                this.RprColCounter = (byte)100;
                this.setVisible(false);
            } else if (jeepY > 1277 && jeepY < 1355) {
                retVal = true;
                this.DrvCollided = true;
                this.setFrameSequence(null);
                this.DrvColCounter = (byte)100;
                this.setVisible(false);
            }
        }
        if (this.LdngColCounter > 0) {
            this.LdngColCounter = (byte)(this.LdngColCounter - 1);
            if (this.LdngColCounter == 1) {
                this.setFrameSequence(null);
                if (this.turboFrameFlag) {
                    this.setFrameSequence(TURBO);
                } else {
                    this.setFrameSequence(FORWARD);
                }
                this.move(-4, 0);
                this.returnToken = (byte)5;
            }
        }
        if (this.GasColCounter > 0) {
            this.GasColCounter = (byte)(this.GasColCounter - 1);
        }
        if (this.DrvColCounter > 0) {
            this.DrvColCounter = (byte)(this.DrvColCounter - 1);
        }
        if (this.RprColCounter > 0) {
            this.RprColCounter = (byte)(this.RprColCounter - 1);
        }
        if (this.GasColCounter == 1 || this.RprColCounter == 1 || this.DrvColCounter == 1) {
            this.setVisible(true);
            this.setFrameSequence(null);
            if (this.turboFrameFlag) {
                this.setFrameSequence(TURBO);
            } else {
                this.setFrameSequence(FORWARD);
            }
            this.move(rightDistance, 0);
            this.returnToken = (byte)5;
        }
        return retVal;
    }

    void reset() {
        this.setRefPixelPosition(this.myInitialX, this.myInitialY);
        this.setVisible(true);
        this.setFrameSequence(null);
        this.setFrameSequence(FORWARD);
        this.setTransform(0);
        this.EnemyCollided = false;
        this.passengersUnloaded = 0;
        this.currentPassengers = 0;
        this.fareEarned = 0;
        this.newPassengers = 0;
        this.driverDamage = (byte)5;
        this.driverBurger = 0;
        moneyBag = 0;
        this.VehcCollided = false;
        this.BldgCollided = false;
        this.LdngCollided = false;
        this.GasCollided = false;
        this.scramblerFlag = false;
        this.RprCollided = false;
        this.ItemCollided = false;
        this.turboFlag = false;
        this.turboFrameFlag = false;
        this.musicFlag = false;
        this.LRColCounter = 0;
        this.VehcColCounter = 0;
        this.BldgColCounter = 0;
        this.LdngColCounter = 0;
        this.GasColCounter = 0;
        this.RprColCounter = 0;
        this.noColCounter = 0;
        this.EnemyColCounter = 0;
    }

    void setTrafficFlag(boolean traffic) {
        boolean trafficFlag = traffic;
        this.setFrameSequence(null);
        if (!trafficFlag) {
            if (this.turboFrameFlag) {
                this.setFrameSequence(TURBO);
            } else {
                this.setFrameSequence(FORWARD);
            }
            this.returnToken = (byte)5;
        } else {
            this.setFrameSequence(TICKETING);
            this.returnToken = (byte)5;
        }
    }

    void advance(int tickCount, boolean up, boolean right, int speed) {
        if (!up) {
            this.move(0, speed);
        } else {
            this.move(0, -speed);
        }
        if (tickCount % 5 == 0) {
            this.nextFrame();
        }
    }

    private int getRandomInt(int upper) {
        int retVal = this.myRandom.nextInt() % upper;
        if (retVal < 0) {
            retVal += upper;
        }
        return retVal;
    }
}

