/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import java.util.Vector;
import org.netbeans.microedition.svg.DataListener;
import org.netbeans.microedition.svg.SVGActionListener;
import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGForm;
import org.netbeans.microedition.svg.SVGList;
import org.netbeans.microedition.svg.SVGListCellRenderer;
import org.netbeans.microedition.svg.SVGRectangle;
import org.netbeans.microedition.svg.SVGTextField;
import org.netbeans.microedition.svg.input.InputHandler;
import org.netbeans.microedition.svg.input.PointerEvent;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimationElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGRect;

public class SVGComboBox
extends SVGComponent
implements DataListener,
SVGActionListener {
    private static final String EDITOR = "editor";
    private static final String BUTTON = "button";
    private static final String LIST = "list";
    private static final String PRESSED = "_pressed";
    private static final String RELEASED = "_released";
    private static final String EDITOR_SUFFIX = "_editor";
    private static final String BUTTON_SUFFIX = "_button";
    private static final String LIST_SUFFIX = "_list";
    private ComboBoxModel myModel;
    private ComboBoxEditor myEditor;
    private InputHandler myInputHandler;
    private SVGLocatableElement myButton;
    private SVGAnimationElement myPressedAnimation;
    private SVGAnimationElement myReleasedAnimation;
    private SVGList myList;
    private boolean isListShown;
    private int myIndex;
    private Object mySelectedValue;
    private boolean isUIAction;
    private Object myUILock = new Object();

    public SVGComboBox(SVGForm form, String elemId) {
        super(form, elemId);
        this.initButton();
        this.initList();
        this.myInputHandler = new ComboBoxInputHandler();
        this.initEditor();
        this.setModel(new DefaultModel(new Vector()));
    }

    public void focusGained() {
        super.focusGained();
        if (this.getEditor() != null) {
            this.getEditor().getEditorComponent().focusGained();
        }
    }

    public void focusLost() {
        super.focusLost();
        this.hideList();
        if (this.getEditor() != null) {
            this.getEditor().getEditorComponent().focusLost();
        }
    }

    public InputHandler getInputHandler() {
        return this.myInputHandler;
    }

    public ComboBoxModel getModel() {
        return this.myModel;
    }

    public void setModel(ComboBoxModel model) {
        if (this.myModel != null) {
            this.myModel.removeDataListener(this);
        }
        this.myModel = model;
        model.addDataListener(this);
        this.myList.setModel(model);
        if (model != null && model.getSize() > 0 && model != null && model.getSize() > 0) {
            this.setSelected(model.getElementAt(0));
        }
    }

    public ComboBoxEditor getEditor() {
        return this.myEditor;
    }

    public void setEditor(ComboBoxEditor editor) {
        if (this.myEditor != null) {
            this.myEditor.removeActionListener(this);
        }
        this.myEditor = editor;
        this.myEditor.addActionListener(this);
    }

    public SVGListCellRenderer getRenderer() {
        return this.getList().getRenderer();
    }

    public void setRenderer(SVGListCellRenderer renderer) {
        this.getList().setRenderer(renderer);
    }

    public Object getSelectedItem() {
        return this.mySelectedValue;
    }

    public void setSelectedItem(Object value) {
        this.setSelected(value);
    }

    public SVGRectangle getBounds() {
        SVGRectangle rectangle = super.getBounds();
        if (this.isListShown) {
            SVGRectangle rect = this.myList.getBounds();
            return rectangle.union(rect);
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentsChanged(Object source) {
        if (source != this.getModel()) {
            return;
        }
        Object object = this.myUILock;
        synchronized (object) {
            if (this.isUIAction) {
                this.isUIAction = false;
            } else {
                this.hideList();
                this.myIndex = this.getModel().getSelectedIndex();
                if (this.myIndex != -1) {
                    this.myList.getSelectionModel().addSelectionInterval(this.myIndex, this.myIndex);
                    this.mySelectedValue = this.getModel().getElementAt(this.myIndex);
                    this.setItem();
                } else {
                    this.myList.getSelectionModel().clearSelection();
                    this.checkedGetEditor().setItem(this.mySelectedValue);
                }
                this.fireActionPerformed();
            }
        }
    }

    public void actionPerformed(SVGComponent comp) {
        this.setSelected(this.checkedGetEditor().getItem());
        this.fireActionPerformed();
    }

    private ComboBoxEditor checkedGetEditor() {
        ComboBoxEditor editor = this.getEditor();
        if (editor == null) {
            throw new IllegalStateException("Component cannot be used without ComboBoxEditor. Please set editor.");
        }
        return editor;
    }

    private void initButton() {
        if (this.getElement().getId() != null) {
            this.myButton = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + BUTTON_SUFFIX);
            this.myPressedAnimation = (SVGAnimationElement)this.getElementById((SVGElement)this.myButton, this.myButton.getId() + PRESSED);
            this.myReleasedAnimation = (SVGAnimationElement)this.getElementById((SVGElement)this.myButton, this.myButton.getId() + RELEASED);
        }
        if (this.myButton == null) {
            this.myButton = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", BUTTON);
        }
        if (this.myPressedAnimation == null && this.myButton != null) {
            this.myPressedAnimation = (SVGAnimationElement)this.myButton.getFirstElementChild();
        }
        if (this.myReleasedAnimation == null && this.myPressedAnimation != null) {
            this.myReleasedAnimation = (SVGAnimationElement)this.myPressedAnimation.getNextElementSibling();
        }
    }

    private void initList() {
        Element root = this.getForm().getDocument().getDocumentElement();
        SVGElement listElement = null;
        if (this.getElement().getId() != null) {
            listElement = this.getElementById((SVGElement)root, this.getElement().getId() + LIST_SUFFIX);
        }
        if (listElement == null) {
            listElement = this.getElementByMeta((SVGElement)root, "ref", this.getElement().getId());
        }
        if (listElement == null) {
            throw new IllegalArgumentException("Could not be found list of choices element with id=" + this.getElement().getId() + LIST_SUFFIX + "." + " Unable to initialize List element with id=" + this.getElement().getId());
        }
        this.myList = new SVGList(this.getForm(), (SVGLocatableElement)listElement);
        this.myList.setFocusable(false);
    }

    private void initEditor() {
        SVGLocatableElement editor = null;
        SVGLocatableElement border = null;
        if (this.getElement().getId() != null) {
            editor = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + EDITOR_SUFFIX);
            border = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + "_border");
        }
        if (editor == null) {
            editor = (SVGLocatableElement)this.getElementByMeta((SVGElement)this.getElement(), "type", EDITOR);
        }
        if (editor != null && border != null) {
            this.setEditor(new DefaultComboBoxEditor(this.form, editor, border.getBBox().getWidth() - this.myButton.getBBox().getWidth(), border.getBBox().getX()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelected(Object value) {
        Object object = this.myUILock;
        synchronized (object) {
            this.mySelectedValue = value;
            int size = this.getModel().getSize();
            boolean found = false;
            for (int i = 0; i < size; ++i) {
                Object obj = this.getModel().getElementAt(i);
                if (value == null) {
                    if (obj != null) continue;
                    this.getModel().setSelectedIndex(i);
                    this.myIndex = i;
                    found = true;
                    continue;
                }
                if (!value.equals(obj)) continue;
                this.getModel().setSelectedIndex(i);
                this.myIndex = i;
                found = true;
            }
            if (!found) {
                this.myIndex = -1;
                this.myList.getSelectionModel().clearSelection();
                this.getModel().setSelectedIndex(-1);
            }
        }
    }

    private void showList() {
        this.isListShown = true;
        this.myList.focusGained();
        this.myList.setTraitSafely((SVGElement)this.myList.getElement(), "visibility", "visible");
        this.myIndex = this.getModel().getSelectedIndex();
    }

    private void hideList() {
        if (this.isListShown) {
            this.isListShown = false;
            this.myList.focusLost();
            this.myList.setTraitSafely((SVGElement)this.myList.getElement(), "visibility", "hidden");
        }
    }

    private void setItem() {
        int index = this.getModel().getSelectedIndex();
        if (index >= 0) {
            Object selected = index < this.getModel().getSize() ? this.getModel().getElementAt(index) : null;
            this.checkedGetEditor().setItem(selected);
        }
    }

    private SVGList getList() {
        return this.myList;
    }

    public static interface ComboBoxEditor {
        public SVGComponent getEditorComponent();

        public Object getItem();

        public void setItem(Object var1);

        public void addActionListener(SVGActionListener var1);

        public void removeActionListener(SVGActionListener var1);
    }

    private class ComboBoxInputHandler
    extends InputHandler {
        private ComboBoxInputHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean handleKeyPress(SVGComponent comp, int keyCode) {
            boolean ret = false;
            if (!(comp instanceof SVGComboBox)) return ret;
            if (keyCode == -3) {
                if (!SVGComboBox.this.isListShown) return true;
                return SVGComboBox.this.myList.getInputHandler().handleKeyPress(comp, keyCode);
            }
            if (keyCode == -4) {
                if (SVGComboBox.this.isListShown) return SVGComboBox.this.myList.getInputHandler().handleKeyPress(SVGComboBox.this.myList, keyCode);
                SVGComboBox.this.getForm().invokeLaterSafely(new Runnable(){

                    public void run() {
                        SVGComboBox.this.myPressedAnimation.beginElementAt(0.0f);
                    }
                });
                return true;
            }
            if (keyCode == -5) {
                if (SVGComboBox.this.isListShown) {
                    return SVGComboBox.this.myList.getInputHandler().handleKeyPress(SVGComboBox.this.myList, keyCode);
                }
                if (SVGComboBox.this.getEditor() == null) {
                    return ret;
                }
                SVGComponent component = SVGComboBox.this.getEditor().getEditorComponent();
                return component.getInputHandler().handleKeyPress(component, keyCode);
            }
            if (SVGComboBox.this.getEditor() == null) {
                return ret;
            }
            SVGComponent component = SVGComboBox.this.getEditor().getEditorComponent();
            return component.getInputHandler().handleKeyPress(component, keyCode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean handleKeyRelease(SVGComponent comp, int keyCode) {
            boolean ret = false;
            if (!(comp instanceof SVGComboBox)) return ret;
            if (keyCode == -3) {
                if (!SVGComboBox.this.isListShown) return true;
                SVGComboBox.this.myIndex = Math.max(0, SVGComboBox.this.myIndex - 1);
                SVGComboBox.this.myList.getInputHandler().handleKeyRelease(SVGComboBox.this.myList, keyCode);
                return true;
            }
            if (keyCode == -4) {
                if (SVGComboBox.this.isListShown) {
                    SVGComboBox.this.myIndex = Math.min(SVGComboBox.this.getModel().getSize() - 1, SVGComboBox.this.myIndex + 1);
                    SVGComboBox.this.myList.getInputHandler().handleKeyRelease(SVGComboBox.this.myList, keyCode);
                    return true;
                } else {
                    SVGComboBox.this.getForm().invokeLaterSafely(new Runnable(){

                        public void run() {
                            SVGComboBox.this.myReleasedAnimation.beginElementAt(0.0f);
                        }
                    });
                    SVGComboBox.this.showList();
                }
                return true;
            }
            if (keyCode == -5) {
                if (SVGComboBox.this.isListShown) {
                    SVGComboBox.this.hideList();
                    Object object = SVGComboBox.this.myUILock;
                    synchronized (object) {
                        SVGComboBox.this.isUIAction = true;
                        SVGComboBox.this.getModel().setSelectedIndex(SVGComboBox.this.myIndex);
                    }
                    SVGComboBox.this.setItem();
                    SVGComboBox.this.fireActionPerformed();
                    return ret;
                }
                if (SVGComboBox.this.getEditor() == null) {
                    return ret;
                }
                SVGComponent component = SVGComboBox.this.getEditor().getEditorComponent();
                return component.getInputHandler().handleKeyRelease(component, keyCode);
            }
            if (SVGComboBox.this.getEditor() == null) {
                return ret;
            }
            SVGComponent component = SVGComboBox.this.getEditor().getEditorComponent();
            return component.getInputHandler().handleKeyRelease(component, keyCode);
        }

        public void handlePointerPress(PointerEvent event) {
            SVGRectangle rectangle;
            SVGComboBox.this.requestFocus();
            boolean isHandled = false;
            SVGLocatableElement button = SVGComboBox.this.myButton;
            SVGRect rect = button.getScreenBBox();
            if (rect != null && (rectangle = new SVGRectangle(rect)).contains(event.getX(), event.getY())) {
                isHandled = true;
                SVGComboBox.this.getForm().invokeLaterSafely(new Runnable(){

                    public void run() {
                        SVGComboBox.this.myPressedAnimation.beginElementAt(0.0f);
                    }
                });
            }
            ComboBoxEditor editor = SVGComboBox.this.checkedGetEditor();
            if (!isHandled && editor.getEditorComponent() != null && editor.getEditorComponent().getBounds() != null && editor.getEditorComponent().getBounds().contains(event.getX(), event.getY())) {
                isHandled = true;
                editor.getEditorComponent().getInputHandler().handlePointerPress(new PointerEvent(editor.getEditorComponent(), event.getX(), event.getY(), event.getClickCount()));
            }
            if (!isHandled && SVGComboBox.this.myList.getBounds() != null && SVGComboBox.this.myList.getBounds().contains(event.getX(), event.getY())) {
                SVGComboBox.this.myList.getInputHandler().handlePointerPress(new PointerEvent(SVGComboBox.this.myList, event.getX(), event.getY(), event.getClickCount()));
            }
            super.handlePointerPress(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePointerRelease(PointerEvent event) {
            SVGRectangle rectangle;
            boolean isHandled = false;
            SVGLocatableElement button = SVGComboBox.this.myButton;
            SVGRect rect = button.getScreenBBox();
            if (rect != null && (rectangle = new SVGRectangle(rect)).contains(event.getX(), event.getY())) {
                isHandled = true;
                SVGComboBox.this.getForm().invokeLaterSafely(new Runnable(){

                    public void run() {
                        SVGComboBox.this.myReleasedAnimation.beginElementAt(0.0f);
                    }
                });
                if (SVGComboBox.this.isListShown) {
                    SVGComboBox.this.hideList();
                } else {
                    SVGComboBox.this.showList();
                }
            }
            ComboBoxEditor editor = SVGComboBox.this.checkedGetEditor();
            if (!isHandled && editor.getEditorComponent() != null && editor.getEditorComponent().getBounds() != null && editor.getEditorComponent().getBounds().contains(event.getX(), event.getY())) {
                isHandled = true;
                editor.getEditorComponent().getInputHandler().handlePointerRelease(new PointerEvent(editor.getEditorComponent(), event.getX(), event.getY(), event.getClickCount()));
            }
            if (!isHandled && SVGComboBox.this.myList.getBounds() != null && SVGComboBox.this.myList.getBounds().contains(event.getX(), event.getY())) {
                SVGComboBox.this.myList.getInputHandler().handlePointerRelease(new PointerEvent(SVGComboBox.this.myList, event.getX(), event.getY(), event.getClickCount()));
                SVGComboBox.this.myIndex = SVGComboBox.this.myList.getSelectionModel().getSelectedIndex();
                if (event.getClickCount() > 1) {
                    SVGComboBox.this.hideList();
                    Object object = SVGComboBox.this.myUILock;
                    synchronized (object) {
                        SVGComboBox.this.isUIAction = true;
                        SVGComboBox.this.getModel().setSelectedIndex(SVGComboBox.this.myIndex);
                    }
                    SVGComboBox.this.setItem();
                    SVGComboBox.this.fireActionPerformed();
                }
            }
            super.handlePointerRelease(event);
        }
    }

    public static interface ComboBoxModel
    extends SVGList.ListModel {
        public int getSelectedIndex();

        public void setSelectedIndex(int var1);
    }

    private class DefaultComboBoxEditor
    extends SVGTextField
    implements ComboBoxEditor {
        public DefaultComboBoxEditor(SVGForm form, SVGLocatableElement element, float width, float x) {
            super(form, element, width, x);
        }

        public SVGComponent getEditorComponent() {
            return this;
        }

        public Object getItem() {
            return this.getText();
        }

        public void setItem(Object value) {
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("null");
            }
        }

        public void setText(String text) {
            super.setText(text);
        }
    }

    public static class DefaultModel
    extends SVGList.DefaultListModel
    implements ComboBoxModel {
        private int myCurrentSelectionIndx;

        public DefaultModel(Vector data) {
            super(data);
        }

        public int getSelectedIndex() {
            return this.myCurrentSelectionIndx;
        }

        public void setSelectedIndex(int index) {
            this.myCurrentSelectionIndx = index;
            this.fireDataChanged();
        }
    }
}

