/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.microedition.svg.DataListener;
import org.netbeans.microedition.svg.SVGActionListener;
import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGForm;
import org.netbeans.microedition.svg.SVGRectangle;
import org.netbeans.microedition.svg.SVGTextField;
import org.netbeans.microedition.svg.input.InputHandler;
import org.netbeans.microedition.svg.input.PointerEvent;
import org.w3c.dom.svg.SVGAnimationElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGRect;

public class SVGSpinner
extends SVGComponent
implements DataListener {
    private static final String UP = "up_button";
    private static final String DOWN = "down_button";
    private static final String EDITOR = "editor";
    private static final String UP_SUFFIX = "_up_button";
    private static final String DOWN_SUFFIX = "_down_button";
    private static final String EDITOR_SUFFIX = "_editor";
    private static final String PRESSED_SUFFIX = "_pressed";
    private static final String RELEASED_SUFFIX = "_released";
    private InputHandler myInputHandler;
    private SVGElement myUpButton;
    private SVGElement myDownButton;
    private SVGComponent myEditor;
    private SVGSpinnerModel myModel;
    private SVGAnimationElement myUpPressedAnimation;
    private SVGAnimationElement myUpReleasedAnimation;
    private SVGAnimationElement myDownPressedAnimation;
    private SVGAnimationElement myDownReleasedAnimation;
    private boolean isUIAction;
    private boolean isInternallyEdited;
    private Object myUILock = new Object();

    public SVGSpinner(SVGForm form, String elemId) {
        super(form, elemId);
        this.initButtons();
        this.myInputHandler = new SpinnerInputHandler();
        this.setModel(new DefaultModel());
        this.initEditor();
    }

    public void focusGained() {
        super.focusGained();
        this.getEditor().focusGained();
    }

    public void focusLost() {
        super.focusLost();
        this.getEditor().focusLost();
    }

    public void setModel(SVGSpinnerModel model) {
        if (this.myModel != null) {
            this.myModel.removeDataListener(this);
        }
        this.myModel = model;
        this.myModel.addDataListener(this);
    }

    public SVGSpinnerModel getModel() {
        return this.myModel;
    }

    public Object getValue() {
        return this.myModel.getValue();
    }

    public void setEditor(SVGComponent editor) {
        this.myEditor = editor;
    }

    public SVGComponent getEditor() {
        return this.myEditor;
    }

    public InputHandler getInputHandler() {
        return this.myInputHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentsChanged(Object source) {
        if (source == this.getModel()) {
            Object object = this.myUILock;
            synchronized (object) {
                if (!this.isUIAction) {
                    this.isInternallyEdited = true;
                    this.fireActionPerformed();
                    this.isInternallyEdited = false;
                }
            }
        }
    }

    private void initEditor() {
        SVGLocatableElement editor = null;
        SVGLocatableElement border = null;
        if (this.getElement().getId() != null) {
            editor = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + EDITOR_SUFFIX);
            border = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + "_border");
        }
        if (editor == null) {
            editor = (SVGLocatableElement)this.getElementByMeta((SVGElement)this.getElement(), "type", EDITOR);
        }
        if (editor != null && border != null) {
            float buttonWidth = 0.0f;
            if (this.myDownButton != null) {
                buttonWidth = ((SVGLocatableElement)this.myDownButton).getBBox().getWidth();
            } else if (this.myUpButton != null) {
                buttonWidth = ((SVGLocatableElement)this.myUpButton).getBBox().getWidth();
            }
            this.setEditor(new DefaultSpinnerEditor(this.getForm(), editor, border.getBBox().getWidth() - buttonWidth, border.getBBox().getX(), this.myUILock));
        }
    }

    private void initButtons() {
        if (this.getElement().getId() != null) {
            this.myUpButton = this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + UP_SUFFIX);
            this.myDownButton = this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + DOWN_SUFFIX);
            this.myUpPressedAnimation = (SVGAnimationElement)this.getElementById(this.myUpButton, this.myUpButton.getId() + PRESSED_SUFFIX);
            this.myUpReleasedAnimation = (SVGAnimationElement)this.getElementById(this.myUpButton, this.myUpButton.getId() + RELEASED_SUFFIX);
            this.myDownPressedAnimation = (SVGAnimationElement)this.getElementById(this.myDownButton, this.myDownButton.getId() + PRESSED_SUFFIX);
            this.myDownReleasedAnimation = (SVGAnimationElement)this.getElementById(this.myDownButton, this.myDownButton.getId() + RELEASED_SUFFIX);
        }
        if (this.myUpButton == null) {
            this.myUpButton = this.getNestedElementByMeta((SVGElement)this.getElement(), "type", UP);
        }
        if (this.myDownButton == null) {
            this.myDownButton = this.getNestedElementByMeta((SVGElement)this.getElement(), "type", DOWN);
        }
        if (this.myUpPressedAnimation == null) {
            this.myUpPressedAnimation = (SVGAnimationElement)this.myUpButton.getFirstElementChild();
        }
        if (this.myDownPressedAnimation == null) {
            this.myDownPressedAnimation = (SVGAnimationElement)this.myDownButton.getFirstElementChild();
        }
        if (this.myUpReleasedAnimation == null && this.myUpPressedAnimation != null) {
            this.myUpReleasedAnimation = (SVGAnimationElement)this.myUpPressedAnimation.getNextElementSibling();
        }
        if (this.myDownReleasedAnimation == null && this.myDownPressedAnimation != null) {
            this.myDownReleasedAnimation = (SVGAnimationElement)this.myDownPressedAnimation.getNextElementSibling();
        }
    }

    private void releaseUpButton() {
        this.getForm().invokeLaterSafely(new Runnable(){

            public void run() {
                if (SVGSpinner.this.myUpReleasedAnimation != null) {
                    SVGSpinner.this.myUpReleasedAnimation.beginElementAt(0.0f);
                }
            }
        });
        this.getModel().setValue(this.getModel().getNextValue());
    }

    private void pressDownButton() {
        this.getForm().invokeLaterSafely(new Runnable(){

            public void run() {
                if (SVGSpinner.this.myDownPressedAnimation != null) {
                    SVGSpinner.this.myDownPressedAnimation.beginElementAt(0.0f);
                }
            }
        });
        this.form.activate(this);
    }

    private void pressUpButton() {
        this.getForm().invokeLaterSafely(new Runnable(){

            public void run() {
                if (SVGSpinner.this.myUpPressedAnimation != null) {
                    SVGSpinner.this.myUpPressedAnimation.beginElementAt(0.0f);
                }
            }
        });
        this.form.activate(this);
    }

    private void releaseDownButton() {
        this.getForm().invokeLaterSafely(new Runnable(){

            public void run() {
                if (SVGSpinner.this.myDownReleasedAnimation != null) {
                    SVGSpinner.this.myDownReleasedAnimation.beginElementAt(0.0f);
                }
            }
        });
        this.getModel().setValue(this.getModel().getPreviousValue());
    }

    private class DefaultModel
    implements SVGSpinnerModel {
        private Integer myValue = new Integer(0);
        private Vector myListeners = new Vector(1);

        DefaultModel() {
        }

        public Object getNextValue() {
            return new Integer(this.myValue + 1);
        }

        public Object getPreviousValue() {
            return new Integer(this.myValue - 1);
        }

        public Object getValue() {
            return this.myValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDataListener(DataListener listener) {
            Vector vector = this.myListeners;
            synchronized (vector) {
                this.myListeners.addElement(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDataListener(DataListener listener) {
            Vector vector = this.myListeners;
            synchronized (vector) {
                this.myListeners.addElement(listener);
            }
        }

        public void setValue(Object value) {
            Integer result;
            String strValue = value.toString();
            this.myValue = result = Integer.valueOf(strValue);
            this.fireDataChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireDataChange() {
            Vector vector = this.myListeners;
            synchronized (vector) {
                Enumeration en = this.myListeners.elements();
                while (en.hasMoreElements()) {
                    DataListener listener = (DataListener)en.nextElement();
                    listener.contentsChanged(this);
                }
            }
        }
    }

    private class DefaultSpinnerEditor
    extends SVGTextField {
        private Object myLock;

        DefaultSpinnerEditor(SVGForm form, SVGLocatableElement element, float width, float x, Object lock) {
            super(form, element, width, x);
            this.myLock = lock;
            SVGSpinner.this.addActionListener(new SVGActionListener(){

                public void actionPerformed(SVGComponent comp) {
                    if (comp == SVGSpinner.this && SVGSpinner.this.isInternallyEdited && SVGSpinner.this.getValue() != null) {
                        DefaultSpinnerEditor.this.setText(SVGSpinner.this.getValue().toString());
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setText(String text) {
            super.setText(text);
            if (this.myLock == null) {
                return;
            }
            Object object = this.myLock;
            synchronized (object) {
                if (!SVGSpinner.this.isInternallyEdited) {
                    SVGSpinner.this.getModel().setValue(text);
                }
            }
        }
    }

    public static interface SVGSpinnerModel {
        public Object getValue();

        public Object getNextValue();

        public Object getPreviousValue();

        public void setValue(Object var1);

        public void addDataListener(DataListener var1);

        public void removeDataListener(DataListener var1);
    }

    private class SpinnerInputHandler
    extends InputHandler {
        private SpinnerInputHandler() {
        }

        public boolean handleKeyPress(SVGComponent comp, int keyCode) {
            boolean ret = false;
            if (comp instanceof SVGSpinner) {
                if (keyCode == -3) {
                    SVGSpinner.this.pressDownButton();
                    ret = true;
                } else if (keyCode == -4) {
                    SVGSpinner.this.pressUpButton();
                    ret = true;
                } else {
                    return SVGSpinner.this.getEditor().getInputHandler().handleKeyPress(SVGSpinner.this.getEditor(), keyCode);
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleKeyRelease(SVGComponent comp, int keyCode) {
            boolean ret = false;
            if (comp instanceof SVGSpinner) {
                if (keyCode == -3) {
                    SVGSpinner.this.releaseDownButton();
                    Object object = SVGSpinner.this.myUILock;
                    synchronized (object) {
                        SVGSpinner.this.isUIAction = true;
                        SVGSpinner.this.isInternallyEdited = true;
                        SVGSpinner.this.fireActionPerformed();
                        SVGSpinner.this.isUIAction = false;
                        SVGSpinner.this.isInternallyEdited = false;
                    }
                    ret = true;
                } else if (keyCode == -4) {
                    SVGSpinner.this.releaseUpButton();
                    Object object = SVGSpinner.this.myUILock;
                    synchronized (object) {
                        SVGSpinner.this.isUIAction = true;
                        SVGSpinner.this.isInternallyEdited = true;
                        SVGSpinner.this.fireActionPerformed();
                        SVGSpinner.this.isUIAction = false;
                        SVGSpinner.this.isInternallyEdited = false;
                    }
                    ret = true;
                } else {
                    return SVGSpinner.this.getEditor().getInputHandler().handleKeyRelease(SVGSpinner.this.getEditor(), keyCode);
                }
            }
            return ret;
        }

        public void handlePointerPress(PointerEvent event) {
            SVGRectangle rectangle;
            SVGSpinner.this.requestFocus();
            boolean isHandled = false;
            SVGRect rect = ((SVGLocatableElement)SVGSpinner.this.myUpButton).getScreenBBox();
            if (rect != null && (rectangle = new SVGRectangle(rect)).contains(event.getX(), event.getY())) {
                SVGSpinner.this.pressUpButton();
                isHandled = true;
            }
            if ((rect = ((SVGLocatableElement)SVGSpinner.this.myDownButton).getScreenBBox()) != null && (rectangle = new SVGRectangle(rect)).contains(event.getX(), event.getY())) {
                SVGSpinner.this.pressDownButton();
                isHandled = true;
            }
            if (!isHandled && SVGSpinner.this.myEditor != null && (rectangle = SVGSpinner.this.myEditor.getBounds()).contains(event.getX(), event.getY())) {
                SVGSpinner.this.myEditor.getInputHandler().handlePointerPress(new PointerEvent(SVGSpinner.this.myEditor, event.getX(), event.getY(), event.getClickCount()));
            }
            super.handlePointerPress(event);
        }

        public void handlePointerRelease(PointerEvent event) {
            SVGRectangle rectangle;
            boolean isHandled = false;
            SVGRect rect = ((SVGLocatableElement)SVGSpinner.this.myUpButton).getScreenBBox();
            if (rect != null && (rectangle = new SVGRectangle(rect)).contains(event.getX(), event.getY())) {
                SVGSpinner.this.releaseUpButton();
                isHandled = true;
            }
            if ((rect = ((SVGLocatableElement)SVGSpinner.this.myDownButton).getScreenBBox()) != null && (rectangle = new SVGRectangle(rect)).contains(event.getX(), event.getY())) {
                SVGSpinner.this.releaseDownButton();
                isHandled = true;
            }
            if (!isHandled && SVGSpinner.this.myEditor != null && (rectangle = SVGSpinner.this.myEditor.getBounds()).contains(event.getX(), event.getY())) {
                PointerEvent ev = new PointerEvent(SVGSpinner.this.myEditor, event.getX(), event.getY(), event.getClickCount());
                SVGSpinner.this.myEditor.getInputHandler().handlePointerRelease(ev);
            }
            super.handlePointerRelease(event);
        }
    }
}

