/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import MyGame.GameMainCanvas;
import MyGame.Items;
import java.util.Random;

public class ItemsThread
extends Thread {
    private boolean myShouldPause;
    private boolean myShouldStop;
    private Items[] myItems;
    private Random myRandom = new Random();

    ItemsThread(GameMainCanvas canvas) throws Exception {
        this.myItems = canvas.getItems();
    }

    void pauseGame() {
        this.myShouldPause = true;
    }

    synchronized void resumeGame() {
        this.myShouldPause = false;
        this.notify();
    }

    synchronized void requestStop() {
        this.myShouldStop = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.myShouldStop = false;
        this.myShouldPause = false;
        while (!this.myShouldStop) {
            ItemsThread itemsThread = this;
            synchronized (itemsThread) {
                while (this.myShouldPause) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {}
                }
            }
            int waitTime = (20 + this.getRandomInt(20)) * 100;
            ItemsThread e = this;
            synchronized (e) {
                try {
                    this.wait(waitTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.myShouldPause) continue;
            int whichItem = this.getRandomInt(this.myItems.length);
            this.myItems[whichItem].go();
        }
    }

    public int getRandomInt(int upper) {
        int retVal = this.myRandom.nextInt() % upper;
        if (retVal < 0) {
            retVal += upper;
        }
        return retVal;
    }
}

