/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;

public class Stations
extends TiledLayer {
    static final int TILE_WIDTH = 60;
    static final int TILE_HEIGHT = 140;
    static final int[] LOADING_FRAME_SEQUENCE = new int[]{1, 2, 3, 4, 5, 6};
    static final int[] GAS_STATION_FRAME_SEQUENCE = new int[]{7, 8};
    static final int[] REPAIR_STATION_FRAME_SEQUENCE = new int[]{13, 14, 15, 16, 17, 18};
    static final int[] DRIVE_THRU_FRAME_SEQUENCE = new int[]{9, 10, 11, 12};
    private int myLoadingSequenceIndex = 0;
    private int myGasStationSequenceIndex = 0;
    private int myRepairStationSequenceIndex = 0;
    private int myDriveThruSequenceIndex = 0;
    public int myAnimatedLoadingIndex;
    public int myAnimatedGasStationIndex;
    public int myAnimatedRepairStationIndex;
    public int myAnimatedDriveThruIndex;
    private int dispWidth = 0;

    public Stations(int dWidth) throws Exception {
        super(4, 20, Image.createImage((String)"/images/stations.png"), 60, 140);
        this.dispWidth = dWidth;
        if (this.dispWidth >= 320) {
            this.setPosition(90, 0);
        } else {
            this.setPosition(30, 0);
        }
        this.myAnimatedLoadingIndex = this.createAnimatedTile(1);
        this.myAnimatedGasStationIndex = this.createAnimatedTile(1);
        this.myAnimatedRepairStationIndex = this.createAnimatedTile(1);
        this.myAnimatedDriveThruIndex = this.createAnimatedTile(1);
        int[][] tiles = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, this.myAnimatedRepairStationIndex}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, this.myAnimatedLoadingIndex}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, this.myAnimatedDriveThruIndex}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, this.myAnimatedGasStationIndex}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, this.myAnimatedLoadingIndex}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}};
        for (int row = 0; row < 20; ++row) {
            for (int col = 0; col < 4; ++col) {
                this.setCell(col, row, tiles[row][col]);
            }
        }
    }

    void reset() {
        if (this.dispWidth == 320) {
            this.setPosition(90, 0);
        } else {
            this.setPosition(30, 0);
        }
        this.myLoadingSequenceIndex = 0;
        this.myGasStationSequenceIndex = 0;
        this.myRepairStationSequenceIndex = 0;
        this.myDriveThruSequenceIndex = 0;
        this.setAnimatedTile(this.myAnimatedLoadingIndex, LOADING_FRAME_SEQUENCE[this.myLoadingSequenceIndex]);
        this.setAnimatedTile(this.myAnimatedGasStationIndex, GAS_STATION_FRAME_SEQUENCE[this.myGasStationSequenceIndex]);
        this.setAnimatedTile(this.myAnimatedRepairStationIndex, REPAIR_STATION_FRAME_SEQUENCE[this.myRepairStationSequenceIndex]);
        this.setAnimatedTile(this.myAnimatedDriveThruIndex, DRIVE_THRU_FRAME_SEQUENCE[this.myDriveThruSequenceIndex]);
    }

    void advance(int tickCount) {
        if (tickCount % 7 == 0) {
            ++this.myLoadingSequenceIndex;
            this.myLoadingSequenceIndex %= 6;
            this.setAnimatedTile(this.myAnimatedLoadingIndex, LOADING_FRAME_SEQUENCE[this.myLoadingSequenceIndex]);
            ++this.myGasStationSequenceIndex;
            this.myGasStationSequenceIndex %= 2;
            this.setAnimatedTile(this.myAnimatedGasStationIndex, GAS_STATION_FRAME_SEQUENCE[this.myGasStationSequenceIndex]);
            ++this.myRepairStationSequenceIndex;
            this.myRepairStationSequenceIndex %= 6;
            this.setAnimatedTile(this.myAnimatedRepairStationIndex, REPAIR_STATION_FRAME_SEQUENCE[this.myRepairStationSequenceIndex]);
            ++this.myDriveThruSequenceIndex;
            this.myDriveThruSequenceIndex %= 4;
            this.setAnimatedTile(this.myAnimatedDriveThruIndex, DRIVE_THRU_FRAME_SEQUENCE[this.myDriveThruSequenceIndex]);
        }
    }
}

