/*
 * Decompiled with CFR 0.152.
 */
package MyGame;

import MyGame.GameMainCanvas;
import MyGame.Vehicles;
import java.util.Random;

public class VehicleThread
extends Thread {
    private boolean myShouldPause;
    private boolean myShouldStop;
    private Vehicles[] myVehicles;
    private Random myRandom = new Random();
    private int Level = 1;

    VehicleThread(GameMainCanvas canvas, int level) throws Exception {
        this.myVehicles = canvas.getVehicles();
        this.Level = level;
    }

    void pauseGame() {
        this.myShouldPause = true;
    }

    synchronized void resumeGame(int level) {
        this.Level = level;
        this.myShouldPause = false;
        this.notify();
    }

    synchronized void requestStop() {
        this.myShouldStop = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.myShouldStop = false;
        this.myShouldPause = false;
        while (!this.myShouldStop) {
            VehicleThread vehicleThread;
            VehicleThread vehicleThread2 = this;
            synchronized (vehicleThread2) {
                while (this.myShouldPause) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.Level == 1) {
                int waitTime = (10 + this.getRandomInt(12)) * 100;
                vehicleThread = this;
                synchronized (vehicleThread) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (this.Level == 2) {
                int waitTime = (6 + this.getRandomInt(6)) * 100;
                vehicleThread = this;
                synchronized (vehicleThread) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (this.Level == 3) {
                int waitTime = (4 + this.getRandomInt(4)) * 100;
                vehicleThread = this;
                synchronized (vehicleThread) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.myShouldPause) continue;
            int whichVehicle = this.getRandomInt(this.myVehicles.length);
            this.myVehicles[whichVehicle].go();
        }
    }

    public int getRandomInt(int upper) {
        int retVal = this.myRandom.nextInt() % upper;
        if (retVal < 0) {
            retVal += upper;
        }
        return retVal;
    }
}

