/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg.meta;

import java.util.Hashtable;
import org.netbeans.microedition.svg.meta.ChildrenAcceptor;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGElement;

public class MetaData
extends Hashtable {
    private static final long serialVersionUID = 526844381412432697L;
    public static final String METADATA = "text";
    public static final String TRAIT_TEXT = "#text";
    public static final String DISPLAY = "display";
    public static final String NONE = "none";
    private static final String EQ = "=";
    private SVGElement myNestedElement;

    public void loadFromElement(SVGElement element) {
        this.clear();
        this.myNestedElement = null;
        MetaVisitor visitor = new MetaVisitor();
        ChildrenAcceptor acceptor = new ChildrenAcceptor(visitor);
        acceptor.accept(element);
    }

    public SVGElement getNestedElement() {
        return this.myNestedElement;
    }

    private class MetaVisitor
    implements ChildrenAcceptor.Visitor {
        private MetaVisitor() {
        }

        public boolean visit(Element element) {
            String name = element.getLocalName();
            if (!(element instanceof SVGElement)) {
                return true;
            }
            SVGElement svgElement = (SVGElement)element;
            if (!MetaData.METADATA.equals(name)) {
                MetaData.this.myNestedElement = svgElement;
                return true;
            }
            String display = svgElement.getTrait(MetaData.DISPLAY);
            if (!MetaData.NONE.equals(display)) {
                MetaData.this.myNestedElement = svgElement;
                return true;
            }
            String content = svgElement.getTrait(MetaData.TRAIT_TEXT);
            if (content == null) {
                return true;
            }
            int indx = (content = content.trim()).indexOf(MetaData.EQ);
            if (indx == -1) {
                MetaData.this.put(content, null);
            } else {
                String value = content.substring(0, indx);
                if (indx == content.length() - 1) {
                    MetaData.this.put(value, "");
                } else {
                    MetaData.this.put(value, content.substring(indx + 1));
                }
            }
            return true;
        }
    }
}

