/*
 * Decompiled with CFR 0.152.
 */
package org.chattando;

import java.util.Vector;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Ticker;
import org.chattando.AlertBox;
import org.chattando.ChatScreen;
import org.chattando.Chattando;

public class ClientChat
implements CommandListener,
DiscoveryListener {
    private static final String CHATTANDO_UUID = "A1A2A3A4A5A6A7A8A9A0B1B2B3B4B5B6";
    private static final String CHATTANDO_SERVICE = "Chattando";
    protected Chattando midlet;
    private boolean inquiryProgress = false;
    private boolean devicesFound = false;
    private Command startScanCMD;
    private Command stopScanCMD;
    private Command connectCMD;
    private Command backCMD;
    private DiscoveryAgent discovery_agent;
    private Displayable backDSP;
    private Image phoneIMG = null;
    private List menu_list;
    private Vector remote_device;
    private Vector device_found;
    private Vector transID_vector = new Vector();
    private ClientChat cc = this;

    public ClientChat(Chattando midlet) {
        this.midlet = midlet;
        this.backDSP = midlet.getDisplay().getCurrent();
        this.loadIMGs();
        this.searchDeviceList();
        this.startScanBluetoothDevices();
    }

    private void loadIMGs() {
        try {
            this.phoneIMG = Image.createImage((String)"/org/chattando/imgs/mobile.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void searchDeviceList() {
        this.menu_list = new List("Searching for devices:", 3);
        this.menu_list.setCommandListener((CommandListener)this);
        this.startScanCMD = new Command("Start Search", 8, 1);
        this.stopScanCMD = new Command("Stop Search", 8, 2);
        this.connectCMD = new Command("Connect", 8, 3);
        this.backCMD = new Command("Back", 2, 1);
        this.menu_list.addCommand(this.backCMD);
        this.midlet.getDisplay().setCurrent((Displayable)this.menu_list);
    }

    private void startScanBluetoothDevices() {
        this.menu_list.setTicker(null);
        this.menu_list.setTicker(new Ticker("...Please Wait..."));
        this.menu_list.removeCommand(this.startScanCMD);
        this.menu_list.addCommand(this.stopScanCMD);
        this.menu_list.removeCommand(this.connectCMD);
        try {
            this.devicesFound = false;
            this.inquiryProgress = true;
            this.remote_device = new Vector();
            this.device_found = new Vector();
            this.transID_vector = new Vector();
            this.discovery_agent = LocalDevice.getLocalDevice().getDiscoveryAgent();
            this.discovery_agent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (Exception error) {
            this.menu_list.setTicker(null);
            this.menu_list.addCommand(this.startScanCMD);
            this.menu_list.removeCommand(this.stopScanCMD);
            this.inquiryProgress = false;
            final Exception e = error;
            new Thread(){

                public void run() {
                    new AlertBox("Error !!!", e.getMessage(), AlertType.ERROR, ClientChat.this.midlet);
                }
            }.start();
        }
    }

    private void stopScanBluetoothDevices() {
        if (this.inquiryProgress) {
            this.discovery_agent.cancelInquiry((DiscoveryListener)this);
        }
        int i = 0;
        int cnt = this.transID_vector.size();
        while (i < cnt) {
            this.discovery_agent.cancelServiceSearch(((Integer)this.transID_vector.elementAt(i)).intValue());
            ++i;
        }
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (cod.getMajorDeviceClass() == 256 || cod.getMajorDeviceClass() == 512) {
            this.remote_device.addElement(btDevice);
        }
    }

    public void inquiryCompleted(int discType) {
        switch (discType) {
            case 0: {
                System.out.println("Device Search Completed");
                break;
            }
            case 7: {
                System.out.println("Device Search Error");
                break;
            }
            case 5: {
                System.out.println("Device Search Terminated");
            }
        }
        this.inquiryProgress = false;
        if (this.remote_device.size() == 0) {
            this.menu_list.setTicker(null);
            this.menu_list.setTitle("Devices Not Found:");
            this.menu_list.addCommand(this.startScanCMD);
            this.menu_list.removeCommand(this.stopScanCMD);
        } else {
            new Thread(){

                public void run() {
                    try {
                        int i = 0;
                        int cnt = ClientChat.this.remote_device.size();
                        while (i < cnt) {
                            ClientChat.this.transID_vector.addElement(new Integer(ClientChat.this.discovery_agent.searchServices(new int[]{256}, new UUID[]{new UUID(3L), new UUID(ClientChat.CHATTANDO_UUID, false)}, (RemoteDevice)ClientChat.this.remote_device.elementAt(i), (DiscoveryListener)ClientChat.this.cc)));
                            ClientChat.this.waitForSearchDone();
                            ++i;
                        }
                    }
                    catch (Exception error) {
                        Exception e = error;
                        new Thread(this, e){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ Exception val$e;
                            {
                                this.this$1 = var1_1;
                                this.val$e = exception;
                            }

                            public void run() {
                                new AlertBox("Error !!!", this.val$e.getMessage(), AlertType.ERROR, 2.access$0(this.this$1).midlet);
                            }
                        }.start();
                    }
                }

                static /* synthetic */ ClientChat access$0(2 var0) {
                    return var0.ClientChat.this;
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSearchDone() {
        try {
            ClientChat clientChat = this;
            synchronized (clientChat) {
                this.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int respCode) {
        switch (respCode) {
            case 1: {
                System.out.println("Service Search Completed");
                break;
            }
            case 6: {
                System.out.println("Service Search Device not Reachable");
                break;
            }
            case 3: {
                System.out.println("Service Search Error");
                break;
            }
            case 4: {
                System.out.println("Service Search No Records");
                break;
            }
            case 2: {
                System.out.println("Service Search Terminated");
            }
        }
        ClientChat clientChat = this;
        synchronized (clientChat) {
            this.notifyAll();
        }
        this.menu_list.setTicker(null);
        this.menu_list.setTitle(this.devicesFound ? "Devices Found:" : "Devices Not Found");
        this.menu_list.addCommand(this.startScanCMD);
        this.menu_list.removeCommand(this.stopScanCMD);
        if (this.devicesFound) {
            this.menu_list.addCommand(this.connectCMD);
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        int i = 0;
        int cnt = servRecord.length;
        while (i < cnt) {
            if (((String)servRecord[i].getAttributeValue(256).getValue()).equalsIgnoreCase(CHATTANDO_SERVICE)) {
                this.device_found.addElement(servRecord[i]);
                this.devicesFound = true;
                try {
                    this.menu_list.append(servRecord[i].getHostDevice().getFriendlyName(false), this.phoneIMG);
                }
                catch (Exception error) {
                    this.menu_list.append(servRecord[i].getHostDevice().getBluetoothAddress(), this.phoneIMG);
                }
            }
            ++i;
        }
    }

    public void commandAction(Command cmd, Displayable dsp) {
        if (cmd == this.startScanCMD) {
            this.menu_list.deleteAll();
            this.startScanBluetoothDevices();
        } else if (cmd == this.stopScanCMD) {
            this.stopScanBluetoothDevices();
        } else if (cmd == this.connectCMD) {
            new Thread(){

                public void run() {
                    try {
                        ClientChat.this.midlet.getDisplay().setCurrent((Displayable)new ChatScreen("Chattando Screen", (StreamConnection)Connector.open((String)((ServiceRecord)ClientChat.this.device_found.elementAt(ClientChat.this.menu_list.getSelectedIndex())).getConnectionURL(0, false)), ClientChat.this.midlet));
                        System.gc();
                    }
                    catch (Exception error) {
                        Exception e = error;
                        new Thread(this, e){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ Exception val$e;
                            {
                                this.this$1 = var1_1;
                                this.val$e = exception;
                            }

                            public void run() {
                                new AlertBox("Error !!!", this.val$e.getMessage(), AlertType.ERROR, 4.access$0(this.this$1).midlet);
                            }
                        }.start();
                    }
                }

                static /* synthetic */ ClientChat access$0(4 var0) {
                    return var0.ClientChat.this;
                }
            }.start();
        } else if (cmd == this.backCMD) {
            this.stopScanBluetoothDevices();
            this.midlet.getDisplay().setCurrent(this.backDSP);
            System.gc();
        }
    }
}

