/*
 * Decompiled with CFR 0.152.
 */
package org.chattando;

import java.util.Vector;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ScrollingMessage
extends CustomItem {
    private static final float LINES_FACTOR = 1.5f;
    private static final int XOFFSET = 5;
    private static final int YOFFSET = 3;
    private boolean upArrowShow = false;
    private boolean downArrowShow = false;
    private int width;
    private int height;
    private int fontHeight;
    private int maxLinesVisible;
    private int maxLines;
    private int numCurrentLines = 0;
    private int numCurrentLinesCopy;
    private Font font;
    private Vector lines = new Vector();

    protected ScrollingMessage(String title, int width, int height) {
        super(title);
        this.width = width;
        this.height = height;
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.fontHeight = this.font.getHeight();
        this.maxLinesVisible = (height - 4) / this.fontHeight;
        this.maxLines = (int)(1.5f * (float)this.maxLinesVisible);
    }

    protected int getMinContentHeight() {
        return this.height;
    }

    protected int getMinContentWidth() {
        return this.width;
    }

    protected int getPrefContentHeight(int height) {
        return this.height;
    }

    protected int getPrefContentWidth(int width) {
        return this.width;
    }

    private String[] splitString(String str, String delims) {
        if (str == null) {
            return null;
        }
        if (str.equals("") || delims == null || delims.length() == 0) {
            return new String[]{str};
        }
        Vector<String> v = new Vector<String>();
        int pos = 0;
        int newpos = str.indexOf(delims, pos);
        while (newpos != -1) {
            v.addElement(str.substring(pos, newpos));
            pos = newpos + delims.length();
            newpos = str.indexOf(delims, pos);
        }
        v.addElement(str.substring(pos));
        String[] s = new String[v.size()];
        int i = 0;
        int cnt = s.length;
        while (i < cnt) {
            s[i] = (String)v.elementAt(i);
            ++i;
        }
        return s;
    }

    public void addMessage(String text) {
        if (text.length() == 1) {
            return;
        }
        char number = text.charAt(0);
        StringBuffer sb = new StringBuffer();
        String[] txt = this.splitString(text.substring(1), " ");
        Vector<String> mex = new Vector<String>();
        int i = 0;
        int cnt = txt.length;
        while (i < cnt) {
            if (this.font.stringWidth(String.valueOf(sb.toString()) + txt[i]) >= this.width - 20) {
                mex.addElement(String.valueOf(number) + sb.toString());
                sb.delete(0, sb.length());
                sb.append(String.valueOf(txt[i]) + " ");
            } else {
                sb.append(String.valueOf(txt[i]) + " ");
            }
            ++i;
        }
        if (sb.toString().length() > 0) {
            mex.addElement(String.valueOf(number) + sb.toString());
        }
        i = 0;
        cnt = mex.size();
        while (i < cnt) {
            int size = this.lines.size();
            this.numCurrentLines = this.numCurrentLinesCopy;
            if (size > this.maxLines) {
                this.lines.removeElementAt(0);
                --this.numCurrentLines;
            }
            this.lines.addElement(mex.elementAt(i));
            this.upArrowShow = ++this.numCurrentLines > this.maxLinesVisible;
            this.downArrowShow = false;
            this.numCurrentLinesCopy = this.numCurrentLines;
            ++i;
        }
        this.repaint();
    }

    public void moveUp() {
        this.upArrowShow = true;
        this.downArrowShow = true;
        if (--this.numCurrentLines <= this.maxLinesVisible) {
            this.numCurrentLines = this.maxLinesVisible;
            if (this.numCurrentLinesCopy <= this.maxLinesVisible) {
                this.upArrowShow = false;
                this.downArrowShow = false;
            } else {
                this.upArrowShow = false;
            }
        }
        this.repaint();
    }

    public void moveDown() {
        this.upArrowShow = true;
        this.downArrowShow = true;
        if (++this.numCurrentLines >= this.numCurrentLinesCopy) {
            this.numCurrentLines = this.numCurrentLinesCopy;
            if (this.numCurrentLinesCopy <= this.maxLinesVisible) {
                this.upArrowShow = false;
                this.downArrowShow = false;
            } else {
                this.downArrowShow = false;
            }
        }
        this.repaint();
    }

    protected void paint(Graphics g, int width, int height) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, width, height);
        g.setColor(0, 0, 0);
        g.drawRect(1, 1, width - 2, height - 2);
        g.setFont(this.font);
        int yoffset = 3;
        int i = this.numCurrentLines > this.maxLinesVisible ? this.numCurrentLines - this.maxLinesVisible : 0;
        int cnt = this.lines.size();
        while (i < cnt) {
            if (((String)this.lines.elementAt(i)).charAt(0) == '0') {
                g.setColor(18, 29, 251);
            } else {
                g.setColor(253, 51, 51);
            }
            g.drawString(((String)this.lines.elementAt(i)).substring(1), 5, yoffset, 20);
            yoffset += this.fontHeight;
            ++i;
        }
        this.drawScrollBar(g, width, height);
    }

    protected void keyReleased(int keyCode) {
        int key = this.getGameAction(keyCode);
        if (key == 1) {
            this.moveUp();
        } else if (key == 6) {
            this.moveDown();
        }
    }

    protected void keyRepeated(int keyCode) {
        int key = this.getGameAction(keyCode);
        if (key == 1) {
            this.moveUp();
        } else if (key == 6) {
            this.moveDown();
        }
    }

    private void drawScrollBar(Graphics g, int width, int height) {
        g.setColor(128, 128, 128);
        g.fillRect(width - 14, 13, 6, height - 26);
        g.setColor(0, 0, 0);
        if (!this.upArrowShow) {
            g.setColor(128, 128, 128);
            g.fillArc(width - 17, 7, 12, 12, 0, 360);
            g.setColor(0, 0, 0);
        } else {
            g.fillTriangle(width - 11, 6, width - 6, 18, width - 16, 18);
        }
        if (!this.downArrowShow) {
            g.setColor(128, 128, 128);
            g.fillArc(width - 17, height - 19, 12, 12, 0, 360);
            g.setColor(0, 0, 0);
        } else {
            g.fillTriangle(width - 11, height - 6, width - 6, height - 18, width - 16, height - 18);
        }
    }
}

