/*
 * Decompiled with CFR 0.152.
 */
package org.chattando;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import org.chattando.AlertBox;
import org.chattando.Chattando;
import org.chattando.ScrollingMessage;

public class ChatScreen
extends Form
implements CommandListener,
Runnable {
    protected Chattando midlet;
    private Command sendCMD;
    private Command disconnectCMD;
    private Command backCMD;
    private Font font;
    private InputStream in;
    private OutputStream out;
    private ScrollingMessage scroll_message;
    private StreamConnection conn;
    private TextField text_field;

    public ChatScreen(String title, StreamConnection conn, Chattando midlet) {
        super(title);
        this.setCommandListener(this);
        this.midlet = midlet;
        this.conn = conn;
        this.font = Font.getFont((int)0, (int)0, (int)8);
        try {
            this.in = conn.openInputStream();
            this.out = conn.openOutputStream();
        }
        catch (Exception error) {
            final Exception e = error;
            final Chattando m = midlet;
            new Thread(){

                public void run() {
                    new AlertBox("Error !!!", e.getMessage(), AlertType.ERROR, m);
                }
            }.start();
        }
        new Thread(this).start();
        this.text_field = new TextField(null, "", 100, 0);
        this.text_field.setPreferredSize(this.getWidth(), this.text_field.getPreferredHeight());
        this.scroll_message = new ScrollingMessage("...", this.getWidth(), this.getHeight() - this.text_field.getPreferredHeight() - 20);
        this.append((Item)this.scroll_message);
        this.append((Item)this.text_field);
        this.sendCMD = new Command("\u0414\u0430!", 8, 1);
        this.addCommand(this.sendCMD);
        this.disconnectCMD = new Command("\u041e\u0442\u0441\u043e\u0435\u0434\u0435\u043d\u0438\u0442\u044c\u0441\u044f", 8, 1);
        this.addCommand(this.disconnectCMD);
        this.backCMD = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 1);
        this.addCommand(this.backCMD);
    }

    private void disconnect() {
        this.sendMSG("\u0412\u042b\u0425\u041e\u0414$$");
        this.removeCommand(this.sendCMD);
        this.removeCommand(this.disconnectCMD);
        try {
            this.in.close();
            this.out.close();
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] splitString(String str, String delims) {
        if (str == null) {
            return null;
        }
        if (str.equals("") || delims == null || delims.length() == 0) {
            return new String[]{str};
        }
        Vector<String> v = new Vector<String>();
        int pos = 0;
        int newpos = str.indexOf(delims, pos);
        while (newpos != -1) {
            v.addElement(str.substring(pos, newpos));
            pos = newpos + delims.length();
            newpos = str.indexOf(delims, pos);
        }
        v.addElement(str.substring(pos));
        String[] s = new String[v.size()];
        int i = 0;
        int cnt = s.length;
        while (i < cnt) {
            s[i] = (String)v.elementAt(i);
            ++i;
        }
        return s;
    }

    public void commandAction(Command cmd, Displayable dsp) {
        if (cmd == this.sendCMD) {
            String[] txt = this.splitString(this.text_field.getString(), " ");
            boolean TextPermit = true;
            int i = 0;
            int cnt = txt.length;
            while (i < cnt) {
                if (this.font.stringWidth(txt[i]) > this.getWidth() - 20) {
                    TextPermit = false;
                    break;
                }
                ++i;
            }
            if (TextPermit) {
                this.sendMSG("0" + this.text_field.getString());
                this.scroll_message.addMessage("1" + this.text_field.getString());
                this.text_field.setString("");
            } else {
                new Thread(){

                    public void run() {
                        new AlertBox("\u041e\u0448\u0438\u0431\u043e\u0447\u043a\u0430 \u0432\u044b\u0448\u043b\u0430 :( , \u0441\u043e\u0432\u0435\u0442 : \u043a\u0443\u043f\u0438\u0442\u0435 \u043d\u043e\u0432\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d :)", ":|", AlertType.ERROR, ChatScreen.this.midlet);
                    }
                }.start();
            }
        } else if (cmd == this.disconnectCMD) {
            this.disconnect();
        } else if (cmd == this.backCMD) {
            this.disconnect();
            this.midlet.getDisplay().setCurrent((Displayable)this.midlet.main_menu);
            System.gc();
        }
    }

    private void sendMSG(String text) {
        try {
            this.out.write(text.getBytes());
            this.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        byte[] buffer = new byte[128];
        int rd = 0;
        try {
            while ((rd = this.in.read(buffer)) > 0) {
                Thread.sleep(100L);
                String msg = new String(buffer, 0, rd);
                if (msg.equalsIgnoreCase("\u0412\u042b\u0425\u041e\u0414$$")) {
                    this.scroll_message.addMessage("1__\u0412\u042b\u0425\u041e\u0414__");
                    this.disconnect();
                    break;
                }
                this.scroll_message.addMessage(msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

