/*
 * Decompiled with CFR 0.152.
 */
package joybits.disciples;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import joybits.disciples.ArmyCharacter;
import joybits.disciples.ArmyController;
import joybits.disciples.DisCanvas;
import joybits.disciples.FontParam;
import joybits.disciples.GlobalConstants;
import joybits.disciples.Globals;
import joybits.disciples.KeyCodeInterface;
import joybits.disciples.Map;
import joybits.disciples.StringParamInterface;
import joybits.disciples.StringProcessor;

public class Battle
implements KeyCodeInterface,
GlobalConstants,
StringParamInterface,
FontParam {
    public static Battle instance;
    public Image bg = null;
    public Image[] battleUnitsImg;
    public byte DEAD_INDEX = (byte)12;
    public byte DEATH_INDEX = (byte)13;
    public byte HURT_INDEX = (byte)14;
    public int hurtType = 0;
    public byte[] imageIndexes;
    public byte[] globalIndexes;
    public Image lifeMeterImg = null;
    public boolean fast;
    public int shakeX;
    public int shakeY;
    public boolean shaking = false;
    public byte selectedSideInFrame = 0;
    public byte selectedAtrefact = 0;
    private boolean hurtAnimEnds;
    private boolean persAnimEnds;
    private boolean deathAnimEnds;
    public boolean victory = false;
    public boolean defeat = false;
    public static int HEROES_ANIMATIONS;
    public static int NEUTRAL_ANIMATIONS;
    public static int BATTLE_ANIMATIONS;
    public static int DEAD_ANIMATION;
    public static int HURT_ANIMATION;
    public static int DEATH_ANIMATION;
    public byte[][] animation;
    public byte[] frames;
    public byte[] ticks;
    public boolean[] justDead;
    public byte army1 = (byte)-1;
    public byte army2 = (byte)-1;
    public short XP_1 = 0;
    public short XP_2 = 0;
    public byte[] availAb;
    public byte availAbCount = 0;
    public byte winId;
    public boolean battleFinished = false;
    public boolean humanTurn = true;
    byte a1x;
    byte a2x;
    byte a1y;
    byte a2y;
    public byte selectedUnitIndex = (byte)10;
    public byte oldSelectedUnitIndex = (byte)10;
    public Image cursorImg = null;
    public Image shadowImg = null;
    public byte attackingUnitIndex;
    public byte applyArtefactAI = (byte)-1;
    public boolean drawLeftFrames = false;
    public boolean drawRightFrames = false;
    public boolean drawAnyFrames = false;
    public short[] unitStaticParams = new short[]{150, 50, 50, 0, 60, 150, 90, 1040, 60, 0, 60, 145, 100, -40, 10, 0, 40, 100, 90, 540, 60, 0, 60, 150, 150, 50, 50, 0, 60, 150, 90, 1040, 60, 0, 60, 145, 100, -40, 10, 0, 50, 120, 65, 530, 60, 0, 60, 150, 65, 25, 65, 0, 25, 95, 110, 35, 75, 0, 35, 120, 120, 35, 50, 0, 45, 150, 50, 15, 30, 0, 15, 85, 40, 1015, 50, 0, 12, 75, 200, 55, 40, 0, 60, 160, 800, 590, 35, 0, 500, 2275, 100, 25, 50, 0, 20, 80, 150, 50, 50, 0, 60, 475, 200, 75, 50, 0, 120, 950, 275, 100, 50, 0, 200, 1600, 35, 515, 40, 0, 15, 75, 65, 530, 40, 0, 55, 550, 95, 545, 40, 0, 120, 1200, 125, 560, 40, 0, 210, 2100, 70, 1025, 60, 0, 20, 70, 90, 1040, 60, 0, 60, 500, 135, 1060, 60, 0, 180, 1100, 80, -1020, 10, 0, 20, 80, 100, -540, 10, 0, 140, 1125, 125, -570, 10, 0, 305, 2050, 120, 20, 50, 0, 25, 95, 170, 50, 50, 0, 70, 550, 220, 75, 50, 0, 130, 1050, 270, 100, 50, 0, 215, 1725, 45, 515, 40, 0, 20, 75, 75, 530, 40, 0, 65, 500, 105, 545, 40, 0, 130, 1325, 90, 1040, 60, 0, 100, 400, 150, 1065, 60, 0, 410, 1650, 170, 1085, 60, 0, 810, 2500, 170, 50, 35, 0, 70, 275, 270, 80, 35, 0, 175, 850, 170, 60, 35, 0, 55, 155, 900, 110, 90, 0, 300, 0, 900, 110, 90, 0, 300, 0};
    public static final byte[] ABILITIES_PER_LEVEL;
    public int[] unitPos = new int[]{131, 106, 74, 107, 90, 60, 169, 142, 112, 184, 156, 127, 127, 140, 150, 107, 118, 130, 146, 159, 172, 168, 180, 191};
    public byte[] nextUnitIndexOnRight = new byte[]{6, 7, 8, 0, 1, 2, 9, 10, 11, 3, 4, 5};
    public byte[] nextUnitIndexOnLeft = new byte[]{3, 4, 5, 9, 10, 11, 0, 1, 2, 6, 7, 8};
    public byte[] drawingSequence = new byte[]{3, 4, 0, 5, 1, 6, 2, 7, 9, 8, 10, 11};
    public byte[] attackSequence;
    public byte currentTurn;
    byte curImgIndex;
    public byte currArtInhand = (byte)-1;

    public Battle() {
        instance = this;
    }

    public void createArrays() {
        this.battleUnitsImg = new Image[18];
        this.imageIndexes = new byte[12];
        this.globalIndexes = new byte[13];
        this.clearArtefactMagic();
        for (int i = 0; i < 12; ++i) {
            this.imageIndexes[i] = -1;
            this.globalIndexes[i] = -1;
        }
        this.curImgIndex = 0;
        if (this.lifeMeterImg == null) {
            this.lifeMeterImg = Globals.loadImage(39);
        }
    }

    public void createArmyImg(int army, boolean secArmy) {
        if (army == -1) {
            return;
        }
        ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(army);
        for (int i = secArmy ? 6 : 0; i < (secArmy ? 12 : 6); ++i) {
            short unitIndex = ac.units[i % 6];
            if (unitIndex == -1) {
                this.imageIndexes[i] = -1;
                continue;
            }
            short imageIndex = ArmyController.instance.battleUnits[unitIndex * 5 + 0];
            if (imageIndex == -1) {
                this.imageIndexes[i] = -1;
                continue;
            }
            int imageExistsIndex = -1;
            for (int j = 0; j < this.curImgIndex; ++j) {
                if (this.globalIndexes[j] != imageIndex) continue;
                imageExistsIndex = j;
                break;
            }
            this.imageIndexes[i] = this.curImgIndex;
            if (imageExistsIndex == -1) {
                if (this.battleUnitsImg[this.curImgIndex] == null) {
                    this.battleUnitsImg[this.curImgIndex] = Globals.loadImage(1005 + imageIndex);
                }
                this.globalIndexes[this.curImgIndex] = (byte)imageIndex;
                this.curImgIndex = (byte)(this.curImgIndex + 1);
                continue;
            }
            this.imageIndexes[i] = (byte)imageExistsIndex;
        }
    }

    public void addRIPandHurt() {
        if (this.battleUnitsImg[this.DEAD_INDEX] == null) {
            this.battleUnitsImg[this.DEAD_INDEX] = Globals.loadImage(1049);
        }
        if (this.battleUnitsImg[this.DEATH_INDEX] == null) {
            this.battleUnitsImg[this.DEATH_INDEX] = Globals.loadImage(14);
        }
        for (int i = 0; i < 4; ++i) {
            if (this.battleUnitsImg[this.HURT_INDEX + i] != null) continue;
            this.battleUnitsImg[this.HURT_INDEX + i] = Globals.loadImage(27 + i);
        }
    }

    public void checkOnAttackTriggers(byte army1, byte army2) {
        for (int i = 0; i < Map.instance.triggersCount; ++i) {
            byte param1;
            byte type = Map.instance.triggers[i * 7 + 1];
            byte enabled = Map.instance.triggers[i * 7 + 3];
            if (type != 3 || enabled == 0 || (param1 = Map.instance.triggers[i * 7 + 4]) != army1 && param1 != army2) continue;
            DisCanvas.instance.returnGameState = DisCanvas.instance.nextGameState;
            byte next = Map.instance.triggers[i * 7 + 2];
            ArmyController.instance.activateTrigger(next);
            Map.instance.triggers[i * 7 + 3] = 0;
        }
    }

    public void prepare(byte _army1, byte _army2) {
        ArmyCharacter ac1 = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(_army1);
        ArmyCharacter ac2 = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(_army2);
        this.XP_1 = 0;
        this.XP_2 = 0;
        this.fast = false;
        this.prepareEssential(_army1, _army2);
        this.a1x = ac1.x;
        this.a1y = ac1.y;
        this.a2x = ac2.x;
        this.a2y = ac2.y;
        int curTileType = 0xFF & Map.instance.tiles[this.a2x][this.a2y];
        int locationType = 1;
        if ((curTileType &= 0x3F) < 16) {
            locationType = 2;
        }
        if (curTileType >= 32) {
            locationType = 0;
        }
        if (Map.instance.isTownOnCellAi(this.a1x, this.a1y) != -1) {
            locationType = 3;
        }
        this.bg = Globals.loadImage(1000 + locationType);
        if (this.cursorImg == null) {
            this.cursorImg = Globals.loadImage(1004);
        }
        if (this.shadowImg == null) {
            this.shadowImg = Globals.loadImage(56);
        }
        if (this.lifeMeterImg == null) {
            this.lifeMeterImg = Globals.loadImage(39);
        }
        if (DisCanvas.instance.inventoryImg == null) {
            DisCanvas.instance.inventoryImg = Globals.loadImage(37);
        }
        DisCanvas.instance.cursorType = 0;
        this.createArrays();
        this.createArmyImg(_army1, false);
        this.createArmyImg(_army2, true);
        this.addRIPandHurt();
        this.resetAnimation();
        this.shuffleAnimation();
        DisCanvas.instance.nextGameState = (byte)12;
        this.checkOnAttackTriggers(ac1.id, ac2.id);
        this.drawUserBar();
    }

    public void clearArtefactMagic() {
        for (int i = 0; i < ArmyController.instance.battleUnitsCount; ++i) {
            int n = i * 5 + 4;
            ArmyController.instance.battleUnits[n] = (short)(ArmyController.instance.battleUnits[n] & 0xFFFFFFFE);
            int n2 = i * 5 + 4;
            ArmyController.instance.battleUnits[n2] = (short)(ArmyController.instance.battleUnits[n2] & 0xFFFFFFFD);
            int n3 = i * 5 + 4;
            ArmyController.instance.battleUnits[n3] = (short)(ArmyController.instance.battleUnits[n3] & 0xFFFFFFFB);
        }
    }

    public void clearMagic() {
        for (int i = 0; i < ArmyController.instance.battleUnitsCount; ++i) {
            int n = i * 5 + 4;
            ArmyController.instance.battleUnits[n] = (short)(ArmyController.instance.battleUnits[n] & 0xFFFFFFF7);
            int n2 = i * 5 + 4;
            ArmyController.instance.battleUnits[n2] = (short)(ArmyController.instance.battleUnits[n2] & 0xFFFFFFEF);
            int n3 = i * 5 + 4;
            ArmyController.instance.battleUnits[n3] = (short)(ArmyController.instance.battleUnits[n3] & 0xFFFFFFDF);
            int n4 = i * 5 + 4;
            ArmyController.instance.battleUnits[n4] = (short)(ArmyController.instance.battleUnits[n4] & 0xFFFFFFBF);
            int n5 = i * 5 + 4;
            ArmyController.instance.battleUnits[n5] = (short)(ArmyController.instance.battleUnits[n5] & 0xFFFFFF7F);
        }
    }

    public void prepareEssential(byte _army1, byte _army2) {
        this.army1 = _army1;
        this.army2 = _army2;
        this.XP_1 = 0;
        this.XP_2 = 0;
        this.battleFinished = false;
        this.attackSequence = new byte[12];
        this.clearArtefactMagic();
        this.buildAttackSequence();
        this.currentTurn = 0;
        this.attackingUnitIndex = this.attackSequence[this.currentTurn];
        this.oldSelectedUnitIndex = this.selectedUnitIndex = (byte)((1 - this.attackingUnitIndex / 6) * 6 + 1);
    }

    public void readPakAnimation() {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/data.pak0");
            DataInputStream dis = new DataInputStream(is);
            for (int curAnimIndex = 0; curAnimIndex < 168; curAnimIndex = (int)((short)(curAnimIndex + 1))) {
                int animSize = 0;
                animSize = dis.read();
                if (curAnimIndex == 80) {
                    animSize = 471;
                }
                if (curAnimIndex == 82) {
                    animSize = 309;
                }
                if (curAnimIndex == 158) {
                    animSize = 311;
                }
                if (curAnimIndex == 163) {
                    animSize = 827;
                }
                this.animation[curAnimIndex] = new byte[animSize];
                boolean currPos = false;
                for (int j = 0; j < animSize; ++j) {
                    this.animation[curAnimIndex][j] = (byte)(0xFF & dis.read());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadAnimation() {
        int animationsCount = 168;
        this.animation = new byte[animationsCount][];
        this.frames = new byte[21];
        this.ticks = new byte[21];
        this.justDead = new boolean[12];
        this.readPakAnimation();
        HEROES_ANIMATIONS = 0;
        NEUTRAL_ANIMATIONS = 64;
        BATTLE_ANIMATIONS = 71;
        DEAD_ANIMATION = 159;
        DEATH_ANIMATION = 160;
        HURT_ANIMATION = 161;
        this.resetAnimation();
        this.shuffleAnimation();
    }

    public int getFrame(int index, int frameN) {
        return this.getPiece(index, frameN, 0) - 4;
    }

    public int getPiece(int index, int frameN, int pieceN) {
        boolean pos = false;
        int fullSize = 0;
        fullSize += 3;
        byte framesCount = this.animation[index][0];
        for (int i = 0; i < frameN; ++i) {
            byte piecesCount = this.animation[index][fullSize + 0];
            fullSize += 4;
            fullSize += piecesCount * 6;
        }
        fullSize += 4;
        return fullSize += pieceN * 6;
    }

    public int getAnotherFuckingIndex(int i) {
        ArmyCharacter ac;
        if (i < 0 || i > 11) {
            return -1;
        }
        if (i < 6) {
            if (this.army1 == -1) {
                return -1;
            }
            if (ArmyController.instance.armyVector.size() <= this.army1) {
                return -1;
            }
            ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(this.army1);
        } else {
            if (this.army2 == -1) {
                return -1;
            }
            if (ArmyController.instance.armyVector.size() <= this.army2) {
                return -1;
            }
            ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(this.army2);
        }
        return ac.units[i % 6];
    }

    public void buildAttackSequence() {
        int current = 0;
        for (int i = 0; i < 12; ++i) {
            this.attackSequence[i] = -1;
        }
        current = 0;
        for (int n = 0; n < 12; n = (int)((byte)(n + 1))) {
            int max = -1;
            int maxN = -1;
            for (int i = 0; i < 12; i = (byte)(i + 1)) {
                int initiative;
                boolean skip = false;
                for (int j = 0; j < 12; ++j) {
                    if (this.attackSequence[j] != i) continue;
                    skip = true;
                }
                if (skip || (initiative = this.getInitiative(i)) <= max || this.getHpLeft(i) <= 0) continue;
                max = initiative;
                maxN = i;
            }
            this.attackSequence[current] = maxN;
            ++current;
        }
        this.humanTurn = this.attackSequence[0] < 6;
    }

    public void free() {
        for (int i = 0; i < 13; ++i) {
            this.battleUnitsImg[i] = null;
        }
        this.battleUnitsImg[13] = null;
        this.battleUnitsImg = null;
        this.shadowImg = null;
        this.imageIndexes = null;
        DisCanvas.instance.inventoryImg = null;
        this.bg = null;
        this.cursorImg = null;
        System.gc();
    }

    public void drawHurt(Graphics g, byte i) {
        boolean attacked;
        if (this.hurtAnimEnds) {
            return;
        }
        boolean bl = attacked = i == this.selectedUnitIndex;
        if (DisCanvas.instance.currGameState == 15 && attacked) {
            boolean attackAll;
            int attackingUnitDamage = this.getDamage(this.attackingUnitIndex);
            boolean bl2 = attackAll = Globals.abs(attackingUnitDamage) >= 500 && Globals.abs(attackingUnitDamage) < 1000;
            if (attackAll && this.selectedUnitIndex / 6 == i / 6) {
                attacked = true;
            }
            if (attackAll) {
                byte init;
                for (byte j = init = (byte)(i >= 6 ? 6 : 0); j < (byte)(init + 6); j = (byte)(j + 1)) {
                    if (this.getHpLeft(j) <= 0) continue;
                    int x = this.unitPos[j];
                    int y = this.unitPos[j + 12];
                    if (this.shaking) {
                        x += this.shakeX;
                        y += this.shakeY;
                    }
                    this.drawFrame(g, x, y, HURT_ANIMATION + this.hurtType, this.HURT_INDEX + this.hurtType, this.frames[this.HURT_INDEX + this.hurtType], true);
                    System.out.println("hurt anim");
                }
            } else {
                int x = this.unitPos[i];
                int y = this.unitPos[i + 12];
                if (this.shaking) {
                    x += this.shakeX;
                    y += this.shakeY;
                }
                this.drawFrame(g, x, y, HURT_ANIMATION + this.hurtType, this.HURT_INDEX + this.hurtType, this.frames[this.HURT_INDEX + this.hurtType], true);
            }
        }
    }

    public void drawDeath(Graphics g, byte i) {
        if (this.justDead[i]) {
            this.drawFrame(g, this.unitPos[i], this.unitPos[i + 12], DEATH_ANIMATION, this.DEATH_INDEX, this.frames[this.DEATH_INDEX], true);
        }
    }

    public void drawFrame(Graphics g, int x, int y, int animIndex, int imageIndex, int frame, boolean inBattle) {
        if (animIndex == -1) {
            return;
        }
        int frameStart = this.getFrame(animIndex, frame);
        int piecesCount = this.animation[animIndex][frameStart + 0];
        int centerX = this.animation[animIndex][1] & 0xFF;
        int centerY = this.animation[animIndex][2] & 0xFF;
        for (int m = 0; m < piecesCount; ++m) {
            int pieceStart = this.getPiece(animIndex, frame, m);
            int xOffset = this.animation[animIndex][pieceStart + 0] & 0xFF;
            int yOffset = this.animation[animIndex][pieceStart + 1] & 0xFF;
            int w = this.animation[animIndex][pieceStart + 2] & 0xFF;
            int h = this.animation[animIndex][pieceStart + 3] & 0xFF;
            int posX = this.animation[animIndex][pieceStart + 4];
            int posY = this.animation[animIndex][pieceStart + 5];
            g.setClip(posX += x - centerX, posY += y - centerY, w, h);
            if (inBattle) {
                g.drawImage(this.battleUnitsImg[imageIndex], posX - xOffset, posY - yOffset, 0);
                continue;
            }
            if (Map.instance.natureImg[imageIndex] == null) {
                Map.instance.natureImg[imageIndex] = Globals.loadImage(DisCanvas.imgNames[imageIndex]);
            }
            g.drawImage(Map.instance.natureImg[imageIndex], posX - xOffset, posY - yOffset, 0);
        }
    }

    public void drawShadows(Graphics g) {
        for (int n = 0; n < 12; ++n) {
            byte i = this.drawingSequence[n];
            int unitType = this.getUnitType(i);
            if (unitType == -1) continue;
            int x = this.unitPos[i] - 15;
            int y = this.unitPos[i + 12] - 6;
            if (this.shaking) {
                x += this.shakeX;
                y += this.shakeY;
            }
            g.setClip(x, y, 31, 13);
            g.drawImage(this.shadowImg, x, y, 0);
        }
    }

    public void drawUnits(Graphics g) {
        int unitType;
        byte i;
        int n;
        for (n = 0; n < 12; ++n) {
            i = this.drawingSequence[n];
            unitType = this.getUnitType(i);
            if (unitType == -1) continue;
            int animIndex = BATTLE_ANIMATIONS + unitType * 2;
            byte imageIndex = this.imageIndexes[i];
            if (imageIndex == -1) continue;
            if (DisCanvas.instance.currGameState == 15 && this.attackingUnitIndex == i) {
                ++animIndex;
            }
            if (this.getHpLeft(i) == 0) {
                animIndex = DEAD_ANIMATION;
                imageIndex = this.DEAD_INDEX;
            }
            int x = this.unitPos[i];
            int y = this.unitPos[i + 12];
            if (this.shaking) {
                x += this.shakeX;
                y += this.shakeY;
            }
            this.drawFrame(g, x, y, animIndex, imageIndex, this.frames[i], true);
            this.drawDeath(g, i);
        }
        for (n = 0; n < 12; ++n) {
            byte imageIndex;
            i = this.drawingSequence[n];
            unitType = this.getUnitType(i);
            if (unitType == -1 || (imageIndex = this.imageIndexes[i]) == -1 || imageIndex == this.DEAD_INDEX) continue;
            int damage = this.getDamage(this.attackingUnitIndex);
            this.hurtType = 0;
            if (damage < 0) {
                this.hurtType = 3;
            }
            if (damage > 500 && damage < 540) {
                this.hurtType = 1;
            }
            if (damage >= 540 && damage < 1000) {
                this.hurtType = 2;
            }
            this.drawHurt(g, i);
        }
    }

    public void drawCursors(Graphics g) {
        boolean attackAll;
        int w = this.cursorImg.getWidth();
        int h = this.cursorImg.getHeight() / 2;
        int x = this.unitPos[this.attackingUnitIndex] - w / 2;
        int y = this.unitPos[this.attackingUnitIndex + 12] - h / 2;
        if (this.shaking) {
            x += this.shakeX;
            y += this.shakeY;
        }
        int color = 0;
        g.setClip(x, y, w, h);
        g.drawImage(this.cursorImg, x, y - color * h, 0);
        if (this.getAnotherFuckingIndex(this.selectedUnitIndex) == -1) {
            return;
        }
        x = this.unitPos[this.selectedUnitIndex] - w / 2;
        y = this.unitPos[this.selectedUnitIndex + 12] - h / 2;
        if (this.shaking) {
            x += this.shakeX;
            y += this.shakeY;
        }
        color = 1;
        int damage = this.getDamage(this.attackingUnitIndex);
        boolean bl = attackAll = Globals.abs(damage) >= 500 && Globals.abs(damage) < 1000;
        if (!attackAll) {
            g.setClip(x, y, w, h);
            g.drawImage(this.cursorImg, x, y - color * h, 0);
        } else {
            for (int i = this.selectedUnitIndex / 6 * 6; i < this.selectedUnitIndex / 6 * 6 + 6; ++i) {
                if (this.getAnotherFuckingIndex(i) == -1) continue;
                x = this.unitPos[i] - w / 2;
                y = this.unitPos[i + 12] - h / 2;
                if (this.shaking) {
                    x += this.shakeX;
                    y += this.shakeY;
                }
                g.setClip(x, y, w, h);
                g.drawImage(this.cursorImg, x, y - color * h, 0);
            }
        }
    }

    public void draw(Graphics g) {
        int shakeStrength;
        if (DisCanvas.instance.currGameState == 15) {
            if (this.hurtType == 1 || this.hurtType == 2) {
                this.shaking = true;
            }
        } else {
            this.shaking = false;
        }
        int n = shakeStrength = this.hurtType == 2 ? 5 : 3;
        if (this.shaking) {
            this.shakeX = Globals.rand(shakeStrength) - shakeStrength / 2;
            this.shakeY = Globals.rand(shakeStrength) - shakeStrength / 2;
        }
        int x = 0;
        int y = 17;
        if (this.shaking) {
            x += this.shakeX;
            y += this.shakeY;
        }
        g.drawImage(this.bg, x, y, 0);
        this.drawShadows(g);
        this.drawCursors(g);
        this.drawUnits(g);
        if (DisCanvas.instance.currGameState != 15 && this.humanTurn) {
            if (this.drawLeftFrames) {
                this.drawFrames(g, false);
            }
            if (this.drawRightFrames) {
                this.drawFrames(g, true);
            }
        }
        this.drawUserBar(g);
        DisCanvas.instance.drawTopBar(g);
        if (DisCanvas.instance.currGameState == 43) {
            DisCanvas.instance.drawSoftBar(g, 429, 248);
        } else {
            DisCanvas.instance.drawSoftBar(g, 60, -1);
        }
        if (this.getUnitType(this.attackingUnitIndex) < 4) {
            DisCanvas.instance.drawArtInhand(g);
        }
        if (!this.drawAnyFrames) {
            DisCanvas.instance.drawCursor(g);
        }
    }

    public void drawBattleInf(Graphics g) {
        if (this.selectedUnitIndex == -1) {
            return;
        }
        ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(this.selectedUnitIndex < 6 ? this.army1 : this.army2);
        if (ac.units[this.selectedUnitIndex % 6] == -1) {
            DisCanvas.instance.interfaceString[0] = "";
            DisCanvas.instance.interfaceTextId[0] = 0;
            DisCanvas.instance.interfaceString[1] = "";
            DisCanvas.instance.interfaceTextId[1] = 0;
            DisCanvas.instance.drawInterface(g);
            return;
        }
        int unitType = this.getUnitType(this.selectedUnitIndex);
        int hpTotal = this.getHpTotal(this.selectedUnitIndex);
        int hpLeft = this.getHpLeft(this.selectedUnitIndex);
        int damage = this.getDamage(this.selectedUnitIndex);
        int initiative = this.getInitiative(this.selectedUnitIndex);
        int defence = this.getDefence(this.selectedUnitIndex);
        int xp = this.getXP(this.selectedUnitIndex);
        int level = this.getLevel(this.selectedUnitIndex);
        short nextLevelXP = this.getXPNext(this.selectedUnitIndex);
        boolean attackAll = Globals.abs(damage) >= 500 && Globals.abs(damage) < 1000;
        String s = "";
        if (unitType < 42) {
            s = (String)Globals.mStringArr.elementAt(398) + ":_" + xp + "/" + nextLevelXP + "^";
        }
        s = s + (String)Globals.mStringArr.elementAt(337) + ":_" + hpLeft + "/" + hpTotal + "^" + (String)Globals.mStringArr.elementAt(damage > 0 ? 338 : 339) + ":_" + Globals.abs(damage % 500) + "^" + (String)Globals.mStringArr.elementAt(340) + ":_" + (attackAll ? 6 : 1) + "^" + (String)Globals.mStringArr.elementAt(341) + ":_" + initiative + "^" + (String)Globals.mStringArr.elementAt(292) + ":_" + defence;
        if (Globals.abs(damage) > 1000) {
            s = s + "^" + (String)Globals.mStringArr.elementAt(342);
        }
        if (unitType < 8 || unitType > 41) {
            s = s + "^" + (String)Globals.mStringArr.elementAt(343) + ":_" + (ac.leadership - 1);
        }
        if (unitType < 42) {
            DisCanvas.instance.interfaceString[0] = (String)Globals.mStringArr.elementAt(85 + unitType) + "^" + (String)Globals.mStringArr.elementAt(336) + "_" + level;
        } else {
            DisCanvas.instance.interfaceTextId[0] = (short)(85 + unitType);
        }
        DisCanvas.instance.interfaceString[1] = s;
        DisCanvas.instance.drawInterface(g);
        short x = DisCanvas.instance.interfacePoints[0];
        short y = DisCanvas.instance.interfacePoints[1];
        this.drawBattleAvatar(g, x, y, this.selectedUnitIndex);
    }

    public void drawUserBar(Graphics g) {
        int y = 256;
        g.setClip(0, y, 240, 50);
        g.drawImage(DisCanvas.instance.userBarBufferImg, 0, y, 0);
    }

    public void drawUserBar() {
        this.redrawUserBar(DisCanvas.instance.userBarBufferGraphics);
    }

    public void redrawUserBar(Graphics g) {
        boolean drawToBuffer;
        int y = 0;
        boolean bl = drawToBuffer = g == DisCanvas.instance.userBarBufferGraphics;
        if (!drawToBuffer) {
            y = 256;
        }
        byte currId = ArmyController.instance.getId();
        ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(currId);
        g.setClip(0, y, 240, 50);
        g.drawImage(DisCanvas.instance.userBarImg, 0, y, 0);
        g.drawImage(DisCanvas.instance.userBarImg, 240 - DisCanvas.instance.userBarImg.getWidth(), y, 0);
        if (DisCanvas.instance.currGameState != 17 && DisCanvas.instance.currGameState != 25) {
            if (this.attackingUnitIndex / 6 != this.selectedUnitIndex / 6 || this.getAnotherFuckingIndex(this.selectedUnitIndex) == -1) {
                this.fillUserBar(g, this.attackingUnitIndex, this.attackingUnitIndex / 6 != 0);
            }
            this.fillUserBar(g, this.selectedUnitIndex, this.selectedUnitIndex / 6 != 0);
        } else {
            this.fillUserBar(g, -1, true);
            this.fillUserBar(g, ac.leader, false);
        }
    }

    public void drawAvatar(Graphics g, int x, int y, int index) {
        g.setClip(x, y, 36, 36);
        int trueIndex = Globals.abs(index);
        int tileOffsetX = trueIndex % 5 * 36;
        int tileOffsetY = trueIndex / 5 * 36;
        g.drawImage(DisCanvas.instance.avatarsImg, x - tileOffsetX, y - tileOffsetY, 0);
    }

    public void drawBattleAvatar(Graphics g, int x, int y, int i) {
        int battleIndex;
        int hpLeft = this.getHpLeft(i);
        int hpTotal = this.getHpTotal(i);
        int index = this.getUnitType(i);
        if (hpLeft == 0) {
            index = 47;
        }
        if (hpLeft < 0) {
            index = 46;
        }
        this.drawAvatar(g, x, y, index);
        if (index != 47 && index != 46 && hpLeft != hpTotal && hpLeft != 0) {
            int barHeight = hpLeft * 36 / hpTotal;
            g.setClip(x, y + barHeight, 36, 36 - barHeight);
            g.drawImage(this.lifeMeterImg, x, y, 0);
        }
        if ((battleIndex = this.getAnotherFuckingIndex(i)) != -1) {
            short spells = ArmyController.instance.battleUnits[battleIndex * 5 + 4];
            if (this.needLevelUp(battleIndex) && (spells & 0x100) == 0) {
                g.setClip(0, 0, 240, 320);
                g.drawImage(DisCanvas.instance.levelUpImg, x + 36 - 6, y + 1, 0);
            }
        }
    }

    public void fillUserBar(Graphics g, int index, boolean right) {
        boolean drawToBuffer;
        if (index == -1) {
            return;
        }
        int unitType = 0;
        int hpTotal = 0;
        int hpLeft = 0;
        int damage = 0;
        unitType = this.getUnitType(index);
        hpTotal = this.getHpTotal(index);
        hpLeft = this.getHpLeft(index);
        damage = this.getDamage(index);
        boolean attackAll = Globals.abs(damage) >= 500 && Globals.abs(damage) < 1000;
        int y = 0;
        boolean bl = drawToBuffer = g == DisCanvas.instance.userBarBufferGraphics;
        if (!drawToBuffer) {
            y = 256;
        }
        int w = DisCanvas.instance.userBarImg.getWidth();
        int textWidth = w - 36 - 8 - 4;
        String s = "";
        s = (String)Globals.mStringArr.elementAt(85 + unitType) + "^HP:_" + hpLeft + "/" + hpTotal;
        g.setClip(0, y, 240, 50);
        if (!right) {
            if (unitType != -1) {
                int x = 8;
                this.drawBattleAvatar(g, x, y + 7, index);
                StringProcessor stringProc = new StringProcessor(s, textWidth, 50, 2);
                stringProc.drawCentered = true;
                stringProc.paintContent(g, x += 39, y - 1);
            }
        } else if (unitType != -1) {
            int x = 196;
            this.drawBattleAvatar(g, x, y + 7, index);
            x = 129;
            StringProcessor stringProc = new StringProcessor(s, textWidth, 50, 2);
            stringProc.drawCentered = true;
            stringProc.paintContent(g, x, y - 1);
        }
    }

    public int getHpLeft(int i) {
        int anotherIndex = this.getAnotherFuckingIndex(i);
        if (anotherIndex == -1) {
            return -1;
        }
        short hpLeft = ArmyController.instance.battleUnits[anotherIndex * 5 + 1];
        if (hpLeft < 0) {
            hpLeft = 0;
        }
        return hpLeft;
    }

    public short getHpTotalGlobal(int anotherIndex) {
        if (anotherIndex == -1) {
            return -1;
        }
        short unitType = ArmyController.instance.battleUnits[anotherIndex * 5 + 0];
        short hpTotal = this.unitStaticParams[unitType * 6 + 0];
        short level = ArmyController.instance.battleUnits[anotherIndex * 5 + 3];
        short spells = ArmyController.instance.battleUnits[anotherIndex * 5 + 4];
        int typeSection = 1;
        for (int m = 0; m < 8; ++m) {
            if (unitType < DisCanvas.UNITS_TYPE_START[m]) continue;
            typeSection = m + 1;
        }
        byte maxLevel = DisCanvas.BUILDING_TYPE_COUNT[typeSection];
        if (unitType >= 8 && unitType <= 14) {
            maxLevel = 1;
        }
        if ((spells & 0x100) != 0) {
            hpTotal = (short)(hpTotal + hpTotal * (level - maxLevel) / 10);
        }
        if (unitType <= 7) {
            hpTotal = (short)(hpTotal + hpTotal * (level - 1) / 10);
        }
        return hpTotal;
    }

    public int getHpTotal(int i) {
        int anotherIndex = this.getAnotherFuckingIndex(i);
        return this.getHpTotalGlobal(anotherIndex);
    }

    public short getDefenceGlobal(int anotherIndex) {
        short spells;
        if (anotherIndex == -1) {
            return 0;
        }
        short unitType = ArmyController.instance.battleUnits[anotherIndex * 5 + 0];
        ArmyCharacter ac = null;
        short defence = this.unitStaticParams[unitType * 6 + 3];
        for (int i = 0; i < ArmyController.instance.armyVector.size(); ++i) {
            ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(i);
            boolean found = false;
            for (int j = 0; j < 6; ++j) {
                if (ac.units[j] != anotherIndex) continue;
                found = true;
            }
            if (found) break;
        }
        if (ac != null) {
            defence = (short)(defence + ac.calculateDefence(this.unitStaticParams[unitType * 6 + 3], unitType));
        }
        if (((spells = ArmyController.instance.battleUnits[anotherIndex * 5 + 4]) & 2) != 0) {
            defence = (short)(defence + 25);
        }
        if ((spells & 0x20) != 0) {
            defence = (short)(defence + 20);
        }
        if (ac.abilities[7]) {
            defence = (short)(defence + 20);
        }
        if (defence > 100) {
            defence = 100;
        }
        return defence;
    }

    public int getDefence(int i) {
        int army = -1;
        return this.getDefenceGlobal(this.getAnotherFuckingIndex(i));
    }

    public int getDamage(int i) {
        int anotherIndex = this.getAnotherFuckingIndex(i);
        if (anotherIndex == -1) {
            return 0;
        }
        short unitType = ArmyController.instance.battleUnits[anotherIndex * 5 + 0];
        ArmyCharacter ac = null;
        int damage = this.unitStaticParams[unitType * 6 + 1];
        boolean isMage = Globals.abs(damage) / 500 == 1;
        boolean isRange = Globals.abs(damage) / 500 == 2;
        boolean isHealer = damage < 0;
        damage = Globals.abs(damage) % 500;
        if (i < 6 && this.army1 != -1) {
            ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(this.army1);
        }
        if (i >= 6 && this.army2 != -1) {
            ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(this.army2);
        }
        damage += ac.calculateDamage(damage);
        short level = ArmyController.instance.battleUnits[anotherIndex * 5 + 3];
        short spells = ArmyController.instance.battleUnits[anotherIndex * 5 + 4];
        int typeSection = 1;
        for (int m = 0; m < 8; ++m) {
            if (unitType < DisCanvas.UNITS_TYPE_START[m]) continue;
            typeSection = m + 1;
        }
        byte maxLevel = DisCanvas.BUILDING_TYPE_COUNT[typeSection];
        if (unitType >= 8 && unitType <= 14) {
            maxLevel = 1;
        }
        if ((spells & 0x100) != 0) {
            damage = damage * (10 + level - maxLevel) / 10;
        }
        if (unitType <= 7) {
            damage += Globals.abs(this.unitStaticParams[unitType * 6 + 1]) % 500 / 10 * (level - 1);
        }
        if ((spells & 1) != 0) {
            damage = damage * 150 / 100;
        }
        if ((spells & 0x10) != 0) {
            damage = damage * 110 / 100;
        }
        if ((spells & 0x40) != 0) {
            damage = damage * 133 / 100;
        }
        if (ac.abilities[6]) {
            damage += damage / 4;
        }
        if (isMage) {
            damage += 500;
        }
        if (isRange) {
            damage += 1000;
        }
        if (isHealer) {
            damage = -damage;
        }
        return damage;
    }

    public int getInitiative(int i) {
        short spells;
        int anotherIndex = this.getAnotherFuckingIndex(i);
        if (anotherIndex == -1) {
            return -1;
        }
        short unitType = ArmyController.instance.battleUnits[anotherIndex * 5 + 0];
        ArmyCharacter ac = null;
        if (i < 6 && this.army1 != -1) {
            ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(this.army1);
        }
        if (i >= 6 && this.army2 != -1) {
            ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(this.army2);
        }
        int initiative = this.unitStaticParams[unitType * 6 + 2];
        if (unitType <= 7) {
            initiative += this.unitStaticParams[unitType * 6 + 2] / 10 * (ArmyController.instance.battleUnits[anotherIndex * 5 + 3] - 1);
        }
        if (((spells = ArmyController.instance.battleUnits[anotherIndex * 5 + 4]) & 8) != 0) {
            initiative += 10;
        }
        if ((spells & 0x80) != 0) {
            initiative += 30;
        }
        initiative += ac.calculateInitiative(initiative);
        if (i == ac.leader && ac.abilities[13]) {
            initiative += 50;
        }
        if (initiative > 100) {
            initiative = 100;
        }
        return initiative;
    }

    public int getXP(int i) {
        int anotherIndex = this.getAnotherFuckingIndex(i);
        if (anotherIndex == -1) {
            return -1;
        }
        short xp = ArmyController.instance.battleUnits[anotherIndex * 5 + 2];
        return xp;
    }

    public int getLevel(int i) {
        int anotherIndex = this.getAnotherFuckingIndex(i);
        if (anotherIndex == -1) {
            return -1;
        }
        short lev = ArmyController.instance.battleUnits[anotherIndex * 5 + 3];
        return lev;
    }

    public short getXPNextGlobal(int anotherIndex) {
        short unitType = ArmyController.instance.battleUnits[anotherIndex * 5 + 0];
        short level = ArmyController.instance.battleUnits[anotherIndex * 5 + 3];
        int typeSection = 1;
        for (int m = 0; m < 8; ++m) {
            if (unitType < DisCanvas.UNITS_TYPE_START[m]) continue;
            typeSection = m + 1;
        }
        short fakeType = (short)(DisCanvas.UNITS_TYPE_START[typeSection - 1] + level - 1);
        short spells = ArmyController.instance.battleUnits[anotherIndex * 5 + 4];
        if ((spells & 0x100) != 0) {
            fakeType = unitType;
        }
        short nextLevelXP = unitType <= 7 ? (short)(level * level * this.unitStaticParams[unitType * 6 + 5]) : this.unitStaticParams[fakeType * 6 + 5];
        byte maxLevel = DisCanvas.BUILDING_TYPE_COUNT[typeSection];
        if (unitType >= 8 && unitType <= 14) {
            maxLevel = 1;
        }
        if ((spells & 0x100) != 0) {
            nextLevelXP = (short)(nextLevelXP * (level - maxLevel + 1) * (level - maxLevel + 1));
        }
        return nextLevelXP;
    }

    public short getXPNext(int i) {
        int anotherIndex = this.getAnotherFuckingIndex(i);
        if (anotherIndex == -1) {
            return -1;
        }
        return this.getXPNextGlobal(anotherIndex);
    }

    public int getUnitType(int i) {
        int anotherIndex = this.getAnotherFuckingIndex(i);
        if (anotherIndex == -1) {
            return -1;
        }
        short unitType = ArmyController.instance.battleUnits[anotherIndex * 5 + 0];
        return unitType;
    }

    public int getKillCount(int i) {
        boolean curUnitAttackAll;
        int curUnitDamage = this.getDamage(i);
        boolean bl = curUnitAttackAll = Globals.abs(curUnitDamage) >= 500 && Globals.abs(curUnitDamage) < 1000;
        if (!curUnitAttackAll) {
            return 1;
        }
        int curSide = i / 6;
        int otherSide = 1 - curSide;
        if (curUnitDamage < 0) {
            otherSide = curSide;
        }
        int otherUnitsCount = 0;
        for (int n = otherSide * 6; n < otherSide * 6 + 6; ++n) {
            if (this.getHpLeft(n) <= 0) continue;
            ++otherUnitsCount;
        }
        return otherUnitsCount;
    }

    public void drawFrames(Graphics g, boolean right) {
        int frameW = DisCanvas.instance.frameImg.getWidth();
        int frameH = DisCanvas.instance.frameImg.getHeight();
        int xOffset = 0;
        if (right) {
            xOffset = 240 - frameW * 2;
        }
        int yOffset = 17;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                g.setClip(0, 0, 240, 320);
                int x = right ? i * frameW + xOffset : (1 - i) * frameW + xOffset;
                int y = j * frameH + yOffset;
                g.drawImage(DisCanvas.instance.frameImg, x, y, 0);
                int indexInIndexTable = i * 3 + j;
                if (right) {
                    indexInIndexTable += 6;
                }
                if (!(DisCanvas.instance.artInt && DisCanvas.instance.currGameState != 29 && DisCanvas.instance.currGameState != 22 && DisCanvas.instance.currGameState != 12 && DisCanvas.instance.currGameState != 15 && DisCanvas.instance.currGameState != 52 || indexInIndexTable != this.selectedUnitIndex || DisCanvas.instance.nextGameState == 27)) {
                    g.setColor(0xFFFFEF);
                    if (DisCanvas.instance.currGameState == 29) {
                        g.setColor(13687551);
                    }
                    g.drawRect(x + 8 - 1, y + 6 - 1, 37, 37);
                }
                if (indexInIndexTable == DisCanvas.instance.selUnit && DisCanvas.instance.nextGameState != 27) {
                    g.setColor(0xFF0000);
                    g.drawRect(x + 8 - 1, y + 6 - 1, 37, 37);
                }
                this.drawBattleAvatar(g, x + 8, y + 6, indexInIndexTable);
                if (this.getHpLeft(indexInIndexTable) == -1 || this.getHpTotal(indexInIndexTable) == -1) continue;
                String s = this.getHpLeft(indexInIndexTable) + "/" + this.getHpTotal(indexInIndexTable);
                int w = Globals.getStringWidth(s);
                Globals.drawString(g, x + 5 + (44 - w) / 2, y + 44, s);
            }
        }
    }

    public void shuffleAnimation() {
        for (int i = 0; i < 12; ++i) {
            this.ticks[i] = (byte)Globals.rand(5);
            this.frames[i] = 0;
            int index = BATTLE_ANIMATIONS + this.getUnitType(i) * 2;
            if (this.getHpLeft(i) == 0) {
                index = DEAD_ANIMATION;
                continue;
            }
            if (index == -1) continue;
            this.frames[i] = (byte)(Globals.rand(10) % this.animation[index][0]);
        }
    }

    public void resetAnimation() {
        for (int i = 0; i < 21; ++i) {
            this.ticks[i] = 0;
            this.frames[i] = 0;
        }
        this.persAnimEnds = false;
        this.hurtAnimEnds = false;
        this.deathAnimEnds = false;
        for (int j = 0; j < 12; ++j) {
            this.justDead[j] = false;
        }
    }

    public void animStep() {
        for (int i = 0; i < 18; ++i) {
            int index = -1;
            for (int j = 0; j < 4; ++j) {
                if (i != this.HURT_INDEX + j) continue;
                index = HURT_ANIMATION + j;
            }
            if (i == this.DEATH_INDEX) {
                index = DEATH_ANIMATION;
            }
            if (index == -1) {
                int unitType = this.getUnitType(i);
                if (unitType == -1) continue;
                index = BATTLE_ANIMATIONS + unitType * 2;
                if (this.getHpLeft(i) == 0) {
                    this.frames[i] = 0;
                    this.ticks[i] = 0;
                    continue;
                }
            }
            if (DisCanvas.instance.currGameState == 15 && this.attackingUnitIndex == i && !this.persAnimEnds) {
                ++index;
            }
            int n = i;
            this.ticks[n] = (byte)(this.ticks[n] + 1);
            byte delay = this.animation[index][this.getFrame(index, this.frames[i]) + 1];
            if (this.ticks[i] < delay) continue;
            this.ticks[i] = 0;
            int n2 = i;
            this.frames[n2] = (byte)(this.frames[n2] + 1);
            if (this.frames[i] < this.animation[index][0]) continue;
            this.frames[i] = 0;
            if (DisCanvas.instance.currGameState == 15 && this.attackingUnitIndex == i) {
                this.persAnimEnds = true;
            }
            if (index == HURT_ANIMATION + this.hurtType) {
                this.hurtAnimEnds = true;
            }
            if (index != DEATH_ANIMATION) continue;
            for (int j = 0; j < 12; ++j) {
                this.justDead[j] = false;
            }
            this.deathAnimEnds = true;
        }
    }

    public void battleTick() {
        if (this.attackingUnitIndex / 6 == 1) {
            this.ai();
        }
        this.animStep();
        DisCanvas.instance.moveCursor();
        this.selectUnitOnCursor();
    }

    public void battleAttackTick() {
        if (DisCanvas.instance.gameStateTicks == 20) {
            int attackingUnitDamage = this.getDamage(this.attackingUnitIndex);
            int realDamage = attackingUnitDamage % 500;
            boolean attackAll = Globals.abs(attackingUnitDamage) >= 500 && Globals.abs(attackingUnitDamage) < 1000;
            this.deathAnimEnds = true;
            for (int j = 0; j < 12; ++j) {
                this.justDead[j] = false;
            }
            if (!attackAll) {
                this.makeDamage(this.selectedUnitIndex, realDamage);
            } else {
                for (int i = this.selectedUnitIndex / 6 * 6; i < this.selectedUnitIndex / 6 * 6 + 6; ++i) {
                    this.makeDamage(i, realDamage);
                }
            }
            this.drawUserBar();
        }
        this.animStep();
        DisCanvas.instance.moveCursor();
        if (this.hurtAnimEnds && this.persAnimEnds && this.deathAnimEnds) {
            this.hurtAnimEnds = false;
            this.persAnimEnds = false;
            this.deathAnimEnds = false;
            this.nextTurn();
            if (!this.battleFinished) {
                DisCanvas.instance.nextGameState = (byte)12;
            }
        }
    }

    public void selectUnitOnCursor() {
        if (!this.humanTurn) {
            return;
        }
        if (DisCanvas.instance.currGameState == 15) {
            return;
        }
        if (!this.drawLeftFrames && !this.drawRightFrames) {
            int minDist = 10000;
            int minN = -1;
            int x = Map.instance.getScreenXFloat(DisCanvas.instance.cursorFloatX) + 8;
            int y = Map.instance.getScreenYFloat(DisCanvas.instance.cursorFloatY) + 8;
            for (int i = 0; i < 12; ++i) {
                int dist = Globals.abs(this.unitPos[i] - x) + Globals.abs(this.unitPos[i + 12] - y);
                if (dist >= minDist || dist >= 21) continue;
                minDist = dist;
                minN = i;
            }
            this.oldSelectedUnitIndex = this.selectedUnitIndex;
            this.selectedUnitIndex = (byte)minN;
            if (this.oldSelectedUnitIndex != this.selectedUnitIndex) {
                this.drawUserBar();
            }
        }
    }

    private void exchangeUnits(byte armyIndex1, byte armyIndex2, byte bUnit1, byte bUnit2) {
        ArmyCharacter[] ac = new ArmyCharacter[2];
        if (armyIndex1 != -1) {
            ac[0] = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(armyIndex1);
        }
        if (armyIndex2 != -1) {
            ac[1] = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(armyIndex2);
        }
        if (armyIndex1 == -1 && (bUnit1 / 6 == 0 || bUnit2 / 6 == 0)) {
            return;
        }
        if (armyIndex2 == -1 && (bUnit1 / 6 == 1 || bUnit2 / 6 == 1)) {
            return;
        }
        if (bUnit1 / 6 != bUnit2 / 6 && (ac[bUnit1 / 6].leader == (byte)(bUnit1 % 6) || ac[bUnit2 / 6].leader == (byte)(bUnit2 % 6))) {
            DisCanvas.instance.toolTipStringId = ac[bUnit1 / 6].leader == (byte)(bUnit1 % 6) && ac[bUnit1 / 6].owner >= 3 || ac[bUnit2 / 6].leader == (byte)(bUnit2 % 6) && ac[bUnit2 / 6].owner >= 3 ? (short)-451 : (short)-452;
            DisCanvas.instance.nextGameState = (byte)34;
            return;
        }
        short index = this.imageIndexes[bUnit1];
        this.imageIndexes[bUnit1] = this.imageIndexes[bUnit2];
        this.imageIndexes[bUnit2] = (byte)index;
        if (bUnit1 / 6 != bUnit2 / 6 && ac[bUnit2 / 6].units[bUnit2 % 6] == -1 && ac[bUnit2 / 6].unitsCount() >= ac[bUnit2 / 6].leadership) {
            DisCanvas.instance.toolTipStringId = (short)-450;
            DisCanvas.instance.nextGameState = (byte)34;
            return;
        }
        if (bUnit1 / 6 == bUnit2 / 6) {
            if (ac[bUnit1 / 6].leader == (byte)(bUnit1 % 6)) {
                ac[bUnit1 / 6].leader = (byte)(bUnit2 % 6);
            } else if (ac[bUnit1 / 6].leader == (byte)(bUnit2 % 6)) {
                ac[bUnit1 / 6].leader = (byte)(bUnit1 % 6);
            }
        }
        index = ac[bUnit1 / 6].units[bUnit1 % 6];
        ac[bUnit1 / 6].units[bUnit1 % 6] = ac[bUnit2 / 6].units[bUnit2 % 6];
        ac[bUnit2 / 6].units[bUnit2 % 6] = index;
    }

    public void applyArtefact(ArmyCharacter ac, ArmyCharacter targetAc, byte returnGameState) {
        if (DisCanvas.instance.selArt == -1) {
            return;
        }
        short unitIndex = targetAc.units[this.selectedUnitIndex % 6];
        if (unitIndex == -1) {
            return;
        }
        short unitType = ArmyController.instance.battleUnits[unitIndex * 5 + 0];
        switch (ac.slot[DisCanvas.instance.selArt]) {
            case 0: {
                if (ac.id != targetAc.id) break;
                if (ArmyController.instance.battleUnits[unitIndex * 5 + 1] <= 0) {
                    DisCanvas.instance.currGameState = returnGameState;
                    DisCanvas.instance.toolTipStringId = (short)-299;
                    DisCanvas.instance.nextGameState = (byte)34;
                    break;
                }
                if (ArmyController.instance.battleUnits[unitIndex * 5 + 1] == this.getHpTotal(this.selectedUnitIndex)) {
                    DisCanvas.instance.currGameState = returnGameState;
                    DisCanvas.instance.toolTipStringId = (short)-298;
                    DisCanvas.instance.nextGameState = (byte)34;
                    break;
                }
                this.makeDamage(this.selectedUnitIndex, -100);
                ac.delArtefact(DisCanvas.instance.selArt);
                DisCanvas.instance.nextGameState = returnGameState;
                if (returnGameState != 12) break;
                this.nextTurn();
                break;
            }
            case 1: {
                if (ac.id != targetAc.id) break;
                if (ArmyController.instance.battleUnits[unitIndex * 5 + 1] > 0) {
                    DisCanvas.instance.currGameState = returnGameState;
                    DisCanvas.instance.toolTipStringId = (short)-300;
                    DisCanvas.instance.nextGameState = (byte)34;
                    break;
                }
                ArmyController.instance.battleUnits[unitIndex * 5 + 1] = 1;
                ac.delArtefact(DisCanvas.instance.selArt);
                DisCanvas.instance.nextGameState = returnGameState;
                if (returnGameState != 12) break;
                this.nextTurn();
                break;
            }
            case 15: {
                if (ac.id != targetAc.id) break;
                for (int i = this.selectedUnitIndex / 6 * 6; i < this.selectedUnitIndex / 6 * 6 + 6; ++i) {
                    this.makeDamage(i, -50);
                }
                ac.delArtefact(DisCanvas.instance.selArt);
                DisCanvas.instance.nextGameState = returnGameState;
                if (returnGameState != 12) break;
                this.nextTurn();
                break;
            }
            case 16: {
                if (ac.id != targetAc.id) break;
                for (int i = this.selectedUnitIndex / 6 * 6; i < this.selectedUnitIndex / 6 * 6 + 6; ++i) {
                    this.makeDamage(i, -100);
                }
                ac.delArtefact(DisCanvas.instance.selArt);
                DisCanvas.instance.nextGameState = returnGameState;
                if (returnGameState != 12) break;
                this.nextTurn();
                break;
            }
            case 17: {
                if (ac.id == targetAc.id) break;
                this.makeDamage(this.selectedUnitIndex, 50);
                ac.delArtefact(DisCanvas.instance.selArt);
                DisCanvas.instance.nextGameState = returnGameState;
                if (returnGameState != 12) break;
                this.nextTurn();
                break;
            }
            case 18: {
                if (ac.id == targetAc.id) break;
                this.makeDamage(this.selectedUnitIndex, 75);
                ac.delArtefact(DisCanvas.instance.selArt);
                DisCanvas.instance.nextGameState = returnGameState;
                if (returnGameState != 12) break;
                this.nextTurn();
                break;
            }
            case 19: {
                if (ac.id != targetAc.id) break;
                int n = unitIndex * 5 + 4;
                ArmyController.instance.battleUnits[n] = (short)(ArmyController.instance.battleUnits[n] | 1);
                ac.delArtefact(DisCanvas.instance.selArt);
                DisCanvas.instance.nextGameState = returnGameState;
                if (returnGameState != 12) break;
                this.nextTurn();
                break;
            }
            case 13: {
                if (ac.id != targetAc.id) break;
                int n = unitIndex * 5 + 4;
                ArmyController.instance.battleUnits[n] = (short)(ArmyController.instance.battleUnits[n] | 2);
                ac.delArtefact(DisCanvas.instance.selArt);
                DisCanvas.instance.nextGameState = returnGameState;
                if (returnGameState != 12) break;
                this.nextTurn();
            }
        }
    }

    public void healKey(int currKey) {
        switch (currKey) {
            case 2: {
                if (this.selectedUnitIndex == 3) {
                    this.selectedUnitIndex = 0;
                    break;
                }
                if (this.selectedUnitIndex == 4) {
                    this.selectedUnitIndex = 1;
                    break;
                }
                if (this.selectedUnitIndex == 5) {
                    this.selectedUnitIndex = (byte)2;
                    break;
                }
                if (this.selectedUnitIndex == 0) {
                    this.selectedUnitIndex = (byte)3;
                    break;
                }
                if (this.selectedUnitIndex == 1) {
                    this.selectedUnitIndex = (byte)4;
                    break;
                }
                if (this.selectedUnitIndex != 2) break;
                this.selectedUnitIndex = (byte)5;
                break;
            }
            case 4: {
                if (this.selectedUnitIndex == 3) {
                    this.selectedUnitIndex = 0;
                    break;
                }
                if (this.selectedUnitIndex == 4) {
                    this.selectedUnitIndex = 1;
                    break;
                }
                if (this.selectedUnitIndex == 5) {
                    this.selectedUnitIndex = (byte)2;
                    break;
                }
                if (this.selectedUnitIndex == 0) {
                    this.selectedUnitIndex = (byte)3;
                    break;
                }
                if (this.selectedUnitIndex == 1) {
                    this.selectedUnitIndex = (byte)4;
                    break;
                }
                if (this.selectedUnitIndex != 2) break;
                this.selectedUnitIndex = (byte)5;
                break;
            }
            case 1: {
                this.selectedUnitIndex = (byte)(this.selectedUnitIndex - 1);
                if (this.selectedUnitIndex == -1) {
                    this.selectedUnitIndex = (byte)2;
                    break;
                }
                if (this.selectedUnitIndex != 2) break;
                this.selectedUnitIndex = (byte)5;
                break;
            }
            case 3: {
                this.selectedUnitIndex = (byte)(this.selectedUnitIndex + 1);
                if (this.selectedUnitIndex == 3) {
                    this.selectedUnitIndex = 0;
                    break;
                }
                if (this.selectedUnitIndex != 6) break;
                this.selectedUnitIndex = (byte)3;
                break;
            }
            case 9: {
                byte armyIndex = this.army1;
                ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(armyIndex);
                if (DisCanvas.instance.selArt == -1) break;
                this.applyArtefact(ac, ac, (byte)17);
            }
        }
    }

    public void asKey(int currKey) {
        switch (currKey) {
            case 2: {
                if (this.selectedUnitIndex == 3) {
                    this.selectedUnitIndex = 0;
                    break;
                }
                if (this.selectedUnitIndex == 4) {
                    this.selectedUnitIndex = 1;
                    break;
                }
                if (this.selectedUnitIndex == 5) {
                    this.selectedUnitIndex = (byte)2;
                    break;
                }
                if (this.selectedUnitIndex == 0) {
                    DisCanvas.instance.artInt = true;
                    break;
                }
                if (this.selectedUnitIndex == 1) {
                    DisCanvas.instance.artInt = true;
                    break;
                }
                if (this.selectedUnitIndex != 2) break;
                DisCanvas.instance.artInt = true;
                break;
            }
            case 4: {
                if (this.selectedUnitIndex == 3) {
                    this.selectedUnitIndex = 0;
                    break;
                }
                if (this.selectedUnitIndex == 4) {
                    this.selectedUnitIndex = 1;
                    break;
                }
                if (this.selectedUnitIndex == 5) {
                    this.selectedUnitIndex = (byte)2;
                    break;
                }
                if (this.selectedUnitIndex == 0) {
                    this.selectedUnitIndex = (byte)3;
                    break;
                }
                if (this.selectedUnitIndex == 1) {
                    this.selectedUnitIndex = (byte)4;
                    break;
                }
                if (this.selectedUnitIndex != 2) break;
                this.selectedUnitIndex = (byte)5;
                break;
            }
            case 1: {
                this.selectedUnitIndex = (byte)(this.selectedUnitIndex - 1);
                if (this.selectedUnitIndex == -1) {
                    this.selectedUnitIndex = (byte)2;
                    break;
                }
                if (this.selectedUnitIndex != 2) break;
                this.selectedUnitIndex = (byte)5;
                break;
            }
            case 3: {
                this.selectedUnitIndex = (byte)(this.selectedUnitIndex + 1);
                if (this.selectedUnitIndex == 3) {
                    this.selectedUnitIndex = 0;
                    break;
                }
                if (this.selectedUnitIndex != 6) break;
                this.selectedUnitIndex = (byte)3;
                break;
            }
            case 9: {
                if (DisCanvas.instance.currGameState == 52) break;
                byte armyIndex = ArmyController.instance.getId();
                ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(armyIndex);
                if (DisCanvas.instance.selUnit == -1) {
                    DisCanvas.instance.selUnit = this.selectedUnitIndex;
                    if (ac.units[this.selectedUnitIndex] != -1) break;
                    DisCanvas.instance.selUnit = (byte)-1;
                    break;
                }
                if (DisCanvas.instance.selUnit == this.selectedUnitIndex) break;
                this.exchangeUnits(armyIndex, armyIndex, DisCanvas.instance.selUnit, this.selectedUnitIndex);
                DisCanvas.instance.selUnit = (byte)-1;
                break;
            }
            case 5: {
                if (DisCanvas.instance.currGameState == 52) break;
                ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(ArmyController.instance.getId());
                if (ac.units[Battle.instance.selectedUnitIndex] == -1) break;
                DisCanvas.instance.nextGameState = (byte)18;
            }
        }
    }

    public void capitalUnitsKey(int currKey) {
        switch (currKey) {
            case 2: {
                this.selectedUnitIndex = this.nextUnitIndexOnRight[this.selectedUnitIndex];
                break;
            }
            case 4: {
                this.selectedUnitIndex = this.nextUnitIndexOnLeft[this.selectedUnitIndex];
                break;
            }
            case 1: {
                this.selectedUnitIndex = (byte)(this.selectedUnitIndex - 1);
                if (this.selectedUnitIndex == -1) {
                    this.selectedUnitIndex = (byte)2;
                    break;
                }
                if (this.selectedUnitIndex == 2) {
                    this.selectedUnitIndex = (byte)5;
                    break;
                }
                if (this.selectedUnitIndex == 5) {
                    this.selectedUnitIndex = (byte)8;
                    break;
                }
                if (this.selectedUnitIndex != 8) break;
                this.selectedUnitIndex = (byte)11;
                break;
            }
            case 3: {
                this.selectedUnitIndex = (byte)(this.selectedUnitIndex + 1);
                if (this.selectedUnitIndex == 3) {
                    this.selectedUnitIndex = 0;
                    break;
                }
                if (this.selectedUnitIndex == 6) {
                    this.selectedUnitIndex = (byte)3;
                    break;
                }
                if (this.selectedUnitIndex == 9) {
                    this.selectedUnitIndex = (byte)6;
                    break;
                }
                if (this.selectedUnitIndex != 12) break;
                this.selectedUnitIndex = (byte)9;
                break;
            }
            case 9: {
                byte selectedIndex = DisCanvas.instance.capitals[DisCanvas.instance.currentTown][(this.selectedUnitIndex / 6 + 1) % 2];
                if (DisCanvas.instance.selUnit == -1) {
                    DisCanvas.instance.selUnit = this.selectedUnitIndex;
                    if (selectedIndex == -1) {
                        DisCanvas.instance.nextGameState = (byte)28;
                        break;
                    }
                    ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(selectedIndex);
                    if (ac.units[this.selectedUnitIndex % 6] != -1) break;
                    if (this.selectedUnitIndex >= 6) {
                        DisCanvas.instance.nextGameState = (byte)26;
                    }
                    DisCanvas.instance.selUnit = (byte)-1;
                    break;
                }
                if (DisCanvas.instance.selUnit == this.selectedUnitIndex) break;
                byte armyIndex1 = DisCanvas.instance.capitals[DisCanvas.instance.currentTown][1];
                byte armyIndex2 = DisCanvas.instance.capitals[DisCanvas.instance.currentTown][0];
                this.exchangeUnits(armyIndex1, armyIndex2, DisCanvas.instance.selUnit, this.selectedUnitIndex);
                DisCanvas.instance.selUnit = (byte)-1;
            }
        }
        if (this.selectedUnitIndex < 6 && DisCanvas.instance.capitals[DisCanvas.instance.currentTown][1] == -1) {
            this.selectedUnitIndex = 1;
        }
    }

    public void battleKeyProcess(int currKey) {
        this.oldSelectedUnitIndex = this.selectedUnitIndex;
        if (!this.drawLeftFrames && !this.drawRightFrames) {
            DisCanvas.instance.cursorHandle(currKey);
        } else {
            switch (currKey) {
                case 2: {
                    this.selectedUnitIndex = this.nextUnitIndexOnRight[this.selectedUnitIndex];
                    if (this.drawLeftFrames) {
                        if (this.selectedUnitIndex == 6) {
                            this.selectedUnitIndex = (byte)3;
                        } else if (this.selectedUnitIndex == 7) {
                            this.selectedUnitIndex = (byte)4;
                        } else if (this.selectedUnitIndex == 8) {
                            this.selectedUnitIndex = (byte)5;
                        }
                    }
                    if (!this.drawRightFrames) break;
                    if (this.selectedUnitIndex == 3) {
                        this.selectedUnitIndex = (byte)6;
                        break;
                    }
                    if (this.selectedUnitIndex == 4) {
                        this.selectedUnitIndex = (byte)7;
                        break;
                    }
                    if (this.selectedUnitIndex != 5) break;
                    this.selectedUnitIndex = (byte)8;
                    break;
                }
                case 4: {
                    this.selectedUnitIndex = this.nextUnitIndexOnLeft[this.selectedUnitIndex];
                    if (this.drawLeftFrames) {
                        if (this.selectedUnitIndex == 9) {
                            this.selectedUnitIndex = 0;
                        } else if (this.selectedUnitIndex == 10) {
                            this.selectedUnitIndex = 1;
                        } else if (this.selectedUnitIndex == 11) {
                            this.selectedUnitIndex = (byte)2;
                        }
                    }
                    if (!this.drawRightFrames) break;
                    if (this.selectedUnitIndex == 0) {
                        this.selectedUnitIndex = (byte)9;
                        break;
                    }
                    if (this.selectedUnitIndex == 1) {
                        this.selectedUnitIndex = (byte)10;
                        break;
                    }
                    if (this.selectedUnitIndex != 2) break;
                    this.selectedUnitIndex = (byte)11;
                    break;
                }
                case 1: {
                    this.selectedUnitIndex = (byte)(this.selectedUnitIndex - 1);
                    if (this.selectedUnitIndex == -1) {
                        this.selectedUnitIndex = (byte)2;
                        break;
                    }
                    if (this.selectedUnitIndex == 2) {
                        this.selectedUnitIndex = (byte)5;
                        break;
                    }
                    if (this.selectedUnitIndex == 5) {
                        this.selectedUnitIndex = (byte)8;
                        break;
                    }
                    if (this.selectedUnitIndex != 8) break;
                    this.selectedUnitIndex = (byte)11;
                    break;
                }
                case 3: {
                    this.selectedUnitIndex = (byte)(this.selectedUnitIndex + 1);
                    if (this.selectedUnitIndex == 3) {
                        this.selectedUnitIndex = 0;
                        break;
                    }
                    if (this.selectedUnitIndex == 6) {
                        this.selectedUnitIndex = (byte)3;
                        break;
                    }
                    if (this.selectedUnitIndex == 9) {
                        this.selectedUnitIndex = (byte)6;
                        break;
                    }
                    if (this.selectedUnitIndex != 12) break;
                    this.selectedUnitIndex = (byte)9;
                }
            }
        }
        switch (currKey) {
            case 9: {
                int x = Map.instance.getScreenXFloat(DisCanvas.instance.cursorFloatX) + 8;
                int y = Map.instance.getScreenYFloat(DisCanvas.instance.cursorFloatY) + 8;
                this.currArtInhand = (byte)-1;
                if (x > 208 && y > 256 - DisCanvas.instance.artefactsBar.getHeight()) {
                    ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(this.army1);
                    byte by = this.currArtInhand = x > 224 ? (byte)0 : 1;
                    if (ac.inhand[this.currArtInhand] == -1) break;
                    DisCanvas.instance.nextGameState = (byte)42;
                    break;
                }
                this.fire();
                break;
            }
            case 17: {
                DisCanvas.instance.useItem();
                break;
            }
            case 19: {
                this.nextTurn();
                break;
            }
            case 10: {
                if (this.getAnotherFuckingIndex(this.selectedUnitIndex) == -1) break;
                DisCanvas.instance.nextGameState = (byte)18;
                break;
            }
            case 11: {
                boolean bl = this.drawLeftFrames = !this.drawLeftFrames;
                if (this.drawLeftFrames) {
                    this.drawRightFrames = false;
                    if (this.getDamage(this.attackingUnitIndex) < 0) {
                        if (this.selectedUnitIndex < 6) {
                            this.selectedUnitIndex = (byte)(this.selectedUnitIndex + 6);
                        }
                    } else if (this.selectedUnitIndex >= 6) {
                        this.selectedUnitIndex = (byte)(this.selectedUnitIndex - 6);
                    }
                }
                this.drawAnyFrames = this.drawLeftFrames || this.drawRightFrames;
                if (!(this.drawLeftFrames & this.selectedUnitIndex / 6 != 0)) break;
                this.selectedUnitIndex = 1;
                break;
            }
            case 13: {
                boolean bl = this.drawRightFrames = !this.drawRightFrames;
                if (this.drawRightFrames) {
                    this.drawLeftFrames = false;
                    if (this.selectedUnitIndex < 6) {
                        this.selectedUnitIndex = (byte)(this.selectedUnitIndex + 6);
                    }
                }
                this.drawAnyFrames = this.drawLeftFrames || this.drawRightFrames;
                if (!(this.drawRightFrames & this.selectedUnitIndex / 6 != 1)) break;
                this.selectedUnitIndex = (byte)7;
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                DisCanvas.instance.nextGameState = (byte)32;
            }
        }
        if (this.oldSelectedUnitIndex != this.selectedUnitIndex) {
            this.drawUserBar();
        }
    }

    public void battleInfKeyProcess(int currKey) {
        switch (currKey) {
            case 6: 
            case 9: 
            case 10: {
                DisCanvas.instance.nextGameState = DisCanvas.instance.returnGameState;
                break;
            }
            case 5: {
                int armyIndex = -1;
                if (DisCanvas.instance.currentTown != -1) {
                    armyIndex = DisCanvas.instance.capitals[DisCanvas.instance.currentTown][1];
                } else if (this.selectedUnitIndex >= -1 && this.selectedUnitIndex < 6) {
                    armyIndex = this.army1;
                } else if (this.selectedUnitIndex >= 6) {
                    armyIndex = this.army2;
                }
                if (!DisCanvas.instance.leader || armyIndex == -1) break;
                ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(armyIndex);
                DisCanvas.instance.toolTipString = (String)Globals.mStringArr.elementAt(399) + ":^";
                if (ac.abilities[0]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(400) + "^";
                }
                if (ac.abilities[1]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(401) + "^";
                }
                if (ac.abilities[2]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(402) + "^";
                }
                if (ac.abilities[3]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(403) + "^";
                }
                if (ac.abilities[4]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(404) + "^";
                }
                if (ac.abilities[5]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(405) + "^";
                }
                if (ac.abilities[6]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(406) + "^";
                }
                if (ac.abilities[7]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(407) + "^";
                }
                if (ac.abilities[8]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(408) + "^";
                }
                if (ac.abilities[9]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(409) + "^";
                }
                if (ac.abilities[10]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(410) + "^";
                }
                if (ac.abilities[11]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(411) + "^";
                }
                if (ac.abilities[12]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(412) + "^";
                }
                if (ac.abilities[13]) {
                    DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "+" + (String)Globals.mStringArr.elementAt(414) + "^";
                }
                DisCanvas.instance.toolTipAvatarId = ArmyController.instance.battleUnits[ac.units[ac.leader] * 5 + 0];
                DisCanvas.instance.nextTriggerId = (byte)-1;
                DisCanvas.instance.returnGameState = (byte)2;
                DisCanvas.instance.nextGameState = (byte)39;
            }
        }
    }

    public int computeChances(byte _army1, byte _army2) {
        int chances = 50;
        this.prepareEssential(_army1, _army2);
        int army1TotalDamage = 0;
        for (int i = 0; i < 6; ++i) {
            army1TotalDamage += Globals.abs(this.getDamage(i) * this.getKillCount(i)) % 500;
        }
        int army2TotalDamage = 0;
        for (int i = 6; i < 12; ++i) {
            army2TotalDamage += Globals.abs(this.getDamage(i) * this.getKillCount(i)) % 500;
        }
        int army1TotalHP = 0;
        for (int i = 0; i < 6; ++i) {
            army1TotalHP += this.getHpLeft(i);
        }
        int army2TotalHP = 0;
        for (int i = 6; i < 12; ++i) {
            army2TotalHP += this.getHpLeft(i);
        }
        if (army2TotalDamage == 0) {
            return 100;
        }
        if (army1TotalDamage == 0) {
            return 0;
        }
        chances = 10 * army1TotalHP / army2TotalDamage - 10 * army2TotalHP / army1TotalDamage;
        if ((chances += 50) < 0) {
            chances = 0;
        }
        if (chances > 100) {
            chances = 100;
        }
        return chances;
    }

    public void fastBattle(byte _army1, byte _army2) {
        this.fast = true;
        this.prepareEssential(_army1, _army2);
        do {
            this.ai();
        } while (!this.battleFinished);
    }

    public boolean needLevelUp(int battleIndex) {
        if (battleIndex == -1) {
            return false;
        }
        short hpLeft = ArmyController.instance.battleUnits[battleIndex * 5 + 1];
        if (hpLeft <= 0) {
            return false;
        }
        short type = ArmyController.instance.battleUnits[battleIndex * 5 + 0];
        if (type < 15) {
            return false;
        }
        if (type >= 42) {
            return false;
        }
        int typeSection = 1;
        for (int m = 0; m < 8; ++m) {
            if (type < DisCanvas.UNITS_TYPE_START[m]) continue;
            typeSection = m + 1;
        }
        int realLevel = type - DisCanvas.UNITS_TYPE_START[typeSection - 1] + 1;
        short level = ArmyController.instance.battleUnits[battleIndex * 5 + 3];
        int buildingNeeded = DisCanvas.BUILDING_TYPE_START[typeSection] + level - 1 - 1 - 1;
        if (buildingNeeded < 0) {
            return false;
        }
        return realLevel < level;
    }

    public void checkLevelUp() {
        for (int i = 0; i < ArmyController.instance.armyVector.size(); ++i) {
            ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(i);
            if (ac.owner % 3 == 2) continue;
            for (int j = 0; j < 6; ++j) {
                if (!this.needLevelUp(ac.units[j])) continue;
                int typeSection = 1;
                short type = ArmyController.instance.battleUnits[ac.units[j] * 5 + 0];
                for (int m = 0; m < 8; ++m) {
                    if (type < DisCanvas.UNITS_TYPE_START[m]) continue;
                    typeSection = m + 1;
                }
                short level = ArmyController.instance.battleUnits[ac.units[j] * 5 + 3];
                short realLevel = (short)(type - DisCanvas.UNITS_TYPE_START[typeSection - 1] + 1);
                int buildingNeeded = DisCanvas.BUILDING_TYPE_START[typeSection] + (realLevel + 1) - 1 - 1 - 1;
                if (type < DisCanvas.UNITS_TYPE_START[typeSection - 1] + DisCanvas.BUILDING_TYPE_COUNT[typeSection]) {
                    if (DisCanvas.instance.capitals[ac.owner][3 + buildingNeeded] == 0) continue;
                    int n = ac.units[j] * 5 + 0;
                    ArmyController.instance.battleUnits[n] = (short)(ArmyController.instance.battleUnits[n] + 1);
                    ArmyController.instance.battleUnits[ac.units[j] * 5 + 1] = this.getHpTotalGlobal(ac.units[j]);
                    continue;
                }
                if (type != DisCanvas.UNITS_TYPE_START[typeSection - 1] + DisCanvas.BUILDING_TYPE_COUNT[typeSection]) continue;
                int n = ac.units[j] * 5 + 4;
                ArmyController.instance.battleUnits[n] = (short)(ArmyController.instance.battleUnits[n] | 0x100);
            }
        }
    }

    public void levelUp(byte win, int ind) {
        DisCanvas.instance.nextGameStateChanged = false;
        short type = ArmyController.instance.battleUnits[ind * 5 + 0];
        if (type > 7 && type < 42) {
            int n = ind * 5 + 3;
            ArmyController.instance.battleUnits[n] = (short)(ArmyController.instance.battleUnits[n] + 1);
            ArmyController.instance.battleUnits[ind * 5 + 1] = this.unitStaticParams[ArmyController.instance.battleUnits[ind * 5 + 0] * 6 + 0];
        }
        if (type <= 7) {
            this.availAb = new byte[20];
            this.availAbCount = 0;
            ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(win);
            int n = ind * 5 + 3;
            ArmyController.instance.battleUnits[n] = (short)(ArmyController.instance.battleUnits[n] + 1);
            int count = ArmyController.instance.battleUnits[ind * 5 + 3] <= 13 ? ABILITIES_PER_LEVEL[ArmyController.instance.battleUnits[ind * 5 + 3]] : 14;
            ArmyController.instance.battleUnits[ind * 5 + 1] = this.getHpTotalGlobal(ind);
            for (int i = 0; i < count; i = (int)((byte)(i + 1))) {
                if (i == 2 || ac.abilities[i]) continue;
                this.availAb[this.availAbCount] = i;
                this.availAbCount = (byte)(this.availAbCount + 1);
            }
            if (this.availAbCount > 0) {
                if (ac.owner == 1) {
                    ac.abilities[this.availAb[0]] = true;
                    ac.postAbilitySelect(this.availAb[0]);
                } else if (DisCanvas.instance.nextGameState != 39) {
                    if (ac.owner == 0) {
                        DisCanvas.instance.nextGameState = (byte)40;
                        DisCanvas.instance.nextGameStateChanged = true;
                    }
                    DisCanvas.instance.returnGameState = !ArmyController.instance.aiTurn ? (byte)2 : (byte)14;
                }
            }
        }
    }

    public void addXP(byte win) {
        ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(win);
        int alive = 0;
        int xp = win == this.army1 ? this.XP_1 : this.XP_2;
        if (ac.abilities[10]) {
            xp += xp / 4;
        }
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (ac.units[i] == -1 || this.needLevelUp(ac.units[i]) || ArmyController.instance.battleUnits[ac.units[i] * 5 + 1] <= 0) continue;
            alive = (byte)(alive + 1);
        }
        boolean leaderLevelUp = false;
        for (byte i = 0; i < 6; i = (byte)((byte)(i + 1))) {
            short hpLeft;
            DisCanvas.instance.xpGet[i] = 0;
            if (ac.units[i] == -1 || this.needLevelUp(ac.units[i]) || (hpLeft = ArmyController.instance.battleUnits[ac.units[i] * 5 + 1]) <= 0) continue;
            int n = ac.units[i] * 5 + 2;
            ArmyController.instance.battleUnits[n] = (short)(ArmyController.instance.battleUnits[n] + xp / alive);
            DisCanvas.instance.xpGet[i] = (short)(xp / alive);
            short unitXP = ArmyController.instance.battleUnits[ac.units[i] * 5 + 2];
            short nextLevelXP = this.getXPNextGlobal(ac.units[i]);
            if (unitXP < nextLevelXP) continue;
            this.levelUp(win, ac.units[i]);
            if (i != ac.leader) continue;
            leaderLevelUp = true;
        }
        if (DisCanvas.instance.nextGameState != 39 && ac.owner == 0 && !leaderLevelUp) {
            DisCanvas.instance.nextGameState = (byte)54;
            DisCanvas.instance.returnGameState = !ArmyController.instance.aiTurn ? (byte)2 : (byte)14;
        }
    }

    public void endBattle(byte armyLoseId) {
        int mpdel;
        int i;
        byte armyLose = armyLoseId == 0 ? this.army1 : this.army2;
        byte armyWin = armyLoseId == 1 ? this.army1 : this.army2;
        this.victory = false;
        this.defeat = false;
        ArmyController.instance.checkBattleEndTriggers(armyWin, armyLose);
        if (this.victory || this.defeat) {
            return;
        }
        this.winId = armyWin;
        this.addXP(armyWin);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.checkLevelUp();
        }
        ArmyCharacter acLose = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(armyLose);
        ArmyCharacter acWin = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(armyWin);
        if (acLose.slotcount > 0) {
            int cnt = 0;
            String str = "";
            for (i = 0; i < acLose.slotcount; i = (byte)(i + 1)) {
                for (byte j = 1; j <= acLose.counts[i]; j = (byte)(j + 1)) {
                    if (cnt > 0) {
                        str = str + ",_";
                    }
                    str = str + (String)Globals.mStringArr.elementAt(159 + acLose.slot[i]);
                    acWin.addArtefact(acLose.slot[i]);
                    cnt = (byte)(cnt + 1);
                }
            }
            if (cnt > 0 && acWin.owner == 0) {
                DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + "^" + (String)Globals.mStringArr.elementAt(416);
                DisCanvas.instance.toolTipString = DisCanvas.instance.toolTipString + str;
            }
        }
        boolean computerWin = false;
        if (acWin.owner == 1) {
            computerWin = true;
        }
        acWin.movePoints = acWin.movePoints - (mpdel = 2 * acWin.maxMP(acWin.owner, false) / 3) > 0 ? (byte)(acWin.movePoints - mpdel) : (byte)0;
        if (acLose.owner < 3) {
            this.shiftTownIndexes(armyLose);
            if (DisCanvas.instance.id > armyLose) {
                DisCanvas.instance.id = (byte)(DisCanvas.instance.id - 1);
            } else if (DisCanvas.instance.id == armyLose) {
                DisCanvas.instance.id = (byte)-1;
            }
            if (armyWin > armyLose) {
                armyWin = (byte)(armyWin - 1);
            }
            this.winId = armyWin;
            ArmyController.instance.armyVector.removeElementAt(armyLose);
            ArmyController.instance.initMap[acLose.x][acLose.y] = 126;
            ArmyController.instance.fillEnemyMap();
        } else {
            acLose.owner = (byte)(acWin.owner + 3);
            acLose.leader = (byte)-1;
            for (i = 0; i < 6; ++i) {
                acLose.units[i] = -1;
            }
        }
        if (!ArmyController.instance.aiTurn) {
            if (ArmyController.instance.getOwner(armyWin) == 0) {
                if (Map.instance.isTownOnCellAi(acLose.x, acLose.y) != -1) {
                    System.out.println("Player win!");
                    DisCanvas.instance.capitals[Map.instance.layer3[DisCanvas.instance.currentTownId][5]][1] = armyWin;
                    DisCanvas.instance.capitals[Map.instance.layer3[DisCanvas.instance.currentTownId][5]][4] = 0;
                    Map.instance.layer3[DisCanvas.instance.currentTownId][4] = 0;
                }
                DisCanvas.instance.army.markArmy(armyWin);
            } else {
                DisCanvas.instance.army.unmarkArmy();
                ArmyController.instance.findNextHero((byte)0);
            }
            if (DisCanvas.instance.nextGameState != 40 && DisCanvas.instance.nextGameState != 39) {
                if (acLose.owner < 3) {
                    if (DisCanvas.instance.nextGameState != 54) {
                        DisCanvas.instance.nextGameState = (byte)2;
                    }
                } else {
                    DisCanvas.instance.nextGameState = (byte)19;
                }
            }
        } else {
            if (computerWin && Map.instance.isTownOnCellAi(acWin.x, acWin.y) != -1) {
                DisCanvas.instance.capitals[Map.instance.layer3[DisCanvas.instance.currentTownId][5]][1] = armyWin;
                DisCanvas.instance.capitals[Map.instance.layer3[DisCanvas.instance.currentTownId][5]][4] = 1;
                Map.instance.layer3[DisCanvas.instance.currentTownId][4] = 1;
                DisCanvas.instance.findLeaderInCapital(DisCanvas.instance.currentTownId);
                acWin.isInTownAdditionalCheck = true;
                acWin.animShiftX = 0;
                acWin.animShiftY = 0;
            }
            if (DisCanvas.instance.nextGameState != 40 && DisCanvas.instance.nextGameState != 39 && DisCanvas.instance.nextGameState != 54) {
                DisCanvas.instance.nextGameState = (byte)14;
            }
        }
        ArmyController.instance.calculateSequence();
        ArmyController.instance.checkHasTownsTriggers();
        this.army1 = armyLoseId == 0 ? armyLose : armyWin;
        this.army2 = armyLoseId == 1 ? armyLose : armyWin;
    }

    public void shiftTownIndexes(byte armyLose) {
        for (int i = 0; i < DisCanvas.instance.townsCount; ++i) {
            if (DisCanvas.instance.capitals[i][0] > armyLose) {
                byte[] byArray = DisCanvas.instance.capitals[i];
                byArray[0] = (byte)(byArray[0] - 1);
            }
            if (DisCanvas.instance.capitals[i][1] <= armyLose) continue;
            byte[] byArray = DisCanvas.instance.capitals[i];
            byArray[1] = (byte)(byArray[1] - 1);
        }
    }

    public boolean nextTurn() {
        int i;
        boolean alive = false;
        for (i = 0; i < 6; ++i) {
            if (this.getHpLeft(i) <= 0) continue;
            alive = true;
        }
        if (!alive) {
            this.endBattle((byte)0);
            this.battleFinished = true;
            return true;
        }
        alive = false;
        for (i = 6; i < 12; ++i) {
            if (this.getHpLeft(i) <= 0) continue;
            alive = true;
        }
        if (!alive) {
            this.endBattle((byte)1);
            this.battleFinished = true;
            return true;
        }
        do {
            this.currentTurn = (byte)(this.currentTurn + 1);
            if (this.currentTurn > 11) {
                this.currentTurn = 0;
            }
            if (this.attackSequence[this.currentTurn] != -1) continue;
            this.currentTurn = 0;
        } while (this.getHpLeft(this.attackSequence[this.currentTurn]) <= 0);
        this.attackingUnitIndex = this.attackSequence[this.currentTurn];
        this.humanTurn = true;
        if (this.selectedUnitIndex / 6 != 1 - this.attackingUnitIndex / 6) {
            this.selectedUnitIndex = (byte)((1 - this.attackingUnitIndex / 6) * 6 + 1);
        }
        if (this.drawAnyFrames) {
            if (this.getDamage(this.attackingUnitIndex) < 0) {
                this.drawLeftFrames = true;
                this.drawRightFrames = false;
            } else {
                this.drawLeftFrames = false;
                this.drawRightFrames = true;
            }
        }
        if (!this.fast) {
            this.drawUserBar();
        }
        return false;
    }

    public boolean canAttack(int selected) {
        int attackingUnitDamage = this.getDamage(this.attackingUnitIndex);
        int anotherSelectedIndex = this.getAnotherFuckingIndex(selected);
        boolean rangeAttack = Globals.abs(attackingUnitDamage) >= 1000;
        boolean attackAll = Globals.abs(attackingUnitDamage) >= 500 && Globals.abs(attackingUnitDamage) < 1000;
        int attackingSide = this.attackingUnitIndex / 6;
        int selectedSide = selected / 6;
        if (!attackAll) {
            if (anotherSelectedIndex == -1) {
                return false;
            }
            if (this.getHpLeft(selected) <= 0) {
                return false;
            }
        }
        if (attackingUnitDamage > 0) {
            if (selected == this.attackingUnitIndex) {
                return false;
            }
            if (selectedSide == attackingSide) {
                return false;
            }
        } else {
            return selectedSide == attackingSide;
        }
        if (attackAll) {
            return true;
        }
        if (!rangeAttack) {
            boolean selectedUnitIsInBackRow;
            boolean someoneInEnemyFrontRow = false;
            for (int i = selectedSide * 6; i < selectedSide * 6 + 3; ++i) {
                if (this.getHpLeft(i) <= 0) continue;
                someoneInEnemyFrontRow = true;
            }
            boolean someoneInAttackingFrontRow = false;
            for (int i = attackingSide * 6; i < attackingSide * 6 + 3; ++i) {
                if (this.getHpLeft(i) <= 0) continue;
                someoneInAttackingFrontRow = true;
            }
            boolean attackingUnitIsInBackRow = this.attackingUnitIndex % 6 > 2;
            boolean bl = selectedUnitIsInBackRow = selected % 6 > 2;
            if (attackingUnitIsInBackRow && someoneInAttackingFrontRow) {
                return false;
            }
            if (selectedUnitIsInBackRow && someoneInEnemyFrontRow) {
                return false;
            }
            if (this.attackingUnitIndex == 2 && selected == 6 && (this.getHpLeft(7) > 0 || this.getHpLeft(8) > 0)) {
                return false;
            }
            if (this.attackingUnitIndex == 0 && selected == 8 && (this.getHpLeft(7) > 0 || this.getHpLeft(6) > 0)) {
                return false;
            }
            if (this.attackingUnitIndex == 6 && selected == 2 && (this.getHpLeft(1) > 0 || this.getHpLeft(0) > 0)) {
                return false;
            }
            if (this.attackingUnitIndex == 8 && selected == 0 && (this.getHpLeft(1) > 0 || this.getHpLeft(2) > 0)) {
                return false;
            }
            if (!(this.attackingUnitIndex != 2 || someoneInEnemyFrontRow || selected != 9 || this.getHpLeft(10) <= 0 && this.getHpLeft(11) <= 0)) {
                return false;
            }
            if (!(this.attackingUnitIndex != 0 || someoneInEnemyFrontRow || selected != 11 || this.getHpLeft(10) <= 0 && this.getHpLeft(9) <= 0)) {
                return false;
            }
            if (!(this.attackingUnitIndex != 6 || someoneInEnemyFrontRow || selected != 5 || this.getHpLeft(4) <= 0 && this.getHpLeft(3) <= 0)) {
                return false;
            }
            if (!(this.attackingUnitIndex != 8 || someoneInEnemyFrontRow || selected != 3 || this.getHpLeft(4) <= 0 && this.getHpLeft(5) <= 0)) {
                return false;
            }
        }
        return true;
    }

    public void makeDamage(int i, int realDamage) {
        if (this.getHpLeft(i) <= 0) {
            return;
        }
        int anotherSelectedIndex = this.getAnotherFuckingIndex(i);
        this.makeDamageGlobal(anotherSelectedIndex, realDamage);
        if (this.getHpLeft(i) <= 0) {
            this.deathAnimEnds = false;
            this.justDead[i] = true;
            this.frames[this.DEATH_INDEX] = 0;
            this.ticks[this.DEATH_INDEX] = 0;
            if (i < 6) {
                this.XP_2 = (short)(this.XP_2 + this.unitStaticParams[ArmyController.instance.battleUnits[anotherSelectedIndex * 5 + 0] * 6 + 4]);
            }
            if (i >= 6) {
                this.XP_1 = (short)(this.XP_1 + this.unitStaticParams[ArmyController.instance.battleUnits[anotherSelectedIndex * 5 + 0] * 6 + 4]);
            }
        }
    }

    public void makeDamageGlobal(int anotherSelectedIndex, int realDamage) {
        if (anotherSelectedIndex == -1) {
            return;
        }
        short hpLeft = ArmyController.instance.battleUnits[anotherSelectedIndex * 5 + 1];
        if (hpLeft <= 0) {
            return;
        }
        short defence = this.getDefenceGlobal(anotherSelectedIndex);
        int n = anotherSelectedIndex * 5 + 1;
        ArmyController.instance.battleUnits[n] = (short)(ArmyController.instance.battleUnits[n] - realDamage * (100 - defence) / 100);
        short hpTotal = this.getHpTotalGlobal(anotherSelectedIndex);
        if ((hpLeft = (short)(hpLeft - realDamage)) > hpTotal) {
            ArmyController.instance.battleUnits[anotherSelectedIndex * 5 + 1] = hpTotal;
        }
        if (hpLeft < 0) {
            ArmyController.instance.battleUnits[anotherSelectedIndex * 5 + 1] = 0;
        }
    }

    public void fire() {
        if (this.getAnotherFuckingIndex(this.selectedUnitIndex) == -1) {
            return;
        }
        if (this.applyArtefactAI == -1 && !this.canAttack(this.selectedUnitIndex)) {
            return;
        }
        if (this.fast) {
            boolean attackAll;
            int attackingUnitDamage = this.getDamage(this.attackingUnitIndex);
            int realDamage = attackingUnitDamage % 500;
            boolean bl = attackAll = Globals.abs(attackingUnitDamage) >= 500 && Globals.abs(attackingUnitDamage) < 1000;
            if (this.applyArtefactAI == -1) {
                if (!attackAll) {
                    this.makeDamage(this.selectedUnitIndex, realDamage);
                } else {
                    for (int i = this.selectedUnitIndex / 6 * 6; i < this.selectedUnitIndex / 6 * 6 + 6; ++i) {
                        this.makeDamage(i, realDamage);
                    }
                }
            }
        }
        if (!this.fast) {
            for (int i = 13; i < 18; ++i) {
                this.ticks[i] = 0;
                this.frames[i] = 0;
            }
            DisCanvas.instance.nextGameState = (byte)15;
            if (this.attackingUnitIndex != -1) {
                this.ticks[this.attackingUnitIndex] = 0;
                this.frames[this.attackingUnitIndex] = 0;
            }
            this.persAnimEnds = false;
            this.hurtAnimEnds = false;
            this.deathAnimEnds = false;
        } else {
            this.nextTurn();
        }
    }

    public boolean archEndBattle() {
        for (byte c = 0; c < 2; c = (byte)((byte)(c + 1))) {
            boolean archExist = false;
            int unitsCount = 0;
            for (int i = c == 0 ? 0 : 6; i < (c == 0 ? 6 : 12); i = (int)((byte)(i + 1))) {
                int currUnit = this.getUnitType(i);
                if (currUnit <= -1) continue;
                unitsCount = (byte)(unitsCount + 1);
                if (currUnit != 2 && currUnit != 6) continue;
                archExist = true;
            }
            if (!archExist || unitsCount != true) continue;
            this.endBattle(c);
            this.battleFinished = true;
            return true;
        }
        return false;
    }

    public void ai() {
        int i;
        if (this.fast && this.archEndBattle()) {
            return;
        }
        this.humanTurn = false;
        int attackingUnitDamage = this.getDamage(this.attackingUnitIndex);
        int attackingRealDamage = attackingUnitDamage % 500;
        boolean attackingAttackAll = Globals.abs(attackingUnitDamage) >= 500 && Globals.abs(attackingUnitDamage) < 1000;
        int attackingSide = this.attackingUnitIndex / 6;
        int selectedSide = 1 - attackingSide;
        if (attackingRealDamage < 0) {
            selectedSide = attackingSide;
        }
        int attackingUnitsCount = 0;
        for (int i2 = attackingSide * 6; i2 < attackingSide * 6 + 6; ++i2) {
            if (this.getHpLeft(i2) <= 0) continue;
            ++attackingUnitsCount;
        }
        int attackedUnitsCount = 0;
        for (int i3 = selectedSide * 6; i3 < selectedSide * 6 + 6; ++i3) {
            if (this.getHpLeft(i3) <= 0) continue;
            ++attackedUnitsCount;
        }
        int selectedTotalDamage = 0;
        for (int i4 = selectedSide * 6; i4 < selectedSide * 6 + 6; ++i4) {
            selectedTotalDamage += Globals.abs(this.getDamage(i4) * this.getKillCount(i4)) % 500;
        }
        int attackingTotalDamage = 0;
        for (int i5 = attackingSide * 6; i5 < attackingSide * 6 + 6; ++i5) {
            attackingTotalDamage += Globals.abs(this.getDamage(i5) * this.getKillCount(i5)) % 500;
        }
        int attackingTotalHP = 0;
        for (int i6 = attackingSide * 6; i6 < attackingSide * 6 + 6; ++i6) {
            attackingTotalHP += this.getHpLeft(i6);
        }
        int looseTurnsCount = selectedTotalDamage == 0 ? 1000 : Globals.ceilDiv(attackingTotalHP, selectedTotalDamage) * (attackingUnitsCount * 3 / 2);
        int attackingUnitType = this.getUnitType(this.attackingUnitIndex);
        ArmyCharacter attackingAc = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(this.attackingUnitIndex < 6 ? this.army1 : this.army2);
        int[] koef = new int[12];
        for (i = 0; i < 12; ++i) {
            koef[i] = -100000;
        }
        for (i = selectedSide * 6; i < selectedSide * 6 + 6; ++i) {
            boolean isInFrontRow;
            koef[i] = 0;
            if (!this.canAttack(i)) {
                koef[i] = -100000;
                continue;
            }
            int hpTotal = this.getHpTotal(i);
            int hpLeft = this.getHpLeft(i);
            if (hpLeft <= 0) {
                koef[i] = -100001;
                continue;
            }
            int damage = this.getDamage(i);
            int realDamage = Globals.abs(damage % 500);
            boolean attackAll = Globals.abs(damage) >= 500 && Globals.abs(damage) < 1000;
            int killCount = attackAll ? attackingUnitsCount : 1;
            int healCount = attackAll ? attackedUnitsCount : 1;
            boolean rangeAttack = Globals.abs(damage) > 1000;
            boolean bl = isInFrontRow = i % 6 < 3;
            if (attackingUnitDamage < 0) {
                int n = i;
                koef[n] = koef[n] - hpLeft * 3 / 2;
                int n2 = i;
                koef[n2] = koef[n2] + 10 * hpTotal / (hpLeft + 1);
                int n3 = i;
                koef[n3] = koef[n3] + realDamage / 3;
            }
            if (attackingUnitDamage <= 0) continue;
            if (damage > 0) {
                int n = i;
                koef[n] = koef[n] + 100 * realDamage * killCount / (hpLeft + 10);
            } else {
                int n = i;
                koef[n] = koef[n] + 101 * realDamage * healCount / (hpLeft + 10);
            }
            if (isInFrontRow) {
                int n = i;
                koef[n] = koef[n] + 30;
            }
            if (hpLeft <= attackingRealDamage) {
                int n = i;
                koef[n] = koef[n] + (50 - (attackingRealDamage - hpLeft));
            }
            if (hpLeft == attackingRealDamage) {
                int n = i;
                koef[n] = koef[n] + 35;
            }
            if (attackingTotalDamage != 0) {
                if (hpLeft / attackingTotalDamage > looseTurnsCount) {
                    int n = i;
                    koef[n] = koef[n] - 20;
                } else {
                    int n = i;
                    koef[n] = koef[n] + 20;
                }
            }
            if (i % 6 != 1 && i % 6 != 4) continue;
            int n = i;
            koef[n] = koef[n] + 7;
        }
        this.applyArtefactAI = (byte)-1;
        if (attackingUnitType < 8) {
            for (int n = 0; n < 2; ++n) {
                byte artefact;
                byte slot = attackingAc.inhand[n];
                if (slot == -1 || (artefact = attackingAc.slot[slot]) != 0) continue;
                for (int i7 = attackingSide * 6; i7 < attackingSide * 6 + 6; ++i7) {
                    int hpLeft;
                    int hpTotal = this.getHpTotal(i7);
                    if (hpTotal - (hpLeft = this.getHpLeft(i7)) <= 75) continue;
                    DisCanvas.instance.selArt = slot;
                    ArmyCharacter targetAc = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(i7 < 6 ? this.army1 : this.army2);
                    this.selectedUnitIndex = (byte)i7;
                    this.applyArtefact(attackingAc, targetAc, DisCanvas.instance.currGameState);
                    this.applyArtefactAI = slot;
                    this.fire();
                    return;
                }
                break;
            }
        }
        int maxKoef = -100000;
        for (int i8 = 0; i8 < 12; ++i8) {
            if (koef[i8] <= maxKoef) continue;
            maxKoef = koef[i8];
            this.selectedUnitIndex = (byte)i8;
        }
        if (maxKoef < -70000) {
            this.nextTurn();
            return;
        }
        this.fire();
    }

    static {
        ABILITIES_PER_LEVEL = new byte[]{3, 5, 6, 8, 9, 11, 12, 13, 13, 13, 13, 13, 13, 14};
    }
}

