/*
 * Decompiled with CFR 0.152.
 */
public final class EGame {
    public static GameLogic logic;
    public static int iLevel;
    public static int iSpeed;
    public static int iHighscore;
    public static int iStateCur;
    public static int iDelayUpdateState;
    public static int iDelayEventNext;
    private static long lTimeState;
    private static long lTimeEvent;
    public static byte bGameLast;
    public static boolean uppnigLevel;
    public static final int[] iArrHighScore;

    public static final void init() {
        GameField.init();
        EGameView.init();
    }

    private static final void updateLogic(byte gameType) {
        logic = null;
        System.gc();
        switch (gameType) {
            case 0: {
                logic = new GameLogicTetris();
                break;
            }
            case 1: {
                logic = new GameLogicSnake();
                break;
            }
            case 3: {
                logic = new GameLogicShooter();
                break;
            }
            case 4: {
                logic = new GameLogicTennis();
                break;
            }
            case 2: {
                logic = new GameLogicArcanoid();
                break;
            }
            case 5: {
                logic = new GameLogicRacing();
                break;
            }
            case 6: {
                logic = new GameLogicCycleTetris();
                break;
            }
            case 8: {
                logic = new GameLogicCycleArcanoid();
                break;
            }
            case 10: {
                logic = new GameLogicTanks();
                break;
            }
            case 7: {
                logic = new GameLogicFillingShooter();
                break;
            }
            case 11: {
                logic = new GameLogicPentis();
                break;
            }
            case 9: {
                logic = new GameLogicBrodilka();
                break;
            }
            case 12: {
                logic = new GameLogicIdentix();
                break;
            }
            case 13: {
                logic = new GameLogicBarrierRacing();
                break;
            }
            case 14: {
                logic = new GameLogicShootRacing();
            }
        }
    }

    public static final void load() throws Exception {
        GUtillIo.initRead(GUtillIo.getRsData("retro.games.alex.kipar.game"));
        iLevel = GUtillIo.readInt();
        iSpeed = GUtillIo.readInt();
        iHighscore = GUtillIo.readInt();
        iStateCur = GUtillIo.readInt();
        lTimeState = GUtillIo.readLong();
        lTimeEvent = GUtillIo.readLong();
        bGameLast = GUtillIo.readByte();
        if (iStateCur == 0 || iStateCur == 1) {
            EGame.updateLogic(bGameLast);
            logic.load();
            GameField.load();
        }
    }

    public static final void save() throws Exception {
        GUtillIo.initWrite();
        GUtillIo.writeInt(iLevel);
        GUtillIo.writeInt(iSpeed);
        GUtillIo.writeInt(iHighscore);
        GUtillIo.writeInt(iStateCur);
        GUtillIo.writeLong(lTimeState);
        GUtillIo.writeLong(lTimeEvent);
        GUtillIo.writeByte(bGameLast);
        if (iStateCur == 0 || iStateCur == 1) {
            logic.save();
            GameField.save();
        }
        GUtillIo.saveRsData("retro.games.alex.kipar.game", GUtillIo.toByteArray());
        GUtillIo.closeWrite();
    }

    public static final void start(byte gameType) {
        if (gameType != bGameLast) {
            logic = null;
            EGame.updateLogic(gameType);
            bGameLast = gameType;
            System.gc();
        }
        if (logic == null) {
            EGame.updateLogic(gameType);
            bGameLast = gameType;
            uppnigLevel = false;
        }
        if (logic != null) {
            EGameView.disableFill();
            GameField.clear();
            EGameView.setTextState(4, (byte)0);
            iHighscore = iArrHighScore[gameType];
            logic.clear();
            logic.updateLevel(iLevel);
            iStateCur = 0;
            iDelayUpdateState = Constants.GAME_DELAY[gameType][iSpeed - 1];
            iDelayEventNext = iDelayUpdateState / 1000;
        }
    }

    public static void resetUpdateState() {
        lTimeState = System.currentTimeMillis() + (long)iDelayUpdateState;
    }

    public static final void update() {
        switch (iStateCur) {
            case 0: {
                if (lTimeState < System.currentTimeMillis()) {
                    logic.updateState();
                    EGame.resetUpdateState();
                }
                if (EGame.logic.gameover) {
                    System.gc();
                    E.updateAction(9, 800);
                    iStateCur = 3;
                    EGameView.fill(true);
                    EGameView.bBackgroundIsInvalid = true;
                } else if (EGame.logic.gameup) {
                    System.gc();
                    uppnigLevel = false;
                    boolean shouldFill = false;
                    if (++iSpeed > 15) {
                        iSpeed = 1;
                        if (++iLevel > 15) {
                            --iLevel;
                        }
                        shouldFill = true;
                        uppnigLevel = true;
                    }
                    if (EGame.logic.fillOnSpeedUp || shouldFill) {
                        iStateCur = 3;
                        EGameView.fill(true);
                        uppnigLevel = true;
                    }
                    iDelayUpdateState = Constants.GAME_DELAY[bGameLast][iSpeed - 1];
                    iDelayEventNext = iDelayUpdateState / 1000;
                    EGame.logic.gameup = false;
                    EGameView.bBackgroundIsInvalid = true;
                } else {
                    logic.updateKeys();
                    logic.updateEvent();
                }
                if (EGame.logic.score <= iArrHighScore[bGameLast]) break;
                EGame.iArrHighScore[EGame.bGameLast] = EGame.logic.score;
                iHighscore = EGame.logic.score;
                break;
            }
            case 3: {
                if (EGameView.bIsOnFill) break;
                GameField.clear();
                if (EGame.logic.fillOnSpeedUp && EGame.logic.gameover || !uppnigLevel) {
                    logic.clear();
                }
                logic.updateLevel(iLevel);
                EGame.logic.gameup = false;
                EGameView.fill(false);
                iStateCur = 2;
                EGameView.bBackgroundIsInvalid = true;
                uppnigLevel = false;
                E.clearKeys();
                break;
            }
            case 2: {
                if (EGameView.bIsOnFill) break;
                iStateCur = 0;
                break;
            }
        }
        if (E.keyIsPressed(0)) {
            E.kStates[0] = false;
            E.updateAction(10, -1);
            EGameView.bBackgroundIsInvalid = true;
        } else if (E.keyIsPressed(1)) {
            E.kStates[1] = false;
            if (iStateCur == 0) {
                iStateCur = 1;
                EGameView.setTextState(4, (byte)1);
            } else if (iStateCur == 1) {
                iStateCur = 0;
                EGameView.setTextState(4, (byte)0);
            }
            EGameView.bBackgroundIsInvalid = true;
        }
    }

    public static final void render() {
        if (logic != null) {
            EGameView.render(logic);
        }
    }

    static {
        iLevel = 1;
        iSpeed = 1;
        iHighscore = 0;
        iStateCur = 2;
        iDelayUpdateState = 800;
        iDelayEventNext = 0;
        lTimeState = 0L;
        lTimeEvent = 0L;
        bGameLast = (byte)-1;
        uppnigLevel = false;
        iArrHighScore = new int[15];
    }
}

