/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicArcanoid
extends GameLogic {
    protected static final byte RACKET_MAX_SIZE = 3;
    protected static final int LIFE_MAX = 3;
    protected static final byte SCORE_INC = 10;
    protected static final byte LEVEL_LINE_MIN = 4;
    protected static final byte LEVEL_LINE_W = 3;
    protected byte bRacketSize = (byte)3;
    protected byte bRacketBottom;
    protected final short[] sBallPos = new short[2];
    protected byte bRacketLeft;
    protected byte bRacketRight;
    protected byte bRacketBorderRight;
    protected byte bBallBorderBottom;
    protected byte bStepV;
    protected byte bStepH;
    protected boolean shift = false;
    private int firstFieldIndex = 0;
    private int lastFieldIndex = 0;
    private boolean isHotBall = false;

    public GameLogicArcanoid() {
        super(3, 3);
        this.fillOnSpeedUp = true;
    }

    public final void save() throws Exception {
        super.save();
        GUtillIo.writeByte(this.bRacketSize);
        GUtillIo.writeByte(this.bRacketBottom);
        GUtillIo.writeByte(this.bRacketLeft);
        GUtillIo.writeByte(this.bRacketRight);
        GUtillIo.writeByte(this.bRacketBorderRight);
        GUtillIo.writeByte(this.bBallBorderBottom);
        GUtillIo.writeByte(this.bStepH);
        GUtillIo.writeByte(this.bStepV);
        GUtillIo.writeArray(this.sBallPos);
        GUtillIo.writeInt(this.firstFieldIndex);
        GUtillIo.writeInt(this.lastFieldIndex);
    }

    public final void load() throws Exception {
        super.load();
        this.bRacketSize = GUtillIo.readByte();
        this.bRacketBottom = GUtillIo.readByte();
        this.bRacketLeft = GUtillIo.readByte();
        this.bRacketRight = GUtillIo.readByte();
        this.bRacketBorderRight = GUtillIo.readByte();
        this.bBallBorderBottom = GUtillIo.readByte();
        this.bStepH = GUtillIo.readByte();
        this.bStepV = GUtillIo.readByte();
        GUtillIo.read(this.sBallPos);
        this.firstFieldIndex = GUtillIo.readInt();
        this.lastFieldIndex = GUtillIo.readInt();
        int rowBottom = (this.bRacketBottom + 1) * 10;
        for (int i = 0; i < 10; ++i) {
            GameField.getItem(rowBottom + i).setBrickType(1);
        }
    }

    public final void updateLevel(int level) {
        int levelId = level - 1;
        this.bRacketSize = (byte)(3 - levelId * 3 / 30);
        this.bRacketBottom = (byte)(19 - levelId / 2 - levelId % 2);
        this.bRacketBorderRight = (byte)(10 - this.bRacketSize);
        this.bBallBorderBottom = (byte)(this.bRacketBottom - 1);
        this.placePlayer();
        int width2 = 5;
        int lineCount = 4 + levelId / 4;
        int lineWidth = 3 + levelId % 2;
        int cur = 0;
        this.lastFieldIndex = this.firstFieldIndex = 20;
        for (int i = 0; i < lineCount; ++i) {
            cur = 0;
            int first = (i + 2) * 10;
            while (cur < lineWidth) {
                int rand = GUtillMath.rnd(5);
                int index = first + 5 - 1 - rand;
                if (GameField.getItem(index).brickType() == 1) continue;
                GameField.getItem(index).setBrickType(1);
                GameField.getItem(first + 5 + rand).setBrickType(1);
                this.lastFieldIndex = this.lastFieldIndex > first + 5 + rand ? this.lastFieldIndex : first + 5 + rand;
                ++cur;
            }
        }
        this.lastFieldIndex = (this.lastFieldIndex / 10 + 1) * 10;
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            this.shift = false;
            GameFieldItem oldBrick = new GameFieldItem(GameField.getItem(this.sBallPos).data());
            oldBrick.setBrickType(this.isHotBall ? 4 : 5);
            GameField.getItem(this.sBallPos).setBrickType(0);
            if (this.sBallPos[0] == 0) {
                this.bStepH = 1;
            } else if (this.sBallPos[0] == 9) {
                this.bStepH = 0;
            }
            boolean decr = false;
            if (this.sBallPos[1] == 0) {
                this.changeStepV();
            } else if (this.bStepV == 3) {
                if (this.sBallPos[1] == this.bBallBorderBottom) {
                    if (this.sBallPos[0] == this.bRacketLeft + 1 || this.sBallPos[0] == this.bRacketLeft || this.sBallPos[0] == this.bRacketRight) {
                        this.changeStepV();
                    } else if (this.bStepH == 1 && this.sBallPos[0] == this.bRacketLeft - 1) {
                        this.changeStepV();
                        this.changeStepH();
                    } else if (this.bStepH == 0 && this.sBallPos[0] == this.bRacketRight + 1) {
                        this.changeStepV();
                        this.changeStepH();
                    }
                } else if (this.sBallPos[1] > this.bBallBorderBottom) {
                    this.lifeDecr();
                    GameField.getItem(this.sBallPos).setBrickType(5);
                    decr = true;
                }
            }
            if (!this.gameover && !decr) {
                do {
                    short[] next = new short[2];
                    long score_was = this.score;
                    next[1] = (short)(this.sBallPos[1] + (this.bStepV == 2 ? -1 : 1));
                    next[0] = this.sBallPos[0];
                    boolean tb = false;
                    boolean lr = false;
                    boolean diag = false;
                    if (GameField.getItem(next).brickType() == 1) {
                        GameField.getItem(next).setBrickType(0);
                        this.score += 10;
                        tb = true;
                    }
                    next[0] = (short)(next[0] + (this.bStepH == 0 ? -1 : 1));
                    if (next[0] != 10 && next[0] != -1) {
                        if (GameField.getItem(next).brickType() == 1) {
                            GameField.getItem(next).setBrickType(0);
                            this.score += 10;
                            diag = true;
                        }
                        next[1] = this.sBallPos[1];
                        if (GameField.getItem(next).brickType() == 1) {
                            GameField.getItem(next).setBrickType(0);
                            this.score += 10;
                            GameField.getItem(this.sBallPos).setBrickType(0);
                            lr = true;
                        }
                    }
                    if (score_was != (long)this.score) {
                        if (diag && !lr && !tb) {
                            this.changeStepH();
                            this.changeStepV();
                        } else {
                            if (lr) {
                                this.changeStepH();
                            }
                            if (tb) {
                                this.changeStepV();
                            }
                        }
                    }
                    if (this.sBallPos[0] == 0) {
                        this.bStepH = 1;
                        continue;
                    }
                    if (this.sBallPos[0] != 9) continue;
                    this.bStepH = 0;
                } while (GameField.getItem(this.sBallPos[0] + (this.bStepH == 0 ? -1 : 1), this.sBallPos[1] + (this.bStepV == 2 ? -1 : 1)).brickType() == 1);
                this.updateBall();
                oldBrick.setIsFillingFull(false);
                oldBrick.setIsFillingHed(false);
                GameField.getItem(this.sBallPos).setData(oldBrick.data());
                oldBrick = null;
            }
            boolean fieldIsClean = true;
            for (int i = this.firstFieldIndex; i <= this.lastFieldIndex; ++i) {
                if (GameField.getItem(i).brickType() != 1) continue;
                fieldIsClean = false;
                break;
            }
            if (fieldIsClean) {
                this.gameup = true;
            }
        }
        this.isHotBall = false;
    }

    public final boolean updateEvent() {
        if (this.canUpdate()) {
            this.updatePlayer();
        }
        return false;
    }

    public void keyClicked(int key) {
        if (key == 7 && !this.active) {
            this.active = true;
        }
        if (this.active) {
            if (key == 6 && this.bRacketLeft > 0 || key == 8 && this.bRacketLeft < this.bRacketBorderRight) {
                int direction;
                int n = direction = key == 6 ? -1 : 1;
                if (!this.shift && this.sBallPos[1] == this.bBallBorderBottom && this.sBallPos[0] >= this.bRacketLeft && this.sBallPos[0] <= this.bRacketRight) {
                    GameField.getItem(this.sBallPos).setBrickType(0);
                    this.sBallPos[0] = (short)(this.sBallPos[0] + direction);
                    GameField.getItem(this.sBallPos).setBrickType(5);
                    this.shift = true;
                    this.bStepV = (byte)2;
                }
                this.bRacketLeft = (byte)(this.bRacketLeft + direction);
                this.updateFigure();
            }
            if (key == 7) {
                this.isHotBall = true;
                this.updateState();
                EGame.resetUpdateState();
            }
        }
    }

    protected final void updatePlayer() {
    }

    protected final void updateFigure() {
        this.bRacketRight = (byte)(this.bRacketLeft + this.bRacketSize - 1);
        int bottomIndex = this.bRacketBottom * 10 + this.bRacketLeft;
        for (int i = 0; i < this.bRacketSize; ++i) {
            this.figure_pos[i] = bottomIndex + i;
        }
        if (!this.active) {
            GameField.getItem(this.sBallPos).setBrickType(0);
            this.sBallPos[1] = this.bBallBorderBottom;
            this.sBallPos[0] = (short)(this.bRacketLeft + this.bRacketSize / 2);
            GameField.getItem(this.sBallPos).setBrickType(5);
        }
    }

    protected final void changeStepH() {
        this.bStepH = this.bStepH == 0 ? (byte)1 : 0;
    }

    protected final void changeStepV() {
        this.bStepV = (byte)(this.bStepV == 2 ? 3 : 2);
    }

    protected final void updateBall() {
        this.sBallPos[1] = (short)(this.sBallPos[1] + (this.bStepV == 3 ? 1 : -1));
        this.sBallPos[0] = (short)(this.sBallPos[0] + (this.bStepH == 1 ? 1 : -1));
    }

    protected void placePlayer() {
        this.active = false;
        this.bRacketLeft = (byte)((10 - this.bRacketSize) / 2);
        this.updateFigure();
        this.bStepV = (byte)2;
        this.bStepH = GUtillMath.rnd(2) == 1 ? (byte)1 : 0;
        for (int i = 0; i < this.figure_elem.length; ++i) {
            this.figure_elem[i] = GameFieldItem.playerBrickData();
        }
        int rowBottom = (this.bRacketBottom + 1) * 10;
        for (int i = 0; i < 10; ++i) {
            GameField.getItem(rowBottom + i).setData(GameFieldItem.fieldBrickData());
        }
    }
}

