/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicBrodilka
extends GameLogic {
    private static final int LIFE_MAX = 4;
    private static final byte SCORE_INC = 100;
    private static final int PLAYER_SIZE = 1;
    private static final int FIRST_LINE = 8;
    private static final int LAST_LINE = 19;
    private static final int[][] BRIKS_PER_LINE = new int[][]{{3, 3}, {5}, {2, 3}, {4}, {3}};
    private static final int[] LINE_SPEED = new int[]{2, 3, 1, 2, 3};
    private byte bCurUpdate;
    private int[] iBriksPlacedPos = new int[10];
    private byte bBricksPlaced;

    public GameLogicBrodilka() {
        super(1, 4);
        GameFieldItem.TRAIN_LENGTH = 0;
    }

    protected void load() throws Exception {
        super.load();
        this.bCurUpdate = GUtillIo.readByte();
        this.bShowCollision = GUtillIo.readByte();
        this.iBriksPlacedPos = GUtillIo.readIntArray();
        this.bBricksPlaced = GUtillIo.readByte();
    }

    protected void save() throws Exception {
        super.save();
        GUtillIo.writeByte(this.bCurUpdate);
        GUtillIo.writeByte(this.bShowCollision);
        GUtillIo.writeIntArray(this.iBriksPlacedPos);
        GUtillIo.writeByte(this.bBricksPlaced);
    }

    public void updateLevel(int level) {
        this.iBriksPlacedPos = new int[10];
        this.bBricksPlaced = 0;
        this.placePlayer();
        this.bShowCollision = 0;
    }

    protected void placePlayer() {
        int i;
        this.active = false;
        GameField.clear();
        for (i = 0; i < this.bBricksPlaced; ++i) {
            GameField.setBrickType(this.iBriksPlacedPos[i], 1);
        }
        for (i = 8; i < 19; i += 2) {
            this.fillLine(i);
        }
        for (i = 0; i < BRIKS_PER_LINE.length; ++i) {
            this.fillBarrier(i);
        }
        this.figure_pos[0] = 190 + GUtillMath.rnd(10);
        GameFieldItem tempItem = new GameFieldItem();
        tempItem.setBrickType(2);
        tempItem.setIsHotBrick(true);
        tempItem.setIsBlinking(true);
        tempItem.updateState();
        this.figure_elem[0] = tempItem.data();
        this.bCurUpdate = 1;
    }

    private void fillLine(int index) {
        for (int i = index * 10; i < index * 10 + 10; ++i) {
            GameField.setBrickType(i, 1);
        }
    }

    private void fillBarrier(int index) {
        int fill_index = (9 + 2 * index) * 10 + GUtillMath.rnd(3);
        for (int i = 0; i < BRIKS_PER_LINE[index].length; ++i) {
            for (int j = 0; j < BRIKS_PER_LINE[index][i]; ++j) {
                GameField.setBrickType(fill_index, 1);
                ++fill_index;
            }
            fill_index += 2;
        }
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            if (this.bShowCollision != 0) {
                if (this.bShowCollision == 4) {
                    this.bShowCollision = 0;
                    this.lifeDecr();
                } else {
                    this.bShowCollision = (byte)(this.bShowCollision + 1);
                }
            } else {
                for (int i = 0; i < LINE_SPEED.length; ++i) {
                    if (this.bCurUpdate % LINE_SPEED[i] != 0) continue;
                    this.cycleLine(i);
                }
                this.checkCollision();
                this.bCurUpdate = this.bCurUpdate != 3 ? (byte)(this.bCurUpdate + 1) : (byte)1;
            }
        }
    }

    private void cycleLine(int index) {
        if (index % 2 == 0) {
            int first = (9 + 2 * index) * 10;
            int last = first + 10;
            int temp = GameField.getItem(first).data();
            for (int i = first + 1; i < last; ++i) {
                if (i == this.figure_pos[0]) {
                    GameField.setBrickType(i - 1, 0);
                }
                GameField.getItem(i - 1).setData(GameField.getItem(i).data());
            }
            GameField.getItem(last - 1).setData(temp);
        } else {
            int first = (9 + 2 * index) * 10 + 9;
            int last = first - 10;
            int temp = GameField.getItem(first).data();
            for (int i = first - 1; i > last; --i) {
                if (i == this.figure_pos[0]) {
                    GameField.setBrickType(i + 1, 0);
                }
                GameField.getItem(i + 1).setData(GameField.getItem(i).data());
            }
            GameField.getItem(last + 1).setData(temp);
        }
    }

    public void keyClicked(int key) {
        if (key == 7 && !this.active) {
            E.kStates[7] = false;
            this.active = true;
        } else if (this.active && this.bShowCollision == 0) {
            if (key == 6) {
                E.kStates[6] = false;
                if (this.figure_pos[0] % 10 != 0) {
                    this.figure_pos[0] = this.figure_pos[0] - 1;
                    this.checkCollision();
                }
            } else if (key == 8) {
                E.kStates[8] = false;
                if (this.figure_pos[0] % 10 != 9) {
                    this.figure_pos[0] = this.figure_pos[0] + 1;
                    this.checkCollision();
                }
            } else if (key == 4 || key == 7) {
                E.kStates[4] = false;
                E.kStates[7] = false;
                this.figure_pos[0] = this.figure_pos[0] - 20;
                this.checkCollision();
                if (this.bShowCollision == 0) {
                    this.checkIfLast();
                }
            } else if (key == 10) {
                E.kStates[10] = false;
                if (this.figure_pos[0] / 10 != 19) {
                    this.figure_pos[0] = this.figure_pos[0] + 20;
                    this.checkCollision();
                }
            }
        }
    }

    public boolean updateEvent() {
        return false;
    }

    private final void checkIfLast() {
        if (this.figure_pos[0] / 10 < 8) {
            this.bBricksPlaced = (byte)(this.bBricksPlaced + 1);
            this.iBriksPlacedPos[this.bBricksPlaced - 1] = this.figure_pos[0];
            GameField.setBrickType(this.figure_pos[0], 1);
            this.figure_pos[0] = 190 + GUtillMath.rnd(10);
            this.score += 100;
            this.checkVictory();
        }
    }

    private final void checkVictory() {
        if (this.bBricksPlaced == 10) {
            this.bBricksPlaced = 0;
            this.gameup = true;
            this.placePlayer();
        }
    }

    private final void showCollision() {
        int collision_pos = this.figure_pos[0];
        GameField.getItem(collision_pos).setData(0);
        this.figure_elem[0] = -1;
        this.collisionAtPos(collision_pos - 11);
    }

    private final void checkCollision() {
        if (GameField.getBrickType(this.figure_pos[0]) == 1) {
            this.showCollision();
        }
    }
}

