/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicTennis
extends GameLogic {
    private static final byte RACKET_MAX_SIZE = 3;
    private static final byte SCORE_INC = 10;
    private static final int SCORE_UP_MIN = 300;
    private static final int SCORE_UP_INC = 400;
    private static final int LIFE_MAX = 3;
    private byte bRacketSize = (byte)3;
    private byte bRacketBottom;
    private byte bRacketTop;
    private final short[] sBallPos = new short[2];
    private byte bRacketLeft;
    private byte bRacketRight;
    private byte bRacketBorderRight;
    private byte bBarrierSize;
    private byte bBarrierLeft;
    private byte bBarrierRight;
    private byte bBarrierTop;
    private byte bBarrierV;
    private byte UpdateBarrier;
    private byte bBallBorderTop;
    private byte bBallBorderBottom;
    private byte bStepV;
    private byte bStepH;
    private short sScoreUp = 0;
    private boolean isHotBall = false;

    public GameLogicTennis() {
        super(6, 3);
    }

    public final void save() throws Exception {
        super.save();
        GUtillIo.writeByte(this.bRacketSize);
        GUtillIo.writeByte(this.bRacketBottom);
        GUtillIo.writeByte(this.bRacketTop);
        GUtillIo.writeByte(this.bRacketLeft);
        GUtillIo.writeByte(this.bRacketRight);
        GUtillIo.writeByte(this.bRacketBorderRight);
        GUtillIo.writeByte(this.bBarrierSize);
        GUtillIo.writeByte(this.bBarrierTop);
        GUtillIo.writeByte(this.bBarrierLeft);
        GUtillIo.writeByte(this.bBarrierRight);
        GUtillIo.writeByte(this.bBarrierV);
        GUtillIo.writeByte(this.bBallBorderTop);
        GUtillIo.writeByte(this.bBallBorderBottom);
        GUtillIo.writeByte(this.bStepH);
        GUtillIo.writeByte(this.bStepV);
        GUtillIo.writeShort(this.sScoreUp);
        GUtillIo.writeArray(this.sBallPos);
    }

    public final void load() throws Exception {
        super.load();
        this.bRacketSize = GUtillIo.readByte();
        this.bRacketBottom = GUtillIo.readByte();
        this.bRacketTop = GUtillIo.readByte();
        this.bRacketLeft = GUtillIo.readByte();
        this.bRacketRight = GUtillIo.readByte();
        this.bRacketBorderRight = GUtillIo.readByte();
        this.bBarrierSize = GUtillIo.readByte();
        this.bBarrierTop = GUtillIo.readByte();
        this.bBarrierLeft = GUtillIo.readByte();
        this.bBarrierRight = GUtillIo.readByte();
        this.bBarrierV = GUtillIo.readByte();
        this.bBallBorderTop = GUtillIo.readByte();
        this.bBallBorderBottom = GUtillIo.readByte();
        this.bStepH = GUtillIo.readByte();
        this.bStepV = GUtillIo.readByte();
        this.sScoreUp = GUtillIo.readShort();
        GUtillIo.read(this.sBallPos);
        int rowTop = (this.bRacketTop - 1) * 10;
        int rowBottom = (this.bRacketBottom + 1) * 10;
        for (int i = 0; i < 10; ++i) {
            GameField.setBrickType(rowTop + i, 1);
            GameField.setBrickType(rowBottom + i, 1);
        }
    }

    public final void updateLevel(int level) {
        int width = 10;
        int levelId = level - 1;
        this.sScoreUp = (short)(300 + 400 * levelId);
        this.bRacketSize = (byte)(3 - levelId * 3 / 30);
        this.bRacketTop = (byte)(levelId / 2);
        this.bRacketBottom = (byte)(19 - levelId / 2 - levelId % 2);
        this.bRacketBorderRight = (byte)(10 - this.bRacketSize);
        this.bBallBorderTop = (byte)(this.bRacketTop + 1);
        this.bBallBorderBottom = (byte)(this.bRacketBottom - 1);
        this.bBarrierSize = (byte)(2 + levelId / 7);
        this.bBarrierLeft = (byte)3;
        this.bBarrierTop = (byte)9;
        this.bBarrierV = 1;
        this.UpdateBarrier = 1;
        this.updateBarrier();
        this.placePlayer();
    }

    public final void updateState() {
        if (this.active && this.canUpdate()) {
            boolean decr = false;
            GameFieldItem oldBrick = new GameFieldItem(GameField.getItem(this.sBallPos).data());
            oldBrick.setBrickType(this.isHotBall ? 4 : 5);
            if (this.isHotBall) {
                oldBrick.setIsHotBrick(true);
            } else {
                oldBrick.setIsHotBrick(false);
            }
            GameField.getItem(this.sBallPos).setBrickType(0);
            if (this.sBallPos[0] == 0) {
                this.bStepH = 1;
            } else if (this.sBallPos[0] == 9) {
                this.bStepH = 0;
            }
            if (this.sBallPos[1] == this.bBallBorderTop && this.bStepV == 2 || this.sBallPos[1] == this.bBallBorderBottom && this.bStepV == 3) {
                if (this.bStepH == 0) {
                    if (this.sBallPos[0] <= this.bRacketRight && this.sBallPos[0] >= this.bRacketLeft) {
                        this.score += 10;
                        this.CurrentScore += 10;
                        this.changeStepV();
                    } else if (this.sBallPos[0] == this.bRacketRight + 1) {
                        this.score += 10;
                        this.CurrentScore += 10;
                        this.changeStepV();
                        this.changeStepH();
                    } else {
                        this.lifeDecr();
                        decr = true;
                    }
                } else if (this.sBallPos[0] >= this.bRacketLeft && this.sBallPos[0] <= this.bRacketRight) {
                    this.score += 10;
                    this.CurrentScore += 10;
                    this.changeStepV();
                } else if (this.sBallPos[0] == this.bRacketLeft - 1) {
                    this.score += 10;
                    this.CurrentScore += 10;
                    this.changeStepV();
                    this.changeStepH();
                } else {
                    this.lifeDecr();
                    decr = true;
                }
            }
            if (!this.gameover && !decr) {
                short[] next = new short[2];
                next[1] = (short)(this.sBallPos[1] + (this.bStepV == 2 ? -1 : 1));
                next[0] = this.sBallPos[0];
                boolean tb = false;
                boolean lr = false;
                boolean diag = false;
                if (GameField.getBrickType(next) == 1) {
                    tb = true;
                }
                next[0] = (short)(next[0] + (this.bStepH == 0 ? -1 : 1));
                if (next[0] != 10 && next[0] != -1) {
                    if (GameField.getBrickType(next) == 1) {
                        diag = true;
                    }
                    next[1] = this.sBallPos[1];
                    if (GameField.getBrickType(next) == 1) {
                        lr = true;
                    }
                }
                if (diag && !lr && !tb) {
                    this.changeStepH();
                    this.changeStepV();
                } else {
                    if (lr) {
                        this.changeStepH();
                    }
                    if (tb) {
                        this.changeStepV();
                    }
                }
                if (this.sBallPos[0] == 0) {
                    this.bStepH = 1;
                } else if (this.sBallPos[0] == 9) {
                    this.bStepH = 0;
                }
            }
            if (!this.gameover && this.active) {
                this.sBallPos[1] = (short)(this.sBallPos[1] + (this.bStepV == 3 ? 1 : -1));
                this.sBallPos[0] = (short)(this.sBallPos[0] + (this.bStepH == 1 ? 1 : -1));
                if (this.sBallPos[1] == this.bBarrierTop && this.sBallPos[0] == this.bBarrierRight + 1 && this.bBarrierV == 1 && this.UpdateBarrier == 3) {
                    this.sBallPos[0] = (short)(this.sBallPos[0] + 1);
                }
                if (this.sBallPos[1] == this.bBarrierTop && this.sBallPos[0] == this.bBarrierLeft - 1 && this.bBarrierV == -1 && this.UpdateBarrier == 3) {
                    this.sBallPos[0] = (short)(this.sBallPos[0] - 1);
                }
                oldBrick.setIsFillingFull(false);
                oldBrick.setIsFillingHed(false);
                GameField.getItem(this.sBallPos).setData(oldBrick.data());
                oldBrick = null;
                if (this.UpdateBarrier == 3) {
                    this.updateBarrier();
                    this.UpdateBarrier = 1;
                } else {
                    this.UpdateBarrier = (byte)(this.UpdateBarrier + 1);
                }
            }
            if (this.CurrentScore >= this.sScoreUp) {
                this.CurrentScore = 0;
                this.gameup = true;
            }
        }
        this.isHotBall = false;
    }

    public void keyClicked(int key) {
        boolean result = false;
        if (this.canUpdate()) {
            if (key == 7 && !this.active) {
                this.active = true;
                result = true;
            }
            if (this.active) {
                if (key == 6) {
                    if (this.bRacketLeft > 0) {
                        this.bRacketLeft = (byte)(this.bRacketLeft - 1);
                        result = true;
                    }
                } else if (key == 8 && this.bRacketLeft < this.bRacketBorderRight) {
                    this.bRacketLeft = (byte)(this.bRacketLeft + 1);
                    result = true;
                }
                if (key == 7) {
                    this.isHotBall = true;
                    this.updateState();
                    EGame.resetUpdateState();
                }
            }
            if (result) {
                this.updateFigure();
            }
        }
    }

    public final boolean updateEvent() {
        return false;
    }

    private final void updateFigure() {
        this.bRacketRight = (byte)(this.bRacketLeft + this.bRacketSize - 1);
        int width = 10;
        int topIndex = this.bRacketTop * 10 + this.bRacketLeft;
        int bottomIndex = this.bRacketBottom * 10 + this.bRacketLeft;
        for (int i = 0; i < this.bRacketSize; ++i) {
            this.figure_pos[i] = topIndex + i;
            this.figure_pos[3 + i] = bottomIndex + i;
        }
        if (!this.active) {
            GameField.setBrickType(this.sBallPos, 0);
            this.sBallPos[0] = (short)(this.bRacketLeft + this.bRacketSize / 2);
            GameField.setBrickType(this.sBallPos, 5);
        }
    }

    private final void changeStepH() {
        this.bStepH = this.bStepH == 0 ? (byte)1 : 0;
    }

    private final void changeStepV() {
        this.bStepV = (byte)(this.bStepV == 2 ? 3 : 2);
    }

    protected final void placePlayer() {
        int i;
        this.active = false;
        this.bRacketLeft = (byte)((10 - this.bRacketSize) / 2);
        this.sBallPos[1] = this.bBallBorderBottom;
        this.sBallPos[0] = (short)(this.bRacketLeft + this.bRacketSize / 2);
        int rowTop = (this.bRacketTop - 1) * 10;
        int rowBottom = (this.bRacketBottom + 1) * 10;
        for (i = 0; i < 10; ++i) {
            GameField.setBrickType(rowTop + i, 1);
            GameField.setBrickType(rowBottom + i, 1);
        }
        GameField.setBrickType(this.sBallPos, 5);
        this.bStepV = (byte)2;
        this.bStepH = 1;
        for (i = 0; i < this.figure_elem.length; ++i) {
            this.figure_elem[i] = GameFieldItem.playerBrickData();
        }
        this.updateFigure();
    }

    protected final void updateBarrier() {
        int i;
        this.bBarrierRight = (byte)(this.bBarrierLeft + this.bBarrierSize - 1);
        for (i = this.bBarrierLeft; i <= this.bBarrierRight; ++i) {
            GameField.setBrickType(i, this.bBarrierTop, 0);
        }
        if (this.bBarrierRight == 9 && this.bBarrierV == 1) {
            this.bBarrierV = (byte)-1;
        }
        if (this.bBarrierLeft == 0 && this.bBarrierV == -1) {
            this.bBarrierV = 1;
        }
        this.bBarrierLeft = (byte)(this.bBarrierLeft + this.bBarrierV);
        this.bBarrierRight = (byte)(this.bBarrierRight + this.bBarrierV);
        for (i = (int)this.bBarrierLeft; i <= this.bBarrierRight; ++i) {
            GameField.setBrickType(i, this.bBarrierTop, 1);
        }
    }
}

