/*
 * Decompiled with CFR 0.152.
 */
package gravity_edit;

import gravity_edit.League;
import gravity_edit.Level;
import gravity_edit.Point2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class Levels {
    League[] leagues = new League[3];

    Levels() {
    }

    void Load(byte[] byArray) {
        try {
            int n;
            int n2;
            int n3;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int[][] nArrayArray = new int[3][];
            for (n3 = 0; n3 < 3; ++n3) {
                n2 = dataInputStream.readInt();
                this.leagues[n3] = new League();
                nArrayArray[n3] = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArrayArray[n3][i] = dataInputStream.readInt();
                    Level level = new Level();
                    do {
                        if ((n = (int)dataInputStream.readByte()) == 0) continue;
                        level.Name = level.Name + (char)n;
                    } while (n != 0);
                    this.leagues[n3].AddLevel(level);
                }
            }
            for (n3 = 0; n3 < 3; ++n3) {
                for (n2 = 0; n2 < this.leagues[n3].Count(); ++n2) {
                    dataInputStream.close();
                    dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    dataInputStream.skip(nArrayArray[n3][n2]);
                    Level level = this.leagues[n3].GetLevel(n2);
                    byte by = dataInputStream.readByte();
                    n = dataInputStream.readInt();
                    level.x0 = n >> 16 << 3;
                    n = dataInputStream.readInt();
                    level.y0 = n >> 16 << 3;
                    n = dataInputStream.readInt();
                    level.xEnd = n >> 16 << 3;
                    n = dataInputStream.readInt();
                    level.yEnd = n >> 16 << 3;
                    short s = dataInputStream.readShort();
                    int n4 = dataInputStream.readInt();
                    int n5 = dataInputStream.readInt();
                    Point2 point2 = new Point2();
                    point2.x = n4;
                    point2.y = n5;
                    level.AddPoint(point2);
                    for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                        int n6;
                        int n7;
                        Point2 point22 = new Point2();
                        int n8 = dataInputStream.readByte();
                        if (n8 == -1) {
                            n4 = 0;
                            n7 = dataInputStream.readInt();
                            n6 = dataInputStream.readInt();
                        } else {
                            n7 = n8;
                            n6 = dataInputStream.readByte();
                        }
                        point22.x = n4 += n7;
                        point22.y = n5 += n6;
                        level.AddPoint(point22);
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    void Load() {
        byte[] byArray = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/levels.mrg"));
            int n = 0;
            int n2 = 0;
            while (n != -1) {
                n = dataInputStream.read();
                if (n == -1) continue;
                ++n2;
            }
            byArray = new byte[n2];
            dataInputStream.close();
            dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/levels.mrg"));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.Load(byArray);
    }

    byte[] Save() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        try {
            int n;
            int n2;
            int[][] nArrayArray = new int[3][];
            int[][] nArrayArray2 = new int[3][];
            int n3 = 0;
            for (n2 = 0; n2 < 3; ++n2) {
                nArrayArray[n2] = new int[this.leagues[n2].Count()];
                nArrayArray2[n2] = new int[this.leagues[n2].Count()];
                dataOutputStream.writeInt(this.leagues[n2].Count());
                n3 += 4;
                for (n = 0; n < this.leagues[n2].Count(); ++n) {
                    nArrayArray[n2][n] = n3;
                    dataOutputStream.writeInt(0);
                    n3 += 4;
                    for (int i = 0; i < this.leagues[n2].GetLevel((int)n).Name.length(); ++i) {
                        dataOutputStream.writeByte(this.leagues[n2].GetLevel((int)n).Name.charAt(i));
                        ++n3;
                    }
                    dataOutputStream.writeByte(0);
                    ++n3;
                }
            }
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < this.leagues[n2].Count(); ++n) {
                    Level level = this.leagues[n2].GetLevel(n);
                    nArrayArray2[n2][n] = n3++;
                    dataOutputStream.writeByte(51);
                    dataOutputStream.writeInt(level.x0 << 16 >> 3);
                    n3 += 4;
                    dataOutputStream.writeInt(level.y0 << 16 >> 3);
                    n3 += 4;
                    dataOutputStream.writeInt(level.xEnd << 16 >> 3);
                    n3 += 4;
                    dataOutputStream.writeInt(level.yEnd << 16 >> 3);
                    n3 += 4;
                    dataOutputStream.writeShort((short)level.Count());
                    n3 += 2;
                    Point2 point2 = level.GetPoint(0);
                    dataOutputStream.writeInt(point2.x);
                    dataOutputStream.writeInt(point2.y);
                    n3 += 8;
                    for (int i = 1; i < level.Count(); ++i) {
                        Point2 point22 = level.GetPoint(i);
                        dataOutputStream.writeByte(point22.x - point2.x);
                        dataOutputStream.writeByte(point22.y - point2.y);
                        n3 += 2;
                        point2 = point22;
                    }
                }
            }
            byArray = byteArrayOutputStream.toByteArray();
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < this.leagues[n2].Count(); ++n) {
                    byArray[nArrayArray[n2][n] + 0] = (byte)(nArrayArray2[n2][n] >> 24 & 0xFF);
                    byArray[nArrayArray[n2][n] + 1] = (byte)(nArrayArray2[n2][n] >> 16 & 0xFF);
                    byArray[nArrayArray[n2][n] + 2] = (byte)(nArrayArray2[n2][n] >> 8 & 0xFF);
                    byArray[nArrayArray[n2][n] + 3] = (byte)(nArrayArray2[n2][n] >> 0 & 0xFF);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return byArray;
    }
}

