/*
 * Decompiled with CFR 0.152.
 */
package gravity_edit;

import gravity_edit.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CustomFont {
    private static final int KNOCKOUT = 0xFFFFFF;
    private static Hashtable fontCache = new Hashtable();
    private FontData font = null;
    private int[] data;
    private int[] buf;
    private char[] charBuf;

    public CustomFont(String string) {
        System.out.println("CustomFont init " + string);
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        this.font = (FontData)fontCache.get(string);
        if (this.font == null) {
            this.font = new FontData(string);
            fontCache.put(string, this.font);
        }
        this.data = this.font.data;
        this.buf = new int[this.font.bufWidth * this.font.height];
        this.charBuf = new char[128];
    }

    public void setColor(int n) {
        int[] nArray = this.data == this.font.data ? new int[this.data.length] : this.data;
        for (int i = 0; i < this.data.length; ++i) {
            int n2 = this.font.data[i] & 0xFF;
            nArray[i] = (255 - n2 & 0xFF) << 24 | n & 0xFFFFFF;
        }
        this.data = nArray;
    }

    public int getHeight() {
        return this.font.height;
    }

    public int stringWidth(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = this.font.alphabet.indexOf(string.charAt(i));
            if (n2 < 0) continue;
            n += this.font.sep[n2] + 1;
        }
        if (n > 0) {
            --n;
        }
        return n;
    }

    public int substringWidth(String string, int n, int n2) {
        return this.charsWidth(string.toCharArray(), n, n2);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            int n4 = this.font.alphabet.indexOf(cArray[i]);
            if (n4 < 0) continue;
            n3 += this.font.sep[n4] + 1;
        }
        if (n3 > 0) {
            --n3;
        }
        return n3;
    }

    public void drawString(Graphics graphics, String string, int n, int n2) {
        int n3 = Math.min(string.length(), this.charBuf.length);
        for (int i = 0; i < n3; ++i) {
            this.charBuf[i] = string.charAt(i);
        }
        this.drawChars(graphics, this.charBuf, 0, n3, n, n2);
    }

    public void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        for (int i = n; i < n + n2; ++i) {
            int n6 = this.font.alphabet.indexOf(cArray[i]);
            if (n6 < 0) continue;
            int n7 = this.font.sepOffset[n6];
            int n8 = this.font.sep[n6];
            for (int j = 0; j < this.font.height; ++j) {
                System.arraycopy(this.data, n7 + j * this.font.dataWidth, this.buf, n5 + j * this.font.bufWidth, n8);
                this.buf[n5 + n8 + j * ((FontData)this.font).bufWidth] = 0xFFFFFF;
            }
            if ((n5 += n8 + 1) >= this.font.bufWidth) break;
        }
        graphics.drawRGB(this.buf, 0, this.font.bufWidth, n3, n4, n5, this.buf.length / this.font.bufWidth, true);
    }

    class FontData {
        private int[] data;
        private int[] sep;
        private int[] sepOffset;
        private String alphabet;
        private int height;
        private int bufWidth;
        private int dataWidth;

        public FontData(String string) {
            InputStream inputStream = null;
            String string2 = null;
            try {
                Image image = Image.createImage((String)(string + ".png"));
                this.height = image.getHeight();
                this.data = new int[image.getWidth() * this.height];
                this.dataWidth = image.getWidth();
                this.bufWidth = 240;
                image.getRGB(this.data, 0, image.getWidth(), 0, 0, image.getWidth(), this.height);
                string2 = string + ".dat";
                inputStream = this.getClass().getResourceAsStream(string2);
                this.alphabet = Util.readUnicodeLine(inputStream);
                String string3 = Util.readUnicodeLine(inputStream);
                this.sep = new int[string3.length()];
                this.sepOffset = new int[this.sep.length];
                int n = 0;
                for (int i = 0; i < this.sep.length; ++i) {
                    char c = string3.charAt(i);
                    if (c >= '0' && c <= '9') {
                        this.sep[i] = string3.charAt(i) - 48;
                    } else if (c >= 'A' && c <= 'Z') {
                        this.sep[i] = string3.charAt(i) - 65 + 10;
                    }
                    this.sepOffset[i] = n;
                    n += this.sep[i];
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("can't get font data: " + string2);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

