/*
 * Decompiled with CFR 0.152.
 */
package gravity_edit;

import gravity_edit.CustomFont;
import gravity_edit.League;
import gravity_edit.Level;
import gravity_edit.Levels;
import gravity_edit.Main;
import gravity_edit.Point2;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;

class MyCanvas
extends Canvas
implements CommandListener {
    static final int kLEFT = 0;
    static final int kRIGHT = 1;
    static final int kUP = 2;
    static final int kDOWN = 3;
    static final int kNUM1 = 4;
    static final int kNUM2 = 5;
    static final int kNUM3 = 6;
    static final int kNUM4 = 7;
    static final int kNUM5 = 8;
    static final int kNUM6 = 9;
    static final int kNUM7 = 10;
    static final int kNUM8 = 11;
    static final int kNUM9 = 12;
    static final int kNUM0 = 13;
    static final int kSTAR = 14;
    static final int kSHARP = 15;
    static final int INFINITY = Integer.MAX_VALUE;
    public static final int FILE_RMS = 0;
    public static final int FILE_SIEMENS = 1;
    public static final int FILE_JSR75 = 2;
    public static final int FILE_SYMBIAN = 3;
    int iCurVertex = -1;
    String sStatus = "Ready";
    int iStatusTimeout = Integer.MAX_VALUE;
    Form formOptions = null;
    ChoiceGroup cgOptView = new ChoiceGroup("\u0412\u0438\u0434", 2);
    TextField tfRootJsr75 = new TextField("Jsr-75 \u043a\u043e\u0440\u0435\u043d\u044c", "c:\\", 8, 0);
    TextField tfRootSiemens = new TextField("Siemens \u043a\u043e\u0440\u0435\u043d\u044c", "0:\\", 8, 0);
    TextField tfRootSymbian = new TextField("Symbian \u043a\u043e\u0440\u0435\u043d\u044c", "e:\\", 8, 0);
    TextField tfSpeed = new TextField("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u043a\u0443\u0440\u0441\u043e\u0440\u0430", "100", 3, 2);
    int nSpeed = 100;
    int curLevel = 0;
    int curTrack = 0;
    List lsLevel = null;
    List lsEasy = null;
    List lsMedium = null;
    List lsPro = null;
    boolean bDrawVertexCoords = false;
    public int nFileAccess = 0;
    boolean[] keys = new boolean[16];
    Command cmdOptions = new Command("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", 1, 1);
    Command cmdManage = new Command("\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440 \u0443\u0440\u043e\u0432\u043d\u0435\u0439", 1, 1);
    Command cmdExit = new Command("\u0412\u044b\u0445\u043e\u0434", 1, 1);
    Command cmdSave = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 1, 1);
    Command cmdLoad = new Command("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c", 1, 1);
    TextField tfFileNameSave = new TextField("\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430", "levels.mrg", 32, 0);
    TextField tfFileNameLoad = new TextField("\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430", "levels.mrg", 32, 0);
    Form formSave = new Form("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
    Form formLoad = new Form("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c");
    ChoiceGroup cgFileModeSave = new ChoiceGroup("\u0424\u0430\u0439\u043b\u043e\u0432\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430", 4);
    ChoiceGroup cgFileModeLoad = new ChoiceGroup("\u0424\u0430\u0439\u043b\u043e\u0432\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430", 4);
    Command cmdOk = new Command("\u041e\u043a", 4, 1);
    Command cmdBack = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 1);
    Command cmdCopy = new Command("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", 1, 1);
    Command cmdPaste = new Command("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", 1, 1);
    Command cmdMoveUp = new Command("\u041f\u0435\u0440\u0435\u043c. \u0432\u0432\u0435\u0440\u0445", 1, 1);
    Command cmdMoveDown = new Command("\u041f\u0435\u0440\u0435\u043c. \u0432\u043d\u0438\u0437", 1, 1);
    Command cmdCreateNew = new Command("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c", 1, 1);
    Command cmdRemove = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", 1, 1);
    Command cmdLevelProp = new Command("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0443\u0440\u043e\u0432\u043d\u044f", 1, 1);
    Main mMain;
    CustomFont font;
    Form formLevelProp = new Form("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0443\u0440\u043e\u0432\u043d\u044f");
    TextField propName = new TextField("Name", "", 12, 0);
    int iCopyLeague = -1;
    int iCopyTrack = -1;
    int w = 176;
    int h = 208;
    int camX = 0;
    int camY = 0;
    long lastTime = System.currentTimeMillis();
    long lTimeInMove = 0L;
    boolean bCanLeft = true;
    boolean bCanRight = true;
    boolean bCanUp = true;
    boolean bCanDown = true;

    MyCanvas(Main main) {
        this.setFullScreenMode(true);
        this.mMain = main;
        for (int i = 0; i < 16; ++i) {
            this.keys[i] = false;
        }
        this.font = new CustomFont("7pt-proportional");
        this.font.setColor(0);
        this.formOptions = new Form("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        this.formOptions.addCommand(this.cmdOk);
        this.formOptions.setCommandListener((CommandListener)this);
        this.cgOptView.append("\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u0442\u043e\u0447\u0435\u043a", null);
        this.formOptions.append((Item)this.tfSpeed);
        this.formOptions.append((Item)this.cgOptView);
        this.formOptions.append((Item)this.tfRootJsr75);
        this.formOptions.append((Item)this.tfRootSiemens);
        this.formOptions.append((Item)this.tfRootSymbian);
        this.cgFileModeSave.append("Rms", null);
        this.cgFileModeSave.append("Siemens", null);
        this.cgFileModeSave.append("Jsr-75", null);
        this.cgFileModeSave.append("Symbian", null);
        this.cgFileModeLoad.append("Rms", null);
        this.cgFileModeLoad.append("Siemens", null);
        this.cgFileModeLoad.append("Jsr-75", null);
        this.cgFileModeLoad.append("Symbian", null);
        this.formSave.append((Item)this.cgFileModeSave);
        this.formSave.append((Item)this.tfFileNameSave);
        this.formLoad.append((Item)this.cgFileModeLoad);
        this.formLoad.append((Item)this.tfFileNameLoad);
        this.formSave.addCommand(this.cmdOk);
        this.formSave.addCommand(this.cmdBack);
        this.formLoad.addCommand(this.cmdOk);
        this.formLoad.addCommand(this.cmdBack);
        this.formSave.setCommandListener((CommandListener)this);
        this.formLoad.setCommandListener((CommandListener)this);
        String[] stringArray = new String[]{"\u041b\u0435\u0433\u043a\u0438\u0439", "\u0421\u0440\u0435\u0434\u043d\u0438\u0439", "\u0421\u043b\u043e\u0436\u043d\u044b\u0439"};
        this.lsLevel = new List("\u0423\u0440\u043e\u0432\u0435\u043d\u044c", 3, stringArray, null);
        this.lsLevel.addCommand(this.cmdBack);
        this.lsLevel.setCommandListener((CommandListener)this);
        this.lsEasy = new List("\u041b\u0435\u0433\u043a\u0438\u0439", 3);
        this.lsEasy.addCommand(this.cmdBack);
        this.lsEasy.addCommand(this.cmdMoveUp);
        this.lsEasy.addCommand(this.cmdMoveDown);
        this.lsEasy.addCommand(this.cmdCopy);
        this.lsEasy.addCommand(this.cmdPaste);
        this.lsEasy.addCommand(this.cmdCreateNew);
        this.lsEasy.addCommand(this.cmdRemove);
        this.lsEasy.setCommandListener((CommandListener)this);
        this.lsMedium = new List("\u0421\u0440\u0435\u0434\u043d\u0438\u0439", 3);
        this.lsMedium.addCommand(this.cmdBack);
        this.lsMedium.addCommand(this.cmdMoveUp);
        this.lsMedium.addCommand(this.cmdMoveDown);
        this.lsMedium.addCommand(this.cmdCopy);
        this.lsMedium.addCommand(this.cmdPaste);
        this.lsMedium.addCommand(this.cmdCreateNew);
        this.lsMedium.addCommand(this.cmdRemove);
        this.lsMedium.setCommandListener((CommandListener)this);
        this.lsPro = new List("\u0421\u043b\u043e\u0436\u043d\u044b\u0439", 3);
        this.lsPro.addCommand(this.cmdBack);
        this.lsPro.addCommand(this.cmdMoveUp);
        this.lsPro.addCommand(this.cmdMoveDown);
        this.lsPro.addCommand(this.cmdCopy);
        this.lsPro.addCommand(this.cmdPaste);
        this.lsPro.addCommand(this.cmdCreateNew);
        this.lsPro.addCommand(this.cmdRemove);
        this.lsPro.setCommandListener((CommandListener)this);
        this.UpdateList();
        this.addCommand(this.cmdLevelProp);
        this.addCommand(this.cmdManage);
        this.addCommand(this.cmdSave);
        this.addCommand(this.cmdLoad);
        this.addCommand(this.cmdOptions);
        this.addCommand(this.cmdExit);
        this.setCommandListener(this);
        this.formLevelProp.append((Item)this.propName);
        this.formLevelProp.addCommand(this.cmdOk);
        this.formLevelProp.addCommand(this.cmdBack);
        this.formLevelProp.setCommandListener((CommandListener)this);
        this.bCanLeft = true;
        this.bCanRight = true;
        this.bCanUp = true;
        this.bCanDown = true;
    }

    void UpdateList() {
        int n;
        this.lsEasy.deleteAll();
        this.lsMedium.deleteAll();
        this.lsPro.deleteAll();
        League league = this.mMain.levels.leagues[0];
        for (n = 0; n < league.Count(); ++n) {
            this.lsEasy.append(league.GetLevel((int)n).Name, null);
        }
        league = this.mMain.levels.leagues[1];
        for (n = 0; n < league.Count(); ++n) {
            this.lsMedium.append(league.GetLevel((int)n).Name, null);
        }
        league = this.mMain.levels.leagues[2];
        for (n = 0; n < league.Count(); ++n) {
            this.lsPro.append(league.GetLevel((int)n).Name, null);
        }
        if (this.curLevel == 0 && this.curTrack > this.mMain.levels.leagues[0].Count() - 1) {
            this.curTrack = this.mMain.levels.leagues[0].Count() - 1;
        }
        if (this.curLevel == 1 && this.curTrack > this.mMain.levels.leagues[1].Count() - 1) {
            this.curTrack = this.mMain.levels.leagues[1].Count() - 1;
        }
        if (this.curLevel == 2 && this.curTrack > this.mMain.levels.leagues[2].Count() - 1) {
            this.curTrack = this.mMain.levels.leagues[2].Count() - 1;
        }
    }

    void SetStatus(String string, int n) {
        this.sStatus = string;
        this.iStatusTimeout = n;
    }

    public void keyPressed(int n) {
        switch (this.getGameAction(n)) {
            case 2: {
                this.keys[0] = true;
                break;
            }
            case 5: {
                this.keys[1] = true;
                break;
            }
            case 1: {
                this.keys[2] = true;
                break;
            }
            case 6: {
                this.keys[3] = true;
                break;
            }
        }
        switch (n) {
            case 49: {
                this.keys[4] = true;
                break;
            }
            case 55: {
                this.keys[10] = true;
                break;
            }
            case 42: {
                if (this.iCurVertex > 0 && this.iCurVertex < this.mMain.levels.leagues[this.curLevel].GetLevel(this.curTrack).Count() - 1) {
                    this.mMain.levels.leagues[this.curLevel].GetLevel(this.curTrack).RemovePoint(this.iCurVertex);
                    this.SetStatus("del [" + this.iCurVertex + "]", 1000);
                    this.iCurVertex = -1;
                    break;
                }
                if (this.iCurVertex == 0) {
                    this.SetStatus("Can't delete 1st point", 1000);
                    break;
                }
                if (this.iCurVertex != this.mMain.levels.leagues[this.curLevel].GetLevel(this.curTrack).Count() - 1) break;
                this.SetStatus("Can't delete last point", 1000);
                break;
            }
            case 35: {
                Point2 point2 = new Point2();
                Level level = this.mMain.levels.leagues[this.curLevel].GetLevel(this.curTrack);
                int n2 = 0;
                for (int i = 0; i < level.Count(); ++i) {
                    if (level.GetPoint((int)i).x >= this.camX) continue;
                    n2 = i;
                }
                point2.x = this.camX;
                point2.y = this.camY - 110;
                level.InsertPoint(n2 + 1, point2);
                this.SetStatus("add (" + point2.x + "," + point2.y + ")", 1000);
                break;
            }
        }
    }

    public void keyRepeated(int n) {
    }

    public void keyReleased(int n) {
        switch (this.getGameAction(n)) {
            case 2: {
                this.keys[0] = false;
                break;
            }
            case 5: {
                this.keys[1] = false;
                break;
            }
            case 1: {
                this.keys[2] = false;
                break;
            }
            case 6: {
                this.keys[3] = false;
                break;
            }
        }
        switch (n) {
            case 49: {
                this.keys[4] = false;
                break;
            }
            case 55: {
                this.bCanLeft = true;
                this.bCanRight = true;
                this.bCanUp = true;
                this.bCanDown = true;
                this.keys[10] = false;
                break;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdManage) {
            this.mMain.display.setCurrent((Displayable)this.lsLevel);
        } else if (command == List.SELECT_COMMAND) {
            if (displayable == this.lsLevel) {
                int n = this.lsLevel.getSelectedIndex();
                if (n == 0) {
                    this.mMain.display.setCurrent((Displayable)this.lsEasy);
                } else if (n == 1) {
                    this.mMain.display.setCurrent((Displayable)this.lsMedium);
                } else if (n == 2) {
                    this.mMain.display.setCurrent((Displayable)this.lsPro);
                }
            } else if (displayable == this.lsEasy || displayable == this.lsMedium || displayable == this.lsPro) {
                int n = ((List)displayable).getSelectedIndex();
                if (n >= 0) {
                    if (displayable == this.lsEasy) {
                        this.curLevel = 0;
                        this.curTrack = n;
                    } else if (displayable == this.lsMedium) {
                        this.curLevel = 1;
                        this.curTrack = n;
                    } else if (displayable == this.lsPro) {
                        this.curLevel = 2;
                        this.curTrack = n;
                    }
                    this.camX = 0;
                    this.camY = 0;
                }
                this.mMain.display.setCurrent((Displayable)this);
            }
        } else if (command == this.cmdCopy) {
            this.iCopyTrack = ((List)displayable).getSelectedIndex();
            if (displayable == this.lsEasy) {
                this.iCopyLeague = 0;
            } else if (displayable == this.lsMedium) {
                this.iCopyLeague = 1;
            } else if (displayable == this.lsPro) {
                this.iCopyLeague = 2;
            }
        } else if (command == this.cmdPaste) {
            int n = ((List)displayable).getSelectedIndex() + 1;
            Levels levels = this.mMain.levels;
            Level level = levels.leagues[this.iCopyLeague].GetLevel(this.iCopyTrack);
            Level level2 = new Level(level);
            if (displayable == this.lsEasy) {
                levels.leagues[0].InsertLevel(n, level2);
            } else if (displayable == this.lsMedium) {
                levels.leagues[1].InsertLevel(n, level2);
            } else if (displayable == this.lsPro) {
                levels.leagues[2].InsertLevel(n, level2);
            }
            this.UpdateList();
        } else if (command == this.cmdMoveUp) {
            int n = ((List)displayable).getSelectedIndex();
            Levels levels = this.mMain.levels;
            if (n > 0) {
                if (displayable == this.lsEasy) {
                    levels.leagues[0].Swap(n, n - 1);
                } else if (displayable == this.lsMedium) {
                    levels.leagues[1].Swap(n, n - 1);
                } else if (displayable == this.lsPro) {
                    levels.leagues[2].Swap(n, n - 1);
                }
                this.UpdateList();
                ((List)displayable).setSelectedIndex(n - 1, true);
                --this.curTrack;
            }
        } else if (command == this.cmdMoveDown) {
            int n = ((List)displayable).getSelectedIndex();
            Levels levels = this.mMain.levels;
            if (n < ((List)displayable).size() - 1) {
                if (displayable == this.lsEasy) {
                    levels.leagues[0].Swap(n, n + 1);
                } else if (displayable == this.lsMedium) {
                    levels.leagues[1].Swap(n, n + 1);
                } else if (displayable == this.lsPro) {
                    levels.leagues[2].Swap(n, n + 1);
                }
                this.UpdateList();
                ((List)displayable).setSelectedIndex(n + 1, true);
                ++this.curTrack;
            }
        } else if (command == this.cmdBack && displayable == this.lsLevel) {
            this.mMain.display.setCurrent((Displayable)this);
        } else if (command == this.cmdBack && (displayable == this.lsEasy || displayable == this.lsMedium || displayable == this.lsPro)) {
            this.mMain.display.setCurrent((Displayable)this.lsLevel);
        } else if (command == this.cmdBack && displayable == this.formLevelProp) {
            this.mMain.display.setCurrent((Displayable)this);
        } else if (command == this.cmdOptions) {
            this.tfRootJsr75.setString(this.mMain.fs.rootJsr75);
            this.tfRootSiemens.setString(this.mMain.fs.rootSiemens);
            this.tfRootSymbian.setString(this.mMain.fs.rootSymbian);
            this.mMain.display.setCurrent((Displayable)this.formOptions);
        } else if (command == this.cmdLevelProp) {
            this.propName.setString(this.mMain.levels.leagues[this.curLevel].GetLevel((int)this.curTrack).Name);
            this.mMain.display.setCurrent((Displayable)this.formLevelProp);
        } else if (command == this.cmdExit) {
            this.mMain.destroyApp(false);
        } else if (command == this.cmdOk && displayable == this.formOptions) {
            boolean[] blArray = new boolean[1];
            this.cgOptView.getSelectedFlags(blArray);
            this.bDrawVertexCoords = blArray[0];
            this.mMain.fs.rootJsr75 = this.tfRootJsr75.getString();
            this.mMain.fs.rootSiemens = this.tfRootSiemens.getString();
            this.mMain.fs.rootSymbian = this.tfRootSymbian.getString();
            this.nSpeed = Integer.parseInt(this.tfSpeed.getString(), 10);
            if (this.nSpeed < 10) {
                this.nSpeed = 10;
            }
            if (this.nSpeed > 200) {
                this.nSpeed = 200;
            }
            this.mMain.display.setCurrent((Displayable)this);
        } else if (command == this.cmdOk && displayable == this.formLevelProp) {
            this.mMain.levels.leagues[this.curLevel].GetLevel((int)this.curTrack).Name = this.propName.getString();
            this.UpdateList();
            this.propName.setString("");
            this.mMain.display.setCurrent((Displayable)this);
        } else if (command == this.cmdSave) {
            this.mMain.display.setCurrent((Displayable)this.formSave);
        } else if (command == this.cmdLoad) {
            this.mMain.display.setCurrent((Displayable)this.formLoad);
        } else if (command == this.cmdOk && displayable == this.formSave) {
            boolean[] blArray = new boolean[4];
            this.cgFileModeSave.getSelectedFlags(blArray);
            if (blArray[0]) {
                this.nFileAccess = 0;
            } else if (blArray[1]) {
                this.nFileAccess = 1;
            } else if (blArray[2]) {
                this.nFileAccess = 2;
            } else if (blArray[3]) {
                this.nFileAccess = 3;
            }
            new Thread(){

                public void run() {
                    String string = MyCanvas.this.tfFileNameSave.getString();
                    boolean bl = false;
                    if (MyCanvas.this.nFileAccess == 0) {
                        bl = MyCanvas.this.mMain.fs.WriteRms(string, MyCanvas.this.mMain.levels.Save());
                    } else if (MyCanvas.this.nFileAccess == 1) {
                        bl = MyCanvas.this.mMain.fs.WriteSiemens(string, MyCanvas.this.mMain.levels.Save());
                    } else if (MyCanvas.this.nFileAccess == 2) {
                        bl = MyCanvas.this.mMain.fs.WriteJsr75(string, MyCanvas.this.mMain.levels.Save());
                    } else if (MyCanvas.this.nFileAccess == 3) {
                        bl = MyCanvas.this.mMain.fs.WriteSymbian(string, MyCanvas.this.mMain.levels.Save());
                    }
                    if (bl) {
                        MyCanvas.this.SetStatus("Saved", 1000);
                    } else {
                        MyCanvas.this.SetStatus("Save failed", 1000);
                    }
                    MyCanvas.this.ResetTiming();
                    MyCanvas.this.mMain.display.setCurrent((Displayable)MyCanvas.this.mMain.mCanvas);
                }
            }.start();
        } else if (command == this.cmdOk && displayable == this.formLoad) {
            boolean[] blArray = new boolean[4];
            this.cgFileModeLoad.getSelectedFlags(blArray);
            if (blArray[0]) {
                this.nFileAccess = 0;
            } else if (blArray[1]) {
                this.nFileAccess = 1;
            } else if (blArray[2]) {
                this.nFileAccess = 2;
            } else if (blArray[3]) {
                this.nFileAccess = 3;
            }
            new Thread(){

                public void run() {
                    String string = MyCanvas.this.tfFileNameLoad.getString();
                    byte[] byArray = null;
                    if (MyCanvas.this.nFileAccess == 0) {
                        byArray = MyCanvas.this.mMain.fs.ReadRms(string);
                    } else if (MyCanvas.this.nFileAccess == 1) {
                        byArray = MyCanvas.this.mMain.fs.ReadSiemens(string);
                    } else if (MyCanvas.this.nFileAccess == 2) {
                        byArray = MyCanvas.this.mMain.fs.ReadJsr75(string);
                    } else if (MyCanvas.this.nFileAccess == 3) {
                        byArray = MyCanvas.this.mMain.fs.ReadSymbian(string);
                    }
                    if (byArray != null) {
                        MyCanvas.this.mMain.levels.Load(byArray);
                        MyCanvas.this.UpdateList();
                        MyCanvas.this.ResetTiming();
                        MyCanvas.this.SetStatus("Loaded", 1000);
                    } else {
                        MyCanvas.this.ResetTiming();
                        MyCanvas.this.SetStatus("Load failed", 1000);
                    }
                    MyCanvas.this.mMain.display.setCurrent((Displayable)MyCanvas.this.mMain.mCanvas);
                }
            }.start();
        } else if (command == this.cmdBack && displayable == this.formSave) {
            this.mMain.display.setCurrent((Displayable)this);
        } else if (command == this.cmdBack && displayable == this.formLoad) {
            this.mMain.display.setCurrent((Displayable)this);
        } else if (command == this.cmdRemove) {
            int n = ((List)displayable).getSelectedIndex();
            Levels levels = this.mMain.levels;
            if (displayable == this.lsEasy) {
                levels.leagues[0].RemoveLevel(n);
            } else if (displayable == this.lsMedium) {
                levels.leagues[1].RemoveLevel(n);
            } else if (displayable == this.lsPro) {
                levels.leagues[2].RemoveLevel(n);
            }
            this.UpdateList();
            if (((List)displayable).size() > 0) {
                ((List)displayable).setSelectedIndex(n, true);
            }
            this.SetStatus("Level removed", 1000);
        } else if (command == this.cmdCreateNew) {
            int n = ((List)displayable).getSelectedIndex();
            Levels levels = this.mMain.levels;
            Level level = new Level();
            level.Name = "New level";
            level.x0 = -70;
            level.y0 = -90;
            level.xEnd = 70;
            level.yEnd = -110;
            for (int i = -100; i < 100; i += 30) {
                Point2 point2 = new Point2();
                point2.x = i;
                point2.y = -110;
                level.AddPoint(point2);
            }
            if (displayable == this.lsEasy) {
                levels.leagues[0].InsertLevel(n, level);
            } else if (displayable == this.lsMedium) {
                levels.leagues[1].InsertLevel(n, level);
            } else if (displayable == this.lsPro) {
                levels.leagues[2].InsertLevel(n, level);
            }
            this.UpdateList();
            ((List)displayable).setSelectedIndex(n, true);
            this.SetStatus("Level created", 1000);
        }
    }

    void ResetTiming() {
        this.lastTime = System.currentTimeMillis();
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        int n3 = (int)(l - this.lastTime);
        this.lastTime = l;
        if (this.iStatusTimeout != Integer.MAX_VALUE) {
            this.iStatusTimeout -= n3;
        }
        if (this.iStatusTimeout <= 0) {
            this.sStatus = "";
        }
        if ((n2 = n3 * this.nSpeed / 1000) > 2) {
            n2 = 2;
        }
        boolean bl = false;
        if (this.keys[2] && this.bCanUp) {
            this.camY += n2;
            bl = true;
        }
        if (this.keys[3] && this.bCanDown) {
            this.camY -= n2;
            bl = true;
        }
        if (this.keys[0] && this.bCanLeft) {
            this.camX -= n2;
            bl = true;
        }
        if (this.keys[1] && this.bCanRight) {
            this.camX += n2;
            bl = true;
        }
        this.lTimeInMove = bl ? (this.lTimeInMove += (long)n3) : 0L;
        this.w = this.getWidth();
        this.h = this.getHeight();
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.w, this.h);
        Level level = this.mMain.levels.leagues[this.curLevel].GetLevel(this.curTrack);
        if (level == null) {
            graphics.setColor(210, 210, 255);
            graphics.fillRect(0, 0, this.w, this.font.getHeight() + 2);
            graphics.setColor(0, 0, 55);
            graphics.drawLine(0, this.font.getHeight() + 2, this.w, this.font.getHeight() + 2);
            this.font.drawString(graphics, "No level", 1, 2);
            this.repaint();
            return;
        }
        int n4 = this.camY + this.h / 2;
        graphics.setColor(100, 100, 255);
        graphics.setStrokeStyle(1);
        graphics.drawLine(0, n4, this.w, n4);
        graphics.drawLine(this.w / 2 - this.camX, n4 - 8, this.w / 2 - this.camX, n4 + 8);
        graphics.setStrokeStyle(0);
        int n5 = this.camX - level.x0;
        if (n5 < 0) {
            n5 *= -1;
        }
        if ((n = this.camY - level.y0 - 110) < 0) {
            n *= -1;
        }
        if (n5 < 10 && n < 10) {
            if (!bl) {
                this.camX = level.x0;
                this.camY = level.y0 + 110;
            } else if (this.keys[10]) {
                if (this.keys[2]) {
                    level.y0 += n2;
                }
                if (this.keys[3]) {
                    level.y0 -= n2;
                }
                if (this.keys[0]) {
                    level.x0 -= n2;
                }
                if (this.keys[1]) {
                    level.x0 += n2;
                }
            }
        }
        graphics.setColor(0, 0, 255);
        graphics.drawLine(this.w / 2 - this.camX + level.xEnd - 2, 0, this.w / 2 - this.camX + level.xEnd - 2, this.h);
        graphics.drawLine(this.w / 2 - this.camX + level.xEnd + 2, 0, this.w / 2 - this.camX + level.xEnd + 2, this.h);
        n5 = this.camX - level.xEnd;
        if (n5 < 0) {
            n5 *= -1;
        }
        if (n5 <= 2 && this.keys[10]) {
            if (this.keys[0]) {
                level.xEnd -= n2;
            }
            if (this.keys[1]) {
                level.xEnd += n2;
            }
        }
        n5 = 0;
        n = 0;
        for (int i = 0; i < level.Count(); ++i) {
            int n6;
            int n7;
            Point2 point2 = level.GetPoint(i);
            Point2 point22 = null;
            int n8 = 0;
            int n9 = 0;
            if (i < level.Count() - 1) {
                point22 = level.GetPoint(i + 1);
                n8 = -this.camX + this.w / 2 + point22.x;
                n9 = this.camY + this.h / 2 - point22.y - 110;
            }
            Point2 point23 = null;
            if (i > 0) {
                point23 = level.GetPoint(i - 1);
            }
            int n10 = -this.camX + this.w / 2 + point2.x;
            int n11 = this.camY + this.h / 2 - point2.y - 110;
            if ((n10 < 0 || n10 > this.w || n11 < 0 || n11 > this.h) && (i == level.Count() - 1 || n8 < 0 && n10 < 0 || n8 > this.w && n10 > this.w || n9 < 0 || n9 > this.h)) continue;
            ++n5;
            if (this.bDrawVertexCoords) {
                this.font.drawString(graphics, "(" + point2.x + "," + (point2.y + 110 + 3) + ")", n10, n11);
            }
            if ((n7 = this.camX - point2.x) < 0) {
                n7 *= -1;
            }
            if ((n6 = this.camY - point2.y - 110) < 0) {
                n6 *= -1;
            }
            if (n7 <= 2 && n6 <= 2 && n == 0) {
                this.iCurVertex = i;
                n = 1;
                if (!bl) {
                    this.camX = point2.x;
                    this.camY = point2.y + 110;
                    this.iCurVertex = i;
                } else if (this.keys[10]) {
                    if (this.keys[2]) {
                        point2.y += n2;
                    }
                    if (this.keys[3]) {
                        point2.y -= n2;
                    }
                    if (this.keys[0]) {
                        point2.x -= n2;
                    }
                    if (this.keys[1]) {
                        point2.x += n2;
                    }
                    if (i != 0 && point23 != null) {
                        if (point2.x - point23.x > 127) {
                            point2.x = point23.x + 127;
                            this.bCanRight = false;
                        } else {
                            this.bCanRight = true;
                        }
                        if (point2.x - point23.x <= 4) {
                            this.bCanLeft = false;
                            point2.x = point23.x + 4;
                        } else {
                            this.bCanLeft = true;
                        }
                        if (point2.y - point23.y > 127) {
                            point2.y = point23.y + 127;
                            this.bCanUp = false;
                        } else {
                            this.bCanUp = true;
                        }
                        if (point2.y - point23.y < -127) {
                            point2.y = point23.y - 127;
                            this.bCanDown = false;
                        } else {
                            this.bCanDown = true;
                        }
                    }
                    if (i != level.Count() - 1 && point22 != null) {
                        if (point2.x - point22.x < -127) {
                            point2.x = point22.x - 127;
                            this.bCanLeft = false;
                        } else {
                            this.bCanLeft = true;
                        }
                        if (point22.x - point2.x <= 4) {
                            point2.x = point22.x - 4;
                            this.bCanRight = false;
                        } else {
                            this.bCanRight = true;
                        }
                        if (point2.y - point22.y > 127) {
                            point2.y = point22.y + 127;
                            this.bCanUp = false;
                        } else {
                            this.bCanUp = true;
                        }
                        if (point2.y - point22.y < -127) {
                            point2.y = point22.y - 127;
                            this.bCanDown = false;
                        } else {
                            this.bCanDown = true;
                        }
                    }
                    this.camX = point2.x;
                    this.camY = point2.y + 110;
                }
            }
            graphics.setColor(0, 255, 0);
            if (i < level.Count() - 1) {
                if (n8 - n10 > 127) {
                    graphics.setColor(255, 0, 0);
                }
                graphics.drawLine(n10, n11, n8, n9);
            }
            graphics.setColor(0, 140, 0);
            graphics.fillRect(n10 - 2, n11 - 2, 4, 4);
        }
        graphics.setColor(0, 0, 0);
        graphics.drawArc(-this.camX + this.w / 2 + level.x0 - 10, -110 + this.camY + this.h / 2 - level.y0 - 10, 20, 20, 0, 360);
        graphics.setColor(0, 0, 0);
        graphics.drawLine(this.w / 2, this.h / 2, this.w / 2 + 8, this.h / 2 + 4);
        graphics.drawLine(this.w / 2 + 8, this.h / 2 + 4, this.w / 2 + 4, this.h / 2 + 8);
        graphics.drawLine(this.w / 2 + 4, this.h / 2 + 8, this.w / 2, this.h / 2);
        this.font.drawString(graphics, "(" + this.camX + "," + this.camY + ")", this.w / 2 + 2, this.h / 2 + 10);
        graphics.setColor(210, 210, 255);
        graphics.fillRect(0, 0, this.w, this.font.getHeight() + 2);
        graphics.setColor(0, 0, 55);
        graphics.drawLine(0, this.font.getHeight() + 2, this.w, this.font.getHeight() + 2);
        this.font.drawString(graphics, level.Name, 1, 2);
        graphics.setColor(210, 210, 255);
        graphics.fillRect(0, this.h - this.font.getHeight() - 2, this.w, this.font.getHeight() + 2);
        graphics.setColor(0, 0, 55);
        graphics.drawLine(0, this.h - this.font.getHeight() - 2, this.w, this.h - this.font.getHeight() - 2);
        this.font.drawString(graphics, this.sStatus, 1, this.h - this.font.getHeight());
        this.repaint();
    }
}

